/*
    $Id: unicodedata.c 1618 2018-08-30 20:07:21Z soci $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

#include "unicodedata.h"

const int16_t usequences[4809] = {
    0, 32, -776, 32, -772, 32, -769, 32,
    -807, 49, 8260, -52, 49, 8260, -50, 51,
    8260, -52, 65, -768, 65, -769, 65, -770,
    65, -771, 65, -776, 65, -778, 67, -807,
    69, -768, 69, -769, 69, -770, 69, -776,
    73, -768, 73, -769, 73, -770, 73, -776,
    78, -771, 79, -768, 79, -769, 79, -770,
    79, -771, 79, -776, 85, -768, 85, -769,
    85, -770, 85, -776, 89, -769, 97, -768,
    97, -769, 97, -770, 97, -771, 97, -776,
    97, -778, 99, -807, 101, -768, 101, -769,
    101, -770, 101, -776, 105, -768, 105, -769,
    105, -770, 105, -776, 110, -771, 111, -768,
    111, -769, 111, -770, 111, -771, 111, -776,
    117, -768, 117, -769, 117, -770, 117, -776,
    121, -769, 121, -776, 65, -772, 97, -772,
    65, -774, 97, -774, 65, -808, 97, -808,
    67, -769, 99, -769, 67, -770, 99, -770,
    67, -775, 99, -775, 67, -780, 99, -780,
    68, -780, 100, -780, 69, -772, 101, -772,
    69, -774, 101, -774, 69, -775, 101, -775,
    69, -808, 101, -808, 69, -780, 101, -780,
    71, -770, 103, -770, 71, -774, 103, -774,
    71, -775, 103, -775, 71, -807, 103, -807,
    72, -770, 104, -770, 73, -771, 105, -771,
    73, -772, 105, -772, 73, -774, 105, -774,
    73, -808, 105, -808, 73, -775, 73, -74,
    105, -106, 74, -770, 106, -770, 75, -807,
    107, -807, 76, -769, 108, -769, 76, -807,
    108, -807, 76, -780, 108, -780, 76, -183,
    108, -183, 78, -769, 110, -769, 78, -807,
    110, -807, 78, -780, 110, -780, 700, -110,
    79, -772, 111, -772, 79, -774, 111, -774,
    79, -779, 111, -779, 82, -769, 114, -769,
    82, -807, 114, -807, 82, -780, 114, -780,
    83, -769, 115, -769, 83, -770, 115, -770,
    83, -807, 115, -807, 83, -780, 115, -780,
    84, -807, 116, -807, 84, -780, 116, -780,
    85, -771, 117, -771, 85, -772, 117, -772,
    85, -774, 117, -774, 85, -778, 117, -778,
    85, -779, 117, -779, 85, -808, 117, -808,
    87, -770, 119, -770, 89, -770, 121, -770,
    89, -776, 90, -769, 122, -769, 90, -775,
    122, -775, 90, -780, 122, -780, 79, -795,
    111, -795, 85, -795, 117, -795, 68, -381,
    68, -382, 100, -382, 76, -74, 76, -106,
    108, -106, 78, -74, 78, -106, 110, -106,
    65, -780, 97, -780, 73, -780, 105, -780,
    79, -780, 111, -780, 85, -780, 117, -780,
    220, -772, 252, -772, 220, -769, 252, -769,
    220, -780, 252, -780, 220, -768, 252, -768,
    196, -772, 228, -772, 550, -772, 551, -772,
    198, -772, 230, -772, 71, -780, 103, -780,
    75, -780, 107, -780, 79, -808, 111, -808,
    490, -772, 491, -772, 439, -780, 658, -780,
    106, -780, 68, -90, 68, -122, 100, -122,
    71, -769, 103, -769, 78, -768, 110, -768,
    197, -769, 229, -769, 198, -769, 230, -769,
    216, -769, 248, -769, 65, -783, 97, -783,
    65, -785, 97, -785, 69, -783, 101, -783,
    69, -785, 101, -785, 73, -783, 105, -783,
    73, -785, 105, -785, 79, -783, 111, -783,
    79, -785, 111, -785, 82, -783, 114, -783,
    82, -785, 114, -785, 85, -783, 117, -783,
    85, -785, 117, -785, 83, -806, 115, -806,
    84, -806, 116, -806, 72, -780, 104, -780,
    65, -775, 97, -775, 69, -807, 101, -807,
    214, -772, 246, -772, 213, -772, 245, -772,
    79, -775, 111, -775, 558, -772, 559, -772,
    89, -772, 121, -772, 32, -774, 32, -775,
    32, -778, 32, -808, 32, -771, 32, -779,
    776, -769, 32, -837, 168, -769, 913, -769,
    917, -769, 919, -769, 921, -769, 927, -769,
    933, -769, 937, -769, 970, -769, 921, -776,
    933, -776, 945, -769, 949, -769, 951, -769,
    953, -769, 971, -769, 953, -776, 965, -776,
    959, -769, 965, -769, 969, -769, 978, -769,
    978, -776, 1045, -768, 1045, -776, 1043, -769,
    1030, -776, 1050, -769, 1048, -768, 1059, -774,
    1048, -774, 1080, -774, 1077, -768, 1077, -776,
    1075, -769, 1110, -776, 1082, -769, 1080, -768,
    1091, -774, 1140, -783, 1141, -783, 1046, -774,
    1078, -774, 1040, -774, 1072, -774, 1040, -776,
    1072, -776, 1045, -774, 1077, -774, 1240, -776,
    1241, -776, 1046, -776, 1078, -776, 1047, -776,
    1079, -776, 1048, -772, 1080, -772, 1048, -776,
    1080, -776, 1054, -776, 1086, -776, 1256, -776,
    1257, -776, 1069, -776, 1101, -776, 1059, -772,
    1091, -772, 1059, -776, 1091, -776, 1059, -779,
    1091, -779, 1063, -776, 1095, -776, 1067, -776,
    1099, -776, 1381, -1410, 1575, -1619, 1575, -1620,
    1608, -1620, 1575, -1621, 1610, -1620, 1575, -1652,
    1608, -1652, 1735, -1652, 1610, -1652, 1749, -1620,
    1729, -1620, 1746, -1620, 2344, -2364, 2352, -2364,
    2355, -2364, 2325, -2364, 2326, -2364, 2327, -2364,
    2332, -2364, 2337, -2364, 2338, -2364, 2347, -2364,
    2351, -2364, 2503, -2494, 2503, -2519, 2465, -2492,
    2466, -2492, 2479, -2492, 2610, -2620, 2616, -2620,
    2582, -2620, 2583, -2620, 2588, -2620, 2603, -2620,
    2887, -2902, 2887, -2878, 2887, -2903, 2849, -2876,
    2850, -2876, 2962, -3031, 3014, -3006, 3015, -3006,
    3014, -3031, 3142, -3158, 3263, -3285, 3270, -3285,
    3270, -3286, 3270, -3266, 3274, -3285, 3398, -3390,
    3399, -3390, 3398, -3415, 3545, -3530, 3545, -3535,
    3548, -3530, 3545, -3551, 3661, -3634, 3789, -3762,
    3755, -3737, 3755, -3745, 3906, -4023, 3916, -4023,
    3921, -4023, 3926, -4023, 3931, -4023, 3904, -4021,
    3953, -3954, 3953, -3956, 4018, -3968, 4018, -3969,
    4019, -3968, 4019, -3969, 3953, -3968, 3986, -4023,
    3996, -4023, 4001, -4023, 4006, -4023, 4011, -4023,
    3984, -4021, 4133, -4142, 6917, -6965, 6919, -6965,
    6921, -6965, 6923, -6965, 6925, -6965, 6929, -6965,
    6970, -6965, 6972, -6965, 6974, -6965, 6975, -6965,
    6978, -6965, 65, -805, 97, -805, 66, -775,
    98, -775, 66, -803, 98, -803, 66, -817,
    98, -817, 199, -769, 231, -769, 68, -775,
    100, -775, 68, -803, 100, -803, 68, -817,
    100, -817, 68, -807, 100, -807, 68, -813,
    100, -813, 274, -768, 275, -768, 274, -769,
    275, -769, 69, -813, 101, -813, 69, -816,
    101, -816, 552, -774, 553, -774, 70, -775,
    102, -775, 71, -772, 103, -772, 72, -775,
    104, -775, 72, -803, 104, -803, 72, -776,
    104, -776, 72, -807, 104, -807, 72, -814,
    104, -814, 73, -816, 105, -816, 207, -769,
    239, -769, 75, -769, 107, -769, 75, -803,
    107, -803, 75, -817, 107, -817, 76, -803,
    108, -803, 7734, -772, 7735, -772, 76, -817,
    108, -817, 76, -813, 108, -813, 77, -769,
    109, -769, 77, -775, 109, -775, 77, -803,
    109, -803, 78, -775, 110, -775, 78, -803,
    110, -803, 78, -817, 110, -817, 78, -813,
    110, -813, 213, -769, 245, -769, 213, -776,
    245, -776, 332, -768, 333, -768, 332, -769,
    333, -769, 80, -769, 112, -769, 80, -775,
    112, -775, 82, -775, 114, -775, 82, -803,
    114, -803, 7770, -772, 7771, -772, 82, -817,
    114, -817, 83, -775, 115, -775, 83, -803,
    115, -803, 346, -775, 347, -775, 352, -775,
    353, -775, 7778, -775, 7779, -775, 84, -775,
    116, -775, 84, -803, 116, -803, 84, -817,
    116, -817, 84, -813, 116, -813, 85, -804,
    117, -804, 85, -816, 117, -816, 85, -813,
    117, -813, 360, -769, 361, -769, 362, -776,
    363, -776, 86, -771, 118, -771, 86, -803,
    118, -803, 87, -768, 119, -768, 87, -769,
    119, -769, 87, -776, 119, -776, 87, -775,
    119, -775, 87, -803, 119, -803, 88, -775,
    120, -775, 88, -776, 120, -776, 89, -775,
    121, -775, 90, -770, 122, -770, 90, -803,
    122, -803, 90, -817, 122, -817, 104, -817,
    116, -776, 119, -778, 121, -778, 97, -702,
    383, -775, 65, -803, 97, -803, 65, -777,
    97, -777, 194, -769, 226, -769, 194, -768,
    226, -768, 194, -777, 226, -777, 194, -771,
    226, -771, 7840, -770, 7841, -770, 258, -769,
    259, -769, 258, -768, 259, -768, 258, -777,
    259, -777, 258, -771, 259, -771, 7840, -774,
    7841, -774, 69, -803, 101, -803, 69, -777,
    101, -777, 69, -771, 101, -771, 202, -769,
    234, -769, 202, -768, 234, -768, 202, -777,
    234, -777, 202, -771, 234, -771, 7864, -770,
    7865, -770, 73, -777, 105, -777, 73, -803,
    105, -803, 79, -803, 111, -803, 79, -777,
    111, -777, 212, -769, 244, -769, 212, -768,
    244, -768, 212, -777, 244, -777, 212, -771,
    244, -771, 7884, -770, 7885, -770, 416, -769,
    417, -769, 416, -768, 417, -768, 416, -777,
    417, -777, 416, -771, 417, -771, 416, -803,
    417, -803, 85, -803, 117, -803, 85, -777,
    117, -777, 431, -769, 432, -769, 431, -768,
    432, -768, 431, -777, 432, -777, 431, -771,
    432, -771, 431, -803, 432, -803, 89, -768,
    121, -768, 89, -803, 121, -803, 89, -777,
    121, -777, 89, -771, 121, -771, 945, -787,
    945, -788, 7936, -768, 7937, -768, 7936, -769,
    7937, -769, 7936, -834, 7937, -834, 913, -787,
    913, -788, 7944, -768, 7945, -768, 7944, -769,
    7945, -769, 7944, -834, 7945, -834, 949, -787,
    949, -788, 7952, -768, 7953, -768, 7952, -769,
    7953, -769, 917, -787, 917, -788, 7960, -768,
    7961, -768, 7960, -769, 7961, -769, 951, -787,
    951, -788, 7968, -768, 7969, -768, 7968, -769,
    7969, -769, 7968, -834, 7969, -834, 919, -787,
    919, -788, 7976, -768, 7977, -768, 7976, -769,
    7977, -769, 7976, -834, 7977, -834, 953, -787,
    953, -788, 7984, -768, 7985, -768, 7984, -769,
    7985, -769, 7984, -834, 7985, -834, 921, -787,
    921, -788, 7992, -768, 7993, -768, 7992, -769,
    7993, -769, 7992, -834, 7993, -834, 959, -787,
    959, -788, 8000, -768, 8001, -768, 8000, -769,
    8001, -769, 927, -787, 927, -788, 8008, -768,
    8009, -768, 8008, -769, 8009, -769, 965, -787,
    965, -788, 8016, -768, 8017, -768, 8016, -769,
    8017, -769, 8016, -834, 8017, -834, 933, -788,
    8025, -768, 8025, -769, 8025, -834, 969, -787,
    969, -788, 8032, -768, 8033, -768, 8032, -769,
    8033, -769, 8032, -834, 8033, -834, 937, -787,
    937, -788, 8040, -768, 8041, -768, 8040, -769,
    8041, -769, 8040, -834, 8041, -834, 945, -768,
    949, -768, 951, -768, 953, -768, 959, -768,
    965, -768, 969, -768, 7936, -837, 7937, -837,
    7938, -837, 7939, -837, 7940, -837, 7941, -837,
    7942, -837, 7943, -837, 7944, -837, 7945, -837,
    7946, -837, 7947, -837, 7948, -837, 7949, -837,
    7950, -837, 7951, -837, 7968, -837, 7969, -837,
    7970, -837, 7971, -837, 7972, -837, 7973, -837,
    7974, -837, 7975, -837, 7976, -837, 7977, -837,
    7978, -837, 7979, -837, 7980, -837, 7981, -837,
    7982, -837, 7983, -837, 8032, -837, 8033, -837,
    8034, -837, 8035, -837, 8036, -837, 8037, -837,
    8038, -837, 8039, -837, 8040, -837, 8041, -837,
    8042, -837, 8043, -837, 8044, -837, 8045, -837,
    8046, -837, 8047, -837, 945, -774, 945, -772,
    8048, -837, 945, -837, 940, -837, 945, -834,
    8118, -837, 913, -774, 913, -772, 913, -768,
    913, -837, 32, -787, 32, -834, 168, -834,
    8052, -837, 951, -837, 942, -837, 951, -834,
    8134, -837, 917, -768, 919, -768, 919, -837,
    8127, -768, 8127, -769, 8127, -834, 953, -774,
    953, -772, 970, -768, 953, -834, 970, -834,
    921, -774, 921, -772, 921, -768, 8190, -768,
    8190, -769, 8190, -834, 965, -774, 965, -772,
    971, -768, 961, -787, 961, -788, 965, -834,
    971, -834, 933, -774, 933, -772, 933, -768,
    929, -788, 168, -768, 8060, -837, 969, -837,
    974, -837, 969, -834, 8182, -837, 927, -768,
    937, -768, 937, -837, 32, -788, 32, -819,
    46, -46, 46, 46, -46, 8242, -8242, 8242,
    8242, -8242, 8245, -8245, 8245, 8245, -8245, 33,
    -33, 32, -773, 63, -63, 63, -33, 33,
    -63, 8242, 8242, 8242, -8242, 82, -115, 97,
    47, -99, 97, 47, -115, 176, -67, 99,
    47, -111, 99, 47, -117, 176, -70, 78,
    -111, 83, -77, 84, 69, -76, 84, -77,
    70, 65, -88, 49, 8260, -55, 49, 8260,
    -57, 49, 8260, 49, -48, 49, 8260, -51,
    50, 8260, -51, 49, 8260, -53, 50, 8260,
    -53, 51, 8260, -53, 52, 8260, -53, 49,
    8260, -54, 53, 8260, -54, 49, 8260, -56,
    51, 8260, -56, 53, 8260, -56, 55, 8260,
    -56, 49, -8260, 73, -73, 73, 73, -73,
    73, -86, 86, -73, 86, 73, -73, 86,
    73, 73, -73, 73, -88, 88, -73, 88,
    73, -73, 105, -105, 105, 105, -105, 105,
    -118, 118, -105, 118, 105, -105, 118, 105,
    105, -105, 105, -120, 120, -105, 120, 105,
    -105, 48, 8260, -51, 8592, -824, 8594, -824,
    8596, -824, 8656, -824, 8660, -824, 8658, -824,
    8707, -824, 8712, -824, 8715, -824, 8739, -824,
    8741, -824, 8747, -8747, 8747, 8747, -8747, 8750,
    -8750, 8750, 8750, -8750, 8764, -824, 8771, -824,
    8773, -824, 8776, -824, 61, -824, 8801, -824,
    8781, -824, 60, -824, 62, -824, 8804, -824,
    8805, -824, 8818, -824, 8819, -824, 8822, -824,
    8823, -824, 8826, -824, 8827, -824, 8834, -824,
    8835, -824, 8838, -824, 8839, -824, 8866, -824,
    8872, -824, 8873, -824, 8875, -824, 8828, -824,
    8829, -824, 8849, -824, 8850, -824, 8882, -824,
    8883, -824, 8884, -824, 8885, -824, 49, -48,
    49, -49, 49, -50, 49, -51, 49, -52,
    49, -53, 49, -54, 49, -55, 49, -56,
    49, -57, 50, -48, 40, 49, -41, 40,
    50, -41, 40, 51, -41, 40, 52, -41,
    40, 53, -41, 40, 54, -41, 40, 55,
    -41, 40, 56, -41, 40, 57, -41, 40,
    49, 48, -41, 40, 49, 49, -41, 40,
    49, 50, -41, 40, 49, 51, -41, 40,
    49, 52, -41, 40, 49, 53, -41, 40,
    49, 54, -41, 40, 49, 55, -41, 40,
    49, 56, -41, 40, 49, 57, -41, 40,
    50, 48, -41, 49, -46, 50, -46, 51,
    -46, 52, -46, 53, -46, 54, -46, 55,
    -46, 56, -46, 57, -46, 49, 48, -46,
    49, 49, -46, 49, 50, -46, 49, 51,
    -46, 49, 52, -46, 49, 53, -46, 49,
    54, -46, 49, 55, -46, 49, 56, -46,
    49, 57, -46, 50, 48, -46, 40, 97,
    -41, 40, 98, -41, 40, 99, -41, 40,
    100, -41, 40, 101, -41, 40, 102, -41,
    40, 103, -41, 40, 104, -41, 40, 105,
    -41, 40, 106, -41, 40, 107, -41, 40,
    108, -41, 40, 109, -41, 40, 110, -41,
    40, 111, -41, 40, 112, -41, 40, 113,
    -41, 40, 114, -41, 40, 115, -41, 40,
    116, -41, 40, 117, -41, 40, 118, -41,
    40, 119, -41, 40, 120, -41, 40, 121,
    -41, 40, 122, -41, 8747, 8747, 8747, -8747,
    58, 58, -61, 61, -61, 61, 61, -61,
    10973, -824, 12363, -12441, 12365, -12441, 12367, -12441,
    12369, -12441, 12371, -12441, 12373, -12441, 12375, -12441,
    12377, -12441, 12379, -12441, 12381, -12441, 12383, -12441,
    12385, -12441, 12388, -12441, 12390, -12441, 12392, -12441,
    12399, -12441, 12399, -12442, 12402, -12441, 12402, -12442,
    12405, -12441, 12405, -12442, 12408, -12441, 12408, -12442,
    12411, -12441, 12411, -12442, 12358, -12441, 32, -12441,
    32, -12442, 12445, -12441, 12424, -12426, 12459, -12441,
    12461, -12441, 12463, -12441, 12465, -12441, 12467, -12441,
    12469, -12441, 12471, -12441, 12473, -12441, 12475, -12441,
    12477, -12441, 12479, -12441, 12481, -12441, 12484, -12441,
    12486, -12441, 12488, -12441, 12495, -12441, 12495, -12442,
    12498, -12441, 12498, -12442, 12501, -12441, 12501, -12442,
    12504, -12441, 12504, -12442, 12507, -12441, 12507, -12442,
    12454, -12441, 12527, -12441, 12528, -12441, 12529, -12441,
    12530, -12441, 12541, -12441, 12467, -12488, 40, 4352,
    -41, 40, 4354, -41, 40, 4355, -41, 40,
    4357, -41, 40, 4358, -41, 40, 4359, -41,
    40, 4361, -41, 40, 4363, -41, 40, 4364,
    -41, 40, 4366, -41, 40, 4367, -41, 40,
    4368, -41, 40, 4369, -41, 40, 4370, -41,
    40, 4352, 4449, -41, 40, 4354, 4449, -41,
    40, 4355, 4449, -41, 40, 4357, 4449, -41,
    40, 4358, 4449, -41, 40, 4359, 4449, -41,
    40, 4361, 4449, -41, 40, 4363, 4449, -41,
    40, 4364, 4449, -41, 40, 4366, 4449, -41,
    40, 4367, 4449, -41, 40, 4368, 4449, -41,
    40, 4369, 4449, -41, 40, 4370, 4449, -41,
    40, 4364, 4462, -41, 40, 4363, 4457, 4364,
    4453, 4523, -41, 40, 4363, 4457, 4370, 4462,
    -41, 40, 19968, -41, 40, 20108, -41, 40,
    19977, -41, 40, 22235, -41, 40, 20116, -41,
    40, 20845, -41, 40, 19971, -41, 40, 20843,
    -41, 40, 20061, -41, 40, 21313, -41, 40,
    26376, -41, 40, 28779, -41, 40, 27700, -41,
    40, 26408, -41, 40, 22303, -41, 40, 26085,
    -41, 40, 26666, -41, 40, 26377, -41, 40,
    31038, -41, 40, 21517, -41, 40, 29305, -41,
    40, 31069, -41, 40, 21172, -41, 40, 20195,
    -41, 40, 21628, -41, 40, 23398, -41, 40,
    30435, -41, 40, 20225, -41, 40, 21332, -41,
    40, 31085, -41, 40, 20241, -41, 80, 84,
    -69, 50, -49, 50, -50, 50, -51, 50,
    -52, 50, -53, 50, -54, 50, -55, 50,
    -56, 50, -57, 51, -48, 51, -49, 51,
    -50, 51, -51, 51, -52, 51, -53, 4352,
    -4449, 4354, -4449, 4355, -4449, 4357, -4449, 4358,
    -4449, 4359, -4449, 4361, -4449, 4363, -4449, 4364,
    -4449, 4366, -4449, 4367, -4449, 4368, -4449, 4369,
    -4449, 4370, -4449, 4366, 4449, 4535, 4352, -4457,
    4364, 4462, 4363, -4468, 4363, -4462, 51, -54,
    51, -55, 51, -56, 51, -57, 52, -48,
    52, -49, 52, -50, 52, -51, 52, -52,
    52, -53, 52, -54, 52, -55, 52, -56,
    52, -57, 53, -48, 49, -26376, 50, -26376,
    51, -26376, 52, -26376, 53, -26376, 54, -26376,
    55, -26376, 56, -26376, 57, -26376, 49, 48,
    -26376, 49, 49, -26376, 49, 50, -26376, 72,
    -103, 101, 114, -103, 101, -86, 76, 84,
    -68, 12450, 12497, 12540, -12488, 12450, 12523, 12501,
    -12449, 12450, 12531, 12506, -12450, 12450, 12540, -12523,
    12452, 12491, 12531, -12464, 12452, 12531, -12481, 12454,
    12457, -12531, 12456, 12473, 12463, 12540, -12489, 12456,
    12540, 12459, -12540, 12458, 12531, -12473, 12458, 12540,
    -12512, 12459, 12452, -12522, 12459, 12521, 12483, -12488,
    12459, 12525, 12522, -12540, 12460, 12525, -12531, 12460,
    12531, -12510, 12462, -12460, 12462, 12491, -12540, 12461,
    12517, 12522, -12540, 12462, 12523, 12480, -12540, 12461,
    -12525, 12461, 12525, 12464, 12521, -12512, 12461, 12525,
    12513, 12540, 12488, -12523, 12461, 12525, 12527, 12483,
    -12488, 12464, 12521, -12512, 12464, 12521, 12512, 12488,
    -12531, 12463, 12523, 12476, 12452, -12525, 12463, 12525,
    12540, -12493, 12465, 12540, -12473, 12467, 12523, -12490,
    12467, 12540, -12509, 12469, 12452, 12463, -12523, 12469,
    12531, 12481, 12540, -12512, 12471, 12522, 12531, -12464,
    12475, 12531, -12481, 12475, 12531, -12488, 12480, 12540,
    -12473, 12487, -12471, 12489, -12523, 12488, -12531, 12490,
    -12494, 12494, 12483, -12488, 12495, 12452, -12484, 12497,
    12540, 12475, 12531, -12488, 12497, 12540, -12484, 12496,
    12540, 12524, -12523, 12500, 12450, 12473, 12488, -12523,
    12500, 12463, -12523, 12500, -12467, 12499, -12523, 12501,
    12449, 12521, 12483, -12489, 12501, 12451, 12540, -12488,
    12502, 12483, 12471, 12455, -12523, 12501, 12521, -12531,
    12504, 12463, 12479, 12540, -12523, 12506, -12477, 12506,
    12491, -12498, 12504, 12523, -12484, 12506, 12531, -12473,
    12506, 12540, -12472, 12505, 12540, -12479, 12509, 12452,
    12531, -12488, 12508, 12523, -12488, 12507, -12531, 12509,
    12531, -12489, 12507, 12540, -12523, 12507, 12540, -12531,
    12510, 12452, 12463, -12525, 12510, 12452, -12523, 12510,
    12483, -12495, 12510, 12523, -12463, 12510, 12531, 12471,
    12519, -12531, 12511, 12463, 12525, -12531, 12511, -12522,
    12511, 12522, 12496, 12540, -12523, 12513, -12460, 12513,
    12460, 12488, -12531, 12513, 12540, 12488, -12523, 12516,
    12540, -12489, 12516, 12540, -12523, 12518, 12450, -12531,
    12522, 12483, 12488, -12523, 12522, -12521, 12523, 12500,
    -12540, 12523, 12540, 12502, -12523, 12524, -12512, 12524,
    12531, 12488, 12466, -12531, 12527, 12483, -12488, 48,
    -28857, 49, -28857, 50, -28857, 51, -28857, 52,
    -28857, 53, -28857, 54, -28857, 55, -28857, 56,
    -28857, 57, -28857, 49, 48, -28857, 49, 49,
    -28857, 49, 50, -28857, 49, 51, -28857, 49,
    52, -28857, 49, 53, -28857, 49, 54, -28857,
    49, 55, -28857, 49, 56, -28857, 49, 57,
    -28857, 50, 48, -28857, 50, 49, -28857, 50,
    50, -28857, 50, 51, -28857, 50, 52, -28857,
    104, 80, -97, 100, -97, 65, -85, 98,
    97, -114, 111, -86, 112, -99, 100, -109,
    100, 109, -178, 100, 109, -179, 73, -85,
    24179, -25104, 26157, -21644, 22823, -27491, 26126, -27835,
    26666, 24335, 20250, -31038, 112, -65, 110, -65,
    956, -65, 109, -65, 107, -65, 75, -66,
    77, -66, 71, -66, 99, 97, -108, 107,
    99, 97, -108, 112, -70, 110, -70, 956,
    -70, 956, -103, 109, -103, 107, -103, 72,
    -122, 107, 72, -122, 77, 72, -122, 71,
    72, -122, 84, 72, -122, 956, -8467, 109,
    -8467, 100, -8467, 107, -8467, 102, -109, 110,
    -109, 956, -109, 109, -109, 99, -109, 107,
    -109, 109, 109, -178, 99, 109, -178, 109,
    -178, 107, 109, -178, 109, 109, -179, 99,
    109, -179, 109, -179, 107, 109, -179, 109,
    8725, -115, 109, 8725, 115, -178, 80, -97,
    107, 80, -97, 77, 80, -97, 71, 80,
    -97, 114, 97, -100, 114, 97, 100, 8725,
    -115, 114, 97, 100, 8725, 115, -178, 112,
    -115, 110, -115, 956, -115, 109, -115, 112,
    -86, 110, -86, 956, -86, 109, -86, 107,
    -86, 77, -86, 112, -87, 110, -87, 956,
    -87, 109, -87, 107, -87, 77, -87, 107,
    -937, 77, -937, 97, 46, 109, -46, 66,
    -113, 99, -99, 99, -100, 67, 8725, 107,
    -103, 67, 111, -46, 100, -66, 71, -121,
    104, -97, 72, -80, 105, -110, 75, -75,
    75, -77, 107, -116, 108, -109, 108, -110,
    108, 111, -103, 108, -120, 109, -98, 109,
    105, -108, 109, 111, -108, 80, -72, 112,
    46, 109, -46, 80, 80, -77, 80, -82,
    115, -114, 83, -118, 87, -98, 86, 8725,
    -109, 65, 8725, -109, 49, -26085, 50, -26085,
    51, -26085, 52, -26085, 53, -26085, 54, -26085,
    55, -26085, 56, -26085, 57, -26085, 49, 48,
    -26085, 49, 49, -26085, 49, 50, -26085, 49,
    51, -26085, 49, 52, -26085, 49, 53, -26085,
    49, 54, -26085, 49, 55, -26085, 49, 56,
    -26085, 49, 57, -26085, 50, 48, -26085, 50,
    49, -26085, 50, 50, -26085, 50, 51, -26085,
    50, 52, -26085, 50, 53, -26085, 50, 54,
    -26085, 50, 55, -26085, 50, 56, -26085, 50,
    57, -26085, 51, 48, -26085, 51, 49, -26085,
    103, 97, -108, 102, -102, 102, -105, 102,
    -108, 102, 102, -105, 102, 102, -108, 383,
    -116, 115, -116, 1396, -1398, 1396, -1381, 1396,
    -1387, 1406, -1398, 1396, -1389, 1497, -1460, 1522,
    -1463, 1513, -1473, 1513, -1474, 1488, -1463, 1488,
    -1464, 1488, -1468, 1489, -1468, 1490, -1468, 1491,
    -1468, 1492, -1468, 1493, -1468, 1494, -1468, 1496,
    -1468, 1497, -1468, 1498, -1468, 1499, -1468, 1500,
    -1468, 1502, -1468, 1504, -1468, 1505, -1468, 1507,
    -1468, 1508, -1468, 1510, -1468, 1511, -1468, 1512,
    -1468, 1513, -1468, 1514, -1468, 1493, -1465, 1489,
    -1471, 1499, -1471, 1508, -1471, 1488, -1500, 1574,
    -1575, 1574, -1749, 1574, -1608, 1574, -1735, 1574,
    -1734, 1574, -1736, 1574, -1744, 1574, -1609, 1574,
    -1580, 1574, -1581, 1574, -1605, 1574, -1610, 1576,
    -1580, 1576, -1581, 1576, -1582, 1576, -1605, 1576,
    -1609, 1576, -1610, 1578, -1580, 1578, -1581, 1578,
    -1582, 1578, -1605, 1578, -1609, 1578, -1610, 1579,
    -1580, 1579, -1605, 1579, -1609, 1579, -1610, 1580,
    -1581, 1580, -1605, 1581, -1580, 1581, -1605, 1582,
    -1580, 1582, -1581, 1582, -1605, 1587, -1580, 1587,
    -1581, 1587, -1582, 1587, -1605, 1589, -1581, 1589,
    -1605, 1590, -1580, 1590, -1581, 1590, -1582, 1590,
    -1605, 1591, -1581, 1591, -1605, 1592, -1605, 1593,
    -1580, 1593, -1605, 1594, -1580, 1594, -1605, 1601,
    -1580, 1601, -1581, 1601, -1582, 1601, -1605, 1601,
    -1609, 1601, -1610, 1602, -1581, 1602, -1605, 1602,
    -1609, 1602, -1610, 1603, -1575, 1603, -1580, 1603,
    -1581, 1603, -1582, 1603, -1604, 1603, -1605, 1603,
    -1609, 1603, -1610, 1604, -1580, 1604, -1581, 1604,
    -1582, 1604, -1605, 1604, -1609, 1604, -1610, 1605,
    -1580, 1605, -1581, 1605, -1582, 1605, -1605, 1605,
    -1609, 1605, -1610, 1606, -1580, 1606, -1581, 1606,
    -1582, 1606, -1605, 1606, -1609, 1606, -1610, 1607,
    -1580, 1607, -1605, 1607, -1609, 1607, -1610, 1610,
    -1580, 1610, -1581, 1610, -1582, 1610, -1605, 1610,
    -1609, 1610, -1610, 1584, -1648, 1585, -1648, 1609,
    -1648, 32, 1612, -1617, 32, 1613, -1617, 32,
    1614, -1617, 32, 1615, -1617, 32, 1616, -1617,
    32, 1617, -1648, 1574, -1585, 1574, -1586, 1574,
    -1606, 1576, -1585, 1576, -1586, 1576, -1606, 1578,
    -1585, 1578, -1586, 1578, -1606, 1579, -1585, 1579,
    -1586, 1579, -1606, 1605, -1575, 1606, -1585, 1606,
    -1586, 1606, -1606, 1610, -1585, 1610, -1586, 1610,
    -1606, 1574, -1582, 1574, -1607, 1576, -1607, 1578,
    -1607, 1589, -1582, 1604, -1607, 1606, -1607, 1607,
    -1648, 1610, -1607, 1579, -1607, 1587, -1607, 1588,
    -1605, 1588, -1607, 1600, 1614, -1617, 1600, 1615,
    -1617, 1600, 1616, -1617, 1591, -1609, 1591, -1610,
    1593, -1609, 1593, -1610, 1594, -1609, 1594, -1610,
    1587, -1609, 1587, -1610, 1588, -1609, 1588, -1610,
    1581, -1609, 1581, -1610, 1580, -1609, 1580, -1610,
    1582, -1609, 1582, -1610, 1589, -1609, 1589, -1610,
    1590, -1609, 1590, -1610, 1588, -1580, 1588, -1581,
    1588, -1582, 1588, -1585, 1587, -1585, 1589, -1585,
    1590, -1585, 1575, -1611, 1578, 1580, -1605, 1578,
    1581, -1580, 1578, 1581, -1605, 1578, 1582, -1605,
    1578, 1605, -1580, 1578, 1605, -1581, 1578, 1605,
    -1582, 1580, 1605, -1581, 1581, 1605, -1610, 1581,
    1605, -1609, 1587, 1581, -1580, 1587, 1580, -1581,
    1587, 1580, -1609, 1587, 1605, -1581, 1587, 1605,
    -1580, 1587, 1605, -1605, 1589, 1581, -1581, 1589,
    1605, -1605, 1588, 1581, -1605, 1588, 1580, -1610,
    1588, 1605, -1582, 1588, 1605, -1605, 1590, 1581,
    -1609, 1590, 1582, -1605, 1591, 1605, -1581, 1591,
    1605, -1605, 1591, 1605, -1610, 1593, 1580, -1605,
    1593, 1605, -1605, 1593, 1605, -1609, 1594, 1605,
    -1605, 1594, 1605, -1610, 1594, 1605, -1609, 1601,
    1582, -1605, 1602, 1605, -1581, 1602, 1605, -1605,
    1604, 1581, -1605, 1604, 1581, -1610, 1604, 1581,
    -1609, 1604, 1580, -1580, 1604, 1582, -1605, 1604,
    1605, -1581, 1605, 1581, -1580, 1605, 1581, -1605,
    1605, 1581, -1610, 1605, 1580, -1581, 1605, 1580,
    -1605, 1605, 1582, -1580, 1605, 1582, -1605, 1605,
    1580, -1582, 1607, 1605, -1580, 1607, 1605, -1605,
    1606, 1581, -1605, 1606, 1581, -1609, 1606, 1580,
    -1605, 1606, 1580, -1609, 1606, 1605, -1610, 1606,
    1605, -1609, 1610, 1605, -1605, 1576, 1582, -1610,
    1578, 1580, -1610, 1578, 1580, -1609, 1578, 1582,
    -1610, 1578, 1582, -1609, 1578, 1605, -1610, 1578,
    1605, -1609, 1580, 1605, -1610, 1580, 1581, -1609,
    1580, 1605, -1609, 1587, 1582, -1609, 1589, 1581,
    -1610, 1588, 1581, -1610, 1590, 1581, -1610, 1604,
    1580, -1610, 1604, 1605, -1610, 1610, 1581, -1610,
    1610, 1580, -1610, 1610, 1605, -1610, 1605, 1605,
    -1610, 1602, 1605, -1610, 1606, 1581, -1610, 1593,
    1605, -1610, 1603, 1605, -1610, 1606, 1580, -1581,
    1605, 1582, -1610, 1604, 1580, -1605, 1603, 1605,
    -1605, 1580, 1581, -1610, 1581, 1580, -1610, 1605,
    1580, -1610, 1601, 1605, -1610, 1576, 1581, -1610,
    1587, 1582, -1610, 1606, 1580, -1610, 1589, 1604,
    -1746, 1602, 1604, -1746, 1575, 1604, 1604, -1607,
    1575, 1603, 1576, -1585, 1605, 1581, 1605, -1583,
    1589, 1604, 1593, -1605, 1585, 1587, 1608, -1604,
    1593, 1604, 1610, -1607, 1608, 1587, 1604, -1605,
    1589, 1604, -1609, 1589, 1604, 1609, 32, 1575,
    1604, 1604, 1607, 32, 1593, 1604, 1610, 1607,
    32, 1608, 1587, 1604, -1605, 1580, 1604, 32,
    1580, 1604, 1575, 1604, -1607, 1585, 1740, 1575,
    -1604, 32, -1611, 1600, -1611, 32, -1612, 32,
    -1613, 32, -1614, 1600, -1614, 32, -1615, 1600,
    -1615, 32, -1616, 1600, -1616, 32, -1617, 1600,
    -1617, 32, -1618, 1600, -1618, 1604, -1570, 1604,
    -1571, 1604, -1573, 1604, -1575, 48, -46, 48,
    -44, 49, -44, 50, -44, 51, -44, 52,
    -44, 53, -44, 54, -44, 55, -44, 56,
    -44, 57, -44, 40, 65, -41, 40, 66,
    -41, 40, 67, -41, 40, 68, -41, 40,
    69, -41, 40, 70, -41, 40, 71, -41,
    40, 72, -41, 40, 73, -41, 40, 74,
    -41, 40, 75, -41, 40, 76, -41, 40,
    77, -41, 40, 78, -41, 40, 79, -41,
    40, 80, -41, 40, 81, -41, 40, 82,
    -41, 40, 83, -41, 40, 84, -41, 40,
    85, -41, 40, 86, -41, 40, 87, -41,
    40, 88, -41, 40, 89, -41, 40, 90,
    -41, 12308, 83, -12309, 67, -68, 87, -90,
    72, -86, 83, -68, 83, -83, 80, 80,
    -86, 87, -67, 77, -67, 77, -68, 68,
    -74, 12411, -12363, 12467, -12467, 12308, 26412, -12309,
    12308, 19977, -12309, 12308, 20108, -12309, 12308, 23433,
    -12309, 12308, 28857, -12309, 12308, 25171, -12309, 12308,
    30423, -12309, 12308, 21213, -12309, 12308, 25943, -12309,
    115, -115, 105, -775, 32, -953, 32, 776,
    -769, 4018, 3953, -3968, 4019, 3953, -3968, 7936,
    -953, 7937, -953, 7938, -953, 7939, -953, 7940,
    -953, 7941, -953, 7942, -953, 7943, -953, 7968,
    -953, 7969, -953, 7970, -953, 7971, -953, 7972,
    -953, 7973, -953, 7974, -953, 7975, -953, 8032,
    -953, 8033, -953, 8034, -953, 8035, -953, 8036,
    -953, 8037, -953, 8038, -953, 8039, -953, 8048,
    -953, 945, -953, 940, -953, 8118, -953, 32,
    776, -834, 8052, -953, 951, -953, 942, -953,
    8134, -953, 32, 787, -768, 32, 787, -769,
    32, 787, -834, 32, 788, -768, 32, 788,
    -769, 32, 788, -834, 32, 776, -768, 8060,
    -953, 969, -953, 974, -953, 8182, -953, 114,
    -115, 176, -99, 176, -102, 110, -111, 115,
    -109, 116, 101, -108, 116, -109, 102, 97,
    -120, 112, 116, -101, 104, -103, 101, -118,
    108, 116, -100, 104, 112, -97, 97, -117,
    111, -118, 100, 109, -50, 100, 109, -51,
    105, -117, 112, -97, 110, -97, 956, -97,
    109, -97, 107, -97, 107, -98, 103, -98,
    112, -102, 110, -102, 956, -102, 104, -122,
    107, 104, -122, 109, 104, -122, 103, 104,
    -122, 116, 104, -122, 956, -108, 109, -108,
    100, -108, 107, -108, 109, 109, -50, 99,
    109, -50, 109, -50, 107, 109, -50, 109,
    109, -51, 99, 109, -51, 109, -51, 107,
    109, -51, 109, 8725, 115, -50, 107, 112,
    -97, 109, 112, -97, 103, 112, -97, 114,
    97, 100, 8725, 115, -50, 112, -118, 110,
    -118, 956, -118, 109, -118, 107, -118, 112,
    -119, 110, -119, 956, -119, 109, -119, 107,
    -119, 107, -969, 109, -969, 98, -113, 99,
    8725, 107, -103, 99, 111, -46, 100, -98,
    103, -121, 104, -112, 107, -107, 112, -104,
    112, 112, -109, 112, -114, 115, -118, 119,
    -98, 118, 8725, -109, 97, 8725, -109, 1513,
    1468, -1473, 1513, 1468, -1474, 12308, 115, -12309,
    119, -122, 104, -118, 115, -100, 112, 112,
    -118, 119, -99, 109, -99, 109, -100, 100,
    -106,
};

const int32_t usequences2[909] = {
    0, -40863, -32769, -32780, -32786, -32819, -32895, -32905,
    -33251, -33258, -33267, -33276, -33292, -33307, -33311, -33390,
    -33394, -33400, -34381, -34411, -34880, -34892, -34915, -35198,
    -35211, -35282, -35328, -35895, -35910, -35925, -35960, -35997,
    -36196, -36208, -36275, -36523, -36554, -36763, -36784, -36789,
    -37009, -37193, -37318, -37324, -37329, -38263, -38272, -38428,
    -38582, -38585, -38632, -38737, -38750, -38754, -38761, -38859,
    -38893, -38899, -38913, -39080, -39131, -39135, -39318, -39321,
    -39340, -39592, -39640, -39647, -39717, -39727, -39730, -39740,
    -39770, -40165, -40565, -40575, -40613, -40635, -40643, -40653,
    -40657, -40697, -40701, -40718, -40723, -40736, -40763, -40778,
    -40786, -40845, -40860, -40864, 40, 37329, -41, 40,
    36001, -41, 40, 36039, -41, 40, 33258, -41,
    40, 33267, -41, -36001, -36969, -38917, -36039, -42863,
    -42791, -43831, -43858, -35912, -36040, -34367, -34746, -35064,
    -37007, -33853, -37226, -39409, -34349, -40478, -34253, -35172,
    -33240, -34847, -37070, -34310, -34396, -36335, -38706, -39791,
    -40442, -33737, -37636, -35542, -32894, -36034, -38647, -38475,
    -32907, -33777, -38517, -35712, -35582, -33865, -35498, -33509,
    -33391, -35538, -37327, -38317, -39530, -40599, -40654, -36706,
    -32879, -36646, -34030, -36899, -37706, -35010, -32838, -37428,
    -38646, -38728, -38936, -37300, -38584, -34044, -36988, -38446,
    -39006, -38520, -36650, -38534, -35023, -35041, -38626, -34298,
    -38563, -40023, -40607, -33256, -35672, -33590, -36667, -38477,
    -38742, -34322, -35576, -36920, -37117, -39151, -39164, -39208,
    -40372, -37086, -38583, -32773, -33261, -33401, -33879, -35088,
    -35222, -35585, -35641, -36051, -36104, -36790, -38627, -38911,
    -38971, -148206, -33304, -33618, -33775, -34681, -35137, -35206,
    -35519, -35531, -35565, -35722, -36664, -36978, -37273, -37494,
    -38524, -38875, -38923, -39698, -141386, -141380, -144341, -152137,
    -154832, -163539, -40771, -40846, 64329, -1473, 64329, -1474,
    69785, -69818, 69787, -69818, 69797, -69818, 69937, -69927,
    69938, -69927, 70471, -70462, 70471, -70487, 70841, -70842,
    70841, -70832, 70841, -70845, 71096, -71087, 71097, -71087,
    119127, -119141, 119128, -119141, 119135, -119150, 119135, -119151,
    119135, -119152, 119135, -119153, 119135, -119154, 119225, -119141,
    119226, -119141, 119227, -119150, 119228, -119150, 119227, -119151,
    119228, -119151, -35299, -36009, -36938, -37197, -131362, -132666,
    -132380, -132427, -168415, -133676, -133987, -136420, -136872, -136938,
    -137672, -138008, -138724, -138726, -139651, -172946, -140081, -33281,
    -144056, -156122, -141012, -142092, -142321, -143370, -32941, -144323,
    -144493, -145059, -145575, -146061, -138507, -146170, -146620, -146718,
    -147153, -147294, -147342, -132389, -148067, -148395, -149000, -149301,
    -149524, -150582, -150674, -139679, -151457, -151480, -151620, -151795,
    -151794, -151833, -151859, -152605, -153126, -153242, -153285, -153980,
    -154279, -154539, -154752, -155526, -156200, -156231, -156377, -156478,
    -156890, -156963, -32864, -157096, -32880, -144223, -32946, -33027,
    -33086, -157607, -157621, -144275, -144284, -33284, -36766, -33425,
    -33419, -33437, -33457, -33459, -33469, -33510, -158524, -33565,
    -33635, -33709, -33571, -33725, -33767, -33619, -33738, -33740,
    -33756, -158774, -159083, -158933, -34033, -34035, -34070, -160714,
    -34148, -159532, -159665, -159954, -34384, -34407, -34409, -34473,
    -34440, -34574, -34530, -34600, -34667, -34694, -34785, -34817,
    -34912, -161383, -35031, -35038, -35066, -161966, -162150, -35488,
    -162984, -36011, -36033, -36123, -36215, -163631, -133124, -36299,
    -36284, -36336, -133342, -36564, -165330, -165357, -37012, -37105,
    -37137, -165678, -37147, -37432, -37591, -37592, -37500, -37881,
    -37909, -166906, -38283, -38327, -167287, -38595, -38691, -168261,
    -168474, -38880, -168970, -169110, -38953, -169398, -39138, -39209,
    -39335, -39362, -39422, -170800, -40000, -40189, -40295, -172238,
    -172293, -172558, -172689, -40702, -40709, -40719, -40726, -173568,
    -42571, 40, 44032, -41, 40, 45208, -41, 40,
    45796, -41, 40, 46972, -41, 40, 47560, -41,
    40, 48148, -41, 40, 49324, -41, 40, 50500,
    -41, 40, 51088, -41, 40, 52264, -41, 40,
    52852, -41, 40, 53440, -41, 40, 54028, -41,
    40, 54616, -41, 40, 51452, -41, 40, 50724,
    51204, -41, 40, 50724, 54980, -41, -44032, -45208,
    -45796, -46972, -47560, -48148, -49324, -50500, -51088, -52264,
    -52852, -53440, -54028, -54616, 52280, -44256, 51452, -51032,
    -50864, -42561, -42563, -42565, -42567, -42569, -42573, -42575,
    -42577, -42579, -42581, -42583, -42585, -42587, -42589, -42591,
    -42593, -42595, -42597, -42599, -42601, -42603, -42605, -42625,
    -42627, -42629, -42631, -42633, -42635, -42637, -42639, -42641,
    -42643, -42645, -42647, -42649, -42651, -42787, -42789, -42793,
    -42795, -42797, -42799, -42803, -42805, -42807, -42809, -42811,
    -42813, -42815, -42817, -42819, -42821, -42823, -42825, -42827,
    -42829, -42831, -42833, -42835, -42837, -42839, -42841, -42843,
    -42845, -42847, -42849, -42851, -42853, -42855, -42857, -42859,
    -42861, -42874, -42876, -42879, -42881, -42883, -42885, -42887,
    -42892, -42897, -42899, -42903, -42905, -42907, -42909, -42911,
    -42913, -42915, -42917, -42919, -42921, -43859, -42933, -42935,
    -42937, -66600, -66601, -66602, -66603, -66604, -66605, -66606,
    -66607, -66608, -66609, -66610, -66611, -66612, -66613, -66614,
    -66615, -66616, -66617, -66618, -66619, -66620, -66621, -66622,
    -66623, -66624, -66625, -66626, -66627, -66628, -66629, -66630,
    -66631, -66632, -66633, -66634, -66635, -66636, -66637, -66638,
    -66639, -66776, -66777, -66778, -66779, -66780, -66781, -66782,
    -66783, -66784, -66785, -66786, -66787, -66788, -66789, -66790,
    -66791, -66792, -66793, -66794, -66795, -66796, -66797, -66798,
    -66799, -66800, -66801, -66802, -66803, -66804, -66805, -66806,
    -66807, -66808, -66809, -66810, -66811, -68800, -68801, -68802,
    -68803, -68804, -68805, -68806, -68807, -68808, -68809, -68810,
    -68811, -68812, -68813, -68814, -68815, -68816, -68817, -68818,
    -68819, -68820, -68821, -68822, -68823, -68824, -68825, -68826,
    -68827, -68828, -68829, -68830, -68831, -68832, -68833, -68834,
    -68835, -68836, -68837, -68838, -68839, -68840, -68841, -68842,
    -68843, -68844, -68845, -68846, -68847, -68848, -68849, -68850,
    -71872, -71873, -71874, -71875, -71876, -71877, -71878, -71879,
    -71880, -71881, -71882, -71883, -71884, -71885, -71886, -71887,
    -71888, -71889, -71890, -71891, -71892, -71893, -71894, -71895,
    -71896, -71897, -71898, -71899, -71900, -71901, -71902, -71903,
    -93792, -93793, -93794, -93795, -93796, -93797, -93798, -93799,
    -93800, -93801, -93802, -93803, -93804, -93805, -93806, -93807,
    -93808, -93809, -93810, -93811, -93812, -93813, -93814, -93815,
    -93816, -93817, -93818, -93819, -93820, -93821, -93822, -93823,
    119128, 119141, -119150, 119128, 119141, -119151, 119128, 119141,
    -119152, 119128, 119141, -119153, 119128, 119141, -119154, 119225,
    119141, -119150, 119226, 119141, -119150, 119225, 119141, -119151,
    119226, 119141, -119151, -125218, -125219, -125220, -125221, -125222,
    -125223, -125224, -125225, -125226, -125227, -125228, -125229, -125230,
    -125231, -125232, -125233, -125234, -125235, -125236, -125237, -125238,
    -125239, -125240, -125241, -125242, -125243, -125244, -125245, -125246,
    -125247, -125248, -125249, -125250, -125251,
};

const uint8_t upropshash1[763] = {
    2, 3, 4, 5, 6, 7, 8, 9,
    10, 11, 12, 13, 14, 15, 16, 17,
    18, 19, 20, 21, 22, 1, 23, 24,
    25, 26, 27, 28, 29, 30, 31, 32,
    33, 34, 35, 36, 37, 0, 0, 0,
    0, 0, 38, 0, 39, 40, 41, 42,
    43, 44, 45, 46, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 47, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 48,
    1, 1, 1, 1, 49, 1, 50, 51,
    52, 53, 54, 55, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 56,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 57, 58, 59, 60, 61, 62, 63,
    0, 64, 65, 66, 67, 0, 0, 0,
    0, 0, 68, 0, 69, 70, 0, 71,
    72, 73, 74, 75, 76, 77, 78, 79,
    80, 0, 81, 0, 82, 83, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 84, 85, 0, 0, 86, 87,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 88, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 89, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 90, 91, 0, 92, 93, 94, 95,
    0, 0, 0, 0, 0, 0, 0, 0,
    96, 0, 0, 0, 0, 0, 0, 0,
    97, 98, 0, 0, 0, 0, 99, 0,
    0, 100, 101, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 102, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 103,
    104, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 105, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 106, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    107, 108, 109,
};

const uint16_t upropshash2[110][256] = {
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 591, 592, 593, 0,
    0, 594, 595, 596, 597, 598, 599, 600,
    601, 602, 603, 604, 605, 606, 607, 608,
    609, 610, 611, 612, 613, 614, 615, 616,
    617, 618, 619, 0, 0, 0, 0, 2,
    0, 620, 621, 622, 623, 624, 625, 626,
    627, 628, 629, 630, 631, 632, 633, 634,
    635, 1, 636, 637, 638, 639, 640, 641,
    642, 643, 644, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    63, 0, 0, 0, 0, 0, 0, 0,
    645, 0, 13, 0, 0, 0, 0, 646,
    0, 0, 219, 220, 265, 97, 0, 2,
    647, 221, 14, 0, 648, 649, 650, 0,
    651, 652, 653, 654, 655, 656, 657, 658,
    659, 660, 661, 662, 663, 664, 665, 666,
    667, 668, 669, 670, 671, 672, 673, 0,
    674, 675, 676, 677, 678, 679, 680, 266,
    681, 682, 683, 684, 685, 686, 687, 688,
    689, 690, 691, 692, 693, 694, 695, 696,
    1, 697, 698, 699, 700, 701, 702, 0,
    703, 704, 705, 706, 707, 708, 1, 709},
    {710, 711, 712, 713, 714, 715, 716, 717,
    718, 719, 720, 721, 722, 723, 724, 725,
    726, 1, 727, 728, 729, 730, 731, 732,
    733, 734, 735, 736, 737, 738, 739, 740,
    741, 742, 743, 744, 745, 746, 747, 1,
    748, 749, 750, 751, 752, 753, 754, 755,
    756, 1, 757, 758, 759, 760, 761, 762,
    1, 763, 764, 765, 766, 767, 768, 769,
    770, 771, 1, 772, 773, 774, 775, 776,
    777, 778, 779, 1, 780, 781, 782, 783,
    784, 785, 786, 1, 787, 788, 789, 790,
    791, 792, 793, 794, 795, 796, 797, 798,
    799, 800, 801, 802, 803, 804, 805, 1,
    806, 807, 808, 809, 810, 811, 812, 813,
    814, 815, 816, 817, 818, 819, 820, 821,
    822, 823, 824, 825, 826, 827, 828, 829,
    1, 830, 831, 1, 832, 1, 833, 834,
    1, 835, 836, 837, 1, 1, 838, 839,
    840, 841, 1, 842, 843, 1, 844, 845,
    846, 1, 1, 1, 847, 848, 1, 849,
    850, 851, 852, 1, 853, 1, 854, 855,
    1, 856, 1, 1, 857, 1, 858, 859,
    860, 861, 862, 863, 1, 864, 1, 865,
    866, 1, 1, 1, 867, 1, 1, 1,
    1, 1, 1, 1, 868, 869, 870, 871,
    872, 873, 874, 875, 876, 877, 878, 879,
    880, 881, 882, 883, 884, 885, 886, 887,
    888, 889, 890, 891, 892, 1, 893, 894,
    895, 896, 897, 898, 899, 1, 900, 901,
    902, 903, 904, 905, 906, 907, 908, 909,
    910, 911, 912, 913, 914, 915, 916, 917,
    918, 919, 920, 921, 922, 923, 924, 925},
    {926, 927, 928, 929, 930, 931, 932, 933,
    934, 935, 936, 937, 938, 939, 940, 941,
    942, 943, 944, 945, 946, 947, 948, 949,
    950, 951, 952, 953, 954, 1, 955, 956,
    957, 1, 958, 1, 959, 1, 960, 961,
    962, 963, 964, 965, 966, 967, 968, 969,
    970, 971, 972, 973, 1, 1, 1, 1,
    1, 1, 974, 975, 1, 976, 977, 1,
    1, 978, 1, 979, 980, 981, 982, 1,
    983, 1, 984, 1, 985, 1, 986, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 987, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    22, 988, 15, 23, 989, 990, 991, 35,
    36, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 0, 0, 0,
    992, 993, 994, 995, 996, 997, 0, 0,
    998, 12, 24, 16, 999, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1000, 1001, 1002, 1003, 1004, 3, 1005, 1006,
    1007, 1008, 1009, 1010, 1011, 3, 3, 1012,
    3, 1013, 3, 1014, 1015, 118, 4, 4,
    4, 4, 118, 1016, 4, 4, 4, 4,
    4, 222, 222, 1017, 1018, 1019, 1020, 1021,
    1022, 4, 4, 4, 4, 1023, 1024, 4,
    1025, 1026, 4, 4, 65, 65, 65, 65,
    1027, 4, 4, 4, 4, 3, 3, 3,
    1028, 1029, 1030, 1031, 1032, 1033, 3, 4,
    4, 4, 3, 3, 3, 4, 4, 0,
    3, 3, 3, 4, 4, 4, 4, 3,
    118, 4, 4, 3, 171, 119, 119, 171,
    119, 119, 171, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    1034, 1, 1035, 1, 1036, 0, 1037, 1,
    0, 0, 1038, 1, 1, 1, 1039, 1040,
    0, 0, 0, 0, 265, 1041, 1042, 1043,
    1044, 1045, 1046, 0, 1047, 0, 1048, 1049,
    1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057,
    1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065,
    1066, 1067, 0, 267, 1068, 1069, 1070, 1071,
    1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079,
    1080, 1081, 1, 1, 1, 1082, 1, 1083,
    1, 1084, 1, 1, 1, 1, 1, 1085,
    1, 1086, 267, 1, 1, 1087, 1, 1,
    1, 1088, 1089, 1090, 1091, 1092, 1093, 1094,
    85, 90, 1095, 1096, 1097, 86, 91, 1,
    1098, 1, 1099, 1, 1100, 1, 1101, 1,
    1102, 1, 1103, 0, 1104, 0, 1105, 0,
    1106, 0, 1107, 0, 1108, 0, 1109, 0,
    98, 92, 99, 1, 100, 101, 0, 1110,
    1, 102, 1111, 1, 1, 1112, 1113, 1114},
    {1115, 1116, 1117, 1118, 1119, 1120, 1121, 1122,
    1123, 1124, 1125, 1126, 1127, 1128, 1129, 1130,
    1131, 1132, 268, 1133, 269, 1134, 1135, 1136,
    1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144,
    1145, 270, 223, 1146, 1147, 1148, 1149, 1150,
    1151, 1152, 271, 1153, 1154, 1155, 1156, 1157,
    1158, 1, 1, 1159, 1, 1160, 1161, 1162,
    1163, 1164, 1165, 1, 1, 1, 1166, 1,
    1, 1, 1, 1167, 1, 1, 1, 1168,
    1, 1, 1, 1169, 1, 1170, 1, 1,
    1171, 1172, 1, 1173, 1, 1, 1174, 1175,
    1, 1, 1, 1, 1176, 1177, 1178, 1,
    1179, 1, 272, 1, 1180, 1, 1181, 1,
    1182, 1, 1183, 1, 1184, 1, 1185, 1,
    1186, 1, 1187, 1, 1188, 1189, 1190, 1191,
    1192, 1, 1193, 1, 1194, 1, 1195, 1,
    1196, 1, 0, 3, 3, 3, 3, 3,
    0, 0, 1197, 1, 1198, 1, 1199, 1,
    1200, 1, 1201, 1, 1202, 1, 1203, 1,
    1204, 1, 1205, 1, 1206, 1, 1207, 1,
    1208, 1, 1209, 1, 1210, 1, 1211, 1,
    1212, 1, 1213, 1, 1214, 1, 1215, 1,
    1216, 1, 1217, 1, 1218, 1, 1219, 1,
    1220, 1, 1221, 1, 1222, 1, 1223, 1,
    1224, 1225, 1226, 1227, 1, 1228, 1, 1229,
    1, 1230, 1, 1231, 1, 1232, 1, 1,
    1233, 1234, 1235, 1236, 1237, 1, 1238, 1239,
    1240, 1241, 1242, 1243, 1244, 1245, 1246, 1247,
    1248, 1, 1249, 1250, 1251, 1252, 1253, 1254,
    1255, 1256, 1257, 1258, 1259, 1260, 1261, 1262,
    1263, 1264, 1265, 1266, 1267, 1268, 1269, 1,
    1270, 1271, 1272, 1, 1273, 1, 1274, 1},
    {1275, 1, 1276, 1, 1277, 1, 1278, 1,
    1279, 1, 1280, 1, 1281, 1, 1282, 1,
    1283, 1, 1284, 1, 1285, 1, 1286, 1,
    1287, 1, 1288, 1, 1289, 1, 1290, 1,
    1291, 1, 1292, 1, 1293, 1, 1294, 1,
    1295, 1, 1296, 1, 1297, 1, 1298, 1,
    0, 1299, 1300, 1301, 1302, 1303, 1304, 1305,
    1306, 1307, 1308, 1309, 1310, 1311, 1312, 1313,
    1314, 1315, 1316, 1317, 1318, 1319, 1320, 1321,
    1322, 1323, 1324, 1325, 1326, 1327, 1328, 1329,
    1330, 1331, 1332, 1333, 1334, 1335, 1336, 0,
    0, 1, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1337,
    1, 0, 0, 0, 0, 0, 0, 0,
    0, 4, 3, 3, 3, 3, 4, 3,
    3, 3, 172, 4, 3, 3, 3, 3,
    3, 3, 4, 4, 4, 4, 4, 4,
    3, 3, 4, 3, 3, 172, 173, 3,
    1338, 1339, 1340, 1341, 1342, 1343, 1344, 1345,
    273, 274, 274, 1346, 1347, 1348, 0, 1349,
    0, 1350, 1351, 0, 3, 4, 0, 273,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    3, 3, 3, 3, 3, 3, 3, 3,
    275, 276, 277, 0, 0, 0, 0, 0,
    1, 1, 1352, 1353, 1354, 1355, 1356, 1357,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 1, 1, 1, 1, 1, 1, 1,
    1358, 1, 1359, 278, 279, 280, 275, 276,
    277, 1360, 1361, 1362, 1363, 1364, 4, 3,
    3, 3, 3, 3, 4, 3, 3, 4,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 1, 1,
    1365, 1, 1, 1, 1, 1366, 1367, 1368,
    1369, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1370, 1371, 1372, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1373, 1374, 0, 1375, 3, 3,
    3, 3, 3, 3, 3, 0, 0, 3,
    3, 3, 3, 4, 3, 1, 1, 3,
    3, 0, 4, 3, 3, 4, 1, 1,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 1, 1, 1, 0, 0, 1},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1376, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    3, 4, 3, 3, 4, 3, 3, 4,
    4, 4, 3, 4, 4, 3, 4, 3,
    3, 3, 4, 3, 4, 3, 4, 3,
    4, 3, 3, 0, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 3, 3, 3, 3, 3,
    3, 3, 4, 3, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 4, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 5, 5,
    5, 5, 0, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 0, 5, 5, 5,
    0, 5, 5, 5, 5, 5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 4, 4, 4, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 4, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 0, 4, 3, 3, 4, 3,
    3, 4, 3, 3, 3, 4, 4, 4,
    278, 279, 280, 3, 3, 3, 4, 3,
    3, 4, 4, 3, 3, 3, 3, 3},
    {2, 2, 2, 2, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1377, 1378, 1, 1, 1, 1, 1, 1,
    1379, 1380, 1, 1381, 1382, 1, 1, 1,
    1, 1, 2, 2, 1383, 1, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 8, 2, 2,
    1, 3, 4, 3, 3, 2, 2, 2,
    1384, 1385, 1386, 1387, 1388, 1389, 1390, 1391,
    1, 1, 2, 2, 0, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 2, 2, 2, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 1,
    1, 0, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 0, 0, 0, 1, 1,
    1, 1, 0, 0, 64, 1, 1392, 2,
    2, 2, 2, 2, 2, 0, 0, 1393,
    2, 0, 0, 1394, 1395, 8, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 1396,
    0, 0, 0, 0, 1397, 1398, 0, 1399,
    1, 1, 2, 2, 0, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    1, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 3, 0},
    {0, 2, 2, 2, 0, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 1,
    1, 0, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1400, 0, 1, 1401, 0,
    1, 1, 0, 0, 64, 0, 2, 2,
    2, 2, 2, 0, 0, 0, 0, 2,
    2, 0, 0, 2, 2, 8, 0, 0,
    0, 2, 0, 0, 0, 0, 0, 0,
    0, 1402, 1403, 1404, 1, 0, 1405, 0,
    0, 0, 0, 0, 0, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 1, 1, 1, 2, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 2, 2, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 1,
    1, 1, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 0, 1, 1, 1,
    1, 1, 0, 0, 64, 1, 2, 2,
    2, 2, 2, 2, 2, 2, 0, 2,
    2, 2, 0, 2, 2, 8, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 2, 2, 0, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 2, 2, 2, 2, 2, 2},
    {0, 2, 2, 2, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 1,
    1, 0, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 0, 1, 1, 1,
    1, 1, 0, 0, 64, 1, 1406, 2,
    2, 2, 2, 2, 2, 0, 0, 1407,
    1408, 0, 0, 1409, 1410, 8, 0, 0,
    0, 0, 0, 0, 0, 0, 1411, 1412,
    0, 0, 0, 0, 1413, 1414, 0, 1,
    1, 1, 2, 2, 0, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 1, 0, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 1, 1,
    1, 0, 1415, 1, 1416, 1, 0, 0,
    0, 1, 1, 0, 1, 0, 1, 1,
    0, 0, 0, 1, 1, 0, 0, 0,
    1, 1, 1, 0, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 0, 1417, 2,
    2, 2, 2, 0, 0, 0, 1418, 1419,
    2, 0, 1420, 1421, 1422, 8, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 1423,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {2, 2, 2, 2, 2, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 1, 2, 2,
    2, 2, 2, 2, 2, 0, 1424, 2,
    1425, 0, 2, 2, 2, 8, 0, 0,
    0, 0, 0, 0, 0, 1426, 1427, 0,
    1, 1, 1, 0, 0, 0, 0, 0,
    1, 1, 2, 2, 0, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 2, 2, 2, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 1, 1, 1,
    1, 1, 0, 0, 64, 1, 2, 1428,
    1429, 2, 1430, 2, 2, 0, 1431, 1432,
    1433, 0, 1434, 1435, 2, 8, 0, 0,
    0, 0, 0, 0, 0, 1436, 1437, 0,
    0, 0, 0, 0, 0, 0, 1, 0,
    1, 1, 2, 2, 0, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {2, 2, 2, 2, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 8, 8, 1, 1438, 2,
    2, 2, 2, 2, 2, 0, 1439, 1440,
    2, 0, 1441, 1442, 1443, 8, 1, 0,
    0, 0, 0, 0, 1, 1, 1, 1444,
    0, 0, 0, 0, 0, 0, 0, 1,
    1, 1, 2, 2, 0, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 1, 1, 1, 1, 1,
    0, 0, 2, 2, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    0, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    0, 0, 1445, 0, 0, 0, 0, 1446,
    2, 2, 2, 2, 2, 0, 2, 0,
    2, 1447, 1448, 2, 1449, 1450, 1451, 1452,
    0, 0, 0, 0, 0, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 0, 2, 2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 2, 1, 1453, 2, 2, 2, 2,
    281, 281, 8, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 2,
    174, 174, 174, 174, 2, 2, 2, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 0, 1, 0, 0, 1,
    1, 0, 1, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 1, 1, 1, 1,
    0, 1, 1, 1, 1, 1, 1, 1,
    0, 1, 1, 1, 0, 1, 0, 1,
    0, 0, 1, 1, 0, 1, 1, 1,
    1, 2, 1, 1454, 2, 2, 2, 2,
    282, 282, 0, 2, 2, 1, 0, 0,
    1, 1, 1, 1, 1, 0, 1, 0,
    175, 175, 175, 175, 2, 2, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 1455, 1456, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1457, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 4, 0, 4,
    0, 1458, 0, 0, 0, 0, 2, 2,
    1, 1, 1, 1459, 1, 1, 1, 1,
    0, 1, 1, 1, 1, 1460, 1, 1,
    1, 1, 1461, 1, 1, 1, 1, 1462,
    1, 1, 1, 1, 1463, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1464, 1, 1, 1, 0, 0, 0,
    0, 1465, 103, 1466, 1467, 1468, 1469, 1470,
    1471, 1472, 103, 103, 103, 103, 2, 2,
    103, 1473, 3, 3, 8, 0, 3, 3,
    1, 1, 1, 1, 1, 2, 2, 2,
    2, 2, 2, 1474, 2, 2, 2, 2,
    0, 2, 2, 2, 2, 1475, 2, 2,
    2, 2, 1476, 2, 2, 2, 2, 1477,
    2, 2, 2, 2, 1478, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 1479, 2, 2, 2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1480, 1481, 1,
    1, 1, 1, 2, 2, 2, 1482, 2,
    2, 2, 2, 2, 2, 2, 2, 64,
    2, 8, 8, 2, 2, 2, 2, 1,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 2, 2,
    2, 2, 1, 1, 1, 1, 2, 2,
    2, 1, 2, 2, 2, 1, 1, 2,
    2, 2, 2, 2, 2, 2, 1, 1,
    1, 2, 2, 2, 2, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 4, 1, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 0, 0,
    1483, 1484, 1485, 1486, 1487, 1488, 1489, 1490,
    1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498,
    1499, 1500, 1501, 1502, 1503, 1504, 1505, 1506,
    1507, 1508, 1509, 1510, 1511, 1512, 1513, 1514,
    1515, 1516, 1517, 1518, 1519, 1520, 0, 1521,
    0, 0, 0, 0, 0, 1522, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 1523, 1, 1, 1},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    0, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 0, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 0, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 3, 3, 3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0,
    1524, 1525, 1526, 1527, 1528, 1529, 0, 0},
    {0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 9, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 9, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 8, 2, 0, 0, 0, 1,
    0, 0, 0, 0, 1, 3, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1530, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 172, 3, 4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 5,
    7, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 0,
    8, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 3, 3, 3,
    3, 3, 3, 3, 3, 0, 0, 4,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    3, 3, 3, 3, 3, 4, 4, 4,
    4, 4, 4, 3, 3, 4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {2, 2, 2, 2, 2, 1531, 1532, 1533,
    1534, 1535, 1536, 1537, 1538, 1539, 1540, 1,
    1, 1541, 1542, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 64, 1543, 2, 2,
    2, 2, 1544, 1545, 1546, 1547, 1548, 1549,
    1550, 1551, 1552, 1553, 8, 1, 1, 1,
    1, 1, 1, 1, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3, 4, 3, 3, 3,
    3, 3, 3, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 8, 8, 2, 2, 1, 1,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 64, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 8, 8, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 64,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 1, 1, 1,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0,
    268, 269, 1554, 270, 223, 223, 271, 272,
    283, 0, 0, 0, 0, 0, 0, 0,
    1555, 1556, 1557, 1558, 1559, 1560, 1561, 1562,
    1563, 1564, 1565, 1566, 1567, 1568, 1569, 1570,
    1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578,
    1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586,
    1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594,
    1595, 1596, 1597, 0, 0, 1598, 1599, 1600,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    3, 3, 3, 0, 65, 4, 4, 4,
    4, 4, 3, 3, 4, 4, 4, 4,
    3, 2, 65, 65, 65, 65, 65, 65,
    65, 1, 1, 1, 1, 4, 1, 1,
    1, 1, 2, 2, 3, 1, 1, 2,
    3, 3, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 37, 1601, 38, 1,
    17, 39, 1602, 40, 41, 25, 42, 43,
    26, 27, 44, 1, 45, 1603, 46, 47,
    48, 49, 50, 13, 1604, 1605, 1606, 51,
    18, 19, 284, 1607, 285, 52, 1, 28,
    20, 1608, 14, 1609, 1610, 1611, 29, 30,
    31, 1612, 1613, 21, 1614, 85, 87, 104,
    86, 93, 10, 23, 31, 21, 85, 87,
    92, 86, 93, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1615, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1616, 32, 1617, 1618, 285,
    53, 1619, 1620, 1621, 1622, 1623, 1624, 1625,
    1626, 1627, 1628, 1629, 1630, 1631, 1632, 1633,
    1634, 1635, 1636, 1637, 1638, 1639, 1640, 1641,
    1642, 1643, 1644, 54, 1645, 1646, 1647, 90,
    3, 3, 4, 3, 3, 3, 3, 3,
    3, 3, 4, 3, 3, 119, 1648, 4,
    222, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 118, 173,
    173, 4, 0, 3, 171, 4, 3, 4},
    {1649, 1650, 1651, 1652, 1653, 1654, 1655, 1656,
    1657, 1658, 1659, 1660, 1661, 1662, 1663, 1664,
    1665, 1666, 1667, 1668, 1669, 1670, 1671, 1672,
    1673, 1674, 1675, 1676, 1677, 1678, 1679, 1680,
    1681, 1682, 1683, 1684, 1685, 1686, 1687, 1688,
    1689, 1690, 1691, 1692, 1693, 1694, 1695, 1696,
    1697, 1698, 1699, 1700, 1701, 1702, 1703, 1704,
    1705, 1706, 1707, 1708, 1709, 1710, 1711, 1712,
    1713, 1714, 1715, 1716, 1717, 1718, 1719, 1720,
    1721, 1722, 1723, 1724, 1725, 1726, 1727, 1728,
    1729, 1730, 1731, 1732, 1733, 1734, 1735, 1736,
    1737, 1738, 1739, 1740, 1741, 1742, 1743, 1744,
    1745, 1746, 1747, 1748, 1749, 1750, 1751, 1752,
    1753, 1754, 1755, 1756, 1757, 1758, 1759, 1760,
    1761, 1762, 1763, 1764, 1765, 1766, 1767, 1768,
    1769, 1770, 1771, 1772, 1773, 1774, 1775, 1776,
    1777, 1778, 1779, 1780, 1781, 1782, 1783, 1784,
    1785, 1786, 1787, 1788, 1789, 1790, 1791, 1792,
    1793, 1794, 1795, 1796, 1797, 1798, 1799, 1800,
    1801, 1802, 1803, 1804, 1, 1, 266, 1,
    1805, 1806, 1807, 1808, 1809, 1810, 1811, 1812,
    1813, 1814, 1815, 1816, 1817, 1818, 1819, 1820,
    1821, 1822, 1823, 1824, 1825, 1826, 1827, 1828,
    1829, 1830, 1831, 1832, 1833, 1834, 1835, 1836,
    1837, 1838, 1839, 1840, 1841, 1842, 1843, 1844,
    1845, 1846, 1847, 1848, 1849, 1850, 1851, 1852,
    1853, 1854, 1855, 1856, 1857, 1858, 1859, 1860,
    1861, 1862, 1863, 1864, 1865, 1866, 1867, 1868,
    1869, 1870, 1871, 1872, 1873, 1874, 1875, 1876,
    1877, 1878, 1879, 1880, 1881, 1882, 1883, 1884,
    1885, 1886, 1887, 1888, 1889, 1890, 1891, 1892,
    1893, 1894, 1895, 1, 1896, 1, 1897, 1},
    {1898, 1899, 1900, 1901, 1902, 1903, 1904, 1905,
    1906, 1907, 1908, 1909, 1910, 1911, 1912, 1913,
    1914, 1915, 1916, 1917, 1918, 1919, 0, 0,
    1920, 1921, 1922, 1923, 1924, 1925, 0, 0,
    1926, 1927, 1928, 1929, 1930, 1931, 1932, 1933,
    1934, 1935, 1936, 1937, 1938, 1939, 1940, 1941,
    1942, 1943, 1944, 1945, 1946, 1947, 1948, 1949,
    1950, 1951, 1952, 1953, 1954, 1955, 1956, 1957,
    1958, 1959, 1960, 1961, 1962, 1963, 0, 0,
    1964, 1965, 1966, 1967, 1968, 1969, 0, 0,
    1970, 1971, 1972, 1973, 1974, 1975, 1976, 1977,
    0, 1978, 0, 1979, 0, 1980, 0, 1981,
    1982, 1983, 1984, 1985, 1986, 1987, 1988, 1989,
    1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997,
    1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
    2006, 2007, 2008, 2009, 2010, 2011, 0, 0,
    2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019,
    2020, 2021, 2022, 2023, 2024, 2025, 2026, 2027,
    2028, 2029, 2030, 2031, 2032, 2033, 2034, 2035,
    2036, 2037, 2038, 2039, 2040, 2041, 2042, 2043,
    2044, 2045, 2046, 2047, 2048, 2049, 2050, 2051,
    2052, 2053, 2054, 2055, 2056, 2057, 2058, 2059,
    2060, 2061, 2062, 2063, 2064, 0, 2065, 2066,
    2067, 2068, 2069, 2070, 2071, 2072, 2073, 2074,
    2075, 2076, 2077, 2078, 2079, 0, 2080, 2081,
    2082, 2083, 2084, 2085, 2086, 2087, 2088, 2089,
    2090, 2091, 2092, 2093, 0, 0, 2094, 2095,
    2096, 2097, 2098, 2099, 0, 2100, 2101, 2102,
    2103, 2104, 2105, 2106, 2107, 2108, 2109, 2110,
    2111, 2112, 2113, 2114, 2115, 2116, 2117, 2118,
    0, 0, 2119, 2120, 2121, 0, 2122, 2123,
    2124, 2125, 2126, 2127, 2128, 2129, 2130, 0},
    {2131, 2132, 63, 63, 63, 63, 63, 63,
    63, 63, 63, 0, 0, 0, 0, 0,
    0, 2133, 0, 0, 0, 0, 0, 2134,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 224, 2135, 2136, 0,
    0, 0, 0, 0, 0, 0, 0, 63,
    0, 0, 0, 2137, 2138, 0, 2139, 2140,
    0, 0, 0, 0, 2141, 0, 2142, 2,
    2, 0, 0, 0, 0, 0, 0, 2143,
    2144, 2145, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 0, 0, 2146,
    0, 0, 0, 0, 0, 0, 0, 63,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    225, 10, 0, 0, 226, 227, 228, 229,
    230, 231, 120, 286, 176, 121, 122, 33,
    225, 221, 219, 220, 226, 227, 228, 229,
    230, 231, 120, 286, 176, 121, 122, 0,
    13, 19, 14, 16, 284, 22, 28, 12,
    20, 33, 29, 24, 30, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2147, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5, 5, 11, 11, 5, 5, 5, 5,
    11, 11, 11, 5, 5, 0, 0, 0,
    0, 5, 0, 0, 0, 11, 11, 5,
    7, 5, 11, 11, 7, 7, 7, 7,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {2148, 2149, 55, 2150, 0, 2151, 2152, 2153,
    0, 2154, 52, 41, 41, 41, 22, 2155,
    25, 25, 26, 12, 0, 44, 2156, 0,
    1, 46, 57, 47, 47, 47, 0, 0,
    2157, 2158, 2159, 0, 58, 0, 2160, 0,
    58, 0, 2161, 2162, 38, 55, 1, 19,
    39, 59, 2163, 27, 14, 287, 2164, 2165,
    288, 10, 0, 2166, 91, 87, 105, 106,
    2167, 0, 0, 0, 0, 17, 18, 19,
    10, 15, 0, 0, 0, 0, 1, 0,
    2168, 2169, 2170, 2171, 2172, 2173, 2174, 2175,
    2176, 2177, 2178, 2179, 2180, 2181, 2182, 2183,
    25, 2184, 2185, 2186, 34, 2187, 2188, 2189,
    2190, 56, 2191, 2192, 26, 55, 17, 27,
    10, 2193, 2194, 2195, 21, 2196, 2197, 2198,
    2199, 16, 2200, 2201, 12, 32, 18, 20,
    1, 1, 1, 2202, 1, 1, 1, 1,
    1, 2203, 0, 0, 0, 0, 0, 0,
    2204, 0, 2205, 0, 2206, 0, 0, 0,
    0, 0, 2207, 2208, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2209, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2210, 2211, 2212,
    2213, 0, 2214, 0, 2215, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 2216, 2217, 0, 0, 0,
    2218, 2219, 0, 2220, 2221, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2222, 2223, 2224, 2225, 0,
    0, 0, 0, 0, 2226, 2227, 0, 2228,
    2229, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2230, 0, 0, 0,
    0, 2231, 0, 2232, 2233, 2234, 0, 2235,
    2236, 2237, 0, 0, 0, 2238, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2239, 2240, 2241, 0, 2242, 2243, 0, 0,
    0, 0, 0, 0, 0, 2244, 2245, 2246,
    2247, 2248, 2249, 2250, 2251, 2252, 2253, 2254,
    2255, 2256, 2257, 2258, 2259, 2260, 0, 0,
    2261, 2262, 2263, 2264, 2265, 2266, 2267, 2268,
    2269, 2270, 0, 0, 0, 0, 0, 0,
    0, 2271, 2272, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2273, 0, 0, 0, 0, 0,
    2274, 2275, 0, 2276, 2277, 2278, 2279, 2280,
    0, 0, 2281, 2282, 2283, 2284, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2285, 2286, 2287, 2288, 0, 0, 0, 0,
    0, 0, 2289, 2290, 2291, 2292, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2293, 2294, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    221, 219, 220, 226, 227, 228, 229, 230,
    231, 2295, 2296, 2297, 2298, 2299, 2300, 2301,
    2302, 2303, 2304, 2305, 2306, 2307, 2308, 2309,
    2310, 2311, 2312, 2313, 2314, 2315, 2316, 2317,
    2318, 2319, 2320, 2321, 2322, 2323, 2324, 2325,
    2326, 2327, 2328, 2329, 2330, 2331, 2332, 2333,
    2334, 2335, 2336, 2337, 2338, 2339, 2340, 2341,
    2342, 2343, 2344, 2345, 2346, 2347, 2348, 2349,
    2350, 2351, 2352, 2353, 2354, 2355, 2356, 2357,
    2358, 2359, 2360, 2361, 2362, 2363, 2364, 2365,
    2366, 2367, 2368, 2369, 2370, 2371, 289, 290,
    232, 291, 292, 293, 294, 295, 296, 297,
    298, 299, 300, 301, 302, 303, 304, 233,
    305, 306, 307, 308, 309, 310, 311, 312,
    2372, 2373, 2374, 2375, 2376, 2377, 2378, 2379,
    2380, 2381, 2382, 2383, 2384, 2385, 2386, 2387,
    2388, 2389, 2390, 2391, 2392, 2393, 2394, 2395,
    2396, 2397, 225, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2398, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2399, 2400, 2401, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2402, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {2403, 2404, 2405, 2406, 2407, 2408, 2409, 2410,
    2411, 2412, 2413, 2414, 2415, 2416, 2417, 2418,
    2419, 2420, 2421, 2422, 2423, 2424, 2425, 2426,
    2427, 2428, 2429, 2430, 2431, 2432, 2433, 2434,
    2435, 2436, 2437, 2438, 2439, 2440, 2441, 2442,
    2443, 2444, 2445, 2446, 2447, 2448, 2449, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2450, 1, 2451, 2452, 2453, 1, 1, 2454,
    1, 2455, 1, 2456, 1, 2457, 2458, 2459,
    2460, 1, 2461, 1, 1, 2462, 1, 1,
    1, 1, 1, 1, 15, 34, 2463, 2464,
    2465, 0, 2466, 0, 2467, 0, 2468, 0,
    2469, 0, 2470, 0, 2471, 0, 2472, 0,
    2473, 0, 2474, 0, 2475, 0, 2476, 0,
    2477, 0, 2478, 0, 2479, 0, 2480, 0,
    2481, 0, 2482, 0, 2483, 0, 2484, 0,
    2485, 0, 2486, 0, 2487, 0, 2488, 0,
    2489, 0, 2490, 0, 2491, 0, 2492, 0,
    2493, 0, 2494, 0, 2495, 0, 2496, 0,
    2497, 0, 2498, 0, 2499, 0, 2500, 0,
    2501, 0, 2502, 0, 2503, 0, 2504, 0,
    2505, 0, 2506, 0, 2507, 0, 2508, 0,
    2509, 0, 2510, 0, 2511, 0, 2512, 0,
    2513, 0, 2514, 0, 0, 0, 0, 0,
    0, 0, 0, 2515, 0, 2516, 0, 5,
    5, 5, 2517, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 1,
    0, 0, 0, 0, 0, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 2518,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 8,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2519,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2520, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {177, 2521, 2522, 2523, 313, 2524, 178, 2525,
    314, 2526, 2527, 315, 2528, 2529, 2530, 2531,
    2532, 2533, 2534, 2535, 2536, 2537, 2538, 316,
    2539, 2540, 2541, 2542, 2543, 2544, 2545, 317,
    2546, 2547, 2548, 2549, 2550, 318, 2551, 2552,
    2553, 2554, 2555, 2556, 2557, 2558, 2559, 2560,
    2561, 2562, 2563, 2564, 2565, 2566, 2567, 2568,
    2569, 2570, 2571, 2572, 2573, 2574, 2575, 319,
    2576, 2577, 320, 2578, 2579, 2580, 2581, 321,
    2582, 234, 322, 2583, 2584, 2585, 2586, 2587,
    2588, 2589, 2590, 2591, 323, 324, 2592, 2593,
    2594, 2595, 2596, 2597, 2598, 2599, 2600, 2601,
    2602, 2603, 2604, 325, 2605, 2606, 2607, 2608,
    2609, 2610, 2611, 2612, 2613, 2614, 2615, 2616,
    2617, 2618, 2619, 2620, 2621, 2622, 2623, 2624,
    2625, 2626, 2627, 2628, 2629, 2630, 2631, 2632,
    2633, 2634, 2635, 2636, 2637, 2638, 2639, 2640,
    2641, 2642, 2643, 2644, 2645, 2646, 2647, 2648,
    2649, 2650, 2651, 2652, 2653, 2654, 2655, 2656,
    2657, 2658, 2659, 326, 2660, 2661, 2662, 2663,
    2664, 2665, 2666, 2667, 2668, 2669, 327, 2670,
    2671, 2672, 2673, 2674, 2675, 2676, 2677, 2678,
    2679, 2680, 2681, 2682, 2683, 2684, 2685, 2686,
    2687, 2688, 2689, 2690, 2691, 2692, 2693, 2694,
    2695, 2696, 2697, 2698, 2699, 2700, 2701, 2702,
    2703, 2704, 2705, 2706, 2707, 2708, 2709, 2710,
    2711, 2712, 2713, 2714, 2715, 2716, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {63, 0, 0, 0, 0, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 2717, 173, 118, 172, 328, 328,
    0, 1, 1, 1, 1, 1, 2718, 0,
    2719, 2720, 2721, 1, 1, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 2722, 1,
    1, 1, 1, 2723, 2724, 2725, 2726, 2727,
    2728, 2729, 2730, 2731, 2732, 2733, 2734, 2735,
    2736, 2737, 2738, 2739, 2740, 2741, 2742, 2743,
    2744, 2745, 2746, 1, 2747, 2748, 2749, 2750,
    2751, 2752, 1, 1, 1, 1, 1, 2753,
    2754, 2755, 2756, 2757, 2758, 2759, 2760, 2761,
    2762, 2763, 2764, 2765, 2766, 2767, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2768, 1, 1, 0,
    0, 2769, 2770, 2771, 2772, 2773, 2774, 2775,
    0, 1, 1, 1, 1, 1, 2776, 1,
    1, 1, 1, 2777, 2778, 2779, 2780, 2781,
    2782, 2783, 2784, 2785, 2786, 2787, 2788, 2789,
    2790, 2791, 2792, 2793, 2794, 2795, 2796, 2797,
    2798, 2799, 2800, 1, 2801, 2802, 2803, 2804,
    2805, 2806, 1, 1, 1, 1, 1, 2807,
    2808, 2809, 2810, 2811, 2812, 2813, 2814, 2815,
    2816, 2817, 2818, 2819, 2820, 2821, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 2822,
    2823, 2824, 2825, 1, 2826, 1, 1, 2827,
    2828, 2829, 2830, 0, 1, 2831, 2832, 2833},
    {0, 0, 0, 0, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 2834, 2835, 2836, 2837, 2838, 2839, 2840,
    2841, 2842, 2843, 2844, 2845, 2846, 2847, 2848,
    2849, 2850, 2851, 2852, 2853, 2854, 2855, 2856,
    2857, 2858, 2859, 2860, 2861, 2862, 2863, 2864,
    2865, 2866, 2867, 2868, 2869, 2870, 2871, 2872,
    2873, 2874, 2875, 2876, 2877, 2878, 2879, 2880,
    2881, 2882, 2883, 2884, 2885, 2886, 2887, 2888,
    2889, 2890, 2891, 2892, 2893, 2894, 2895, 2896,
    2897, 2898, 2899, 2900, 2901, 2902, 2903, 2904,
    2905, 2906, 2907, 2908, 2909, 2910, 2911, 2912,
    2913, 2914, 2915, 2916, 2917, 2918, 2919, 2920,
    2921, 2922, 2923, 2924, 2925, 2926, 2927, 0,
    0, 0, 177, 178, 235, 329, 330, 236,
    331, 2928, 313, 2929, 2930, 332, 2931, 314,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1},
    {2932, 2933, 2934, 2935, 2936, 2937, 2938, 2939,
    2940, 2941, 2942, 2943, 2944, 2945, 2946, 2947,
    2948, 2949, 2950, 2951, 2952, 2953, 2954, 2955,
    2956, 2957, 2958, 2959, 2960, 2961, 2962, 0,
    2963, 2964, 2965, 2966, 2967, 2968, 2969, 2970,
    2971, 2972, 2973, 2974, 2975, 2976, 2977, 2978,
    2979, 2980, 2981, 2982, 2983, 2984, 2985, 2986,
    2987, 2988, 2989, 2990, 2991, 2992, 2993, 2994,
    2995, 2996, 2997, 2998, 2999, 3000, 320, 3001,
    0, 0, 0, 0, 0, 0, 0, 0,
    3002, 3003, 3004, 3005, 3006, 3007, 3008, 3009,
    3010, 3011, 3012, 3013, 3014, 3015, 3016, 3017,
    3018, 3019, 3020, 3021, 3022, 3023, 3024, 3025,
    3026, 3027, 3028, 3029, 3030, 3031, 3032, 3033,
    3034, 3035, 3036, 3037, 3038, 3039, 3040, 3041,
    3042, 3043, 3044, 3045, 3046, 3047, 3048, 0,
    177, 178, 235, 329, 3049, 3050, 3051, 315,
    3052, 316, 234, 324, 323, 322, 327, 317,
    321, 3053, 333, 3054, 3055, 3056, 3057, 3058,
    3059, 3060, 3061, 318, 3062, 3063, 3064, 3065,
    3066, 3067, 3068, 3069, 330, 236, 331, 334,
    335, 3070, 3071, 3072, 3073, 3074, 3075, 3076,
    3077, 3078, 3079, 3080, 3081, 3082, 3083, 3084,
    3085, 3086, 3087, 3088, 3089, 3090, 3091, 3092,
    3093, 3094, 3095, 3096, 3097, 3098, 3099, 3100,
    3101, 3102, 3103, 3104, 3105, 3106, 3107, 3108,
    3109, 3110, 3111, 3112, 3113, 3114, 3115, 3116,
    3117, 3118, 336, 3119, 3120, 3121, 3122, 3123,
    3124, 3125, 3126, 3127, 3128, 3129, 3130, 3131,
    3132, 3133, 3134, 3135, 3136, 3137, 3138, 3139,
    3140, 3141, 3142, 3143, 3144, 3145, 3146, 3147,
    3148, 3149, 3150, 3151, 3152, 3153, 3154, 0},
    {3155, 3156, 3157, 3158, 3159, 3160, 3161, 3162,
    3163, 3164, 3165, 3166, 3167, 3168, 3169, 3170,
    3171, 3172, 3173, 3174, 3175, 3176, 3177, 3178,
    3179, 3180, 3181, 3182, 3183, 3184, 3185, 3186,
    3187, 3188, 3189, 3190, 3191, 3192, 3193, 3194,
    3195, 3196, 3197, 3198, 3199, 3200, 3201, 3202,
    3203, 3204, 3205, 3206, 3207, 3208, 3209, 3210,
    3211, 3212, 3213, 3214, 3215, 3216, 3217, 3218,
    3219, 3220, 3221, 3222, 3223, 3224, 3225, 3226,
    3227, 3228, 3229, 3230, 3231, 3232, 3233, 3234,
    3235, 3236, 3237, 3238, 3239, 3240, 3241, 3242,
    3243, 3244, 3245, 3246, 3247, 3248, 3249, 3250,
    3251, 3252, 3253, 3254, 3255, 3256, 3257, 3258,
    3259, 3260, 3261, 3262, 3263, 3264, 3265, 3266,
    3267, 3268, 3269, 3270, 3271, 3272, 3273, 3274,
    3275, 3276, 3277, 3278, 3279, 3280, 3281, 3282,
    3283, 3284, 3285, 3286, 3287, 3288, 3289, 3290,
    3291, 3292, 3293, 3294, 3295, 3296, 3297, 3298,
    3299, 3300, 3301, 3302, 3303, 3304, 3305, 3306,
    3307, 3308, 3309, 3310, 3311, 3312, 3313, 3314,
    3315, 3316, 3317, 3318, 3319, 3320, 3321, 3322,
    3323, 3324, 3325, 3326, 3327, 3328, 3329, 3330,
    3331, 3332, 3333, 3334, 3335, 3336, 3337, 3338,
    3339, 337, 3340, 3341, 3342, 3343, 3344, 3345,
    3346, 3347, 3348, 3349, 3350, 3351, 3352, 3353,
    3354, 3355, 3356, 3357, 3358, 3359, 3360, 3361,
    3362, 3363, 3364, 3365, 3366, 3367, 3368, 3369,
    3370, 3371, 3372, 3373, 3374, 3375, 3376, 3377,
    3378, 3379, 3380, 3381, 3382, 3383, 3384, 3385,
    3386, 3387, 3388, 3389, 3390, 3391, 3392, 3393,
    3394, 3395, 3396, 3397, 3398, 3399, 3400, 3401,
    3402, 3403, 3404, 3405, 3406, 3407, 3408, 3409},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    3410, 1, 3411, 1, 3412, 1, 3413, 1,
    3414, 1, 283, 1, 3415, 1, 3416, 1,
    3417, 1, 3418, 1, 3419, 1, 3420, 1,
    3421, 1, 3422, 1, 3423, 1, 3424, 1,
    3425, 1, 3426, 1, 3427, 1, 3428, 1,
    3429, 1, 3430, 1, 3431, 1, 1, 3,
    0, 0, 0, 0, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 0, 1,
    3432, 1, 3433, 1, 3434, 1, 3435, 1,
    3436, 1, 3437, 1, 3438, 1, 3439, 1,
    3440, 1, 3441, 1, 3442, 1, 3443, 1,
    3444, 1, 3445, 1, 3446, 3447, 3, 3,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    3, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 3448, 1, 3449, 1, 3450, 1,
    3451, 1, 3452, 1, 3453, 1, 3454, 1,
    1, 1, 3455, 1, 3456, 1, 3457, 1,
    3458, 1, 3459, 1, 3460, 1, 3461, 1,
    3462, 1, 3463, 1, 3464, 1, 3465, 1,
    3466, 1, 3467, 1, 3468, 1, 3469, 1,
    3470, 1, 3471, 1, 3472, 1, 3473, 1,
    3474, 1, 3475, 1, 3476, 1, 3477, 1,
    3478, 1, 3479, 1, 3480, 1, 3481, 1,
    3482, 1, 3483, 1, 3484, 1, 3485, 1,
    3486, 1, 1, 1, 1, 1, 1, 1,
    1, 3487, 1, 3488, 1, 3489, 3490, 1,
    3491, 1, 3492, 1, 3493, 1, 3494, 1,
    1, 0, 0, 3495, 1, 3496, 1, 1,
    3497, 1, 3498, 1, 1, 1, 3499, 1,
    3500, 1, 3501, 1, 3502, 1, 3503, 1,
    3504, 1, 3505, 1, 3506, 1, 3507, 1,
    3508, 1, 3509, 3510, 3511, 3512, 3513, 1,
    3514, 3515, 3516, 3517, 3518, 1, 3519, 1,
    3520, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1,
    3521, 3522, 1, 1, 1, 1, 1, 1},
    {1, 1, 2, 1, 1, 1, 8, 1,
    1, 1, 1, 2, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 2, 2, 2, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 8, 2, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 1, 0, 1, 1, 2},
    {2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 2, 2,
    2, 2, 2, 4, 4, 4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 9, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 0,
    2, 2, 2, 2, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 64, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 2, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 1, 1, 1, 1, 1, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 2, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 2, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    0, 0, 1, 2, 2, 2, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    3, 1, 3, 3, 4, 1, 1, 3,
    3, 1, 1, 1, 1, 1, 3, 3,
    1, 3, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 2, 2, 2, 2, 2,
    0, 0, 1, 1, 1, 2, 8, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 1, 1, 1, 1, 1, 1, 0,
    0, 1, 1, 1, 1, 1, 1, 0,
    0, 1, 1, 1, 1, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 3523, 3524, 3525, 3526,
    1, 1, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    3527, 3528, 3529, 3530, 3531, 3532, 3533, 3534,
    3535, 3536, 3537, 3538, 3539, 3540, 3541, 3542,
    3543, 3544, 3545, 3546, 3547, 3548, 3549, 3550,
    3551, 3552, 3553, 3554, 3555, 3556, 3557, 3558,
    3559, 3560, 3561, 3562, 3563, 3564, 3565, 3566,
    3567, 3568, 3569, 3570, 3571, 3572, 3573, 3574,
    3575, 3576, 3577, 3578, 3579, 3580, 3581, 3582,
    3583, 3584, 3585, 3586, 3587, 3588, 3589, 3590,
    3591, 3592, 3593, 3594, 3595, 3596, 3597, 3598,
    3599, 3600, 3601, 3602, 3603, 3604, 3605, 3606,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 2, 2, 2, 2, 2,
    2, 2, 2, 0, 2, 8, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    0, 0, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 0, 0, 0},
    {3607, 3608, 3609, 3610, 3611, 3612, 3613, 237,
    237, 3614, 3615, 3616, 3617, 338, 3618, 3619,
    3620, 3621, 3622, 3623, 238, 3624, 3625, 3626,
    3627, 3628, 3629, 3630, 3631, 3632, 3633, 3634,
    3635, 3636, 3637, 3638, 3639, 3640, 3641, 3642,
    339, 239, 3643, 3644, 3645, 3646, 3647, 3648,
    3649, 3650, 3651, 3652, 3653, 3654, 340, 3655,
    3656, 3657, 3658, 341, 3659, 3660, 3661, 3662,
    3663, 3664, 3665, 3666, 3667, 3668, 3669, 3670,
    3671, 3672, 3673, 3674, 3675, 3676, 3677, 3678,
    3679, 3680, 3681, 3682, 3683, 3684, 3685, 3686,
    3687, 3688, 3689, 3690, 238, 342, 3691, 240,
    3692, 343, 344, 345, 3693, 3694, 3695, 3696,
    3697, 3698, 3699, 3700, 3701, 3702, 3703, 346,
    241, 3704, 3705, 3706, 347, 3707, 3708, 3709,
    3710, 3711, 3712, 3713, 3714, 3715, 3716, 3717,
    3718, 3719, 3720, 3721, 3722, 3723, 3724, 3725,
    3726, 3727, 3728, 3729, 3730, 3731, 3732, 3733,
    3734, 3735, 3736, 3737, 3738, 3739, 242, 3740,
    3741, 3742, 3743, 3744, 3745, 3746, 3747, 3748,
    3749, 346, 3750, 3751, 3752, 3753, 3754, 3755,
    3756, 3757, 240, 3758, 3759, 3760, 3761, 3762,
    3763, 3764, 3765, 3766, 3767, 3768, 3769, 3770,
    3771, 3772, 3773, 3774, 3775, 3776, 3777, 238,
    3778, 3779, 3780, 3781, 3782, 3783, 3784, 3785,
    3786, 3787, 243, 3788, 3789, 3790, 3791, 3792,
    3793, 3794, 3795, 3796, 3797, 3798, 3799, 3800,
    3801, 3802, 3803, 343, 3804, 3805, 3806, 3807,
    3808, 3809, 3810, 3811, 3812, 3813, 3814, 3815,
    3816, 3817, 3818, 3819, 3820, 3821, 3822, 3823,
    3824, 3825, 3826, 3827, 3828, 3829, 3830, 3831,
    3832, 3833, 3834, 3835, 3836, 3837, 3838, 3839},
    {348, 3840, 3841, 3842, 3843, 3844, 3845, 3846,
    3847, 3848, 3849, 3850, 3851, 3852, 1, 1,
    349, 1, 350, 1, 1, 3853, 351, 352,
    3854, 3855, 3856, 353, 354, 3857, 3858, 1,
    3859, 1, 355, 1, 1, 356, 3860, 1,
    1, 1, 3861, 3862, 3863, 3864, 3865, 3866,
    357, 358, 359, 360, 361, 362, 363, 364,
    3867, 3868, 3869, 3870, 365, 366, 3871, 244,
    245, 367, 3872, 368, 369, 370, 3873, 371,
    372, 3874, 3875, 3876, 3877, 3878, 3879, 3880,
    373, 3881, 3882, 3883, 374, 3884, 375, 242,
    3885, 3886, 3887, 246, 3888, 376, 376, 377,
    3889, 378, 379, 380, 3890, 381, 3891, 356,
    382, 383, 384, 3892, 3893, 3894, 0, 0,
    3895, 385, 3896, 3897, 3898, 3899, 386, 387,
    363, 3900, 388, 3901, 349, 3902, 3903, 3904,
    3905, 3906, 3907, 3908, 3909, 3910, 3911, 389,
    3912, 244, 3913, 245, 3914, 3915, 3916, 3917,
    3918, 350, 239, 390, 3919, 3920, 241, 243,
    3921, 391, 371, 392, 372, 3922, 393, 3923,
    351, 394, 3924, 3925, 3926, 3927, 352, 3928,
    395, 396, 3929, 397, 3930, 375, 3931, 3932,
    242, 3933, 246, 3934, 3935, 398, 3936, 3937,
    378, 3938, 355, 3939, 379, 342, 399, 380,
    400, 381, 401, 3940, 3941, 3942, 3943, 382,
    354, 3944, 383, 247, 384, 402, 237, 3945,
    3946, 3947, 403, 3948, 404, 3949, 3950, 3951,
    3952, 3953, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {3954, 3955, 3956, 3957, 3958, 3959, 3960, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3961, 3962, 3963, 3964, 3965,
    0, 0, 0, 0, 0, 3966, 3967, 3968,
    3969, 287, 288, 3970, 3971, 3972, 3973, 3974,
    3975, 120, 3976, 3977, 3978, 3979, 3980, 3981,
    3982, 3983, 3984, 3985, 3986, 3987, 3988, 0,
    3989, 3990, 3991, 3992, 3993, 0, 3994, 0,
    3995, 3996, 0, 3997, 3998, 0, 3999, 4000,
    4001, 4002, 4003, 4004, 4005, 4006, 4007, 4008,
    405, 405, 179, 179, 179, 179, 180, 180,
    180, 180, 181, 181, 181, 181, 182, 182,
    182, 182, 183, 183, 183, 183, 184, 184,
    184, 184, 185, 185, 185, 185, 186, 186,
    186, 186, 187, 187, 187, 187, 188, 188,
    188, 188, 189, 189, 189, 189, 190, 190,
    190, 190, 406, 406, 407, 407, 408, 408,
    409, 409, 410, 410, 411, 411, 191, 191,
    191, 191, 192, 192, 192, 192, 193, 193,
    193, 193, 194, 194, 194, 194, 195, 195,
    196, 196, 196, 196, 412, 412, 197, 197,
    197, 197, 198, 198, 198, 198, 413, 413,
    414, 414, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 199, 199, 199, 199, 415,
    415, 416, 416, 417, 417, 4009, 418, 418,
    419, 419, 420, 420, 200, 200, 200, 200,
    201, 201, 421, 421, 422, 422, 423, 423,
    424, 424, 425, 425, 426, 426, 248, 248,
    248, 123, 123, 123, 202, 202, 202, 202},
    {427, 428, 203, 123, 429, 430, 431, 432,
    204, 433, 434, 435, 436, 437, 205, 438,
    439, 4010, 206, 440, 441, 442, 443, 444,
    445, 446, 4011, 447, 249, 250, 251, 252,
    448, 449, 450, 451, 452, 453, 454, 253,
    254, 455, 456, 457, 458, 459, 460, 461,
    462, 463, 464, 465, 466, 467, 468, 469,
    470, 471, 472, 207, 208, 473, 474, 475,
    476, 477, 209, 478, 479, 480, 481, 482,
    255, 4012, 4013, 483, 484, 485, 210, 486,
    487, 488, 489, 4014, 4015, 490, 491, 492,
    211, 493, 494, 4016, 4017, 495, 4018, 4019,
    4020, 4021, 4022, 4023, 4024, 4025, 203, 4026,
    123, 429, 4027, 4028, 204, 4029, 433, 434,
    4030, 4031, 205, 4032, 438, 439, 4033, 4034,
    206, 4035, 440, 441, 463, 464, 467, 468,
    469, 207, 208, 473, 474, 209, 478, 479,
    4036, 255, 4037, 4038, 210, 4039, 486, 487,
    495, 4040, 4041, 211, 4042, 493, 494, 427,
    428, 4043, 203, 496, 430, 431, 432, 204,
    497, 435, 436, 437, 205, 498, 206, 442,
    443, 444, 445, 446, 447, 249, 250, 251,
    252, 448, 4044, 449, 450, 451, 452, 453,
    454, 254, 455, 456, 457, 458, 459, 460,
    461, 462, 465, 466, 470, 471, 472, 207,
    208, 475, 476, 477, 209, 4045, 480, 481,
    482, 255, 483, 484, 485, 210, 499, 488,
    489, 4046, 490, 491, 492, 211, 500, 203,
    496, 204, 497, 205, 498, 206, 4047, 252,
    501, 212, 502, 207, 208, 209, 210, 499,
    211, 500, 4048, 4049, 4050, 503, 504, 505,
    506, 507, 508, 509, 510, 511, 512, 513},
    {514, 515, 516, 517, 518, 519, 520, 521,
    522, 213, 214, 215, 212, 523, 524, 525,
    526, 503, 504, 505, 506, 507, 508, 509,
    510, 511, 512, 513, 514, 515, 516, 517,
    518, 519, 520, 521, 522, 213, 214, 215,
    212, 523, 524, 525, 526, 213, 214, 215,
    212, 501, 502, 253, 249, 250, 251, 213,
    214, 215, 253, 254, 527, 527, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4051, 528, 528, 4052, 4053, 4054, 4055, 4056,
    529, 529, 4057, 4058, 4059, 4060, 4061, 530,
    530, 4062, 531, 531, 532, 532, 533, 534,
    534, 4063, 535, 535, 536, 536, 4064, 537,
    537, 538, 538, 4065, 4066, 539, 540, 540,
    4067, 4068, 4069, 4070, 541, 541, 542, 4071,
    543, 4072, 4073, 544, 544, 545, 545, 546,
    546, 4074, 4075, 4076, 4077, 4078, 4079, 4080,
    0, 0, 4081, 4082, 4083, 4084, 4085, 547,
    547, 4086, 4087, 4088, 548, 548, 4089, 4090,
    4091, 4092, 4093, 4094, 4095, 4096, 4097, 4098,
    4099, 4100, 4101, 4102, 4103, 4104, 4105, 4106,
    4107, 4108, 4109, 4110, 542, 543, 4111, 4112,
    549, 4113, 550, 551, 550, 549, 4114, 4115,
    4116, 4117, 4118, 551, 539, 533, 4119, 4120,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4121, 4122, 4123, 4124, 4125, 4126, 4127, 4128,
    4129, 4130, 4131, 4132, 4133, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    256, 257, 552, 258, 259, 260, 261, 4134,
    4135, 4136, 0, 0, 0, 0, 0, 0,
    3, 3, 3, 3, 3, 3, 3, 4,
    4, 4, 4, 4, 4, 4, 3, 3,
    4137, 553, 4138, 107, 107, 121, 122, 262,
    263, 554, 555, 4139, 4140, 4141, 4142, 4143,
    4144, 556, 557, 4145, 4146, 0, 0, 558,
    559, 216, 216, 216, 216, 107, 107, 107,
    256, 257, 224, 0, 259, 258, 261, 260,
    553, 121, 122, 262, 263, 554, 555, 560,
    561, 562, 120, 563, 564, 565, 176, 0,
    566, 567, 568, 569, 0, 0, 0, 0,
    4147, 4148, 4149, 1, 4150, 0, 4151, 4152,
    4153, 4154, 4155, 4156, 4157, 4158, 4159, 4160,
    4161, 570, 570, 571, 571, 572, 572, 573,
    573, 217, 217, 217, 217, 218, 218, 79,
    79, 79, 79, 574, 574, 80, 80, 80,
    80, 81, 81, 81, 81, 66, 66, 66,
    66, 67, 67, 67, 67, 68, 68, 68,
    68, 124, 124, 125, 125, 126, 126, 127,
    127, 69, 69, 69, 69, 70, 70, 70,
    70, 71, 71, 71, 71, 72, 72, 72,
    72, 88, 88, 88, 88, 89, 89, 89,
    89, 73, 73, 73, 73, 74, 74, 74,
    74, 82, 82, 82, 82, 75, 75, 75,
    75, 94, 94, 94, 94, 83, 83, 83,
    83, 84, 84, 84, 84, 76, 76, 76,
    76, 95, 95, 95, 95, 128, 128, 201,
    201, 77, 77, 77, 77, 575, 575, 576,
    576, 577, 577, 578, 578, 0, 0, 0},
    {0, 260, 4162, 560, 567, 568, 561, 4163,
    121, 122, 562, 120, 256, 563, 224, 4164,
    108, 109, 110, 111, 112, 113, 114, 115,
    116, 117, 258, 259, 564, 176, 565, 261,
    569, 37, 38, 55, 17, 39, 59, 40,
    41, 25, 42, 43, 26, 27, 44, 45,
    46, 57, 47, 60, 48, 49, 34, 50,
    56, 61, 58, 558, 566, 559, 4165, 107,
    4166, 13, 51, 32, 18, 19, 53, 52,
    22, 10, 15, 28, 12, 20, 33, 14,
    29, 62, 23, 24, 30, 31, 21, 35,
    16, 36, 54, 262, 4167, 263, 4168, 4169,
    4170, 552, 556, 557, 257, 4171, 4172, 4173,
    4174, 4175, 4176, 4177, 4178, 4179, 4180, 4181,
    4182, 4183, 4184, 4185, 4186, 4187, 4188, 4189,
    4190, 4191, 4192, 4193, 4194, 4195, 4196, 4197,
    4198, 4199, 4200, 4201, 4202, 4203, 4204, 4205,
    4206, 4207, 4208, 4209, 4210, 4211, 4212, 4213,
    4214, 4215, 4216, 4217, 4218, 4219, 4220, 4221,
    4222, 4223, 4224, 4225, 4226, 4227, 4228, 4229,
    4230, 4231, 4232, 4233, 4234, 4235, 4236, 4237,
    4238, 4239, 4240, 4241, 4242, 4243, 4244, 4245,
    4246, 4247, 4248, 4249, 4250, 4251, 4252, 4253,
    4254, 4255, 4256, 4257, 4258, 4259, 4260, 0,
    0, 0, 4261, 4262, 4263, 4264, 4265, 4266,
    0, 0, 4267, 4268, 4269, 4270, 4271, 4272,
    0, 0, 4273, 4274, 4275, 4276, 4277, 4278,
    0, 0, 4279, 4280, 4281, 0, 0, 0,
    4282, 4283, 4284, 4285, 4286, 4287, 4288, 0,
    4289, 4290, 4291, 4292, 4293, 4294, 4295, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 5, 5,
    5, 5, 5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {4296, 4297, 4298, 4299, 4300, 4301, 4302, 4303,
    4304, 4305, 4306, 4307, 4308, 4309, 4310, 4311,
    4312, 4313, 4314, 4315, 4316, 4317, 4318, 4319,
    4320, 4321, 4322, 4323, 4324, 4325, 4326, 4327,
    4328, 4329, 4330, 4331, 4332, 4333, 4334, 4335,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4336, 4337, 4338, 4339, 4340, 4341, 4342, 4343,
    4344, 4345, 4346, 4347, 4348, 4349, 4350, 4351,
    4352, 4353, 4354, 4355, 4356, 4357, 4358, 4359,
    4360, 4361, 4362, 4363, 4364, 4365, 4366, 4367,
    4368, 4369, 4370, 4371, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7, 0, 5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5, 11, 7, 0, 0, 0, 0, 9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5, 7, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4372, 4373, 4374, 4375, 4376, 4377, 4378, 4379,
    4380, 4381, 4382, 4383, 4384, 4385, 4386, 4387,
    4388, 4389, 4390, 4391, 4392, 4393, 4394, 4395,
    4396, 4397, 4398, 4399, 4400, 4401, 4402, 4403,
    4404, 4405, 4406, 4407, 4408, 4409, 4410, 4411,
    4412, 4413, 4414, 4415, 4416, 4417, 4418, 4419,
    4420, 4421, 4422, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 3, 3, 3, 3,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 7, 7,
    5, 5, 5, 7, 5, 7, 7, 7,
    7, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 9, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 4423, 4424, 4425, 4426, 0, 0, 0,
    0, 0, 0, 0, 0, 4427, 0, 0,
    0, 0, 0, 4428, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 9, 4429, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {3, 3, 3, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 4430,
    2, 2, 2, 2, 2, 2, 4431, 4432,
    2, 4433, 4434, 8, 8, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 0, 0, 0, 1, 2, 2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 78, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 78, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 9, 78, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 78, 9, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 64, 78, 0, 4435, 0,
    0, 0, 0, 0, 0, 0, 0, 4436,
    0, 0, 0, 4437, 4438, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4439,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 5, 5,
    5, 5, 5, 5, 5, 0, 0, 0,
    5, 5, 5, 5, 5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 8, 2, 2, 2, 64, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4440, 0, 0, 0, 0, 0, 0, 0,
    0, 4441, 4442, 4443, 4444, 4445, 4446, 0,
    0, 0, 9, 78, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4447,
    0, 0, 0, 0, 0, 0, 0, 0,
    4448, 4449, 4450, 4451, 0, 0, 0, 9,
    78, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 9, 78,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 9, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 9, 78, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4452, 4453, 4454, 4455, 4456, 4457, 4458, 4459,
    4460, 4461, 4462, 4463, 4464, 4465, 4466, 4467,
    4468, 4469, 4470, 4471, 4472, 4473, 4474, 4475,
    4476, 4477, 4478, 4479, 4480, 4481, 4482, 4483,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 9, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 9, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 78, 0, 9, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    11, 11, 11, 11, 11, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5, 5, 5, 5, 5, 5, 5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4484, 4485, 4486, 4487, 4488, 4489, 4490, 4491,
    4492, 4493, 4494, 4495, 4496, 4497, 4498, 4499,
    4500, 4501, 4502, 4503, 4504, 4505, 4506, 4507,
    4508, 4509, 4510, 4511, 4512, 4513, 4514, 4515,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    2, 2, 2, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 11, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 4516, 4517,
    4518, 4519, 4520, 4521, 4522, 96, 96, 11,
    11, 11, 0, 0, 0, 4523, 96, 96,
    96, 96, 96, 0, 0, 0, 0, 0,
    0, 0, 0, 7, 7, 7, 7, 7,
    7, 7, 7, 0, 0, 5, 5, 5,
    5, 5, 7, 7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 5, 5, 5, 5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 4524, 4525, 4526, 4527, 4528,
    4529, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 5, 5, 5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {37, 38, 55, 17, 39, 59, 40, 41,
    25, 42, 43, 26, 27, 44, 45, 46,
    57, 47, 60, 48, 49, 34, 50, 56,
    61, 58, 13, 51, 32, 18, 19, 53,
    52, 22, 10, 15, 28, 12, 20, 33,
    14, 29, 62, 23, 24, 30, 31, 21,
    35, 16, 36, 54, 37, 38, 55, 17,
    39, 59, 40, 41, 25, 42, 43, 26,
    27, 44, 45, 46, 57, 47, 60, 48,
    49, 34, 50, 56, 61, 58, 13, 51,
    32, 18, 19, 53, 52, 0, 10, 15,
    28, 12, 20, 33, 14, 29, 62, 23,
    24, 30, 31, 21, 35, 16, 36, 54,
    37, 38, 55, 17, 39, 59, 40, 41,
    25, 42, 43, 26, 27, 44, 45, 46,
    57, 47, 60, 48, 49, 34, 50, 56,
    61, 58, 13, 51, 32, 18, 19, 53,
    52, 22, 10, 15, 28, 12, 20, 33,
    14, 29, 62, 23, 24, 30, 31, 21,
    35, 16, 36, 54, 37, 0, 55, 17,
    0, 0, 40, 0, 0, 42, 43, 0,
    0, 44, 45, 46, 57, 0, 60, 48,
    49, 34, 50, 56, 61, 58, 13, 51,
    32, 18, 0, 53, 0, 22, 10, 15,
    28, 12, 20, 33, 0, 29, 62, 23,
    24, 30, 31, 21, 35, 16, 36, 54,
    37, 38, 55, 17, 39, 59, 40, 41,
    25, 42, 43, 26, 27, 44, 45, 46,
    57, 47, 60, 48, 49, 34, 50, 56,
    61, 58, 13, 51, 32, 18, 19, 53,
    52, 22, 10, 15, 28, 12, 20, 33,
    14, 29, 62, 23, 24, 30, 31, 21},
    {35, 16, 36, 54, 37, 38, 0, 17,
    39, 59, 40, 0, 0, 42, 43, 26,
    27, 44, 45, 46, 57, 0, 60, 48,
    49, 34, 50, 56, 61, 0, 13, 51,
    32, 18, 19, 53, 52, 22, 10, 15,
    28, 12, 20, 33, 14, 29, 62, 23,
    24, 30, 31, 21, 35, 16, 36, 54,
    37, 38, 0, 17, 39, 59, 40, 0,
    25, 42, 43, 26, 27, 0, 45, 0,
    0, 0, 60, 48, 49, 34, 50, 56,
    61, 0, 13, 51, 32, 18, 19, 53,
    52, 22, 10, 15, 28, 12, 20, 33,
    14, 29, 62, 23, 24, 30, 31, 21,
    35, 16, 36, 54, 37, 38, 55, 17,
    39, 59, 40, 41, 25, 42, 43, 26,
    27, 44, 45, 46, 57, 47, 60, 48,
    49, 34, 50, 56, 61, 58, 13, 51,
    32, 18, 19, 53, 52, 22, 10, 15,
    28, 12, 20, 33, 14, 29, 62, 23,
    24, 30, 31, 21, 35, 16, 36, 54,
    37, 38, 55, 17, 39, 59, 40, 41,
    25, 42, 43, 26, 27, 44, 45, 46,
    57, 47, 60, 48, 49, 34, 50, 56,
    61, 58, 13, 51, 32, 18, 19, 53,
    52, 22, 10, 15, 28, 12, 20, 33,
    14, 29, 62, 23, 24, 30, 31, 21,
    35, 16, 36, 54, 37, 38, 55, 17,
    39, 59, 40, 41, 25, 42, 43, 26,
    27, 44, 45, 46, 57, 47, 60, 48,
    49, 34, 50, 56, 61, 58, 13, 51,
    32, 18, 19, 53, 52, 22, 10, 15,
    28, 12, 20, 33, 14, 29, 62, 23},
    {24, 30, 31, 21, 35, 16, 36, 54,
    37, 38, 55, 17, 39, 59, 40, 41,
    25, 42, 43, 26, 27, 44, 45, 46,
    57, 47, 60, 48, 49, 34, 50, 56,
    61, 58, 13, 51, 32, 18, 19, 53,
    52, 22, 10, 15, 28, 12, 20, 33,
    14, 29, 62, 23, 24, 30, 31, 21,
    35, 16, 36, 54, 37, 38, 55, 17,
    39, 59, 40, 41, 25, 42, 43, 26,
    27, 44, 45, 46, 57, 47, 60, 48,
    49, 34, 50, 56, 61, 58, 13, 51,
    32, 18, 19, 53, 52, 22, 10, 15,
    28, 12, 20, 33, 14, 29, 62, 23,
    24, 30, 31, 21, 35, 16, 36, 54,
    37, 38, 55, 17, 39, 59, 40, 41,
    25, 42, 43, 26, 27, 44, 45, 46,
    57, 47, 60, 48, 49, 34, 50, 56,
    61, 58, 13, 51, 32, 18, 19, 53,
    52, 22, 10, 15, 28, 12, 20, 33,
    14, 29, 62, 23, 24, 30, 31, 21,
    35, 16, 36, 54, 4530, 4531, 0, 0,
    129, 130, 105, 131, 132, 133, 134, 100,
    135, 136, 137, 138, 139, 140, 141, 106,
    142, 143, 102, 144, 145, 146, 147, 148,
    149, 150, 151, 85, 87, 104, 101, 152,
    153, 90, 154, 98, 155, 97, 156, 157,
    158, 91, 92, 99, 159, 160, 161, 86,
    93, 162, 163, 164, 165, 166, 167, 168,
    169, 170, 129, 130, 105, 131, 132, 133,
    134, 100, 135, 136, 137, 138, 139, 140,
    141, 106, 142, 143, 102, 144, 145, 146,
    147, 148, 149, 150, 151, 85, 87, 104},
    {101, 152, 153, 90, 154, 98, 155, 97,
    156, 157, 158, 91, 92, 99, 159, 160,
    161, 86, 93, 162, 163, 164, 165, 166,
    167, 168, 169, 170, 129, 130, 105, 131,
    132, 133, 134, 100, 135, 136, 137, 138,
    139, 140, 141, 106, 142, 143, 102, 144,
    145, 146, 147, 148, 149, 150, 151, 85,
    87, 104, 101, 152, 153, 90, 154, 98,
    155, 97, 156, 157, 158, 91, 92, 99,
    159, 160, 161, 86, 93, 162, 163, 164,
    165, 166, 167, 168, 169, 170, 129, 130,
    105, 131, 132, 133, 134, 100, 135, 136,
    137, 138, 139, 140, 141, 106, 142, 143,
    102, 144, 145, 146, 147, 148, 149, 150,
    151, 85, 87, 104, 101, 152, 153, 90,
    154, 98, 155, 97, 156, 157, 158, 91,
    92, 99, 159, 160, 161, 86, 93, 162,
    163, 164, 165, 166, 167, 168, 169, 170,
    129, 130, 105, 131, 132, 133, 134, 100,
    135, 136, 137, 138, 139, 140, 141, 106,
    142, 143, 102, 144, 145, 146, 147, 148,
    149, 150, 151, 85, 87, 104, 101, 152,
    153, 90, 154, 98, 155, 97, 156, 157,
    158, 91, 92, 99, 159, 160, 161, 86,
    93, 162, 163, 164, 165, 166, 167, 168,
    169, 170, 4532, 4533, 0, 0, 108, 109,
    110, 111, 112, 113, 114, 115, 116, 117,
    108, 109, 110, 111, 112, 113, 114, 115,
    116, 117, 108, 109, 110, 111, 112, 113,
    114, 115, 116, 117, 108, 109, 110, 111,
    112, 113, 114, 115, 116, 117, 108, 109,
    110, 111, 112, 113, 114, 115, 116, 117},
    {5, 5, 5, 5, 5, 5, 5, 0,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 0, 0, 5, 5, 5, 5, 5,
    5, 5, 0, 5, 5, 0, 5, 5,
    5, 5, 5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    7, 7, 7, 7, 7, 7, 7, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {4534, 4535, 4536, 4537, 4538, 4539, 4540, 4541,
    4542, 4543, 4544, 4545, 4546, 4547, 4548, 4549,
    4550, 4551, 4552, 4553, 4554, 4555, 4556, 4557,
    4558, 4559, 4560, 4561, 4562, 4563, 4564, 4565,
    4566, 4567, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 3, 3, 3, 3,
    3, 3, 64, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {218, 79, 66, 124, 0, 128, 127, 67,
    88, 77, 94, 83, 84, 76, 69, 73,
    82, 71, 75, 126, 70, 80, 81, 68,
    125, 72, 89, 74, 579, 195, 580, 581,
    0, 79, 66, 0, 95, 0, 0, 67,
    0, 77, 94, 83, 84, 76, 69, 73,
    82, 71, 75, 0, 70, 80, 81, 68,
    0, 72, 0, 74, 0, 0, 0, 0,
    0, 0, 66, 0, 0, 0, 0, 67,
    0, 77, 0, 83, 0, 76, 69, 73,
    0, 71, 75, 0, 70, 0, 0, 68,
    0, 72, 0, 74, 0, 195, 0, 581,
    0, 79, 66, 0, 95, 0, 0, 67,
    88, 77, 94, 0, 84, 76, 69, 73,
    82, 71, 75, 0, 70, 80, 81, 68,
    0, 72, 89, 74, 579, 0, 580, 0,
    218, 79, 66, 124, 95, 128, 127, 67,
    88, 77, 0, 83, 84, 76, 69, 73,
    82, 71, 75, 126, 70, 80, 81, 68,
    125, 72, 89, 74, 0, 0, 0, 0,
    0, 79, 66, 124, 0, 128, 127, 67,
    88, 77, 0, 83, 84, 76, 69, 73,
    82, 71, 75, 126, 70, 80, 81, 68,
    125, 72, 89, 74, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {4568, 4569, 4570, 4571, 4572, 4573, 4574, 4575,
    4576, 4577, 4578, 0, 0, 0, 0, 0,
    4579, 4580, 4581, 4582, 4583, 4584, 4585, 4586,
    4587, 4588, 4589, 4590, 4591, 4592, 4593, 4594,
    4595, 4596, 4597, 4598, 4599, 4600, 4601, 4602,
    4603, 4604, 4605, 232, 233, 4606, 4607, 0,
    289, 290, 232, 291, 292, 293, 294, 295,
    296, 297, 298, 299, 300, 301, 302, 303,
    304, 233, 305, 306, 307, 308, 309, 310,
    311, 312, 4608, 337, 4609, 4610, 4611, 4612,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 4613, 4614, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4615, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {4616, 4617, 336, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    319, 4618, 4619, 4620, 178, 4621, 4622, 332,
    4623, 4624, 4625, 4626, 4627, 4628, 4629, 4630,
    4631, 4632, 325, 4633, 4634, 4635, 4636, 4637,
    4638, 177, 235, 4639, 334, 236, 335, 4640,
    326, 4641, 4642, 4643, 4644, 4645, 333, 234,
    4646, 4647, 4648, 4649, 0, 0, 0, 0,
    4650, 4651, 4652, 4653, 4654, 4655, 4656, 4657,
    4658, 0, 0, 0, 0, 0, 0, 0,
    4659, 4660, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {4661, 4662, 4663, 4664, 4665, 357, 4666, 4667,
    4668, 4669, 358, 4670, 4671, 4672, 359, 4673,
    4674, 4675, 4676, 4677, 4678, 4679, 4680, 4681,
    4682, 4683, 4684, 385, 4685, 4686, 4687, 4688,
    4689, 4690, 4691, 4692, 4693, 386, 360, 361,
    387, 4694, 4695, 345, 4696, 362, 4697, 4698,
    4699, 264, 264, 264, 4700, 4701, 4702, 4703,
    4704, 4705, 4706, 4707, 4708, 4709, 4710, 4711,
    4712, 4713, 4714, 4715, 4716, 582, 582, 388,
    4717, 4718, 4719, 4720, 364, 4721, 4722, 4723,
    348, 4724, 4725, 4726, 4727, 4728, 4729, 4730,
    4731, 4732, 4733, 4734, 4735, 4736, 4737, 4738,
    4739, 4740, 4741, 4742, 4743, 4744, 4745, 4746,
    4747, 4748, 583, 583, 4749, 4750, 4751, 240,
    4752, 4753, 4754, 4755, 4756, 4757, 4758, 4759,
    365, 4760, 4761, 4762, 4763, 4764, 4765, 4766,
    4767, 4768, 4769, 4770, 4771, 4772, 4773, 4774,
    4775, 4776, 4777, 4778, 4779, 4780, 339, 4781,
    4782, 584, 584, 585, 586, 586, 4783, 4784,
    4785, 4786, 4787, 4788, 4789, 4790, 4791, 4792,
    4793, 4794, 4795, 366, 4796, 4797, 4798, 587,
    389, 587, 4799, 244, 4800, 4801, 4802, 4803,
    245, 338, 4804, 4805, 4806, 4807, 4808, 4809,
    4810, 4811, 4812, 4813, 4814, 4815, 4816, 4817,
    4818, 4819, 4820, 4821, 4822, 4823, 4824, 4825,
    367, 4826, 4827, 4828, 4829, 4830, 4831, 368,
    4832, 4833, 4834, 4835, 4836, 4837, 4838, 4839,
    239, 390, 4840, 4841, 4842, 4843, 4844, 4845,
    4846, 4847, 369, 4848, 4849, 4850, 4851, 403,
    4852, 4853, 4854, 4855, 4856, 4857, 4858, 4859,
    4860, 4861, 4862, 4863, 4864, 241, 4865, 4866,
    4867, 4868, 4869, 4870, 4871, 4872, 4873, 4874},
    {4875, 370, 243, 4876, 4877, 4878, 4879, 4880,
    4881, 4882, 4883, 391, 4884, 4885, 4886, 4887,
    4888, 4889, 4890, 4891, 392, 4892, 4893, 4894,
    4895, 4896, 4897, 4898, 4899, 4900, 4901, 4902,
    4903, 393, 4904, 4905, 4906, 4907, 4908, 4909,
    4910, 4911, 4912, 4913, 588, 588, 4914, 4915,
    394, 4916, 4917, 4918, 4919, 4920, 4921, 4922,
    344, 4923, 4924, 4925, 4926, 4927, 4928, 4929,
    395, 4930, 4931, 4932, 4933, 4934, 589, 589,
    396, 404, 4935, 4936, 4937, 4938, 4939, 341,
    397, 4940, 4941, 373, 4942, 4943, 353, 4944,
    4945, 374, 4946, 4947, 4948, 590, 590, 4949,
    4950, 4951, 4952, 4953, 4954, 4955, 4956, 4957,
    4958, 4959, 4960, 4961, 4962, 4963, 4964, 4965,
    4966, 4967, 4968, 4969, 4970, 4971, 4972, 4973,
    4974, 4975, 246, 4976, 4977, 4978, 4979, 4980,
    4981, 4982, 4983, 4984, 4985, 4986, 4987, 4988,
    4989, 4990, 4991, 585, 4992, 4993, 4994, 4995,
    4996, 4997, 4998, 4999, 5000, 5001, 5002, 5003,
    347, 5004, 5005, 5006, 5007, 5008, 5009, 377,
    5010, 5011, 5012, 5013, 5014, 5015, 5016, 5017,
    5018, 5019, 5020, 5021, 5022, 5023, 5024, 5025,
    5026, 5027, 5028, 5029, 340, 5030, 5031, 5032,
    5033, 5034, 5035, 398, 5036, 5037, 5038, 5039,
    5040, 5041, 5042, 5043, 5044, 5045, 5046, 5047,
    5048, 5049, 5050, 5051, 5052, 5053, 5054, 5055,
    399, 400, 5056, 5057, 5058, 5059, 5060, 5061,
    5062, 5063, 5064, 5065, 5066, 5067, 5068, 401,
    5069, 5070, 5071, 5072, 5073, 5074, 5075, 5076,
    5077, 5078, 5079, 5080, 5081, 5082, 5083, 5084,
    5085, 5086, 5087, 5088, 5089, 5090, 5091, 5092,
    5093, 5094, 5095, 5096, 5097, 5098, 247, 247},
    {5099, 5100, 5101, 5102, 5103, 5104, 5105, 5106,
    5107, 5108, 402, 5109, 5110, 5111, 5112, 5113,
    5114, 5115, 5116, 5117, 5118, 5119, 5120, 5121,
    5122, 5123, 5124, 5125, 5126, 5127, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
};

const struct properties_s uproperties[5128] = {
    {0, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, -1, id_Continue},
    {0, 0, 230, -1, -1, id_Continue},
    {0, 0, 220, -1, -1, id_Continue},
    {0, 0, 230, -1, -1, 0},
    {0, 0, 0, -1, -1, id_Start | qc_M},
    {0, 0, 220, -1, -1, 0},
    {0, 0, 9, -1, -1, id_Continue},
    {0, 0, 9, -1, -1, 0},
    {105, 105, 0, -1, -1, pr_compat | id_Start},
    {0, 0, 1, -1, -1, 0},
    {108, 108, 0, -1, -1, pr_compat | id_Start},
    {97, 97, 0, -1, -1, pr_compat | id_Start},
    {111, 111, 0, -1, -1, pr_compat | id_Start},
    {106, 106, 0, -1, -1, pr_compat | id_Start},
    {120, 120, 0, -1, -1, pr_compat | id_Start},
    {68, 100, 0, -1, -1, pr_compat | id_Start},
    {100, 100, 0, -1, -1, pr_compat | id_Start},
    {101, 101, 0, -1, -1, pr_compat | id_Start},
    {109, 109, 0, -1, -1, pr_compat | id_Start},
    {118, 118, 0, -1, -1, pr_compat | id_Start},
    {104, 104, 0, -1, -1, pr_compat | id_Start},
    {114, 114, 0, -1, -1, pr_compat | id_Start},
    {115, 115, 0, -1, -1, pr_compat | id_Start},
    {73, 105, 0, -1, -1, pr_compat | id_Start},
    {76, 108, 0, -1, -1, pr_compat | id_Start},
    {77, 109, 0, -1, -1, pr_compat | id_Start},
    {107, 107, 0, -1, -1, pr_compat | id_Start},
    {112, 112, 0, -1, -1, pr_compat | id_Start},
    {116, 116, 0, -1, -1, pr_compat | id_Start},
    {117, 117, 0, -1, -1, pr_compat | id_Start},
    {99, 99, 0, -1, -1, pr_compat | id_Start},
    {110, 110, 0, -1, -1, pr_compat | id_Start},
    {86, 118, 0, -1, -1, pr_compat | id_Start},
    {119, 119, 0, -1, -1, pr_compat | id_Start},
    {121, 121, 0, -1, -1, pr_compat | id_Start},
    {65, 97, 0, -1, -1, pr_compat | id_Start},
    {66, 98, 0, -1, -1, pr_compat | id_Start},
    {69, 101, 0, -1, -1, pr_compat | id_Start},
    {71, 103, 0, -1, -1, pr_compat | id_Start},
    {72, 104, 0, -1, -1, pr_compat | id_Start},
    {74, 106, 0, -1, -1, pr_compat | id_Start},
    {75, 107, 0, -1, -1, pr_compat | id_Start},
    {78, 110, 0, -1, -1, pr_compat | id_Start},
    {79, 111, 0, -1, -1, pr_compat | id_Start},
    {80, 112, 0, -1, -1, pr_compat | id_Start},
    {82, 114, 0, -1, -1, pr_compat | id_Start},
    {84, 116, 0, -1, -1, pr_compat | id_Start},
    {85, 117, 0, -1, -1, pr_compat | id_Start},
    {87, 119, 0, -1, -1, pr_compat | id_Start},
    {98, 98, 0, -1, -1, pr_compat | id_Start},
    {103, 103, 0, -1, -1, pr_compat | id_Start},
    {102, 102, 0, -1, -1, pr_compat | id_Start},
    {122, 122, 0, -1, -1, pr_compat | id_Start},
    {67, 99, 0, -1, -1, pr_compat | id_Start},
    {88, 120, 0, -1, -1, pr_compat | id_Start},
    {81, 113, 0, -1, -1, pr_compat | id_Start},
    {90, 122, 0, -1, -1, pr_compat | id_Start},
    {70, 102, 0, -1, -1, pr_compat | id_Start},
    {83, 115, 0, -1, -1, pr_compat | id_Start},
    {89, 121, 0, -1, -1, pr_compat | id_Start},
    {113, 113, 0, -1, -1, pr_compat | id_Start},
    {32, 32, 0, -1, -1, pr_compat},
    {0, 0, 7, -1, -1, id_Continue},
    {0, 0, 1, -1, -1, id_Continue},
    {1580, 1580, 0, -1, -1, pr_compat | id_Start},
    {1581, 1581, 0, -1, -1, pr_compat | id_Start},
    {1582, 1582, 0, -1, -1, pr_compat | id_Start},
    {1587, 1587, 0, -1, -1, pr_compat | id_Start},
    {1588, 1588, 0, -1, -1, pr_compat | id_Start},
    {1589, 1589, 0, -1, -1, pr_compat | id_Start},
    {1590, 1590, 0, -1, -1, pr_compat | id_Start},
    {1593, 1593, 0, -1, -1, pr_compat | id_Start},
    {1594, 1594, 0, -1, -1, pr_compat | id_Start},
    {1602, 1602, 0, -1, -1, pr_compat | id_Start},
    {1606, 1606, 0, -1, -1, pr_compat | id_Start},
    {1610, 1610, 0, -1, -1, pr_compat | id_Start},
    {0, 0, 7, -1, -1, 0},
    {1576, 1576, 0, -1, -1, pr_compat | id_Start},
    {1578, 1578, 0, -1, -1, pr_compat | id_Start},
    {1579, 1579, 0, -1, -1, pr_compat | id_Start},
    {1601, 1601, 0, -1, -1, pr_compat | id_Start},
    {1604, 1604, 0, -1, -1, pr_compat | id_Start},
    {1605, 1605, 0, -1, -1, pr_compat | id_Start},
    {946, 946, 0, -1, -1, pr_compat | id_Start},
    {966, 966, 0, -1, -1, pr_compat | id_Start},
    {947, 947, 0, -1, -1, pr_compat | id_Start},
    {1591, 1591, 0, -1, -1, pr_compat | id_Start},
    {1592, 1592, 0, -1, -1, pr_compat | id_Start},
    {952, 952, 0, -1, -1, pr_compat | id_Start},
    {960, 960, 0, -1, -1, pr_compat | id_Start},
    {961, 961, 0, -1, -1, pr_compat | id_Start},
    {967, 967, 0, -1, -1, pr_compat | id_Start},
    {1603, 1603, 0, -1, -1, pr_compat | id_Start},
    {1607, 1607, 0, -1, -1, pr_compat | id_Start},
    {0, 0, 216, -1, -1, 0},
    {956, 956, 0, -1, -1, pr_compat | id_Start},
    {954, 954, 0, -1, -1, pr_compat | id_Start},
    {962, 963, 0, -1, -1, pr_compat | id_Start},
    {920, 952, 0, -1, -1, pr_compat | id_Start},
    {949, 949, 0, -1, -1, pr_compat | id_Start},
    {931, 963, 0, -1, -1, pr_compat | id_Start},
    {0, 0, 130, -1, -1, id_Continue},
    {948, 948, 0, -1, -1, pr_compat | id_Start},
    {915, 947, 0, -1, -1, pr_compat | id_Start},
    {928, 960, 0, -1, -1, pr_compat | id_Start},
    {95, 95, 0, -1, -1, pr_compat | id_Continue},
    {48, 48, 0, -1, -1, pr_compat | id_Continue},
    {49, 49, 0, -1, -1, pr_compat | id_Continue},
    {50, 50, 0, -1, -1, pr_compat | id_Continue},
    {51, 51, 0, -1, -1, pr_compat | id_Continue},
    {52, 52, 0, -1, -1, pr_compat | id_Continue},
    {53, 53, 0, -1, -1, pr_compat | id_Continue},
    {54, 54, 0, -1, -1, pr_compat | id_Continue},
    {55, 55, 0, -1, -1, pr_compat | id_Continue},
    {56, 56, 0, -1, -1, pr_compat | id_Continue},
    {57, 57, 0, -1, -1, pr_compat | id_Continue},
    {0, 0, 232, -1, -1, id_Continue},
    {0, 0, 234, -1, -1, id_Continue},
    {43, 43, 0, -1, -1, pr_compat},
    {40, 40, 0, -1, -1, pr_compat},
    {41, 41, 0, -1, -1, pr_compat},
    {-3613, -3613, 0, -1, -1, pr_compat | id_Start},
    {1583, 1583, 0, -1, -1, pr_compat | id_Start},
    {1584, 1584, 0, -1, -1, pr_compat | id_Start},
    {1585, 1585, 0, -1, -1, pr_compat | id_Start},
    {1586, 1586, 0, -1, -1, pr_compat | id_Start},
    {1608, 1608, 0, -1, -1, pr_compat | id_Start},
    {913, 945, 0, -1, -1, pr_compat | id_Start},
    {914, 946, 0, -1, -1, pr_compat | id_Start},
    {916, 948, 0, -1, -1, pr_compat | id_Start},
    {917, 949, 0, -1, -1, pr_compat | id_Start},
    {918, 950, 0, -1, -1, pr_compat | id_Start},
    {919, 951, 0, -1, -1, pr_compat | id_Start},
    {921, 953, 0, -1, -1, pr_compat | id_Start},
    {922, 954, 0, -1, -1, pr_compat | id_Start},
    {923, 955, 0, -1, -1, pr_compat | id_Start},
    {924, 956, 0, -1, -1, pr_compat | id_Start},
    {925, 957, 0, -1, -1, pr_compat | id_Start},
    {926, 958, 0, -1, -1, pr_compat | id_Start},
    {927, 959, 0, -1, -1, pr_compat | id_Start},
    {929, 961, 0, -1, -1, pr_compat | id_Start},
    {1012, 952, 0, -1, -1, pr_compat | id_Start},
    {932, 964, 0, -1, -1, pr_compat | id_Start},
    {933, 965, 0, -1, -1, pr_compat | id_Start},
    {934, 966, 0, -1, -1, pr_compat | id_Start},
    {935, 967, 0, -1, -1, pr_compat | id_Start},
    {936, 968, 0, -1, -1, pr_compat | id_Start},
    {937, 969, 0, -1, -1, pr_compat | id_Start},
    {8711, 8711, 0, -1, -1, pr_compat},
    {945, 945, 0, -1, -1, pr_compat | id_Start},
    {950, 950, 0, -1, -1, pr_compat | id_Start},
    {951, 951, 0, -1, -1, pr_compat | id_Start},
    {953, 953, 0, -1, -1, pr_compat | id_Start},
    {955, 955, 0, -1, -1, pr_compat | id_Start},
    {957, 957, 0, -1, -1, pr_compat | id_Start},
    {958, 958, 0, -1, -1, pr_compat | id_Start},
    {959, 959, 0, -1, -1, pr_compat | id_Start},
    {963, 963, 0, -1, -1, pr_compat | id_Start},
    {964, 964, 0, -1, -1, pr_compat | id_Start},
    {965, 965, 0, -1, -1, pr_compat | id_Start},
    {968, 968, 0, -1, -1, pr_compat | id_Start},
    {969, 969, 0, -1, -1, pr_compat | id_Start},
    {8706, 8706, 0, -1, -1, pr_compat},
    {1013, 949, 0, -1, -1, pr_compat | id_Start},
    {977, 952, 0, -1, -1, pr_compat | id_Start},
    {1008, 954, 0, -1, -1, pr_compat | id_Start},
    {981, 966, 0, -1, -1, pr_compat | id_Start},
    {1009, 961, 0, -1, -1, pr_compat | id_Start},
    {982, 960, 0, -1, -1, pr_compat | id_Start},
    {0, 0, 233, -1, -1, id_Continue},
    {0, 0, 222, -1, -1, id_Continue},
    {0, 0, 228, -1, -1, id_Continue},
    {0, 0, 107, -1, -1, id_Continue},
    {0, 0, 122, -1, -1, id_Continue},
    {61, 61, 0, -1, -1, pr_compat},
    {19968, 19968, 0, -1, -1, pr_compat},
    {20108, 20108, 0, -1, -1, pr_compat},
    {1659, 1659, 0, -1, -1, pr_compat | id_Start},
    {1662, 1662, 0, -1, -1, pr_compat | id_Start},
    {1664, 1664, 0, -1, -1, pr_compat | id_Start},
    {1658, 1658, 0, -1, -1, pr_compat | id_Start},
    {1663, 1663, 0, -1, -1, pr_compat | id_Start},
    {1657, 1657, 0, -1, -1, pr_compat | id_Start},
    {1700, 1700, 0, -1, -1, pr_compat | id_Start},
    {1702, 1702, 0, -1, -1, pr_compat | id_Start},
    {1668, 1668, 0, -1, -1, pr_compat | id_Start},
    {1667, 1667, 0, -1, -1, pr_compat | id_Start},
    {1670, 1670, 0, -1, -1, pr_compat | id_Start},
    {1671, 1671, 0, -1, -1, pr_compat | id_Start},
    {1705, 1705, 0, -1, -1, pr_compat | id_Start},
    {1711, 1711, 0, -1, -1, pr_compat | id_Start},
    {1715, 1715, 0, -1, -1, pr_compat | id_Start},
    {1713, 1713, 0, -1, -1, pr_compat | id_Start},
    {1722, 1722, 0, -1, -1, pr_compat | id_Start},
    {1723, 1723, 0, -1, -1, pr_compat | id_Start},
    {1729, 1729, 0, -1, -1, pr_compat | id_Start},
    {1726, 1726, 0, -1, -1, pr_compat | id_Start},
    {1709, 1709, 0, -1, -1, pr_compat | id_Start},
    {1744, 1744, 0, -1, -1, pr_compat | id_Start},
    {1609, 1609, 0, -1, -1, pr_compat | id_Start},
    {1740, 1740, 0, -1, -1, pr_compat | id_Start},
    {-3619, -3619, 0, -1, -1, pr_compat | id_Start},
    {-3629, -3629, 0, -1, -1, pr_compat | id_Start},
    {-3641, -3641, 0, -1, -1, pr_compat | id_Start},
    {-3649, -3649, 0, -1, -1, pr_compat | id_Start},
    {-3731, -3731, 0, -1, -1, pr_compat | id_Start},
    {-3733, -3733, 0, -1, -1, pr_compat | id_Start},
    {-3745, -3745, 0, -1, -1, pr_compat | id_Start},
    {-3769, -3769, 0, -1, -1, pr_compat | id_Start},
    {-3789, -3789, 0, -1, -1, pr_compat | id_Start},
    {-3879, -3879, 0, -1, -1, pr_compat | id_Start},
    {-3932, -3932, 0, -1, -1, pr_compat | id_Start},
    {-3934, -3934, 0, -1, -1, pr_compat | id_Start},
    {-3936, -3936, 0, -1, -1, pr_compat | id_Start},
    {8254, -1841, 0, -1, -1, pr_compat},
    {1574, 1574, 0, -1, -1, pr_compat | id_Start},
    {1575, 1575, 0, -1, -1, pr_compat | id_Start},
    {50, 50, 0, -1, -1, pr_compat},
    {51, 51, 0, -1, -1, pr_compat},
    {49, 49, 0, -1, -1, pr_compat},
    {0, 0, 202, -1, -1, id_Continue},
    {0, 1090, 0, -1, -1, id_Start},
    {46, 46, 0, -1, -1, pr_compat},
    {48, 48, 0, -1, -1, pr_compat},
    {52, 52, 0, -1, -1, pr_compat},
    {53, 53, 0, -1, -1, pr_compat},
    {54, 54, 0, -1, -1, pr_compat},
    {55, 55, 0, -1, -1, pr_compat},
    {56, 56, 0, -1, -1, pr_compat},
    {57, 57, 0, -1, -1, pr_compat},
    {67, 99, 0, -1, -1, pr_compat},
    {82, 114, 0, -1, -1, pr_compat},
    {26376, 26376, 0, -1, -1, pr_compat},
    {19977, 19977, 0, -1, -1, pr_compat},
    {20013, 20013, 0, -1, -1, pr_compat},
    {-16474, -16474, 0, -1, -1, id_Start | qc_N},
    {27138, 27138, 0, -1, -1, id_Start | qc_N},
    {26391, 26391, 0, -1, -1, id_Start | qc_N},
    {23527, 23527, 0, -1, -1, id_Start | qc_N},
    {27578, 27578, 0, -1, -1, id_Start | qc_N},
    {32244, 32244, 0, -1, -1, id_Start | qc_N},
    {27969, 27969, 0, -1, -1, id_Start | qc_N},
    {24974, 24974, 0, -1, -1, id_Start | qc_N},
    {25074, 25074, 0, -1, -1, id_Start | qc_N},
    {-16587, -16587, 0, -1, -1, id_Start | qc_N},
    {-16618, -16618, 0, -1, -1, id_Start | qc_N},
    {-3611, -3611, 0, -1, -1, pr_compat | id_Start},
    {-3669, -3669, 0, -1, -1, pr_compat | id_Start},
    {-3671, -3671, 0, -1, -1, pr_compat | id_Start},
    {-3673, -3673, 0, -1, -1, pr_compat | id_Start},
    {-3675, -3675, 0, -1, -1, pr_compat | id_Start},
    {-3691, -3691, 0, -1, -1, pr_compat | id_Start},
    {-3693, -3693, 0, -1, -1, pr_compat | id_Start},
    {-3757, -3757, 0, -1, -1, pr_compat | id_Start},
    {44, 44, 0, -1, -1, pr_compat},
    {12289, 12289, 0, -1, -1, pr_compat},
    {58, 58, 0, -1, -1, pr_compat},
    {59, 59, 0, -1, -1, pr_compat},
    {33, 33, 0, -1, -1, pr_compat},
    {63, 63, 0, -1, -1, pr_compat},
    {123, 123, 0, -1, -1, pr_compat},
    {125, 125, 0, -1, -1, pr_compat},
    {21375, 21375, 0, -1, -1, id_Start | qc_N},
    {-5, -5, 0, -1, -1, pr_compat},
    {0, -4488, 0, -1, -1, id_Start},
    {0, 963, 0, -1, -1, id_Start},
    {0, 1074, 0, -1, -1, id_Start},
    {0, 1076, 0, -1, -1, id_Start},
    {0, 1089, 0, -1, -1, id_Start},
    {0, 1098, 0, -1, -1, id_Start},
    {0, 1123, 0, -1, -1, id_Start},
    {0, 0, 18, -1, -1, id_Continue},
    {0, 0, 19, -1, -1, id_Continue},
    {0, 0, 30, -1, -1, id_Continue},
    {0, 0, 31, -1, -1, id_Continue},
    {0, 0, 32, -1, -1, id_Continue},
    {0, 0, 27, -1, -1, id_Continue},
    {0, 0, 28, -1, -1, id_Continue},
    {0, 0, 29, -1, -1, id_Continue},
    {0, 0, 103, -1, -1, id_Continue},
    {0, 0, 118, -1, -1, id_Continue},
    {0, -16872, 0, -1, -1, id_Start},
    {601, 601, 0, -1, -1, pr_compat | id_Start},
    {604, 604, 0, -1, -1, pr_compat | id_Start},
    {8722, 8722, 0, -1, -1, pr_compat},
    {1488, 1488, 0, -1, -1, pr_compat | id_Start},
    {1491, 1491, 0, -1, -1, pr_compat | id_Start},
    {65, 97, 0, -1, -1, pr_compat},
    {66, 98, 0, -1, -1, pr_compat},
    {68, 100, 0, -1, -1, pr_compat},
    {69, 101, 0, -1, -1, pr_compat},
    {70, 102, 0, -1, -1, pr_compat},
    {71, 103, 0, -1, -1, pr_compat},
    {72, 104, 0, -1, -1, pr_compat},
    {73, 105, 0, -1, -1, pr_compat},
    {74, 106, 0, -1, -1, pr_compat},
    {75, 107, 0, -1, -1, pr_compat},
    {76, 108, 0, -1, -1, pr_compat},
    {77, 109, 0, -1, -1, pr_compat},
    {78, 110, 0, -1, -1, pr_compat},
    {79, 111, 0, -1, -1, pr_compat},
    {80, 112, 0, -1, -1, pr_compat},
    {81, 113, 0, -1, -1, pr_compat},
    {83, 115, 0, -1, -1, pr_compat},
    {84, 116, 0, -1, -1, pr_compat},
    {85, 117, 0, -1, -1, pr_compat},
    {86, 118, 0, -1, -1, pr_compat},
    {87, 119, 0, -1, -1, pr_compat},
    {88, 120, 0, -1, -1, pr_compat},
    {89, 121, 0, -1, -1, pr_compat},
    {90, 122, 0, -1, -1, pr_compat},
    {20057, 20057, 0, -1, -1, pr_compat},
    {20154, 20154, 0, -1, -1, pr_compat},
    {20843, 20843, 0, -1, -1, pr_compat},
    {21313, 21313, 0, -1, -1, pr_compat},
    {22303, 22303, 0, -1, -1, pr_compat},
    {22899, 22899, 0, -1, -1, pr_compat},
    {25163, 25163, 0, -1, -1, pr_compat},
    {25991, 25991, 0, -1, -1, pr_compat},
    {26085, 26085, 0, -1, -1, pr_compat},
    {26408, 26408, 0, -1, -1, pr_compat},
    {27700, 27700, 0, -1, -1, pr_compat},
    {28779, 28779, 0, -1, -1, pr_compat},
    {29983, 29983, 0, -1, -1, pr_compat},
    {-16417, -16417, 0, -1, -1, pr_compat},
    {-16428, -16428, 0, -1, -1, pr_compat},
    {0, 0, 224, -1, -1, id_Continue},
    {22235, 22235, 0, -1, -1, pr_compat},
    {19978, 19978, 0, -1, -1, pr_compat},
    {19979, 19979, 0, -1, -1, pr_compat},
    {22825, 22825, 0, -1, -1, pr_compat},
    {26377, 26377, 0, -1, -1, pr_compat},
    {24038, 24038, 0, -1, -1, pr_compat},
    {21491, 21491, 0, -1, -1, pr_compat},
    {12469, 12469, 0, -1, -1, pr_compat},
    {-3329, -4731, 0, -1, -1, pr_compat},
    {25078, 25078, 0, -1, -1, id_Start | qc_N},
    {24266, 24266, 0, -1, -1, id_Start | qc_N},
    {-16516, -16516, 0, -1, -1, id_Start | qc_N},
    {30860, 30860, 0, -1, -1, id_Start | qc_N},
    {-16532, -16532, 0, -1, -1, id_Start | qc_N},
    {29575, 29575, 0, -1, -1, id_Start | qc_N},
    {30064, 30064, 0, -1, -1, id_Start | qc_N},
    {21271, 21271, 0, -1, -1, id_Start | qc_N},
    {-16534, -16534, 0, -1, -1, id_Start | qc_N},
    {-16535, -16535, 0, -1, -1, id_Start | qc_N},
    {20999, 20999, 0, -1, -1, id_Start | qc_N},
    {22618, 22618, 0, -1, -1, id_Start | qc_N},
    {26228, 26228, 0, -1, -1, id_Start | qc_N},
    {29482, 29482, 0, -1, -1, id_Start | qc_N},
    {30410, 30410, 0, -1, -1, id_Start | qc_N},
    {31119, 31119, 0, -1, -1, id_Start | qc_N},
    {-16576, -16576, 0, -1, -1, id_Start | qc_N},
    {-16578, -16578, 0, -1, -1, id_Start | qc_N},
    {-16579, -16579, 0, -1, -1, id_Start | qc_N},
    {20398, 20398, 0, -1, -1, id_Start | qc_N},
    {20711, 20711, 0, -1, -1, id_Start | qc_N},
    {20813, 20813, 0, -1, -1, id_Start | qc_N},
    {21193, 21193, 0, -1, -1, id_Start | qc_N},
    {21220, 21220, 0, -1, -1, id_Start | qc_N},
    {21329, 21329, 0, -1, -1, id_Start | qc_N},
    {21917, 21917, 0, -1, -1, id_Start | qc_N},
    {22022, 22022, 0, -1, -1, id_Start | qc_N},
    {23662, 23662, 0, -1, -1, id_Start | qc_N},
    {24724, 24724, 0, -1, -1, id_Start | qc_N},
    {25935, 25935, 0, -1, -1, id_Start | qc_N},
    {26257, 26257, 0, -1, -1, id_Start | qc_N},
    {26757, 26757, 0, -1, -1, id_Start | qc_N},
    {28023, 28023, 0, -1, -1, id_Start | qc_N},
    {28450, 28450, 0, -1, -1, id_Start | qc_N},
    {29038, 29038, 0, -1, -1, id_Start | qc_N},
    {31062, 31062, 0, -1, -1, id_Start | qc_N},
    {31296, 31296, 0, -1, -1, id_Start | qc_N},
    {31680, 31680, 0, -1, -1, id_Start | qc_N},
    {-16589, -16589, 0, -1, -1, id_Start | qc_N},
    {-16590, -16590, 0, -1, -1, id_Start | qc_N},
    {-16592, -16592, 0, -1, -1, id_Start | qc_N},
    {-16593, -16593, 0, -1, -1, id_Start | qc_N},
    {-16594, -16594, 0, -1, -1, id_Start | qc_N},
    {-16596, -16596, 0, -1, -1, id_Start | qc_N},
    {-16598, -16598, 0, -1, -1, id_Start | qc_N},
    {-16599, -16599, 0, -1, -1, id_Start | qc_N},
    {-16600, -16600, 0, -1, -1, id_Start | qc_N},
    {20917, 20917, 0, -1, -1, id_Start | qc_N},
    {21191, 21191, 0, -1, -1, id_Start | qc_N},
    {21242, 21242, 0, -1, -1, id_Start | qc_N},
    {21913, 21913, 0, -1, -1, id_Start | qc_N},
    {24910, 24910, 0, -1, -1, id_Start | qc_N},
    {26395, 26395, 0, -1, -1, id_Start | qc_N},
    {28363, 28363, 0, -1, -1, id_Start | qc_N},
    {28702, 28702, 0, -1, -1, id_Start | qc_N},
    {29237, 29237, 0, -1, -1, id_Start | qc_N},
    {29809, 29809, 0, -1, -1, id_Start | qc_N},
    {30452, 30452, 0, -1, -1, id_Start | qc_N},
    {30538, 30538, 0, -1, -1, id_Start | qc_N},
    {30924, 30924, 0, -1, -1, id_Start | qc_N},
    {-16605, -16605, 0, -1, -1, id_Start | qc_N},
    {-16610, -16610, 0, -1, -1, id_Start | qc_N},
    {-16611, -16611, 0, -1, -1, id_Start | qc_N},
    {-16612, -16612, 0, -1, -1, id_Start | qc_N},
    {-16619, -16619, 0, -1, -1, id_Start | qc_N},
    {15261, 15261, 0, -1, -1, id_Start | qc_N},
    {16441, 16441, 0, -1, -1, id_Start | qc_N},
    {1649, 1649, 0, -1, -1, pr_compat | id_Start},
    {1677, 1677, 0, -1, -1, pr_compat | id_Start},
    {1676, 1676, 0, -1, -1, pr_compat | id_Start},
    {1678, 1678, 0, -1, -1, pr_compat | id_Start},
    {1672, 1672, 0, -1, -1, pr_compat | id_Start},
    {1688, 1688, 0, -1, -1, pr_compat | id_Start},
    {1681, 1681, 0, -1, -1, pr_compat | id_Start},
    {1728, 1728, 0, -1, -1, pr_compat | id_Start},
    {1746, 1746, 0, -1, -1, pr_compat | id_Start},
    {1747, 1747, 0, -1, -1, pr_compat | id_Start},
    {1735, 1735, 0, -1, -1, pr_compat | id_Start},
    {1734, 1734, 0, -1, -1, pr_compat | id_Start},
    {1736, 1736, 0, -1, -1, pr_compat | id_Start},
    {1739, 1739, 0, -1, -1, pr_compat | id_Start},
    {1733, 1733, 0, -1, -1, pr_compat | id_Start},
    {1737, 1737, 0, -1, -1, pr_compat | id_Start},
    {-3599, -3599, 0, -1, -1, pr_compat | id_Start},
    {-3601, -3601, 0, -1, -1, pr_compat | id_Start},
    {-3603, -3603, 0, -1, -1, pr_compat | id_Start},
    {-3605, -3605, 0, -1, -1, pr_compat | id_Start},
    {-3607, -3607, 0, -1, -1, pr_compat | id_Start},
    {-3609, -3609, 0, -1, -1, pr_compat | id_Start},
    {-3615, -3615, 0, -1, -1, pr_compat | id_Start},
    {-3617, -3617, 0, -1, -1, pr_compat | id_Start},
    {-3621, -3621, 0, -1, -1, pr_compat | id_Start},
    {-3623, -3623, 0, -1, -1, pr_compat | id_Start},
    {-3625, -3625, 0, -1, -1, pr_compat | id_Start},
    {-3627, -3627, 0, -1, -1, pr_compat | id_Start},
    {-3631, -3631, 0, -1, -1, pr_compat | id_Start},
    {-3633, -3633, 0, -1, -1, pr_compat | id_Start},
    {-3635, -3635, 0, -1, -1, pr_compat | id_Start},
    {-3637, -3637, 0, -1, -1, pr_compat | id_Start},
    {-3639, -3639, 0, -1, -1, pr_compat | id_Start},
    {-3643, -3643, 0, -1, -1, pr_compat | id_Start},
    {-3645, -3645, 0, -1, -1, pr_compat | id_Start},
    {-3651, -3651, 0, -1, -1, pr_compat | id_Start},
    {-3653, -3653, 0, -1, -1, pr_compat | id_Start},
    {-3655, -3655, 0, -1, -1, pr_compat | id_Start},
    {-3657, -3657, 0, -1, -1, pr_compat | id_Start},
    {-3659, -3659, 0, -1, -1, pr_compat | id_Start},
    {-3661, -3661, 0, -1, -1, pr_compat | id_Start},
    {-3663, -3663, 0, -1, -1, pr_compat | id_Start},
    {-3667, -3667, 0, -1, -1, pr_compat | id_Start},
    {-3677, -3677, 0, -1, -1, pr_compat | id_Start},
    {-3679, -3679, 0, -1, -1, pr_compat | id_Start},
    {-3681, -3681, 0, -1, -1, pr_compat | id_Start},
    {-3683, -3683, 0, -1, -1, pr_compat | id_Start},
    {-3685, -3685, 0, -1, -1, pr_compat | id_Start},
    {-3687, -3687, 0, -1, -1, pr_compat | id_Start},
    {-3689, -3689, 0, -1, -1, pr_compat | id_Start},
    {-3695, -3695, 0, -1, -1, pr_compat | id_Start},
    {-3697, -3697, 0, -1, -1, pr_compat | id_Start},
    {-3699, -3699, 0, -1, -1, pr_compat | id_Start},
    {-3701, -3701, 0, -1, -1, pr_compat | id_Start},
    {-3703, -3703, 0, -1, -1, pr_compat | id_Start},
    {-3705, -3705, 0, -1, -1, pr_compat | id_Start},
    {-3707, -3707, 0, -1, -1, pr_compat | id_Start},
    {-3709, -3709, 0, -1, -1, pr_compat | id_Start},
    {-3711, -3711, 0, -1, -1, pr_compat | id_Start},
    {-3713, -3713, 0, -1, -1, pr_compat | id_Start},
    {-3715, -3715, 0, -1, -1, pr_compat | id_Start},
    {-3717, -3717, 0, -1, -1, pr_compat | id_Start},
    {-3719, -3719, 0, -1, -1, pr_compat | id_Start},
    {-3721, -3721, 0, -1, -1, pr_compat | id_Start},
    {-3723, -3723, 0, -1, -1, pr_compat | id_Start},
    {-3725, -3725, 0, -1, -1, pr_compat | id_Start},
    {-3727, -3727, 0, -1, -1, pr_compat | id_Start},
    {-3729, -3729, 0, -1, -1, pr_compat | id_Start},
    {-3735, -3735, 0, -1, -1, pr_compat | id_Start},
    {-3737, -3737, 0, -1, -1, pr_compat | id_Start},
    {-3739, -3739, 0, -1, -1, pr_compat | id_Start},
    {-3741, -3741, 0, -1, -1, pr_compat | id_Start},
    {-3743, -3743, 0, -1, -1, pr_compat | id_Start},
    {-3747, -3747, 0, -1, -1, pr_compat | id_Start},
    {-3749, -3749, 0, -1, -1, pr_compat | id_Start},
    {-3751, -3751, 0, -1, -1, pr_compat | id_Start},
    {-3753, -3753, 0, -1, -1, pr_compat | id_Start},
    {-3755, -3755, 0, -1, -1, pr_compat | id_Start},
    {-3763, -3763, 0, -1, -1, pr_compat | id_Start},
    {-3765, -3765, 0, -1, -1, pr_compat | id_Start},
    {-3767, -3767, 0, -1, -1, pr_compat | id_Start},
    {-3771, -3771, 0, -1, -1, pr_compat | id_Start},
    {-3773, -3773, 0, -1, -1, pr_compat | id_Start},
    {-3775, -3775, 0, -1, -1, pr_compat | id_Start},
    {-3777, -3777, 0, -1, -1, pr_compat | id_Start},
    {-3783, -3783, 0, -1, -1, pr_compat | id_Start},
    {-3785, -3785, 0, -1, -1, pr_compat | id_Start},
    {-3787, -3787, 0, -1, -1, pr_compat | id_Start},
    {-3791, -3791, 0, -1, -1, pr_compat | id_Start},
    {-3793, -3793, 0, -1, -1, pr_compat | id_Start},
    {-3799, -3799, 0, -1, -1, pr_compat | id_Start},
    {-3859, -3859, 0, -1, -1, pr_compat | id_Start},
    {-3861, -3861, 0, -1, -1, pr_compat | id_Start},
    {-3863, -3863, 0, -1, -1, pr_compat | id_Start},
    {-3869, -3869, 0, -1, -1, pr_compat | id_Start},
    {-3873, -3873, 0, -1, -1, pr_compat | id_Start},
    {-3877, -3877, 0, -1, -1, pr_compat | id_Start},
    {-3881, -3881, 0, -1, -1, pr_compat | id_Start},
    {-3892, -3892, 0, -1, -1, pr_compat | id_Start},
    {-3894, -3894, 0, -1, -1, pr_compat | id_Start},
    {-3896, -3896, 0, -1, -1, pr_compat | id_Start},
    {-3898, -3898, 0, -1, -1, pr_compat | id_Start},
    {-3900, -3900, 0, -1, -1, pr_compat | id_Start},
    {-3902, -3902, 0, -1, -1, pr_compat | id_Start},
    {-3904, -3904, 0, -1, -1, pr_compat | id_Start},
    {-3906, -3906, 0, -1, -1, pr_compat | id_Start},
    {-3908, -3908, 0, -1, -1, pr_compat | id_Start},
    {-3910, -3910, 0, -1, -1, pr_compat | id_Start},
    {-3912, -3912, 0, -1, -1, pr_compat | id_Start},
    {-3914, -3914, 0, -1, -1, pr_compat | id_Start},
    {-3916, -3916, 0, -1, -1, pr_compat | id_Start},
    {-3918, -3918, 0, -1, -1, pr_compat | id_Start},
    {-3920, -3920, 0, -1, -1, pr_compat | id_Start},
    {-3922, -3922, 0, -1, -1, pr_compat | id_Start},
    {-3924, -3924, 0, -1, -1, pr_compat | id_Start},
    {-3926, -3926, 0, -1, -1, pr_compat | id_Start},
    {-3928, -3928, 0, -1, -1, pr_compat | id_Start},
    {-3930, -3930, 0, -1, -1, pr_compat | id_Start},
    {-3938, -3938, 0, -1, -1, pr_compat | id_Start},
    {-3940, -3940, 0, -1, -1, pr_compat | id_Start},
    {-3942, -3942, 0, -1, -1, pr_compat | id_Start},
    {-3944, -3944, 0, -1, -1, pr_compat | id_Start},
    {-3946, -3946, 0, -1, -1, pr_compat | id_Start},
    {-3951, -3951, 0, -1, -1, pr_compat | id_Start},
    {-3969, -3969, 0, -1, -1, pr_compat | id_Start},
    {-3987, -3987, 0, -1, -1, pr_compat | id_Start},
    {-3993, -3993, 0, -1, -1, pr_compat | id_Start},
    {-3996, -3996, 0, -1, -1, pr_compat | id_Start},
    {-3999, -3999, 0, -1, -1, pr_compat | id_Start},
    {-4002, -4002, 0, -1, -1, pr_compat | id_Start},
    {-4008, -4008, 0, -1, -1, pr_compat | id_Start},
    {-4011, -4011, 0, -1, -1, pr_compat | id_Start},
    {-4017, -4017, 0, -1, -1, pr_compat | id_Start},
    {-4020, -4020, 0, -1, -1, pr_compat | id_Start},
    {-4029, -4029, 0, -1, -1, pr_compat | id_Start},
    {-4032, -4032, 0, -1, -1, pr_compat | id_Start},
    {-4047, -4047, 0, -1, -1, pr_compat | id_Start},
    {-4050, -4050, 0, -1, -1, pr_compat | id_Start},
    {-4056, -4056, 0, -1, -1, pr_compat | id_Start},
    {-4065, -4065, 0, -1, -1, pr_compat | id_Start},
    {-4068, -4068, 0, -1, -1, pr_compat | id_Start},
    {-4071, -4071, 0, -1, -1, pr_compat | id_Start},
    {-4110, -4110, 0, -1, -1, pr_compat | id_Start},
    {-4122, -4122, 0, -1, -1, pr_compat | id_Start},
    {-4197, -4197, 0, -1, -1, pr_compat | id_Start},
    {-4203, -4203, 0, -1, -1, pr_compat | id_Start},
    {-4206, -4206, 0, -1, -1, pr_compat | id_Start},
    {12290, 12290, 0, -1, -1, pr_compat},
    {8212, 8212, 0, -1, -1, pr_compat},
    {12308, 12308, 0, -1, -1, pr_compat},
    {12309, 12309, 0, -1, -1, pr_compat},
    {12300, 12300, 0, -1, -1, pr_compat},
    {12301, 12301, 0, -1, -1, pr_compat},
    {91, 91, 0, -1, -1, pr_compat},
    {93, 93, 0, -1, -1, pr_compat},
    {35, 35, 0, -1, -1, pr_compat},
    {38, 38, 0, -1, -1, pr_compat},
    {42, 42, 0, -1, -1, pr_compat},
    {45, 45, 0, -1, -1, pr_compat},
    {60, 60, 0, -1, -1, pr_compat},
    {62, 62, 0, -1, -1, pr_compat},
    {92, 92, 0, -1, -1, pr_compat},
    {36, 36, 0, -1, -1, pr_compat},
    {37, 37, 0, -1, -1, pr_compat},
    {64, 64, 0, -1, -1, pr_compat},
    {1570, 1570, 0, -1, -1, pr_compat | id_Start},
    {1571, 1571, 0, -1, -1, pr_compat | id_Start},
    {1572, 1572, 0, -1, -1, pr_compat | id_Start},
    {1573, 1573, 0, -1, -1, pr_compat | id_Start},
    {1577, 1577, 0, -1, -1, pr_compat | id_Start},
    {-4325, -4325, 0, -1, -1, pr_compat | id_Start},
    {-4327, -4327, 0, -1, -1, pr_compat | id_Start},
    {-4329, -4329, 0, -1, -1, pr_compat | id_Start},
    {-4331, -4331, 0, -1, -1, pr_compat | id_Start},
    {1646, 1646, 0, -1, -1, pr_compat | id_Start},
    {1697, 1697, 0, -1, -1, pr_compat | id_Start},
    {1647, 1647, 0, -1, -1, pr_compat | id_Start},
    {21892, 21892, 0, -1, -1, id_Start | qc_N},
    {23358, 23358, 0, -1, -1, id_Start | qc_N},
    {-16702, -16702, 0, -1, -1, id_Start | qc_N},
    {-16703, -16703, 0, -1, -1, id_Start | qc_N},
    {24354, 24354, 0, -1, -1, id_Start | qc_N},
    {24908, 24908, 0, -1, -1, id_Start | qc_N},
    {16056, 16056, 0, -1, -1, id_Start | qc_N},
    {30495, 30495, 0, -1, -1, id_Start | qc_N},
    {-16744, -16744, 0, -1, -1, id_Start | qc_N},
    {0, 0, 0, -1, 4464, 0},
    {0, 0, 0, -1, 4278, 0},
    {0, 0, 0, -1, 4526, 0},
    {0, 97, 0, -1, 0, id_Start},
    {0, 98, 0, -1, 15190, id_Start},
    {0, 99, 0, -1, 62, id_Start},
    {0, 100, 0, -1, 992, id_Start},
    {0, 101, 0, -1, 124, id_Start},
    {0, 102, 0, -1, 15686, id_Start},
    {0, 103, 0, -1, 1116, id_Start},
    {0, 104, 0, -1, 1240, id_Start},
    {0, 105, 0, -1, 186, id_Start},
    {0, 106, 0, -1, 1364, id_Start},
    {0, 107, 0, -1, 1488, id_Start},
    {0, 108, 0, -1, 1612, id_Start},
    {0, 109, 0, -1, 16058, id_Start},
    {0, 110, 0, -1, 248, id_Start},
    {0, 111, 0, -1, 310, id_Start},
    {0, 112, 0, -1, 16306, id_Start},
    {0, 113, 0, -1, -1, id_Start},
    {0, 114, 0, -1, 1736, id_Start},
    {0, 115, 0, -1, 1860, id_Start},
    {0, 116, 0, -1, 1984, id_Start},
    {0, 117, 0, -1, 372, id_Start},
    {0, 118, 0, -1, 17174, id_Start},
    {0, 119, 0, -1, 2108, id_Start},
    {0, 120, 0, -1, 17298, id_Start},
    {0, 121, 0, -1, 434, id_Start},
    {0, 122, 0, -1, 2232, id_Start},
    {0, 0, 0, -1, 496, id_Start},
    {0, 0, 0, -1, 15252, id_Start},
    {0, 0, 0, -1, 558, id_Start},
    {0, 0, 0, -1, 1054, id_Start},
    {0, 0, 0, -1, 620, id_Start},
    {0, 0, 0, -1, 15748, id_Start},
    {0, 0, 0, -1, 1178, id_Start},
    {0, 0, 0, -1, 1302, id_Start},
    {0, 0, 0, -1, 682, id_Start},
    {0, 0, 0, -1, 1426, id_Start},
    {0, 0, 0, -1, 1550, id_Start},
    {0, 0, 0, -1, 1674, id_Start},
    {0, 0, 0, -1, 16120, id_Start},
    {0, 0, 0, -1, 744, id_Start},
    {0, 0, 0, -1, 806, id_Start},
    {0, 0, 0, -1, 16368, id_Start},
    {0, 0, 0, -1, 1798, id_Start},
    {0, 0, 0, -1, 1922, id_Start},
    {0, 0, 0, -1, 2046, id_Start},
    {0, 0, 0, -1, 868, id_Start},
    {0, 0, 0, -1, 17236, id_Start},
    {0, 0, 0, -1, 2170, id_Start},
    {0, 0, 0, -1, 17360, id_Start},
    {0, 0, 0, -1, 930, id_Start},
    {0, 0, 0, -1, 2294, id_Start},
    {-1, -1, 0, -1, 6076, pr_compat},
    {-3, -3, 0, -1, -1, pr_compat},
    {-7, -7, 0, -1, -1, pr_compat},
    {-9, -9, 0, -1, -1, pr_compat},
    {-12, -12, 0, -1, -1, pr_compat},
    {-15, -15, 0, -1, -1, pr_compat},
    {-18, 224, 0, -1, -1, id_Start},
    {-20, 225, 0, -1, -1, id_Start},
    {-22, 226, 0, -1, 17484, id_Start},
    {-24, 227, 0, -1, -1, id_Start},
    {-26, 228, 0, -1, 2666, id_Start},
    {-28, 229, 0, -1, 3286, id_Start},
    {0, 230, 0, -1, 2914, id_Start},
    {-30, 231, 0, -1, 15314, id_Start},
    {-32, 232, 0, -1, -1, id_Start},
    {-34, 233, 0, -1, -1, id_Start},
    {-36, 234, 0, -1, 17856, id_Start},
    {-38, 235, 0, -1, -1, id_Start},
    {-40, 236, 0, -1, -1, id_Start},
    {-42, 237, 0, -1, -1, id_Start},
    {-44, 238, 0, -1, -1, id_Start},
    {-46, 239, 0, -1, 15810, id_Start},
    {0, 240, 0, -1, -1, id_Start},
    {-48, 241, 0, -1, -1, id_Start},
    {-50, 242, 0, -1, -1, id_Start},
    {-52, 243, 0, -1, -1, id_Start},
    {-54, 244, 0, -1, 18104, id_Start},
    {-56, 245, 0, -1, 3782, id_Start},
    {-58, 246, 0, -1, 3658, id_Start},
    {0, 248, 0, -1, 3410, id_Start},
    {-60, 249, 0, -1, -1, id_Start},
    {-62, 250, 0, -1, -1, id_Start},
    {-64, 251, 0, -1, -1, id_Start},
    {-66, 252, 0, -1, 2542, id_Start},
    {-68, 253, 0, -1, -1, id_Start},
    {0, 254, 0, -1, -1, id_Start},
    {-70, 0, 0, -1, -1, id_Start},
    {-72, 0, 0, -1, -1, id_Start},
    {-74, 0, 0, -1, 17546, id_Start},
    {-76, 0, 0, -1, -1, id_Start},
    {-78, 0, 0, -1, 2728, id_Start},
    {-80, 0, 0, -1, 3348, id_Start},
    {0, 0, 0, -1, 2976, id_Start},
    {-82, 0, 0, -1, 15376, id_Start},
    {-84, 0, 0, -1, -1, id_Start},
    {-86, 0, 0, -1, -1, id_Start},
    {-88, 0, 0, -1, 17918, id_Start},
    {-90, 0, 0, -1, -1, id_Start},
    {-92, 0, 0, -1, -1, id_Start},
    {-94, 0, 0, -1, -1, id_Start},
    {-96, 0, 0, -1, -1, id_Start},
    {-98, 0, 0, -1, 15872, id_Start},
    {-100, 0, 0, -1, -1, id_Start},
    {-102, 0, 0, -1, -1, id_Start},
    {-104, 0, 0, -1, -1, id_Start},
    {-106, 0, 0, -1, 18166, id_Start},
    {-108, 0, 0, -1, 3844, id_Start},
    {-110, 0, 0, -1, 3720, id_Start},
    {0, 0, 0, -1, 3472, id_Start},
    {-112, 0, 0, -1, -1, id_Start},
    {-114, 0, 0, -1, -1, id_Start},
    {-116, 0, 0, -1, -1, id_Start},
    {-118, 0, 0, -1, 2604, id_Start},
    {-120, 0, 0, -1, -1, id_Start},
    {-122, 0, 0, -1, -1, id_Start},
    {-124, 257, 0, -1, -1, id_Start},
    {-126, 0, 0, -1, -1, id_Start},
    {-128, 259, 0, -1, 17732, id_Start},
    {-130, 0, 0, -1, 17794, id_Start},
    {-132, 261, 0, -1, -1, id_Start},
    {-134, 0, 0, -1, -1, id_Start},
    {-136, 263, 0, -1, -1, id_Start},
    {-138, 0, 0, -1, -1, id_Start},
    {-140, 265, 0, -1, -1, id_Start},
    {-142, 0, 0, -1, -1, id_Start},
    {-144, 267, 0, -1, -1, id_Start},
    {-146, 0, 0, -1, -1, id_Start},
    {-148, 269, 0, -1, -1, id_Start},
    {-150, 0, 0, -1, -1, id_Start},
    {-152, 271, 0, -1, -1, id_Start},
    {-154, 0, 0, -1, -1, id_Start},
    {0, 273, 0, -1, -1, id_Start},
    {-156, 275, 0, -1, 15438, id_Start},
    {-158, 0, 0, -1, 15500, id_Start},
    {-160, 277, 0, -1, -1, id_Start},
    {-162, 0, 0, -1, -1, id_Start},
    {-164, 279, 0, -1, -1, id_Start},
    {-166, 0, 0, -1, -1, id_Start},
    {-168, 281, 0, -1, -1, id_Start},
    {-170, 0, 0, -1, -1, id_Start},
    {-172, 283, 0, -1, -1, id_Start},
    {-174, 0, 0, -1, -1, id_Start},
    {-176, 285, 0, -1, -1, id_Start},
    {-178, 0, 0, -1, -1, id_Start},
    {-180, 287, 0, -1, -1, id_Start},
    {-182, 0, 0, -1, -1, id_Start},
    {-184, 289, 0, -1, -1, id_Start},
    {-186, 0, 0, -1, -1, id_Start},
    {-188, 291, 0, -1, -1, id_Start},
    {-190, 0, 0, -1, -1, id_Start},
    {-192, 293, 0, -1, -1, id_Start},
    {-194, 0, 0, -1, -1, id_Start},
    {0, 295, 0, -1, -1, id_Start},
    {-196, 297, 0, -1, -1, id_Start},
    {-198, 0, 0, -1, -1, id_Start},
    {-200, 299, 0, -1, -1, id_Start},
    {-202, 0, 0, -1, -1, id_Start},
    {-204, 301, 0, -1, -1, id_Start},
    {-206, 0, 0, -1, -1, id_Start},
    {-208, 303, 0, -1, -1, id_Start},
    {-210, 0, 0, -1, -1, id_Start},
    {-212, -4490, 0, -1, -1, id_Start},
    {-214, -216, 0, -1, -1, pr_compat | id_Start},
    {-216, -216, 0, -1, -1, pr_compat | id_Start},
    {-218, 309, 0, -1, -1, id_Start},
    {-220, 0, 0, -1, -1, id_Start},
    {-222, 311, 0, -1, -1, id_Start},
    {-224, 0, 0, -1, -1, id_Start},
    {-226, 314, 0, -1, -1, id_Start},
    {-228, 0, 0, -1, -1, id_Start},
    {-230, 316, 0, -1, -1, id_Start},
    {-232, 0, 0, -1, -1, id_Start},
    {-234, 318, 0, -1, -1, id_Start},
    {-236, 0, 0, -1, -1, id_Start},
    {-238, -240, 0, -1, -1, pr_compat | id_Start},
    {-240, -240, 0, -1, -1, pr_compat | id_Start},
    {0, 322, 0, -1, -1, id_Start},
    {-242, 324, 0, -1, -1, id_Start},
    {-244, 0, 0, -1, -1, id_Start},
    {-246, 326, 0, -1, -1, id_Start},
    {-248, 0, 0, -1, -1, id_Start},
    {-250, 328, 0, -1, -1, id_Start},
    {-252, 0, 0, -1, -1, id_Start},
    {-254, -254, 0, -1, -1, pr_compat | id_Start},
    {0, 331, 0, -1, -1, id_Start},
    {-256, 333, 0, -1, 16182, id_Start},
    {-258, 0, 0, -1, 16244, id_Start},
    {-260, 335, 0, -1, -1, id_Start},
    {-262, 0, 0, -1, -1, id_Start},
    {-264, 337, 0, -1, -1, id_Start},
    {-266, 0, 0, -1, -1, id_Start},
    {0, 339, 0, -1, -1, id_Start},
    {-268, 341, 0, -1, -1, id_Start},
    {-270, 0, 0, -1, -1, id_Start},
    {-272, 343, 0, -1, -1, id_Start},
    {-274, 0, 0, -1, -1, id_Start},
    {-276, 345, 0, -1, -1, id_Start},
    {-278, 0, 0, -1, -1, id_Start},
    {-280, 347, 0, -1, 16554, id_Start},
    {-282, 0, 0, -1, 16616, id_Start},
    {-284, 349, 0, -1, -1, id_Start},
    {-286, 0, 0, -1, -1, id_Start},
    {-288, 351, 0, -1, -1, id_Start},
    {-290, 0, 0, -1, -1, id_Start},
    {-292, 353, 0, -1, 16678, id_Start},
    {-294, 0, 0, -1, 16740, id_Start},
    {-296, 355, 0, -1, -1, id_Start},
    {-298, 0, 0, -1, -1, id_Start},
    {-300, 357, 0, -1, -1, id_Start},
    {-302, 0, 0, -1, -1, id_Start},
    {0, 359, 0, -1, -1, id_Start},
    {-304, 361, 0, -1, 16926, id_Start},
    {-306, 0, 0, -1, 16988, id_Start},
    {-308, 363, 0, -1, 17050, id_Start},
    {-310, 0, 0, -1, 17112, id_Start},
    {-312, 365, 0, -1, -1, id_Start},
    {-314, 0, 0, -1, -1, id_Start},
    {-316, 367, 0, -1, -1, id_Start},
    {-318, 0, 0, -1, -1, id_Start},
    {-320, 369, 0, -1, -1, id_Start},
    {-322, 0, 0, -1, -1, id_Start},
    {-324, 371, 0, -1, -1, id_Start},
    {-326, 0, 0, -1, -1, id_Start},
    {-328, 373, 0, -1, -1, id_Start},
    {-330, 0, 0, -1, -1, id_Start},
    {-332, 375, 0, -1, -1, id_Start},
    {-334, 0, 0, -1, -1, id_Start},
    {-336, 255, 0, -1, -1, id_Start},
    {-338, 378, 0, -1, -1, id_Start},
    {-340, 0, 0, -1, -1, id_Start},
    {-342, 380, 0, -1, -1, id_Start},
    {-344, 0, 0, -1, -1, id_Start},
    {-346, 382, 0, -1, -1, id_Start},
    {-348, 0, 0, -1, -1, id_Start},
    {115, 115, 0, -1, 17422, pr_compat | id_Start},
    {0, 595, 0, -1, -1, id_Start},
    {0, 387, 0, -1, -1, id_Start},
    {0, 389, 0, -1, -1, id_Start},
    {0, 596, 0, -1, -1, id_Start},
    {0, 392, 0, -1, -1, id_Start},
    {0, 598, 0, -1, -1, id_Start},
    {0, 599, 0, -1, -1, id_Start},
    {0, 396, 0, -1, -1, id_Start},
    {0, 477, 0, -1, -1, id_Start},
    {0, 601, 0, -1, -1, id_Start},
    {0, 603, 0, -1, -1, id_Start},
    {0, 402, 0, -1, -1, id_Start},
    {0, 608, 0, -1, -1, id_Start},
    {0, 611, 0, -1, -1, id_Start},
    {0, 617, 0, -1, -1, id_Start},
    {0, 616, 0, -1, -1, id_Start},
    {0, 409, 0, -1, -1, id_Start},
    {0, 623, 0, -1, -1, id_Start},
    {0, 626, 0, -1, -1, id_Start},
    {0, 629, 0, -1, -1, id_Start},
    {-350, 417, 0, -1, 18352, id_Start},
    {-352, 0, 0, -1, 18414, id_Start},
    {0, 419, 0, -1, -1, id_Start},
    {0, 421, 0, -1, -1, id_Start},
    {0, 640, 0, -1, -1, id_Start},
    {0, 424, 0, -1, -1, id_Start},
    {0, 643, 0, -1, -1, id_Start},
    {0, 429, 0, -1, -1, id_Start},
    {0, 648, 0, -1, -1, id_Start},
    {-354, 432, 0, -1, 18476, id_Start},
    {-356, 0, 0, -1, 18538, id_Start},
    {0, 650, 0, -1, -1, id_Start},
    {0, 651, 0, -1, -1, id_Start},
    {0, 436, 0, -1, -1, id_Start},
    {0, 438, 0, -1, -1, id_Start},
    {0, 658, 0, -1, 3162, id_Start},
    {0, 441, 0, -1, -1, id_Start},
    {0, 445, 0, -1, -1, id_Start},
    {-358, -362, 0, -1, -1, pr_compat | id_Start},
    {-360, -362, 0, -1, -1, pr_compat | id_Start},
    {-362, -362, 0, -1, -1, pr_compat | id_Start},
    {-364, -368, 0, -1, -1, pr_compat | id_Start},
    {-366, -368, 0, -1, -1, pr_compat | id_Start},
    {-368, -368, 0, -1, -1, pr_compat | id_Start},
    {-370, -374, 0, -1, -1, pr_compat | id_Start},
    {-372, -374, 0, -1, -1, pr_compat | id_Start},
    {-374, -374, 0, -1, -1, pr_compat | id_Start},
    {-376, 462, 0, -1, -1, id_Start},
    {-378, 0, 0, -1, -1, id_Start},
    {-380, 464, 0, -1, -1, id_Start},
    {-382, 0, 0, -1, -1, id_Start},
    {-384, 466, 0, -1, -1, id_Start},
    {-386, 0, 0, -1, -1, id_Start},
    {-388, 468, 0, -1, -1, id_Start},
    {-390, 0, 0, -1, -1, id_Start},
    {-392, 470, 0, -1, -1, id_Start},
    {-394, 0, 0, -1, -1, id_Start},
    {-396, 472, 0, -1, -1, id_Start},
    {-398, 0, 0, -1, -1, id_Start},
    {-400, 474, 0, -1, -1, id_Start},
    {-402, 0, 0, -1, -1, id_Start},
    {-404, 476, 0, -1, -1, id_Start},
    {-406, 0, 0, -1, -1, id_Start},
    {-408, 479, 0, -1, -1, id_Start},
    {-410, 0, 0, -1, -1, id_Start},
    {-412, 481, 0, -1, -1, id_Start},
    {-414, 0, 0, -1, -1, id_Start},
    {-416, 483, 0, -1, -1, id_Start},
    {-418, 0, 0, -1, -1, id_Start},
    {0, 485, 0, -1, -1, id_Start},
    {-420, 487, 0, -1, -1, id_Start},
    {-422, 0, 0, -1, -1, id_Start},
    {-424, 489, 0, -1, -1, id_Start},
    {-426, 0, 0, -1, -1, id_Start},
    {-428, 491, 0, -1, 3038, id_Start},
    {-430, 0, 0, -1, 3100, id_Start},
    {-432, 493, 0, -1, -1, id_Start},
    {-434, 0, 0, -1, -1, id_Start},
    {-436, 495, 0, -1, -1, id_Start},
    {-438, 0, 0, -1, -1, id_Start},
    {-440, 0, 0, -1, -1, id_Start},
    {-442, -446, 0, -1, -1, pr_compat | id_Start},
    {-444, -446, 0, -1, -1, pr_compat | id_Start},
    {-446, -446, 0, -1, -1, pr_compat | id_Start},
    {-448, 501, 0, -1, -1, id_Start},
    {-450, 0, 0, -1, -1, id_Start},
    {0, 405, 0, -1, -1, id_Start},
    {0, 447, 0, -1, -1, id_Start},
    {-452, 505, 0, -1, -1, id_Start},
    {-454, 0, 0, -1, -1, id_Start},
    {-456, 507, 0, -1, -1, id_Start},
    {-458, 0, 0, -1, -1, id_Start},
    {-460, 509, 0, -1, -1, id_Start},
    {-462, 0, 0, -1, -1, id_Start},
    {-464, 511, 0, -1, -1, id_Start},
    {-466, 0, 0, -1, -1, id_Start},
    {-468, 513, 0, -1, -1, id_Start},
    {-470, 0, 0, -1, -1, id_Start},
    {-472, 515, 0, -1, -1, id_Start},
    {-474, 0, 0, -1, -1, id_Start},
    {-476, 517, 0, -1, -1, id_Start},
    {-478, 0, 0, -1, -1, id_Start},
    {-480, 519, 0, -1, -1, id_Start},
    {-482, 0, 0, -1, -1, id_Start},
    {-484, 521, 0, -1, -1, id_Start},
    {-486, 0, 0, -1, -1, id_Start},
    {-488, 523, 0, -1, -1, id_Start},
    {-490, 0, 0, -1, -1, id_Start},
    {-492, 525, 0, -1, -1, id_Start},
    {-494, 0, 0, -1, -1, id_Start},
    {-496, 527, 0, -1, -1, id_Start},
    {-498, 0, 0, -1, -1, id_Start},
    {-500, 529, 0, -1, -1, id_Start},
    {-502, 0, 0, -1, -1, id_Start},
    {-504, 531, 0, -1, -1, id_Start},
    {-506, 0, 0, -1, -1, id_Start},
    {-508, 533, 0, -1, -1, id_Start},
    {-510, 0, 0, -1, -1, id_Start},
    {-512, 535, 0, -1, -1, id_Start},
    {-514, 0, 0, -1, -1, id_Start},
    {-516, 537, 0, -1, -1, id_Start},
    {-518, 0, 0, -1, -1, id_Start},
    {-520, 539, 0, -1, -1, id_Start},
    {-522, 0, 0, -1, -1, id_Start},
    {0, 541, 0, -1, -1, id_Start},
    {-524, 543, 0, -1, -1, id_Start},
    {-526, 0, 0, -1, -1, id_Start},
    {0, 414, 0, -1, -1, id_Start},
    {0, 547, 0, -1, -1, id_Start},
    {0, 549, 0, -1, -1, id_Start},
    {-528, 551, 0, -1, 2790, id_Start},
    {-530, 0, 0, -1, 2852, id_Start},
    {-532, 553, 0, -1, 15562, id_Start},
    {-534, 0, 0, -1, 15624, id_Start},
    {-536, 555, 0, -1, -1, id_Start},
    {-538, 0, 0, -1, -1, id_Start},
    {-540, 557, 0, -1, -1, id_Start},
    {-542, 0, 0, -1, -1, id_Start},
    {-544, 559, 0, -1, 3906, id_Start},
    {-546, 0, 0, -1, 3968, id_Start},
    {-548, 561, 0, -1, -1, id_Start},
    {-550, 0, 0, -1, -1, id_Start},
    {-552, 563, 0, -1, -1, id_Start},
    {-554, 0, 0, -1, -1, id_Start},
    {0, 11365, 0, -1, -1, id_Start},
    {0, 572, 0, -1, -1, id_Start},
    {0, 410, 0, -1, -1, id_Start},
    {0, 11366, 0, -1, -1, id_Start},
    {0, 578, 0, -1, -1, id_Start},
    {0, 384, 0, -1, -1, id_Start},
    {0, 649, 0, -1, -1, id_Start},
    {0, 652, 0, -1, -1, id_Start},
    {0, 583, 0, -1, -1, id_Start},
    {0, 585, 0, -1, -1, id_Start},
    {0, 587, 0, -1, -1, id_Start},
    {0, 589, 0, -1, -1, id_Start},
    {0, 591, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 3224, id_Start},
    {614, 614, 0, -1, -1, pr_compat | id_Start},
    {633, 633, 0, -1, -1, pr_compat | id_Start},
    {635, 635, 0, -1, -1, pr_compat | id_Start},
    {641, 641, 0, -1, -1, pr_compat | id_Start},
    {-556, -556, 0, -1, -1, pr_compat},
    {-558, -558, 0, -1, -1, pr_compat},
    {-560, -560, 0, -1, -1, pr_compat},
    {-562, -562, 0, -1, -1, pr_compat},
    {-564, -564, 0, -1, -1, pr_compat},
    {-566, -566, 0, -1, -1, pr_compat},
    {611, 611, 0, -1, -1, pr_compat | id_Start},
    {661, 661, 0, -1, -1, pr_compat | id_Start},
    {0, 0, 230, 0, -1, id_Continue | qc_M},
    {0, 0, 230, 1, -1, id_Continue | qc_M},
    {0, 0, 230, 2, -1, id_Continue | qc_M},
    {0, 0, 230, 3, -1, id_Continue | qc_M},
    {0, 0, 230, 7, -1, id_Continue | qc_M},
    {0, 0, 230, 8, -1, id_Continue | qc_M},
    {0, 0, 230, 10, -1, id_Continue | qc_M},
    {0, 0, 230, 4, -1, id_Continue | qc_M},
    {0, 0, 230, 57, -1, id_Continue | qc_M},
    {0, 0, 230, 5, -1, id_Continue | qc_M},
    {0, 0, 230, 12, -1, id_Continue | qc_M},
    {0, 0, 230, 11, -1, id_Continue | qc_M},
    {0, 0, 230, 15, -1, id_Continue | qc_M},
    {0, 0, 230, 16, -1, id_Continue | qc_M},
    {0, 0, 230, 58, -1, id_Continue | qc_M},
    {0, 0, 230, 59, -1, id_Continue | qc_M},
    {0, 0, 216, 14, -1, id_Continue | qc_M},
    {0, 0, 220, 51, -1, id_Continue | qc_M},
    {0, 0, 220, 56, -1, id_Continue | qc_M},
    {0, 0, 220, 50, -1, id_Continue | qc_M},
    {0, 0, 220, 17, -1, id_Continue | qc_M},
    {0, 0, 202, 6, -1, id_Continue | qc_M},
    {0, 0, 202, 9, -1, id_Continue | qc_M},
    {0, 0, 220, 53, -1, id_Continue | qc_M},
    {0, 0, 220, 55, -1, id_Continue | qc_M},
    {0, 0, 220, 54, -1, id_Continue | qc_M},
    {0, 0, 220, 52, -1, id_Continue | qc_M},
    {0, 0, 1, 13, -1, id_Continue | qc_M},
    {768, 768, 230, -1, -1, id_Continue | qc_N},
    {769, 769, 230, -1, -1, id_Continue | qc_N},
    {0, 0, 230, 60, -1, id_Continue | qc_M},
    {787, 787, 230, -1, -1, id_Continue | qc_N},
    {-568, -568, 230, -1, -1, id_Continue | qc_N},
    {0, 953, 240, 61, -1, id_Continue | qc_M},
    {0, 881, 0, -1, -1, id_Start},
    {0, 883, 0, -1, -1, id_Start},
    {697, 697, 0, -1, -1, id_Start | qc_N},
    {0, 887, 0, -1, -1, id_Start},
    {-570, -4492, 0, -1, -1, pr_compat},
    {59, 59, 0, -1, -1, qc_N},
    {0, 1011, 0, -1, -1, id_Start},
    {-572, -4494, 0, -1, -1, 0},
    {-574, 940, 0, -1, -1, id_Start},
    {183, 183, 0, -1, -1, id_Continue | qc_N},
    {-576, 941, 0, -1, -1, id_Start},
    {-578, 942, 0, -1, -1, id_Start},
    {-580, 943, 0, -1, -1, id_Start},
    {-582, 972, 0, -1, -1, id_Start},
    {-584, 973, 0, -1, -1, id_Start},
    {-586, 974, 0, -1, -1, id_Start},
    {-588, 0, 0, -1, -1, id_Start},
    {0, 945, 0, -1, 6138, id_Start},
    {0, 946, 0, -1, -1, id_Start},
    {0, 947, 0, -1, -1, id_Start},
    {0, 948, 0, -1, -1, id_Start},
    {0, 949, 0, -1, 6200, id_Start},
    {0, 950, 0, -1, -1, id_Start},
    {0, 951, 0, -1, 6262, id_Start},
    {0, 952, 0, -1, -1, id_Start},
    {0, 953, 0, -1, 6324, id_Start},
    {0, 954, 0, -1, -1, id_Start},
    {0, 955, 0, -1, -1, id_Start},
    {0, 956, 0, -1, -1, id_Start},
    {0, 957, 0, -1, -1, id_Start},
    {0, 958, 0, -1, -1, id_Start},
    {0, 959, 0, -1, 6386, id_Start},
    {0, 960, 0, -1, -1, id_Start},
    {0, 961, 0, -1, 23064, id_Start},
    {0, 964, 0, -1, -1, id_Start},
    {0, 965, 0, -1, 6448, id_Start},
    {0, 966, 0, -1, -1, id_Start},
    {0, 967, 0, -1, -1, id_Start},
    {0, 968, 0, -1, -1, id_Start},
    {0, 969, 0, -1, 6510, id_Start},
    {-590, 970, 0, -1, -1, id_Start},
    {-592, 971, 0, -1, -1, id_Start},
    {-594, 0, 0, -1, 22568, id_Start},
    {-596, 0, 0, -1, -1, id_Start},
    {-598, 0, 0, -1, 22754, id_Start},
    {-600, 0, 0, -1, -1, id_Start},
    {-602, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 6634, id_Start},
    {0, 0, 0, -1, 6696, id_Start},
    {0, 0, 0, -1, 6758, id_Start},
    {0, 0, 0, -1, 6820, id_Start},
    {0, 0, 0, -1, 7006, id_Start},
    {0, 0, 0, -1, 23002, id_Start},
    {0, 0, 0, -1, 6944, id_Start},
    {0, 0, 0, -1, 7068, id_Start},
    {-604, 0, 0, -1, 6572, id_Start},
    {-606, 0, 0, -1, 6882, id_Start},
    {-608, 0, 0, -1, -1, id_Start},
    {-610, 0, 0, -1, -1, id_Start},
    {-612, 0, 0, -1, 23188, id_Start},
    {0, 983, 0, -1, -1, id_Start},
    {933, 965, 0, -1, 7130, pr_compat | id_Start},
    {-614, 973, 0, -1, -1, id_Start},
    {-616, 971, 0, -1, -1, id_Start},
    {0, 985, 0, -1, -1, id_Start},
    {0, 987, 0, -1, -1, id_Start},
    {0, 989, 0, -1, -1, id_Start},
    {0, 991, 0, -1, -1, id_Start},
    {0, 993, 0, -1, -1, id_Start},
    {0, 995, 0, -1, -1, 0},
    {0, 997, 0, -1, -1, 0},
    {0, 999, 0, -1, -1, 0},
    {0, 1001, 0, -1, -1, 0},
    {0, 1003, 0, -1, -1, 0},
    {0, 1005, 0, -1, -1, 0},
    {0, 1007, 0, -1, -1, 0},
    {0, 1016, 0, -1, -1, id_Start},
    {0, 1019, 0, -1, -1, id_Start},
    {0, 891, 0, -1, -1, id_Start},
    {0, 892, 0, -1, -1, id_Start},
    {0, 893, 0, -1, -1, id_Start},
    {-618, 1104, 0, -1, -1, id_Start},
    {-620, 1105, 0, -1, -1, id_Start},
    {0, 1106, 0, -1, -1, id_Start},
    {-622, 1107, 0, -1, -1, id_Start},
    {0, 1108, 0, -1, -1, id_Start},
    {0, 1109, 0, -1, -1, id_Start},
    {0, 1110, 0, -1, 7316, id_Start},
    {-624, 1111, 0, -1, -1, id_Start},
    {0, 1112, 0, -1, -1, id_Start},
    {0, 1113, 0, -1, -1, id_Start},
    {0, 1114, 0, -1, -1, id_Start},
    {0, 1115, 0, -1, -1, id_Start},
    {-626, 1116, 0, -1, -1, id_Start},
    {-628, 1117, 0, -1, -1, id_Start},
    {-630, 1118, 0, -1, -1, id_Start},
    {0, 1119, 0, -1, -1, id_Start},
    {0, 1072, 0, -1, 8184, id_Start},
    {0, 1073, 0, -1, -1, id_Start},
    {0, 1075, 0, -1, 7254, id_Start},
    {0, 1077, 0, -1, 7192, id_Start},
    {0, 1078, 0, -1, 8060, id_Start},
    {0, 1079, 0, -1, 8432, id_Start},
    {0, 1080, 0, -1, 7440, id_Start},
    {-632, 1081, 0, -1, -1, id_Start},
    {0, 1082, 0, -1, 7378, id_Start},
    {0, 1083, 0, -1, -1, id_Start},
    {0, 1084, 0, -1, -1, id_Start},
    {0, 1085, 0, -1, -1, id_Start},
    {0, 1086, 0, -1, 8556, id_Start},
    {0, 1087, 0, -1, -1, id_Start},
    {0, 1088, 0, -1, -1, id_Start},
    {0, 1091, 0, -1, 7502, id_Start},
    {0, 1092, 0, -1, -1, id_Start},
    {0, 1093, 0, -1, -1, id_Start},
    {0, 1094, 0, -1, -1, id_Start},
    {0, 1095, 0, -1, 8928, id_Start},
    {0, 1096, 0, -1, -1, id_Start},
    {0, 1097, 0, -1, -1, id_Start},
    {0, 1099, 0, -1, 9052, id_Start},
    {0, 1100, 0, -1, -1, id_Start},
    {0, 1101, 0, -1, 8804, id_Start},
    {0, 1102, 0, -1, -1, id_Start},
    {0, 1103, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 8246, id_Start},
    {0, 0, 0, -1, 7688, id_Start},
    {0, 0, 0, -1, 7626, id_Start},
    {0, 0, 0, -1, 8122, id_Start},
    {0, 0, 0, -1, 8494, id_Start},
    {0, 0, 0, -1, 7564, id_Start},
    {-634, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 7812, id_Start},
    {0, 0, 0, -1, 8618, id_Start},
    {0, 0, 0, -1, 7874, id_Start},
    {0, 0, 0, -1, 8990, id_Start},
    {0, 0, 0, -1, 9114, id_Start},
    {0, 0, 0, -1, 8866, id_Start},
    {-636, 0, 0, -1, -1, id_Start},
    {-638, 0, 0, -1, -1, id_Start},
    {-640, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 7750, id_Start},
    {-642, 0, 0, -1, -1, id_Start},
    {-644, 0, 0, -1, -1, id_Start},
    {-646, 0, 0, -1, -1, id_Start},
    {-648, 0, 0, -1, -1, id_Start},
    {0, 1121, 0, -1, -1, id_Start},
    {0, 1125, 0, -1, -1, id_Start},
    {0, 1127, 0, -1, -1, id_Start},
    {0, 1129, 0, -1, -1, id_Start},
    {0, 1131, 0, -1, -1, id_Start},
    {0, 1133, 0, -1, -1, id_Start},
    {0, 1135, 0, -1, -1, id_Start},
    {0, 1137, 0, -1, -1, id_Start},
    {0, 1139, 0, -1, -1, id_Start},
    {0, 1141, 0, -1, 7936, id_Start},
    {0, 0, 0, -1, 7998, id_Start},
    {-650, 1143, 0, -1, -1, id_Start},
    {-652, 0, 0, -1, -1, id_Start},
    {0, 1145, 0, -1, -1, id_Start},
    {0, 1147, 0, -1, -1, id_Start},
    {0, 1149, 0, -1, -1, id_Start},
    {0, 1151, 0, -1, -1, id_Start},
    {0, 1153, 0, -1, -1, id_Start},
    {0, 1163, 0, -1, -1, id_Start},
    {0, 1165, 0, -1, -1, id_Start},
    {0, 1167, 0, -1, -1, id_Start},
    {0, 1169, 0, -1, -1, id_Start},
    {0, 1171, 0, -1, -1, id_Start},
    {0, 1173, 0, -1, -1, id_Start},
    {0, 1175, 0, -1, -1, id_Start},
    {0, 1177, 0, -1, -1, id_Start},
    {0, 1179, 0, -1, -1, id_Start},
    {0, 1181, 0, -1, -1, id_Start},
    {0, 1183, 0, -1, -1, id_Start},
    {0, 1185, 0, -1, -1, id_Start},
    {0, 1187, 0, -1, -1, id_Start},
    {0, 1189, 0, -1, -1, id_Start},
    {0, 1191, 0, -1, -1, id_Start},
    {0, 1193, 0, -1, -1, id_Start},
    {0, 1195, 0, -1, -1, id_Start},
    {0, 1197, 0, -1, -1, id_Start},
    {0, 1199, 0, -1, -1, id_Start},
    {0, 1201, 0, -1, -1, id_Start},
    {0, 1203, 0, -1, -1, id_Start},
    {0, 1205, 0, -1, -1, id_Start},
    {0, 1207, 0, -1, -1, id_Start},
    {0, 1209, 0, -1, -1, id_Start},
    {0, 1211, 0, -1, -1, id_Start},
    {0, 1213, 0, -1, -1, id_Start},
    {0, 1215, 0, -1, -1, id_Start},
    {0, 1231, 0, -1, -1, id_Start},
    {-654, 1218, 0, -1, -1, id_Start},
    {-656, 0, 0, -1, -1, id_Start},
    {0, 1220, 0, -1, -1, id_Start},
    {0, 1222, 0, -1, -1, id_Start},
    {0, 1224, 0, -1, -1, id_Start},
    {0, 1226, 0, -1, -1, id_Start},
    {0, 1228, 0, -1, -1, id_Start},
    {0, 1230, 0, -1, -1, id_Start},
    {-658, 1233, 0, -1, -1, id_Start},
    {-660, 0, 0, -1, -1, id_Start},
    {-662, 1235, 0, -1, -1, id_Start},
    {-664, 0, 0, -1, -1, id_Start},
    {0, 1237, 0, -1, -1, id_Start},
    {-666, 1239, 0, -1, -1, id_Start},
    {-668, 0, 0, -1, -1, id_Start},
    {0, 1241, 0, -1, 8308, id_Start},
    {0, 0, 0, -1, 8370, id_Start},
    {-670, 1243, 0, -1, -1, id_Start},
    {-672, 0, 0, -1, -1, id_Start},
    {-674, 1245, 0, -1, -1, id_Start},
    {-676, 0, 0, -1, -1, id_Start},
    {-678, 1247, 0, -1, -1, id_Start},
    {-680, 0, 0, -1, -1, id_Start},
    {0, 1249, 0, -1, -1, id_Start},
    {-682, 1251, 0, -1, -1, id_Start},
    {-684, 0, 0, -1, -1, id_Start},
    {-686, 1253, 0, -1, -1, id_Start},
    {-688, 0, 0, -1, -1, id_Start},
    {-690, 1255, 0, -1, -1, id_Start},
    {-692, 0, 0, -1, -1, id_Start},
    {0, 1257, 0, -1, 8680, id_Start},
    {0, 0, 0, -1, 8742, id_Start},
    {-694, 1259, 0, -1, -1, id_Start},
    {-696, 0, 0, -1, -1, id_Start},
    {-698, 1261, 0, -1, -1, id_Start},
    {-700, 0, 0, -1, -1, id_Start},
    {-702, 1263, 0, -1, -1, id_Start},
    {-704, 0, 0, -1, -1, id_Start},
    {-706, 1265, 0, -1, -1, id_Start},
    {-708, 0, 0, -1, -1, id_Start},
    {-710, 1267, 0, -1, -1, id_Start},
    {-712, 0, 0, -1, -1, id_Start},
    {-714, 1269, 0, -1, -1, id_Start},
    {-716, 0, 0, -1, -1, id_Start},
    {0, 1271, 0, -1, -1, id_Start},
    {-718, 1273, 0, -1, -1, id_Start},
    {-720, 0, 0, -1, -1, id_Start},
    {0, 1275, 0, -1, -1, id_Start},
    {0, 1277, 0, -1, -1, id_Start},
    {0, 1279, 0, -1, -1, id_Start},
    {0, 1281, 0, -1, -1, id_Start},
    {0, 1283, 0, -1, -1, id_Start},
    {0, 1285, 0, -1, -1, id_Start},
    {0, 1287, 0, -1, -1, id_Start},
    {0, 1289, 0, -1, -1, id_Start},
    {0, 1291, 0, -1, -1, id_Start},
    {0, 1293, 0, -1, -1, id_Start},
    {0, 1295, 0, -1, -1, id_Start},
    {0, 1297, 0, -1, -1, id_Start},
    {0, 1299, 0, -1, -1, id_Start},
    {0, 1301, 0, -1, -1, id_Start},
    {0, 1303, 0, -1, -1, id_Start},
    {0, 1305, 0, -1, -1, id_Start},
    {0, 1307, 0, -1, -1, id_Start},
    {0, 1309, 0, -1, -1, id_Start},
    {0, 1311, 0, -1, -1, id_Start},
    {0, 1313, 0, -1, -1, id_Start},
    {0, 1315, 0, -1, -1, id_Start},
    {0, 1317, 0, -1, -1, id_Start},
    {0, 1319, 0, -1, -1, id_Start},
    {0, 1321, 0, -1, -1, id_Start},
    {0, 1323, 0, -1, -1, id_Start},
    {0, 1325, 0, -1, -1, id_Start},
    {0, 1327, 0, -1, -1, id_Start},
    {0, 1377, 0, -1, -1, id_Start},
    {0, 1378, 0, -1, -1, id_Start},
    {0, 1379, 0, -1, -1, id_Start},
    {0, 1380, 0, -1, -1, id_Start},
    {0, 1381, 0, -1, -1, id_Start},
    {0, 1382, 0, -1, -1, id_Start},
    {0, 1383, 0, -1, -1, id_Start},
    {0, 1384, 0, -1, -1, id_Start},
    {0, 1385, 0, -1, -1, id_Start},
    {0, 1386, 0, -1, -1, id_Start},
    {0, 1387, 0, -1, -1, id_Start},
    {0, 1388, 0, -1, -1, id_Start},
    {0, 1389, 0, -1, -1, id_Start},
    {0, 1390, 0, -1, -1, id_Start},
    {0, 1391, 0, -1, -1, id_Start},
    {0, 1392, 0, -1, -1, id_Start},
    {0, 1393, 0, -1, -1, id_Start},
    {0, 1394, 0, -1, -1, id_Start},
    {0, 1395, 0, -1, -1, id_Start},
    {0, 1396, 0, -1, -1, id_Start},
    {0, 1397, 0, -1, -1, id_Start},
    {0, 1398, 0, -1, -1, id_Start},
    {0, 1399, 0, -1, -1, id_Start},
    {0, 1400, 0, -1, -1, id_Start},
    {0, 1401, 0, -1, -1, id_Start},
    {0, 1402, 0, -1, -1, id_Start},
    {0, 1403, 0, -1, -1, id_Start},
    {0, 1404, 0, -1, -1, id_Start},
    {0, 1405, 0, -1, -1, id_Start},
    {0, 1406, 0, -1, -1, id_Start},
    {0, 1407, 0, -1, -1, id_Start},
    {0, 1408, 0, -1, -1, id_Start},
    {0, 1409, 0, -1, -1, id_Start},
    {0, 1410, 0, -1, -1, id_Start},
    {0, 1411, 0, -1, -1, id_Start},
    {0, 1412, 0, -1, -1, id_Start},
    {0, 1413, 0, -1, -1, id_Start},
    {0, 1414, 0, -1, -1, id_Start},
    {-722, -722, 0, -1, -1, pr_compat | id_Start},
    {0, 0, 10, -1, -1, id_Continue},
    {0, 0, 11, -1, -1, id_Continue},
    {0, 0, 12, -1, -1, id_Continue},
    {0, 0, 13, -1, -1, id_Continue},
    {0, 0, 14, -1, -1, id_Continue},
    {0, 0, 15, -1, -1, id_Continue},
    {0, 0, 16, -1, -1, id_Continue},
    {0, 0, 17, -1, -1, id_Continue},
    {0, 0, 20, -1, -1, id_Continue},
    {0, 0, 21, -1, -1, id_Continue},
    {0, 0, 22, -1, -1, id_Continue},
    {0, 0, 23, -1, -1, id_Continue},
    {0, 0, 24, -1, -1, id_Continue},
    {0, 0, 25, -1, -1, id_Continue},
    {-724, 0, 0, -1, -1, id_Start},
    {-726, 0, 0, -1, -1, id_Start},
    {-728, 0, 0, -1, -1, id_Start},
    {-730, 0, 0, -1, -1, id_Start},
    {-732, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 9176, id_Start},
    {0, 0, 0, -1, 9238, id_Start},
    {0, 0, 0, -1, 9300, id_Start},
    {0, 0, 33, -1, -1, id_Continue},
    {0, 0, 34, -1, -1, id_Continue},
    {0, 0, 230, 18, -1, id_Continue | qc_M},
    {0, 0, 230, 19, -1, id_Continue | qc_M},
    {0, 0, 220, 20, -1, id_Continue | qc_M},
    {0, 0, 35, -1, -1, id_Continue},
    {-734, -734, 0, -1, -1, pr_compat | id_Start},
    {-736, -736, 0, -1, -1, pr_compat | id_Start},
    {-738, -738, 0, -1, -1, pr_compat | id_Start},
    {-740, -740, 0, -1, -1, pr_compat | id_Start},
    {-742, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 9424, id_Start},
    {-744, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 9486, id_Start},
    {-746, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 9362, id_Start},
    {0, 0, 36, -1, -1, id_Continue},
    {0, 0, 0, -1, 9548, id_Start},
    {-748, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 9610, id_Start},
    {-750, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 9672, id_Start},
    {-752, 0, 0, -1, -1, id_Start},
    {0, 0, 7, 21, -1, id_Continue | qc_M},
    {-754, -754, 0, -1, -1, id_Start | qc_N},
    {-756, -756, 0, -1, -1, id_Start | qc_N},
    {-758, -758, 0, -1, -1, id_Start | qc_N},
    {-760, -760, 0, -1, -1, id_Start | qc_N},
    {-762, -762, 0, -1, -1, id_Start | qc_N},
    {-764, -764, 0, -1, -1, id_Start | qc_N},
    {-766, -766, 0, -1, -1, id_Start | qc_N},
    {-768, -768, 0, -1, -1, id_Start | qc_N},
    {0, 0, 0, 22, -1, id_Continue | qc_M},
    {0, 0, 0, -1, 9734, id_Continue},
    {-770, 0, 0, -1, -1, id_Continue},
    {-772, 0, 0, -1, -1, id_Continue},
    {0, 0, 0, 23, -1, id_Continue | qc_M},
    {-774, -774, 0, -1, -1, id_Start | qc_N},
    {-776, -776, 0, -1, -1, id_Start | qc_N},
    {-778, -778, 0, -1, -1, id_Start | qc_N},
    {-780, -780, 0, -1, -1, id_Start | qc_N},
    {-782, -782, 0, -1, -1, id_Start | qc_N},
    {-784, -784, 0, -1, -1, id_Start | qc_N},
    {-786, -786, 0, -1, -1, id_Start | qc_N},
    {-788, -788, 0, -1, -1, id_Start | qc_N},
    {-790, -790, 0, -1, -1, id_Start | qc_N},
    {0, 0, 0, 25, -1, id_Continue | qc_M},
    {0, 0, 0, -1, 9982, id_Continue},
    {-792, 0, 0, -1, -1, id_Continue},
    {-794, 0, 0, -1, -1, id_Continue},
    {-796, 0, 0, -1, -1, id_Continue},
    {0, 0, 0, 24, -1, id_Continue | qc_M},
    {0, 0, 0, 26, -1, id_Continue | qc_M},
    {-798, -798, 0, -1, -1, id_Start | qc_N},
    {-800, -800, 0, -1, -1, id_Start | qc_N},
    {0, 0, 0, -1, 10044, id_Start},
    {-802, 0, 0, -1, -1, id_Start},
    {0, 0, 0, 28, -1, id_Continue | qc_M},
    {0, 0, 0, -1, 10106, id_Continue},
    {0, 0, 0, -1, 10168, id_Continue},
    {-804, 0, 0, -1, -1, id_Continue},
    {-806, 0, 0, -1, -1, id_Continue},
    {-808, 0, 0, -1, -1, id_Continue},
    {0, 0, 0, 27, -1, id_Continue | qc_M},
    {0, 0, 0, -1, 10354, id_Continue},
    {-810, 0, 0, -1, -1, id_Continue},
    {0, 0, 84, -1, -1, id_Continue},
    {0, 0, 91, 29, -1, id_Continue | qc_M},
    {0, 0, 0, -1, 10478, id_Continue},
    {-812, 0, 0, -1, -1, id_Continue},
    {0, 0, 0, 32, -1, id_Continue | qc_M},
    {0, 0, 0, -1, 10540, id_Continue},
    {-814, 0, 0, -1, -1, id_Continue},
    {-816, 0, 0, -1, -1, id_Continue},
    {-818, 0, 0, -1, 10602, id_Continue},
    {-820, 0, 0, -1, -1, id_Continue},
    {0, 0, 0, 30, -1, id_Continue | qc_M},
    {0, 0, 0, 31, -1, id_Continue | qc_M},
    {0, 0, 0, 33, -1, id_Continue | qc_M},
    {0, 0, 0, -1, 10664, id_Continue},
    {0, 0, 0, -1, 10726, id_Continue},
    {-822, 0, 0, -1, -1, id_Continue},
    {-824, 0, 0, -1, -1, id_Continue},
    {-826, 0, 0, -1, -1, id_Continue},
    {0, 0, 0, 34, -1, id_Continue | qc_M},
    {0, 0, 9, 35, -1, id_Continue | qc_M},
    {0, 0, 0, 36, -1, id_Continue | qc_M},
    {0, 0, 0, -1, 10788, id_Continue},
    {-828, 0, 0, -1, -1, id_Continue},
    {-830, 0, 0, -1, 10850, id_Continue},
    {-832, 0, 0, -1, -1, id_Continue},
    {-834, 0, 0, -1, -1, id_Continue},
    {0, 0, 0, 37, -1, id_Continue | qc_M},
    {-836, -836, 0, -1, -1, pr_compat | id_Continue},
    {-838, -838, 0, -1, -1, pr_compat | id_Continue},
    {-840, -840, 0, -1, -1, pr_compat | id_Start},
    {-842, -842, 0, -1, -1, pr_compat | id_Start},
    {3851, 3851, 0, -1, -1, pr_compat},
    {0, 0, 216, -1, -1, id_Continue},
    {-844, -844, 0, -1, -1, id_Start | qc_N},
    {-846, -846, 0, -1, -1, id_Start | qc_N},
    {-848, -848, 0, -1, -1, id_Start | qc_N},
    {-850, -850, 0, -1, -1, id_Start | qc_N},
    {-852, -852, 0, -1, -1, id_Start | qc_N},
    {-854, -854, 0, -1, -1, id_Start | qc_N},
    {0, 0, 129, -1, -1, id_Continue},
    {-856, -856, 0, -1, -1, id_Continue | qc_N},
    {0, 0, 132, -1, -1, id_Continue},
    {-858, -858, 0, -1, -1, id_Continue | qc_N},
    {-860, -860, 0, -1, -1, id_Continue | qc_N},
    {-862, -4497, 0, -1, -1, pr_compat | id_Continue},
    {-864, -864, 0, -1, -1, id_Continue | qc_N},
    {-866, -4500, 0, -1, -1, pr_compat | id_Continue},
    {-868, -868, 0, -1, -1, id_Continue | qc_N},
    {-870, -870, 0, -1, -1, id_Continue | qc_N},
    {-872, -872, 0, -1, -1, id_Continue | qc_N},
    {-874, -874, 0, -1, -1, id_Continue | qc_N},
    {-876, -876, 0, -1, -1, id_Continue | qc_N},
    {-878, -878, 0, -1, -1, id_Continue | qc_N},
    {-880, -880, 0, -1, -1, id_Continue | qc_N},
    {0, 0, 0, -1, 10912, id_Start},
    {-882, 0, 0, -1, -1, id_Start},
    {0, 0, 0, 38, -1, id_Continue | qc_M},
    {0, 11520, 0, -1, -1, id_Start},
    {0, 11521, 0, -1, -1, id_Start},
    {0, 11522, 0, -1, -1, id_Start},
    {0, 11523, 0, -1, -1, id_Start},
    {0, 11524, 0, -1, -1, id_Start},
    {0, 11525, 0, -1, -1, id_Start},
    {0, 11526, 0, -1, -1, id_Start},
    {0, 11527, 0, -1, -1, id_Start},
    {0, 11528, 0, -1, -1, id_Start},
    {0, 11529, 0, -1, -1, id_Start},
    {0, 11530, 0, -1, -1, id_Start},
    {0, 11531, 0, -1, -1, id_Start},
    {0, 11532, 0, -1, -1, id_Start},
    {0, 11533, 0, -1, -1, id_Start},
    {0, 11534, 0, -1, -1, id_Start},
    {0, 11535, 0, -1, -1, id_Start},
    {0, 11536, 0, -1, -1, id_Start},
    {0, 11537, 0, -1, -1, id_Start},
    {0, 11538, 0, -1, -1, id_Start},
    {0, 11539, 0, -1, -1, id_Start},
    {0, 11540, 0, -1, -1, id_Start},
    {0, 11541, 0, -1, -1, id_Start},
    {0, 11542, 0, -1, -1, id_Start},
    {0, 11543, 0, -1, -1, id_Start},
    {0, 11544, 0, -1, -1, id_Start},
    {0, 11545, 0, -1, -1, id_Start},
    {0, 11546, 0, -1, -1, id_Start},
    {0, 11547, 0, -1, -1, id_Start},
    {0, 11548, 0, -1, -1, id_Start},
    {0, 11549, 0, -1, -1, id_Start},
    {0, 11550, 0, -1, -1, id_Start},
    {0, 11551, 0, -1, -1, id_Start},
    {0, 11552, 0, -1, -1, id_Start},
    {0, 11553, 0, -1, -1, id_Start},
    {0, 11554, 0, -1, -1, id_Start},
    {0, 11555, 0, -1, -1, id_Start},
    {0, 11556, 0, -1, -1, id_Start},
    {0, 11557, 0, -1, -1, id_Start},
    {0, 11559, 0, -1, -1, id_Start},
    {0, 11565, 0, -1, -1, id_Start},
    {4316, 4316, 0, -1, -1, pr_compat | id_Start},
    {0, 5104, 0, -1, -1, id_Start},
    {0, 5105, 0, -1, -1, id_Start},
    {0, 5106, 0, -1, -1, id_Start},
    {0, 5107, 0, -1, -1, id_Start},
    {0, 5108, 0, -1, -1, id_Start},
    {0, 5109, 0, -1, -1, id_Start},
    {0, 0, 228, -1, -1, 0},
    {0, 0, 0, -1, 14508, id_Start},
    {-884, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 14570, id_Start},
    {-886, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 14632, id_Start},
    {-888, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 14694, id_Start},
    {-890, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 14756, id_Start},
    {-892, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 14818, id_Start},
    {-894, 0, 0, -1, -1, id_Start},
    {0, 0, 0, 49, -1, id_Continue | qc_M},
    {0, 0, 0, -1, 14880, id_Continue},
    {-896, 0, 0, -1, -1, id_Continue},
    {0, 0, 0, -1, 14942, id_Continue},
    {-898, 0, 0, -1, -1, id_Continue},
    {0, 0, 0, -1, 15004, id_Continue},
    {0, 0, 0, -1, 15066, id_Continue},
    {-900, 0, 0, -1, -1, id_Continue},
    {-902, 0, 0, -1, -1, id_Continue},
    {0, 0, 0, -1, 15128, id_Continue},
    {-904, 0, 0, -1, -1, id_Continue},
    {0, 1086, 0, -1, -1, id_Start},
    {0, 4304, 0, -1, -1, id_Start},
    {0, 4305, 0, -1, -1, id_Start},
    {0, 4306, 0, -1, -1, id_Start},
    {0, 4307, 0, -1, -1, id_Start},
    {0, 4308, 0, -1, -1, id_Start},
    {0, 4309, 0, -1, -1, id_Start},
    {0, 4310, 0, -1, -1, id_Start},
    {0, 4311, 0, -1, -1, id_Start},
    {0, 4312, 0, -1, -1, id_Start},
    {0, 4313, 0, -1, -1, id_Start},
    {0, 4314, 0, -1, -1, id_Start},
    {0, 4315, 0, -1, -1, id_Start},
    {0, 4316, 0, -1, -1, id_Start},
    {0, 4317, 0, -1, -1, id_Start},
    {0, 4318, 0, -1, -1, id_Start},
    {0, 4319, 0, -1, -1, id_Start},
    {0, 4320, 0, -1, -1, id_Start},
    {0, 4321, 0, -1, -1, id_Start},
    {0, 4322, 0, -1, -1, id_Start},
    {0, 4323, 0, -1, -1, id_Start},
    {0, 4324, 0, -1, -1, id_Start},
    {0, 4325, 0, -1, -1, id_Start},
    {0, 4326, 0, -1, -1, id_Start},
    {0, 4327, 0, -1, -1, id_Start},
    {0, 4328, 0, -1, -1, id_Start},
    {0, 4329, 0, -1, -1, id_Start},
    {0, 4330, 0, -1, -1, id_Start},
    {0, 4331, 0, -1, -1, id_Start},
    {0, 4332, 0, -1, -1, id_Start},
    {0, 4333, 0, -1, -1, id_Start},
    {0, 4334, 0, -1, -1, id_Start},
    {0, 4335, 0, -1, -1, id_Start},
    {0, 4336, 0, -1, -1, id_Start},
    {0, 4337, 0, -1, -1, id_Start},
    {0, 4338, 0, -1, -1, id_Start},
    {0, 4339, 0, -1, -1, id_Start},
    {0, 4340, 0, -1, -1, id_Start},
    {0, 4341, 0, -1, -1, id_Start},
    {0, 4342, 0, -1, -1, id_Start},
    {0, 4343, 0, -1, -1, id_Start},
    {0, 4344, 0, -1, -1, id_Start},
    {0, 4345, 0, -1, -1, id_Start},
    {0, 4346, 0, -1, -1, id_Start},
    {0, 4349, 0, -1, -1, id_Start},
    {0, 4350, 0, -1, -1, id_Start},
    {0, 4351, 0, -1, -1, id_Start},
    {198, 230, 0, -1, -1, pr_compat | id_Start},
    {398, 477, 0, -1, -1, pr_compat | id_Start},
    {546, 547, 0, -1, -1, pr_compat | id_Start},
    {592, 592, 0, -1, -1, pr_compat | id_Start},
    {593, 593, 0, -1, -1, pr_compat | id_Start},
    {7426, 7426, 0, -1, -1, pr_compat | id_Start},
    {603, 603, 0, -1, -1, pr_compat | id_Start},
    {331, 331, 0, -1, -1, pr_compat | id_Start},
    {596, 596, 0, -1, -1, pr_compat | id_Start},
    {7446, 7446, 0, -1, -1, pr_compat | id_Start},
    {7447, 7447, 0, -1, -1, pr_compat | id_Start},
    {7453, 7453, 0, -1, -1, pr_compat | id_Start},
    {623, 623, 0, -1, -1, pr_compat | id_Start},
    {7461, 7461, 0, -1, -1, pr_compat | id_Start},
    {1085, 1085, 0, -1, -1, pr_compat | id_Start},
    {594, 594, 0, -1, -1, pr_compat | id_Start},
    {597, 597, 0, -1, -1, pr_compat | id_Start},
    {240, 240, 0, -1, -1, pr_compat | id_Start},
    {607, 607, 0, -1, -1, pr_compat | id_Start},
    {609, 609, 0, -1, -1, pr_compat | id_Start},
    {613, 613, 0, -1, -1, pr_compat | id_Start},
    {616, 616, 0, -1, -1, pr_compat | id_Start},
    {617, 617, 0, -1, -1, pr_compat | id_Start},
    {618, 618, 0, -1, -1, pr_compat | id_Start},
    {7547, 7547, 0, -1, -1, pr_compat | id_Start},
    {669, 669, 0, -1, -1, pr_compat | id_Start},
    {621, 621, 0, -1, -1, pr_compat | id_Start},
    {7557, 7557, 0, -1, -1, pr_compat | id_Start},
    {671, 671, 0, -1, -1, pr_compat | id_Start},
    {625, 625, 0, -1, -1, pr_compat | id_Start},
    {624, 624, 0, -1, -1, pr_compat | id_Start},
    {626, 626, 0, -1, -1, pr_compat | id_Start},
    {627, 627, 0, -1, -1, pr_compat | id_Start},
    {628, 628, 0, -1, -1, pr_compat | id_Start},
    {629, 629, 0, -1, -1, pr_compat | id_Start},
    {632, 632, 0, -1, -1, pr_compat | id_Start},
    {642, 642, 0, -1, -1, pr_compat | id_Start},
    {643, 643, 0, -1, -1, pr_compat | id_Start},
    {427, 427, 0, -1, -1, pr_compat | id_Start},
    {649, 649, 0, -1, -1, pr_compat | id_Start},
    {650, 650, 0, -1, -1, pr_compat | id_Start},
    {7452, 7452, 0, -1, -1, pr_compat | id_Start},
    {651, 651, 0, -1, -1, pr_compat | id_Start},
    {652, 652, 0, -1, -1, pr_compat | id_Start},
    {656, 656, 0, -1, -1, pr_compat | id_Start},
    {657, 657, 0, -1, -1, pr_compat | id_Start},
    {658, 658, 0, -1, -1, pr_compat | id_Start},
    {0, 0, 214, -1, -1, id_Continue},
    {-906, 7681, 0, -1, -1, id_Start},
    {-908, 0, 0, -1, -1, id_Start},
    {-910, 7683, 0, -1, -1, id_Start},
    {-912, 0, 0, -1, -1, id_Start},
    {-914, 7685, 0, -1, -1, id_Start},
    {-916, 0, 0, -1, -1, id_Start},
    {-918, 7687, 0, -1, -1, id_Start},
    {-920, 0, 0, -1, -1, id_Start},
    {-922, 7689, 0, -1, -1, id_Start},
    {-924, 0, 0, -1, -1, id_Start},
    {-926, 7691, 0, -1, -1, id_Start},
    {-928, 0, 0, -1, -1, id_Start},
    {-930, 7693, 0, -1, -1, id_Start},
    {-932, 0, 0, -1, -1, id_Start},
    {-934, 7695, 0, -1, -1, id_Start},
    {-936, 0, 0, -1, -1, id_Start},
    {-938, 7697, 0, -1, -1, id_Start},
    {-940, 0, 0, -1, -1, id_Start},
    {-942, 7699, 0, -1, -1, id_Start},
    {-944, 0, 0, -1, -1, id_Start},
    {-946, 7701, 0, -1, -1, id_Start},
    {-948, 0, 0, -1, -1, id_Start},
    {-950, 7703, 0, -1, -1, id_Start},
    {-952, 0, 0, -1, -1, id_Start},
    {-954, 7705, 0, -1, -1, id_Start},
    {-956, 0, 0, -1, -1, id_Start},
    {-958, 7707, 0, -1, -1, id_Start},
    {-960, 0, 0, -1, -1, id_Start},
    {-962, 7709, 0, -1, -1, id_Start},
    {-964, 0, 0, -1, -1, id_Start},
    {-966, 7711, 0, -1, -1, id_Start},
    {-968, 0, 0, -1, -1, id_Start},
    {-970, 7713, 0, -1, -1, id_Start},
    {-972, 0, 0, -1, -1, id_Start},
    {-974, 7715, 0, -1, -1, id_Start},
    {-976, 0, 0, -1, -1, id_Start},
    {-978, 7717, 0, -1, -1, id_Start},
    {-980, 0, 0, -1, -1, id_Start},
    {-982, 7719, 0, -1, -1, id_Start},
    {-984, 0, 0, -1, -1, id_Start},
    {-986, 7721, 0, -1, -1, id_Start},
    {-988, 0, 0, -1, -1, id_Start},
    {-990, 7723, 0, -1, -1, id_Start},
    {-992, 0, 0, -1, -1, id_Start},
    {-994, 7725, 0, -1, -1, id_Start},
    {-996, 0, 0, -1, -1, id_Start},
    {-998, 7727, 0, -1, -1, id_Start},
    {-1000, 0, 0, -1, -1, id_Start},
    {-1002, 7729, 0, -1, -1, id_Start},
    {-1004, 0, 0, -1, -1, id_Start},
    {-1006, 7731, 0, -1, -1, id_Start},
    {-1008, 0, 0, -1, -1, id_Start},
    {-1010, 7733, 0, -1, -1, id_Start},
    {-1012, 0, 0, -1, -1, id_Start},
    {-1014, 7735, 0, -1, 15934, id_Start},
    {-1016, 0, 0, -1, 15996, id_Start},
    {-1018, 7737, 0, -1, -1, id_Start},
    {-1020, 0, 0, -1, -1, id_Start},
    {-1022, 7739, 0, -1, -1, id_Start},
    {-1024, 0, 0, -1, -1, id_Start},
    {-1026, 7741, 0, -1, -1, id_Start},
    {-1028, 0, 0, -1, -1, id_Start},
    {-1030, 7743, 0, -1, -1, id_Start},
    {-1032, 0, 0, -1, -1, id_Start},
    {-1034, 7745, 0, -1, -1, id_Start},
    {-1036, 0, 0, -1, -1, id_Start},
    {-1038, 7747, 0, -1, -1, id_Start},
    {-1040, 0, 0, -1, -1, id_Start},
    {-1042, 7749, 0, -1, -1, id_Start},
    {-1044, 0, 0, -1, -1, id_Start},
    {-1046, 7751, 0, -1, -1, id_Start},
    {-1048, 0, 0, -1, -1, id_Start},
    {-1050, 7753, 0, -1, -1, id_Start},
    {-1052, 0, 0, -1, -1, id_Start},
    {-1054, 7755, 0, -1, -1, id_Start},
    {-1056, 0, 0, -1, -1, id_Start},
    {-1058, 7757, 0, -1, -1, id_Start},
    {-1060, 0, 0, -1, -1, id_Start},
    {-1062, 7759, 0, -1, -1, id_Start},
    {-1064, 0, 0, -1, -1, id_Start},
    {-1066, 7761, 0, -1, -1, id_Start},
    {-1068, 0, 0, -1, -1, id_Start},
    {-1070, 7763, 0, -1, -1, id_Start},
    {-1072, 0, 0, -1, -1, id_Start},
    {-1074, 7765, 0, -1, -1, id_Start},
    {-1076, 0, 0, -1, -1, id_Start},
    {-1078, 7767, 0, -1, -1, id_Start},
    {-1080, 0, 0, -1, -1, id_Start},
    {-1082, 7769, 0, -1, -1, id_Start},
    {-1084, 0, 0, -1, -1, id_Start},
    {-1086, 7771, 0, -1, 16430, id_Start},
    {-1088, 0, 0, -1, 16492, id_Start},
    {-1090, 7773, 0, -1, -1, id_Start},
    {-1092, 0, 0, -1, -1, id_Start},
    {-1094, 7775, 0, -1, -1, id_Start},
    {-1096, 0, 0, -1, -1, id_Start},
    {-1098, 7777, 0, -1, -1, id_Start},
    {-1100, 0, 0, -1, -1, id_Start},
    {-1102, 7779, 0, -1, 16802, id_Start},
    {-1104, 0, 0, -1, 16864, id_Start},
    {-1106, 7781, 0, -1, -1, id_Start},
    {-1108, 0, 0, -1, -1, id_Start},
    {-1110, 7783, 0, -1, -1, id_Start},
    {-1112, 0, 0, -1, -1, id_Start},
    {-1114, 7785, 0, -1, -1, id_Start},
    {-1116, 0, 0, -1, -1, id_Start},
    {-1118, 7787, 0, -1, -1, id_Start},
    {-1120, 0, 0, -1, -1, id_Start},
    {-1122, 7789, 0, -1, -1, id_Start},
    {-1124, 0, 0, -1, -1, id_Start},
    {-1126, 7791, 0, -1, -1, id_Start},
    {-1128, 0, 0, -1, -1, id_Start},
    {-1130, 7793, 0, -1, -1, id_Start},
    {-1132, 0, 0, -1, -1, id_Start},
    {-1134, 7795, 0, -1, -1, id_Start},
    {-1136, 0, 0, -1, -1, id_Start},
    {-1138, 7797, 0, -1, -1, id_Start},
    {-1140, 0, 0, -1, -1, id_Start},
    {-1142, 7799, 0, -1, -1, id_Start},
    {-1144, 0, 0, -1, -1, id_Start},
    {-1146, 7801, 0, -1, -1, id_Start},
    {-1148, 0, 0, -1, -1, id_Start},
    {-1150, 7803, 0, -1, -1, id_Start},
    {-1152, 0, 0, -1, -1, id_Start},
    {-1154, 7805, 0, -1, -1, id_Start},
    {-1156, 0, 0, -1, -1, id_Start},
    {-1158, 7807, 0, -1, -1, id_Start},
    {-1160, 0, 0, -1, -1, id_Start},
    {-1162, 7809, 0, -1, -1, id_Start},
    {-1164, 0, 0, -1, -1, id_Start},
    {-1166, 7811, 0, -1, -1, id_Start},
    {-1168, 0, 0, -1, -1, id_Start},
    {-1170, 7813, 0, -1, -1, id_Start},
    {-1172, 0, 0, -1, -1, id_Start},
    {-1174, 7815, 0, -1, -1, id_Start},
    {-1176, 0, 0, -1, -1, id_Start},
    {-1178, 7817, 0, -1, -1, id_Start},
    {-1180, 0, 0, -1, -1, id_Start},
    {-1182, 7819, 0, -1, -1, id_Start},
    {-1184, 0, 0, -1, -1, id_Start},
    {-1186, 7821, 0, -1, -1, id_Start},
    {-1188, 0, 0, -1, -1, id_Start},
    {-1190, 7823, 0, -1, -1, id_Start},
    {-1192, 0, 0, -1, -1, id_Start},
    {-1194, 7825, 0, -1, -1, id_Start},
    {-1196, 0, 0, -1, -1, id_Start},
    {-1198, 7827, 0, -1, -1, id_Start},
    {-1200, 0, 0, -1, -1, id_Start},
    {-1202, 7829, 0, -1, -1, id_Start},
    {-1204, 0, 0, -1, -1, id_Start},
    {-1206, 0, 0, -1, -1, id_Start},
    {-1208, 0, 0, -1, -1, id_Start},
    {-1210, 0, 0, -1, -1, id_Start},
    {-1212, 0, 0, -1, -1, id_Start},
    {-1214, -1214, 0, -1, -1, pr_compat | id_Start},
    {-1216, 7777, 0, -1, -1, id_Start},
    {-1218, 7841, 0, -1, 17608, id_Start},
    {-1220, 0, 0, -1, 17670, id_Start},
    {-1222, 7843, 0, -1, -1, id_Start},
    {-1224, 0, 0, -1, -1, id_Start},
    {-1226, 7845, 0, -1, -1, id_Start},
    {-1228, 0, 0, -1, -1, id_Start},
    {-1230, 7847, 0, -1, -1, id_Start},
    {-1232, 0, 0, -1, -1, id_Start},
    {-1234, 7849, 0, -1, -1, id_Start},
    {-1236, 0, 0, -1, -1, id_Start},
    {-1238, 7851, 0, -1, -1, id_Start},
    {-1240, 0, 0, -1, -1, id_Start},
    {-1242, 7853, 0, -1, -1, id_Start},
    {-1244, 0, 0, -1, -1, id_Start},
    {-1246, 7855, 0, -1, -1, id_Start},
    {-1248, 0, 0, -1, -1, id_Start},
    {-1250, 7857, 0, -1, -1, id_Start},
    {-1252, 0, 0, -1, -1, id_Start},
    {-1254, 7859, 0, -1, -1, id_Start},
    {-1256, 0, 0, -1, -1, id_Start},
    {-1258, 7861, 0, -1, -1, id_Start},
    {-1260, 0, 0, -1, -1, id_Start},
    {-1262, 7863, 0, -1, -1, id_Start},
    {-1264, 0, 0, -1, -1, id_Start},
    {-1266, 7865, 0, -1, 17980, id_Start},
    {-1268, 0, 0, -1, 18042, id_Start},
    {-1270, 7867, 0, -1, -1, id_Start},
    {-1272, 0, 0, -1, -1, id_Start},
    {-1274, 7869, 0, -1, -1, id_Start},
    {-1276, 0, 0, -1, -1, id_Start},
    {-1278, 7871, 0, -1, -1, id_Start},
    {-1280, 0, 0, -1, -1, id_Start},
    {-1282, 7873, 0, -1, -1, id_Start},
    {-1284, 0, 0, -1, -1, id_Start},
    {-1286, 7875, 0, -1, -1, id_Start},
    {-1288, 0, 0, -1, -1, id_Start},
    {-1290, 7877, 0, -1, -1, id_Start},
    {-1292, 0, 0, -1, -1, id_Start},
    {-1294, 7879, 0, -1, -1, id_Start},
    {-1296, 0, 0, -1, -1, id_Start},
    {-1298, 7881, 0, -1, -1, id_Start},
    {-1300, 0, 0, -1, -1, id_Start},
    {-1302, 7883, 0, -1, -1, id_Start},
    {-1304, 0, 0, -1, -1, id_Start},
    {-1306, 7885, 0, -1, 18228, id_Start},
    {-1308, 0, 0, -1, 18290, id_Start},
    {-1310, 7887, 0, -1, -1, id_Start},
    {-1312, 0, 0, -1, -1, id_Start},
    {-1314, 7889, 0, -1, -1, id_Start},
    {-1316, 0, 0, -1, -1, id_Start},
    {-1318, 7891, 0, -1, -1, id_Start},
    {-1320, 0, 0, -1, -1, id_Start},
    {-1322, 7893, 0, -1, -1, id_Start},
    {-1324, 0, 0, -1, -1, id_Start},
    {-1326, 7895, 0, -1, -1, id_Start},
    {-1328, 0, 0, -1, -1, id_Start},
    {-1330, 7897, 0, -1, -1, id_Start},
    {-1332, 0, 0, -1, -1, id_Start},
    {-1334, 7899, 0, -1, -1, id_Start},
    {-1336, 0, 0, -1, -1, id_Start},
    {-1338, 7901, 0, -1, -1, id_Start},
    {-1340, 0, 0, -1, -1, id_Start},
    {-1342, 7903, 0, -1, -1, id_Start},
    {-1344, 0, 0, -1, -1, id_Start},
    {-1346, 7905, 0, -1, -1, id_Start},
    {-1348, 0, 0, -1, -1, id_Start},
    {-1350, 7907, 0, -1, -1, id_Start},
    {-1352, 0, 0, -1, -1, id_Start},
    {-1354, 7909, 0, -1, -1, id_Start},
    {-1356, 0, 0, -1, -1, id_Start},
    {-1358, 7911, 0, -1, -1, id_Start},
    {-1360, 0, 0, -1, -1, id_Start},
    {-1362, 7913, 0, -1, -1, id_Start},
    {-1364, 0, 0, -1, -1, id_Start},
    {-1366, 7915, 0, -1, -1, id_Start},
    {-1368, 0, 0, -1, -1, id_Start},
    {-1370, 7917, 0, -1, -1, id_Start},
    {-1372, 0, 0, -1, -1, id_Start},
    {-1374, 7919, 0, -1, -1, id_Start},
    {-1376, 0, 0, -1, -1, id_Start},
    {-1378, 7921, 0, -1, -1, id_Start},
    {-1380, 0, 0, -1, -1, id_Start},
    {-1382, 7923, 0, -1, -1, id_Start},
    {-1384, 0, 0, -1, -1, id_Start},
    {-1386, 7925, 0, -1, -1, id_Start},
    {-1388, 0, 0, -1, -1, id_Start},
    {-1390, 7927, 0, -1, -1, id_Start},
    {-1392, 0, 0, -1, -1, id_Start},
    {-1394, 7929, 0, -1, -1, id_Start},
    {-1396, 0, 0, -1, -1, id_Start},
    {0, 7931, 0, -1, -1, id_Start},
    {0, 7933, 0, -1, -1, id_Start},
    {0, 7935, 0, -1, -1, id_Start},
    {-1398, 0, 0, -1, 18600, id_Start},
    {-1400, 0, 0, -1, 18662, id_Start},
    {-1402, 0, 0, -1, 20274, id_Start},
    {-1404, 0, 0, -1, 20336, id_Start},
    {-1406, 0, 0, -1, 20398, id_Start},
    {-1408, 0, 0, -1, 20460, id_Start},
    {-1410, 0, 0, -1, 20522, id_Start},
    {-1412, 0, 0, -1, 20584, id_Start},
    {-1414, 7936, 0, -1, 18724, id_Start},
    {-1416, 7937, 0, -1, 18786, id_Start},
    {-1418, 7938, 0, -1, 20646, id_Start},
    {-1420, 7939, 0, -1, 20708, id_Start},
    {-1422, 7940, 0, -1, 20770, id_Start},
    {-1424, 7941, 0, -1, 20832, id_Start},
    {-1426, 7942, 0, -1, 20894, id_Start},
    {-1428, 7943, 0, -1, 20956, id_Start},
    {-1430, 0, 0, -1, 18848, id_Start},
    {-1432, 0, 0, -1, 18910, id_Start},
    {-1434, 0, 0, -1, -1, id_Start},
    {-1436, 0, 0, -1, -1, id_Start},
    {-1438, 0, 0, -1, -1, id_Start},
    {-1440, 0, 0, -1, -1, id_Start},
    {-1442, 7952, 0, -1, 18972, id_Start},
    {-1444, 7953, 0, -1, 19034, id_Start},
    {-1446, 7954, 0, -1, -1, id_Start},
    {-1448, 7955, 0, -1, -1, id_Start},
    {-1450, 7956, 0, -1, -1, id_Start},
    {-1452, 7957, 0, -1, -1, id_Start},
    {-1454, 0, 0, -1, 19096, id_Start},
    {-1456, 0, 0, -1, 19158, id_Start},
    {-1458, 0, 0, -1, 21018, id_Start},
    {-1460, 0, 0, -1, 21080, id_Start},
    {-1462, 0, 0, -1, 21142, id_Start},
    {-1464, 0, 0, -1, 21204, id_Start},
    {-1466, 0, 0, -1, 21266, id_Start},
    {-1468, 0, 0, -1, 21328, id_Start},
    {-1470, 7968, 0, -1, 19220, id_Start},
    {-1472, 7969, 0, -1, 19282, id_Start},
    {-1474, 7970, 0, -1, 21390, id_Start},
    {-1476, 7971, 0, -1, 21452, id_Start},
    {-1478, 7972, 0, -1, 21514, id_Start},
    {-1480, 7973, 0, -1, 21576, id_Start},
    {-1482, 7974, 0, -1, 21638, id_Start},
    {-1484, 7975, 0, -1, 21700, id_Start},
    {-1486, 0, 0, -1, 19344, id_Start},
    {-1488, 0, 0, -1, 19406, id_Start},
    {-1490, 0, 0, -1, -1, id_Start},
    {-1492, 0, 0, -1, -1, id_Start},
    {-1494, 0, 0, -1, -1, id_Start},
    {-1496, 0, 0, -1, -1, id_Start},
    {-1498, 0, 0, -1, -1, id_Start},
    {-1500, 0, 0, -1, -1, id_Start},
    {-1502, 7984, 0, -1, 19468, id_Start},
    {-1504, 7985, 0, -1, 19530, id_Start},
    {-1506, 7986, 0, -1, -1, id_Start},
    {-1508, 7987, 0, -1, -1, id_Start},
    {-1510, 7988, 0, -1, -1, id_Start},
    {-1512, 7989, 0, -1, -1, id_Start},
    {-1514, 7990, 0, -1, -1, id_Start},
    {-1516, 7991, 0, -1, -1, id_Start},
    {-1518, 0, 0, -1, 19592, id_Start},
    {-1520, 0, 0, -1, 19654, id_Start},
    {-1522, 0, 0, -1, -1, id_Start},
    {-1524, 0, 0, -1, -1, id_Start},
    {-1526, 0, 0, -1, -1, id_Start},
    {-1528, 0, 0, -1, -1, id_Start},
    {-1530, 8000, 0, -1, 19716, id_Start},
    {-1532, 8001, 0, -1, 19778, id_Start},
    {-1534, 8002, 0, -1, -1, id_Start},
    {-1536, 8003, 0, -1, -1, id_Start},
    {-1538, 8004, 0, -1, -1, id_Start},
    {-1540, 8005, 0, -1, -1, id_Start},
    {-1542, 0, 0, -1, 19840, id_Start},
    {-1544, 0, 0, -1, 19902, id_Start},
    {-1546, 0, 0, -1, -1, id_Start},
    {-1548, 0, 0, -1, -1, id_Start},
    {-1550, 0, 0, -1, -1, id_Start},
    {-1552, 0, 0, -1, -1, id_Start},
    {-1554, 0, 0, -1, -1, id_Start},
    {-1556, 0, 0, -1, -1, id_Start},
    {-1558, 8017, 0, -1, 19964, id_Start},
    {-1560, 8019, 0, -1, -1, id_Start},
    {-1562, 8021, 0, -1, -1, id_Start},
    {-1564, 8023, 0, -1, -1, id_Start},
    {-1566, 0, 0, -1, 20026, id_Start},
    {-1568, 0, 0, -1, 20088, id_Start},
    {-1570, 0, 0, -1, 21762, id_Start},
    {-1572, 0, 0, -1, 21824, id_Start},
    {-1574, 0, 0, -1, 21886, id_Start},
    {-1576, 0, 0, -1, 21948, id_Start},
    {-1578, 0, 0, -1, 22010, id_Start},
    {-1580, 0, 0, -1, 22072, id_Start},
    {-1582, 8032, 0, -1, 20150, id_Start},
    {-1584, 8033, 0, -1, 20212, id_Start},
    {-1586, 8034, 0, -1, 22134, id_Start},
    {-1588, 8035, 0, -1, 22196, id_Start},
    {-1590, 8036, 0, -1, 22258, id_Start},
    {-1592, 8037, 0, -1, 22320, id_Start},
    {-1594, 8038, 0, -1, 22382, id_Start},
    {-1596, 8039, 0, -1, 22444, id_Start},
    {-1598, 0, 0, -1, 22506, id_Start},
    {940, 940, 0, -1, -1, id_Start | qc_N},
    {-1600, 0, 0, -1, -1, id_Start},
    {941, 941, 0, -1, -1, id_Start | qc_N},
    {-1602, 0, 0, -1, 22692, id_Start},
    {942, 942, 0, -1, -1, id_Start | qc_N},
    {-1604, 0, 0, -1, -1, id_Start},
    {943, 943, 0, -1, -1, id_Start | qc_N},
    {-1606, 0, 0, -1, -1, id_Start},
    {972, 972, 0, -1, -1, id_Start | qc_N},
    {-1608, 0, 0, -1, -1, id_Start},
    {973, 973, 0, -1, -1, id_Start | qc_N},
    {-1610, 0, 0, -1, 23126, id_Start},
    {974, 974, 0, -1, -1, id_Start | qc_N},
    {-1612, -4503, 0, -1, -1, id_Start},
    {-1614, -4505, 0, -1, -1, id_Start},
    {-1616, -4507, 0, -1, -1, id_Start},
    {-1618, -4509, 0, -1, -1, id_Start},
    {-1620, -4511, 0, -1, -1, id_Start},
    {-1622, -4513, 0, -1, -1, id_Start},
    {-1624, -4515, 0, -1, -1, id_Start},
    {-1626, -4517, 0, -1, -1, id_Start},
    {-1628, -4503, 0, -1, -1, id_Start},
    {-1630, -4505, 0, -1, -1, id_Start},
    {-1632, -4507, 0, -1, -1, id_Start},
    {-1634, -4509, 0, -1, -1, id_Start},
    {-1636, -4511, 0, -1, -1, id_Start},
    {-1638, -4513, 0, -1, -1, id_Start},
    {-1640, -4515, 0, -1, -1, id_Start},
    {-1642, -4517, 0, -1, -1, id_Start},
    {-1644, -4519, 0, -1, -1, id_Start},
    {-1646, -4521, 0, -1, -1, id_Start},
    {-1648, -4523, 0, -1, -1, id_Start},
    {-1650, -4525, 0, -1, -1, id_Start},
    {-1652, -4527, 0, -1, -1, id_Start},
    {-1654, -4529, 0, -1, -1, id_Start},
    {-1656, -4531, 0, -1, -1, id_Start},
    {-1658, -4533, 0, -1, -1, id_Start},
    {-1660, -4519, 0, -1, -1, id_Start},
    {-1662, -4521, 0, -1, -1, id_Start},
    {-1664, -4523, 0, -1, -1, id_Start},
    {-1666, -4525, 0, -1, -1, id_Start},
    {-1668, -4527, 0, -1, -1, id_Start},
    {-1670, -4529, 0, -1, -1, id_Start},
    {-1672, -4531, 0, -1, -1, id_Start},
    {-1674, -4533, 0, -1, -1, id_Start},
    {-1676, -4535, 0, -1, -1, id_Start},
    {-1678, -4537, 0, -1, -1, id_Start},
    {-1680, -4539, 0, -1, -1, id_Start},
    {-1682, -4541, 0, -1, -1, id_Start},
    {-1684, -4543, 0, -1, -1, id_Start},
    {-1686, -4545, 0, -1, -1, id_Start},
    {-1688, -4547, 0, -1, -1, id_Start},
    {-1690, -4549, 0, -1, -1, id_Start},
    {-1692, -4535, 0, -1, -1, id_Start},
    {-1694, -4537, 0, -1, -1, id_Start},
    {-1696, -4539, 0, -1, -1, id_Start},
    {-1698, -4541, 0, -1, -1, id_Start},
    {-1700, -4543, 0, -1, -1, id_Start},
    {-1702, -4545, 0, -1, -1, id_Start},
    {-1704, -4547, 0, -1, -1, id_Start},
    {-1706, -4549, 0, -1, -1, id_Start},
    {-1708, 0, 0, -1, -1, id_Start},
    {-1710, 0, 0, -1, -1, id_Start},
    {-1712, -4551, 0, -1, -1, id_Start},
    {-1714, -4553, 0, -1, -1, id_Start},
    {-1716, -4555, 0, -1, -1, id_Start},
    {-1718, 0, 0, -1, 22630, id_Start},
    {-1720, -4557, 0, -1, -1, id_Start},
    {-1722, 8112, 0, -1, -1, id_Start},
    {-1724, 8113, 0, -1, -1, id_Start},
    {-1726, 8048, 0, -1, -1, id_Start},
    {902, 940, 0, -1, -1, id_Start | qc_N},
    {-1728, -4553, 0, -1, -1, id_Start},
    {-1730, -1730, 0, -1, -1, pr_compat},
    {953, 953, 0, -1, -1, id_Start | qc_N},
    {-1730, -1730, 0, -1, 22878, pr_compat},
    {-1732, -1732, 0, -1, -1, pr_compat},
    {-1734, -4559, 0, -1, -1, 0},
    {-1736, -4562, 0, -1, -1, id_Start},
    {-1738, -4564, 0, -1, -1, id_Start},
    {-1740, -4566, 0, -1, -1, id_Start},
    {-1742, 0, 0, -1, 22816, id_Start},
    {-1744, -4568, 0, -1, -1, id_Start},
    {-1746, 8050, 0, -1, -1, id_Start},
    {904, 941, 0, -1, -1, id_Start | qc_N},
    {-1748, 8052, 0, -1, -1, id_Start},
    {905, 942, 0, -1, -1, id_Start | qc_N},
    {-1750, -4564, 0, -1, -1, id_Start},
    {-1752, -4570, 0, -1, -1, 0},
    {-1754, -4573, 0, -1, -1, 0},
    {-1756, -4576, 0, -1, -1, 0},
    {-1758, 0, 0, -1, -1, id_Start},
    {-1760, 0, 0, -1, -1, id_Start},
    {-1762, 0, 0, -1, -1, id_Start},
    {912, 912, 0, -1, -1, id_Start | qc_N},
    {-1764, 0, 0, -1, -1, id_Start},
    {-1766, 0, 0, -1, -1, id_Start},
    {-1768, 8144, 0, -1, -1, id_Start},
    {-1770, 8145, 0, -1, -1, id_Start},
    {-1772, 8054, 0, -1, -1, id_Start},
    {906, 943, 0, -1, -1, id_Start | qc_N},
    {-1774, -4579, 0, -1, -1, 0},
    {-1776, -4582, 0, -1, -1, 0},
    {-1778, -4585, 0, -1, -1, 0},
    {-1780, 0, 0, -1, -1, id_Start},
    {-1782, 0, 0, -1, -1, id_Start},
    {-1784, 0, 0, -1, -1, id_Start},
    {944, 944, 0, -1, -1, id_Start | qc_N},
    {-1786, 0, 0, -1, -1, id_Start},
    {-1788, 0, 0, -1, -1, id_Start},
    {-1790, 0, 0, -1, -1, id_Start},
    {-1792, 0, 0, -1, -1, id_Start},
    {-1794, 8160, 0, -1, -1, id_Start},
    {-1796, 8161, 0, -1, -1, id_Start},
    {-1798, 8058, 0, -1, -1, id_Start},
    {910, 973, 0, -1, -1, id_Start | qc_N},
    {-1800, 8165, 0, -1, -1, id_Start},
    {-1802, -4588, 0, -1, -1, 0},
    {901, -4494, 0, -1, -1, qc_N},
    {96, 96, 0, -1, -1, qc_N},
    {-1804, -4591, 0, -1, -1, id_Start},
    {-1806, -4593, 0, -1, -1, id_Start},
    {-1808, -4595, 0, -1, -1, id_Start},
    {-1810, 0, 0, -1, 23250, id_Start},
    {-1812, -4597, 0, -1, -1, id_Start},
    {-1814, 8056, 0, -1, -1, id_Start},
    {908, 972, 0, -1, -1, id_Start | qc_N},
    {-1816, 8060, 0, -1, -1, id_Start},
    {911, 974, 0, -1, -1, id_Start | qc_N},
    {-1818, -4593, 0, -1, -1, id_Start},
    {180, -5, 0, -1, -1, qc_N},
    {-1820, -1820, 0, -1, 22940, pr_compat},
    {8194, 32, 0, -1, -1, qc_N},
    {8195, 32, 0, -1, -1, qc_N},
    {8208, 8208, 0, -1, -1, pr_compat},
    {-1822, -1822, 0, -1, -1, pr_compat},
    {-1824, -1824, 0, -1, -1, pr_compat},
    {-1826, -1826, 0, -1, -1, pr_compat},
    {-1829, -1829, 0, -1, -1, pr_compat},
    {-1831, -1831, 0, -1, -1, pr_compat},
    {-1834, -1834, 0, -1, -1, pr_compat},
    {-1836, -1836, 0, -1, -1, pr_compat},
    {-1839, -1839, 0, -1, -1, pr_compat},
    {-1841, -1841, 0, -1, -1, pr_compat},
    {-1843, -1843, 0, -1, -1, pr_compat},
    {-1845, -1845, 0, -1, -1, pr_compat},
    {-1847, -1847, 0, -1, -1, pr_compat},
    {-1849, -1849, 0, -1, -1, pr_compat},
    {-1853, -4599, 0, -1, -1, pr_compat},
    {-1855, -1855, 0, -1, -1, pr_compat},
    {-1858, -1858, 0, -1, -1, pr_compat},
    {-1861, -4601, 0, -1, -1, pr_compat},
    {-1863, -1863, 0, -1, -1, pr_compat},
    {-1866, -1866, 0, -1, -1, pr_compat},
    {400, 603, 0, -1, -1, pr_compat | id_Start},
    {-1869, -4603, 0, -1, -1, pr_compat},
    {295, 295, 0, -1, -1, pr_compat | id_Start},
    {-1871, -4605, 0, -1, -1, pr_compat},
    {-1873, -4607, 0, -1, -1, pr_compat},
    {-1875, -4609, 0, -1, -1, pr_compat},
    {-1878, -4612, 0, -1, -1, pr_compat},
    {937, 969, 0, -1, -1, id_Start | qc_N},
    {75, 107, 0, -1, -1, id_Start | qc_N},
    {197, 229, 0, -1, -1, id_Start | qc_N},
    {0, 8526, 0, -1, -1, id_Start},
    {1489, 1489, 0, -1, -1, pr_compat | id_Start},
    {1490, 1490, 0, -1, -1, pr_compat | id_Start},
    {-1880, -4614, 0, -1, -1, pr_compat},
    {8721, 8721, 0, -1, -1, pr_compat},
    {-1883, -1883, 0, -1, -1, pr_compat},
    {-1886, -1886, 0, -1, -1, pr_compat},
    {-1889, -1889, 0, -1, -1, pr_compat},
    {-1893, -1893, 0, -1, -1, pr_compat},
    {-1896, -1896, 0, -1, -1, pr_compat},
    {-1899, -1899, 0, -1, -1, pr_compat},
    {-1902, -1902, 0, -1, -1, pr_compat},
    {-1905, -1905, 0, -1, -1, pr_compat},
    {-1908, -1908, 0, -1, -1, pr_compat},
    {-1911, -1911, 0, -1, -1, pr_compat},
    {-1914, -1914, 0, -1, -1, pr_compat},
    {-1917, -1917, 0, -1, -1, pr_compat},
    {-1920, -1920, 0, -1, -1, pr_compat},
    {-1923, -1923, 0, -1, -1, pr_compat},
    {-1926, -1926, 0, -1, -1, pr_compat},
    {-1929, -1929, 0, -1, -1, pr_compat},
    {-1931, -1954, 0, -1, -1, pr_compat | id_Start},
    {-1933, -1956, 0, -1, -1, pr_compat | id_Start},
    {-1936, -1959, 0, -1, -1, pr_compat | id_Start},
    {-1938, -1961, 0, -1, -1, pr_compat | id_Start},
    {-1940, -1963, 0, -1, -1, pr_compat | id_Start},
    {-1943, -1966, 0, -1, -1, pr_compat | id_Start},
    {-1947, -1970, 0, -1, -1, pr_compat | id_Start},
    {-1949, -1972, 0, -1, -1, pr_compat | id_Start},
    {-1951, -1974, 0, -1, -1, pr_compat | id_Start},
    {-1954, -1954, 0, -1, -1, pr_compat | id_Start},
    {-1956, -1956, 0, -1, -1, pr_compat | id_Start},
    {-1959, -1959, 0, -1, -1, pr_compat | id_Start},
    {-1961, -1961, 0, -1, -1, pr_compat | id_Start},
    {-1963, -1963, 0, -1, -1, pr_compat | id_Start},
    {-1966, -1966, 0, -1, -1, pr_compat | id_Start},
    {-1970, -1970, 0, -1, -1, pr_compat | id_Start},
    {-1972, -1972, 0, -1, -1, pr_compat | id_Start},
    {-1974, -1974, 0, -1, -1, pr_compat | id_Start},
    {0, 8580, 0, -1, -1, id_Start},
    {-1977, -1977, 0, -1, -1, pr_compat},
    {0, 0, 0, -1, 2356, 0},
    {0, 0, 0, -1, 2418, 0},
    {0, 0, 0, -1, 2480, 0},
    {-1980, 0, 0, -1, -1, 0},
    {-1982, 0, 0, -1, -1, 0},
    {-1984, 0, 0, -1, -1, 0},
    {-1986, 0, 0, -1, -1, 0},
    {-1988, 0, 0, -1, -1, 0},
    {-1990, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 9796, 0},
    {0, 0, 0, -1, 9920, 0},
    {0, 0, 0, -1, 9858, 0},
    {0, 0, 0, -1, 10230, 0},
    {-1992, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 10292, 0},
    {-1994, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 10416, 0},
    {-1996, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 3534, 0},
    {-1998, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 3596, 0},
    {-2000, 0, 0, -1, -1, 0},
    {-2002, -2002, 0, -1, -1, pr_compat},
    {-2004, -2004, 0, -1, -1, pr_compat},
    {-2007, -2007, 0, -1, -1, pr_compat},
    {-2009, -2009, 0, -1, -1, pr_compat},
    {0, 0, 0, -1, 4030, 0},
    {-2012, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 4092, 0},
    {-2014, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 4154, 0},
    {-2016, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 4216, 0},
    {-2018, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 4402, 0},
    {-2020, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 4340, 0},
    {-2022, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 4588, 0},
    {0, 0, 0, -1, 4650, 0},
    {-2024, 0, 0, -1, -1, 0},
    {-2026, 0, 0, -1, -1, 0},
    {-2028, 0, 0, -1, -1, 0},
    {-2030, 0, 0, -1, -1, 0},
    {-2032, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 4712, 0},
    {0, 0, 0, -1, 4774, 0},
    {-2034, 0, 0, -1, -1, 0},
    {-2036, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 4836, 0},
    {0, 0, 0, -1, 4898, 0},
    {-2038, 0, 0, -1, -1, 0},
    {-2040, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 4960, 0},
    {0, 0, 0, -1, 5022, 0},
    {0, 0, 0, -1, 5580, 0},
    {0, 0, 0, -1, 5642, 0},
    {-2042, 0, 0, -1, -1, 0},
    {-2044, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 5084, 0},
    {0, 0, 0, -1, 5146, 0},
    {-2046, 0, 0, -1, -1, 0},
    {-2048, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 5208, 0},
    {0, 0, 0, -1, 5270, 0},
    {-2050, 0, 0, -1, -1, 0},
    {-2052, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 5704, 0},
    {0, 0, 0, -1, 5766, 0},
    {0, 0, 0, -1, 5332, 0},
    {0, 0, 0, -1, 5394, 0},
    {0, 0, 0, -1, 5456, 0},
    {0, 0, 0, -1, 5518, 0},
    {-2054, 0, 0, -1, -1, 0},
    {-2056, 0, 0, -1, -1, 0},
    {-2058, 0, 0, -1, -1, 0},
    {-2060, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 5828, 0},
    {0, 0, 0, -1, 5890, 0},
    {0, 0, 0, -1, 5952, 0},
    {0, 0, 0, -1, 6014, 0},
    {-2062, 0, 0, -1, -1, 0},
    {-2064, 0, 0, -1, -1, 0},
    {-2066, 0, 0, -1, -1, 0},
    {-2068, 0, 0, -1, -1, 0},
    {-2070, 0, 0, -1, -1, 0},
    {-2072, 0, 0, -1, -1, 0},
    {-2074, 0, 0, -1, -1, 0},
    {-2076, 0, 0, -1, -1, 0},
    {12296, 12296, 0, -1, -1, qc_N},
    {12297, 12297, 0, -1, -1, qc_N},
    {-2078, -2078, 0, -1, -1, pr_compat},
    {-2080, -2080, 0, -1, -1, pr_compat},
    {-2082, -2082, 0, -1, -1, pr_compat},
    {-2084, -2084, 0, -1, -1, pr_compat},
    {-2086, -2086, 0, -1, -1, pr_compat},
    {-2088, -2088, 0, -1, -1, pr_compat},
    {-2090, -2090, 0, -1, -1, pr_compat},
    {-2092, -2092, 0, -1, -1, pr_compat},
    {-2094, -2094, 0, -1, -1, pr_compat},
    {-2096, -2096, 0, -1, -1, pr_compat},
    {-2098, -2098, 0, -1, -1, pr_compat},
    {-2100, -2100, 0, -1, -1, pr_compat},
    {-2103, -2103, 0, -1, -1, pr_compat},
    {-2106, -2106, 0, -1, -1, pr_compat},
    {-2109, -2109, 0, -1, -1, pr_compat},
    {-2112, -2112, 0, -1, -1, pr_compat},
    {-2115, -2115, 0, -1, -1, pr_compat},
    {-2118, -2118, 0, -1, -1, pr_compat},
    {-2121, -2121, 0, -1, -1, pr_compat},
    {-2124, -2124, 0, -1, -1, pr_compat},
    {-2127, -2127, 0, -1, -1, pr_compat},
    {-2131, -2131, 0, -1, -1, pr_compat},
    {-2135, -2135, 0, -1, -1, pr_compat},
    {-2139, -2139, 0, -1, -1, pr_compat},
    {-2143, -2143, 0, -1, -1, pr_compat},
    {-2147, -2147, 0, -1, -1, pr_compat},
    {-2151, -2151, 0, -1, -1, pr_compat},
    {-2155, -2155, 0, -1, -1, pr_compat},
    {-2159, -2159, 0, -1, -1, pr_compat},
    {-2163, -2163, 0, -1, -1, pr_compat},
    {-2167, -2167, 0, -1, -1, pr_compat},
    {-2171, -2171, 0, -1, -1, pr_compat},
    {-2173, -2173, 0, -1, -1, pr_compat},
    {-2175, -2175, 0, -1, -1, pr_compat},
    {-2177, -2177, 0, -1, -1, pr_compat},
    {-2179, -2179, 0, -1, -1, pr_compat},
    {-2181, -2181, 0, -1, -1, pr_compat},
    {-2183, -2183, 0, -1, -1, pr_compat},
    {-2185, -2185, 0, -1, -1, pr_compat},
    {-2187, -2187, 0, -1, -1, pr_compat},
    {-2189, -2189, 0, -1, -1, pr_compat},
    {-2192, -2192, 0, -1, -1, pr_compat},
    {-2195, -2195, 0, -1, -1, pr_compat},
    {-2198, -2198, 0, -1, -1, pr_compat},
    {-2201, -2201, 0, -1, -1, pr_compat},
    {-2204, -2204, 0, -1, -1, pr_compat},
    {-2207, -2207, 0, -1, -1, pr_compat},
    {-2210, -2210, 0, -1, -1, pr_compat},
    {-2213, -2213, 0, -1, -1, pr_compat},
    {-2216, -2216, 0, -1, -1, pr_compat},
    {-2219, -2219, 0, -1, -1, pr_compat},
    {-2222, -2222, 0, -1, -1, pr_compat},
    {-2225, -2225, 0, -1, -1, pr_compat},
    {-2228, -2228, 0, -1, -1, pr_compat},
    {-2231, -2231, 0, -1, -1, pr_compat},
    {-2234, -2234, 0, -1, -1, pr_compat},
    {-2237, -2237, 0, -1, -1, pr_compat},
    {-2240, -2240, 0, -1, -1, pr_compat},
    {-2243, -2243, 0, -1, -1, pr_compat},
    {-2246, -2246, 0, -1, -1, pr_compat},
    {-2249, -2249, 0, -1, -1, pr_compat},
    {-2252, -2252, 0, -1, -1, pr_compat},
    {-2255, -2255, 0, -1, -1, pr_compat},
    {-2258, -2258, 0, -1, -1, pr_compat},
    {-2261, -2261, 0, -1, -1, pr_compat},
    {-2264, -2264, 0, -1, -1, pr_compat},
    {-2267, -2267, 0, -1, -1, pr_compat},
    {-2270, -2270, 0, -1, -1, pr_compat},
    {-2273, -2273, 0, -1, -1, pr_compat},
    {-2276, -2276, 0, -1, -1, pr_compat},
    {-2279, -2279, 0, -1, -1, pr_compat},
    {-2282, -2282, 0, -1, -1, pr_compat},
    {-2285, -2285, 0, -1, -1, pr_compat},
    {-2288, -2288, 0, -1, -1, pr_compat},
    {-2291, -2291, 0, -1, -1, pr_compat},
    {-2294, -2294, 0, -1, -1, pr_compat},
    {-2297, -2297, 0, -1, -1, pr_compat},
    {97, 97, 0, -1, -1, pr_compat},
    {98, 98, 0, -1, -1, pr_compat},
    {99, 99, 0, -1, -1, pr_compat},
    {100, 100, 0, -1, -1, pr_compat},
    {101, 101, 0, -1, -1, pr_compat},
    {102, 102, 0, -1, -1, pr_compat},
    {103, 103, 0, -1, -1, pr_compat},
    {104, 104, 0, -1, -1, pr_compat},
    {105, 105, 0, -1, -1, pr_compat},
    {106, 106, 0, -1, -1, pr_compat},
    {107, 107, 0, -1, -1, pr_compat},
    {108, 108, 0, -1, -1, pr_compat},
    {109, 109, 0, -1, -1, pr_compat},
    {110, 110, 0, -1, -1, pr_compat},
    {111, 111, 0, -1, -1, pr_compat},
    {112, 112, 0, -1, -1, pr_compat},
    {113, 113, 0, -1, -1, pr_compat},
    {114, 114, 0, -1, -1, pr_compat},
    {115, 115, 0, -1, -1, pr_compat},
    {116, 116, 0, -1, -1, pr_compat},
    {117, 117, 0, -1, -1, pr_compat},
    {118, 118, 0, -1, -1, pr_compat},
    {119, 119, 0, -1, -1, pr_compat},
    {120, 120, 0, -1, -1, pr_compat},
    {121, 121, 0, -1, -1, pr_compat},
    {122, 122, 0, -1, -1, pr_compat},
    {-2300, -2300, 0, -1, -1, pr_compat},
    {-2304, -2304, 0, -1, -1, pr_compat},
    {-2307, -2307, 0, -1, -1, pr_compat},
    {-2309, -2309, 0, -1, -1, pr_compat},
    {-2312, -2312, 0, -1, -1, qc_N},
    {0, 11312, 0, -1, -1, 0},
    {0, 11313, 0, -1, -1, 0},
    {0, 11314, 0, -1, -1, 0},
    {0, 11315, 0, -1, -1, 0},
    {0, 11316, 0, -1, -1, 0},
    {0, 11317, 0, -1, -1, 0},
    {0, 11318, 0, -1, -1, 0},
    {0, 11319, 0, -1, -1, 0},
    {0, 11320, 0, -1, -1, 0},
    {0, 11321, 0, -1, -1, 0},
    {0, 11322, 0, -1, -1, 0},
    {0, 11323, 0, -1, -1, 0},
    {0, 11324, 0, -1, -1, 0},
    {0, 11325, 0, -1, -1, 0},
    {0, 11326, 0, -1, -1, 0},
    {0, 11327, 0, -1, -1, 0},
    {0, 11328, 0, -1, -1, 0},
    {0, 11329, 0, -1, -1, 0},
    {0, 11330, 0, -1, -1, 0},
    {0, 11331, 0, -1, -1, 0},
    {0, 11332, 0, -1, -1, 0},
    {0, 11333, 0, -1, -1, 0},
    {0, 11334, 0, -1, -1, 0},
    {0, 11335, 0, -1, -1, 0},
    {0, 11336, 0, -1, -1, 0},
    {0, 11337, 0, -1, -1, 0},
    {0, 11338, 0, -1, -1, 0},
    {0, 11339, 0, -1, -1, 0},
    {0, 11340, 0, -1, -1, 0},
    {0, 11341, 0, -1, -1, 0},
    {0, 11342, 0, -1, -1, 0},
    {0, 11343, 0, -1, -1, 0},
    {0, 11344, 0, -1, -1, 0},
    {0, 11345, 0, -1, -1, 0},
    {0, 11346, 0, -1, -1, 0},
    {0, 11347, 0, -1, -1, 0},
    {0, 11348, 0, -1, -1, 0},
    {0, 11349, 0, -1, -1, 0},
    {0, 11350, 0, -1, -1, 0},
    {0, 11351, 0, -1, -1, 0},
    {0, 11352, 0, -1, -1, 0},
    {0, 11353, 0, -1, -1, 0},
    {0, 11354, 0, -1, -1, 0},
    {0, 11355, 0, -1, -1, 0},
    {0, 11356, 0, -1, -1, 0},
    {0, 11357, 0, -1, -1, 0},
    {0, 11358, 0, -1, -1, 0},
    {0, 11361, 0, -1, -1, id_Start},
    {0, 619, 0, -1, -1, id_Start},
    {0, 7549, 0, -1, -1, id_Start},
    {0, 637, 0, -1, -1, id_Start},
    {0, 11368, 0, -1, -1, id_Start},
    {0, 11370, 0, -1, -1, id_Start},
    {0, 11372, 0, -1, -1, id_Start},
    {0, 593, 0, -1, -1, id_Start},
    {0, 625, 0, -1, -1, id_Start},
    {0, 592, 0, -1, -1, id_Start},
    {0, 594, 0, -1, -1, id_Start},
    {0, 11379, 0, -1, -1, id_Start},
    {0, 11382, 0, -1, -1, id_Start},
    {0, 575, 0, -1, -1, id_Start},
    {0, 576, 0, -1, -1, id_Start},
    {0, 11393, 0, -1, -1, 0},
    {0, 11395, 0, -1, -1, 0},
    {0, 11397, 0, -1, -1, 0},
    {0, 11399, 0, -1, -1, 0},
    {0, 11401, 0, -1, -1, 0},
    {0, 11403, 0, -1, -1, 0},
    {0, 11405, 0, -1, -1, 0},
    {0, 11407, 0, -1, -1, 0},
    {0, 11409, 0, -1, -1, 0},
    {0, 11411, 0, -1, -1, 0},
    {0, 11413, 0, -1, -1, 0},
    {0, 11415, 0, -1, -1, 0},
    {0, 11417, 0, -1, -1, 0},
    {0, 11419, 0, -1, -1, 0},
    {0, 11421, 0, -1, -1, 0},
    {0, 11423, 0, -1, -1, 0},
    {0, 11425, 0, -1, -1, 0},
    {0, 11427, 0, -1, -1, 0},
    {0, 11429, 0, -1, -1, 0},
    {0, 11431, 0, -1, -1, 0},
    {0, 11433, 0, -1, -1, 0},
    {0, 11435, 0, -1, -1, 0},
    {0, 11437, 0, -1, -1, 0},
    {0, 11439, 0, -1, -1, 0},
    {0, 11441, 0, -1, -1, 0},
    {0, 11443, 0, -1, -1, 0},
    {0, 11445, 0, -1, -1, 0},
    {0, 11447, 0, -1, -1, 0},
    {0, 11449, 0, -1, -1, 0},
    {0, 11451, 0, -1, -1, 0},
    {0, 11453, 0, -1, -1, 0},
    {0, 11455, 0, -1, -1, 0},
    {0, 11457, 0, -1, -1, 0},
    {0, 11459, 0, -1, -1, 0},
    {0, 11461, 0, -1, -1, 0},
    {0, 11463, 0, -1, -1, 0},
    {0, 11465, 0, -1, -1, 0},
    {0, 11467, 0, -1, -1, 0},
    {0, 11469, 0, -1, -1, 0},
    {0, 11471, 0, -1, -1, 0},
    {0, 11473, 0, -1, -1, 0},
    {0, 11475, 0, -1, -1, 0},
    {0, 11477, 0, -1, -1, 0},
    {0, 11479, 0, -1, -1, 0},
    {0, 11481, 0, -1, -1, 0},
    {0, 11483, 0, -1, -1, 0},
    {0, 11485, 0, -1, -1, 0},
    {0, 11487, 0, -1, -1, 0},
    {0, 11489, 0, -1, -1, 0},
    {0, 11491, 0, -1, -1, 0},
    {0, 11500, 0, -1, -1, 0},
    {0, 11502, 0, -1, -1, 0},
    {0, 11507, 0, -1, -1, 0},
    {11617, 11617, 0, -1, -1, pr_compat | id_Start},
    {27597, 27597, 0, -1, -1, pr_compat},
    {-16385, -16385, 0, -1, -1, pr_compat},
    {20008, 20008, 0, -1, -1, pr_compat},
    {20022, 20022, 0, -1, -1, pr_compat},
    {20031, 20031, 0, -1, -1, pr_compat},
    {20101, 20101, 0, -1, -1, pr_compat},
    {20128, 20128, 0, -1, -1, pr_compat},
    {20799, 20799, 0, -1, -1, pr_compat},
    {20837, 20837, 0, -1, -1, pr_compat},
    {20866, 20866, 0, -1, -1, pr_compat},
    {20886, 20886, 0, -1, -1, pr_compat},
    {20907, 20907, 0, -1, -1, pr_compat},
    {20960, 20960, 0, -1, -1, pr_compat},
    {20981, 20981, 0, -1, -1, pr_compat},
    {20992, 20992, 0, -1, -1, pr_compat},
    {21147, 21147, 0, -1, -1, pr_compat},
    {21241, 21241, 0, -1, -1, pr_compat},
    {21269, 21269, 0, -1, -1, pr_compat},
    {21274, 21274, 0, -1, -1, pr_compat},
    {21304, 21304, 0, -1, -1, pr_compat},
    {21340, 21340, 0, -1, -1, pr_compat},
    {21353, 21353, 0, -1, -1, pr_compat},
    {21378, 21378, 0, -1, -1, pr_compat},
    {21430, 21430, 0, -1, -1, pr_compat},
    {21448, 21448, 0, -1, -1, pr_compat},
    {21475, 21475, 0, -1, -1, pr_compat},
    {22231, 22231, 0, -1, -1, pr_compat},
    {22763, 22763, 0, -1, -1, pr_compat},
    {22786, 22786, 0, -1, -1, pr_compat},
    {22794, 22794, 0, -1, -1, pr_compat},
    {22805, 22805, 0, -1, -1, pr_compat},
    {22823, 22823, 0, -1, -1, pr_compat},
    {23376, 23376, 0, -1, -1, pr_compat},
    {23424, 23424, 0, -1, -1, pr_compat},
    {23544, 23544, 0, -1, -1, pr_compat},
    {23567, 23567, 0, -1, -1, pr_compat},
    {23586, 23586, 0, -1, -1, pr_compat},
    {23608, 23608, 0, -1, -1, pr_compat},
    {23662, 23662, 0, -1, -1, pr_compat},
    {23665, 23665, 0, -1, -1, pr_compat},
    {24027, 24027, 0, -1, -1, pr_compat},
    {24037, 24037, 0, -1, -1, pr_compat},
    {24049, 24049, 0, -1, -1, pr_compat},
    {24062, 24062, 0, -1, -1, pr_compat},
    {24178, 24178, 0, -1, -1, pr_compat},
    {24186, 24186, 0, -1, -1, pr_compat},
    {24191, 24191, 0, -1, -1, pr_compat},
    {24308, 24308, 0, -1, -1, pr_compat},
    {24318, 24318, 0, -1, -1, pr_compat},
    {24331, 24331, 0, -1, -1, pr_compat},
    {24339, 24339, 0, -1, -1, pr_compat},
    {24400, 24400, 0, -1, -1, pr_compat},
    {24417, 24417, 0, -1, -1, pr_compat},
    {24435, 24435, 0, -1, -1, pr_compat},
    {24515, 24515, 0, -1, -1, pr_compat},
    {25096, 25096, 0, -1, -1, pr_compat},
    {25142, 25142, 0, -1, -1, pr_compat},
    {25903, 25903, 0, -1, -1, pr_compat},
    {25908, 25908, 0, -1, -1, pr_compat},
    {26007, 26007, 0, -1, -1, pr_compat},
    {26020, 26020, 0, -1, -1, pr_compat},
    {26041, 26041, 0, -1, -1, pr_compat},
    {26080, 26080, 0, -1, -1, pr_compat},
    {26352, 26352, 0, -1, -1, pr_compat},
    {27424, 27424, 0, -1, -1, pr_compat},
    {27490, 27490, 0, -1, -1, pr_compat},
    {27513, 27513, 0, -1, -1, pr_compat},
    {27571, 27571, 0, -1, -1, pr_compat},
    {27595, 27595, 0, -1, -1, pr_compat},
    {27604, 27604, 0, -1, -1, pr_compat},
    {27611, 27611, 0, -1, -1, pr_compat},
    {27663, 27663, 0, -1, -1, pr_compat},
    {27668, 27668, 0, -1, -1, pr_compat},
    {29226, 29226, 0, -1, -1, pr_compat},
    {29238, 29238, 0, -1, -1, pr_compat},
    {29243, 29243, 0, -1, -1, pr_compat},
    {29247, 29247, 0, -1, -1, pr_compat},
    {29255, 29255, 0, -1, -1, pr_compat},
    {29273, 29273, 0, -1, -1, pr_compat},
    {29275, 29275, 0, -1, -1, pr_compat},
    {29356, 29356, 0, -1, -1, pr_compat},
    {29572, 29572, 0, -1, -1, pr_compat},
    {29577, 29577, 0, -1, -1, pr_compat},
    {29916, 29916, 0, -1, -1, pr_compat},
    {29926, 29926, 0, -1, -1, pr_compat},
    {29976, 29976, 0, -1, -1, pr_compat},
    {29992, 29992, 0, -1, -1, pr_compat},
    {30000, 30000, 0, -1, -1, pr_compat},
    {30091, 30091, 0, -1, -1, pr_compat},
    {30098, 30098, 0, -1, -1, pr_compat},
    {30326, 30326, 0, -1, -1, pr_compat},
    {30333, 30333, 0, -1, -1, pr_compat},
    {30382, 30382, 0, -1, -1, pr_compat},
    {30399, 30399, 0, -1, -1, pr_compat},
    {30446, 30446, 0, -1, -1, pr_compat},
    {30683, 30683, 0, -1, -1, pr_compat},
    {30690, 30690, 0, -1, -1, pr_compat},
    {30707, 30707, 0, -1, -1, pr_compat},
    {31034, 31034, 0, -1, -1, pr_compat},
    {31160, 31160, 0, -1, -1, pr_compat},
    {31166, 31166, 0, -1, -1, pr_compat},
    {31348, 31348, 0, -1, -1, pr_compat},
    {31435, 31435, 0, -1, -1, pr_compat},
    {31481, 31481, 0, -1, -1, pr_compat},
    {31859, 31859, 0, -1, -1, pr_compat},
    {31992, 31992, 0, -1, -1, pr_compat},
    {32566, 32566, 0, -1, -1, pr_compat},
    {32593, 32593, 0, -1, -1, pr_compat},
    {32650, 32650, 0, -1, -1, pr_compat},
    {32701, 32701, 0, -1, -1, pr_compat},
    {-16386, -16386, 0, -1, -1, pr_compat},
    {-16387, -16387, 0, -1, -1, pr_compat},
    {-16388, -16388, 0, -1, -1, pr_compat},
    {-16389, -16389, 0, -1, -1, pr_compat},
    {-16390, -16390, 0, -1, -1, pr_compat},
    {-16391, -16391, 0, -1, -1, pr_compat},
    {-16392, -16392, 0, -1, -1, pr_compat},
    {-16393, -16393, 0, -1, -1, pr_compat},
    {-16394, -16394, 0, -1, -1, pr_compat},
    {-16395, -16395, 0, -1, -1, pr_compat},
    {-16396, -16396, 0, -1, -1, pr_compat},
    {-16397, -16397, 0, -1, -1, pr_compat},
    {-16398, -16398, 0, -1, -1, pr_compat},
    {-16399, -16399, 0, -1, -1, pr_compat},
    {-16400, -16400, 0, -1, -1, pr_compat},
    {-16401, -16401, 0, -1, -1, pr_compat},
    {-16402, -16402, 0, -1, -1, pr_compat},
    {-16403, -16403, 0, -1, -1, pr_compat},
    {-16404, -16404, 0, -1, -1, pr_compat},
    {-16405, -16405, 0, -1, -1, pr_compat},
    {-16406, -16406, 0, -1, -1, pr_compat},
    {-16407, -16407, 0, -1, -1, pr_compat},
    {-16408, -16408, 0, -1, -1, pr_compat},
    {-16409, -16409, 0, -1, -1, pr_compat},
    {-16410, -16410, 0, -1, -1, pr_compat},
    {-16411, -16411, 0, -1, -1, pr_compat},
    {-16412, -16412, 0, -1, -1, pr_compat},
    {-16413, -16413, 0, -1, -1, pr_compat},
    {-16414, -16414, 0, -1, -1, pr_compat},
    {-16415, -16415, 0, -1, -1, pr_compat},
    {-16416, -16416, 0, -1, -1, pr_compat},
    {-16418, -16418, 0, -1, -1, pr_compat},
    {-16419, -16419, 0, -1, -1, pr_compat},
    {-16420, -16420, 0, -1, -1, pr_compat},
    {-16421, -16421, 0, -1, -1, pr_compat},
    {-16422, -16422, 0, -1, -1, pr_compat},
    {-16423, -16423, 0, -1, -1, pr_compat},
    {-16424, -16424, 0, -1, -1, pr_compat},
    {-16425, -16425, 0, -1, -1, pr_compat},
    {-16426, -16426, 0, -1, -1, pr_compat},
    {-16427, -16427, 0, -1, -1, pr_compat},
    {-16429, -16429, 0, -1, -1, pr_compat},
    {-16430, -16430, 0, -1, -1, pr_compat},
    {-16431, -16431, 0, -1, -1, pr_compat},
    {-16432, -16432, 0, -1, -1, pr_compat},
    {-16433, -16433, 0, -1, -1, pr_compat},
    {-16434, -16434, 0, -1, -1, pr_compat},
    {-16435, -16435, 0, -1, -1, pr_compat},
    {-16436, -16436, 0, -1, -1, pr_compat},
    {-16437, -16437, 0, -1, -1, pr_compat},
    {-16438, -16438, 0, -1, -1, pr_compat},
    {-16439, -16439, 0, -1, -1, pr_compat},
    {-16440, -16440, 0, -1, -1, pr_compat},
    {-16441, -16441, 0, -1, -1, pr_compat},
    {-16442, -16442, 0, -1, -1, pr_compat},
    {-16443, -16443, 0, -1, -1, pr_compat},
    {-16444, -16444, 0, -1, -1, pr_compat},
    {-16445, -16445, 0, -1, -1, pr_compat},
    {-16446, -16446, 0, -1, -1, pr_compat},
    {-16447, -16447, 0, -1, -1, pr_compat},
    {-16448, -16448, 0, -1, -1, pr_compat},
    {-16449, -16449, 0, -1, -1, pr_compat},
    {-16450, -16450, 0, -1, -1, pr_compat},
    {-16451, -16451, 0, -1, -1, pr_compat},
    {-16452, -16452, 0, -1, -1, pr_compat},
    {-16453, -16453, 0, -1, -1, pr_compat},
    {-16454, -16454, 0, -1, -1, pr_compat},
    {-16455, -16455, 0, -1, -1, pr_compat},
    {-16456, -16456, 0, -1, -1, pr_compat},
    {-16457, -16457, 0, -1, -1, pr_compat},
    {-16458, -16458, 0, -1, -1, pr_compat},
    {-16459, -16459, 0, -1, -1, pr_compat},
    {-16460, -16460, 0, -1, -1, pr_compat},
    {-16461, -16461, 0, -1, -1, pr_compat},
    {-16462, -16462, 0, -1, -1, pr_compat},
    {-16463, -16463, 0, -1, -1, pr_compat},
    {-16464, -16464, 0, -1, -1, pr_compat},
    {-16465, -16465, 0, -1, -1, pr_compat},
    {-16466, -16466, 0, -1, -1, pr_compat},
    {-16467, -16467, 0, -1, -1, pr_compat},
    {-16468, -16468, 0, -1, -1, pr_compat},
    {-16469, -16469, 0, -1, -1, pr_compat},
    {-16470, -16470, 0, -1, -1, pr_compat},
    {-16471, -16471, 0, -1, -1, pr_compat},
    {-16472, -16472, 0, -1, -1, pr_compat},
    {-16473, -16473, 0, -1, -1, pr_compat},
    {-16474, -16474, 0, -1, -1, pr_compat},
    {-16475, -16475, 0, -1, -1, pr_compat},
    {0, 0, 218, -1, -1, id_Continue},
    {12306, 12306, 0, -1, -1, pr_compat},
    {21313, 21313, 0, -1, -1, pr_compat | id_Start},
    {21316, 21316, 0, -1, -1, pr_compat | id_Start},
    {21317, 21317, 0, -1, -1, pr_compat | id_Start},
    {0, 0, 0, -1, 12214, id_Start},
    {0, 0, 0, -1, 10974, id_Start},
    {-2314, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11036, id_Start},
    {-2316, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11098, id_Start},
    {-2318, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11160, id_Start},
    {-2320, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11222, id_Start},
    {-2322, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11284, id_Start},
    {-2324, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11346, id_Start},
    {-2326, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11408, id_Start},
    {-2328, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11470, id_Start},
    {-2330, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11532, id_Start},
    {-2332, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11594, id_Start},
    {-2334, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11656, id_Start},
    {-2336, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11718, id_Start},
    {-2338, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11780, id_Start},
    {-2340, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11842, id_Start},
    {-2342, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11904, id_Start},
    {-2344, 0, 0, -1, -1, id_Start},
    {-2346, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 11966, id_Start},
    {-2348, 0, 0, -1, -1, id_Start},
    {-2350, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 12028, id_Start},
    {-2352, 0, 0, -1, -1, id_Start},
    {-2354, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 12090, id_Start},
    {-2356, 0, 0, -1, -1, id_Start},
    {-2358, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 12152, id_Start},
    {-2360, 0, 0, -1, -1, id_Start},
    {-2362, 0, 0, -1, -1, id_Start},
    {-2364, 0, 0, -1, -1, id_Start},
    {0, 0, 8, 39, -1, id_Continue | qc_M},
    {0, 0, 8, 40, -1, id_Continue | qc_M},
    {-2366, -2366, 0, -1, -1, pr_compat},
    {-2368, -2368, 0, -1, -1, pr_compat},
    {0, 0, 0, -1, 12400, id_Start},
    {-2370, 0, 0, -1, -1, id_Start},
    {-2372, -2372, 0, -1, -1, pr_compat | id_Start},
    {0, 0, 0, -1, 13764, id_Start},
    {0, 0, 0, -1, 12524, id_Start},
    {-2374, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 12586, id_Start},
    {-2376, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 12648, id_Start},
    {-2378, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 12710, id_Start},
    {-2380, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 12772, id_Start},
    {-2382, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 12834, id_Start},
    {-2384, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 12896, id_Start},
    {-2386, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 12958, id_Start},
    {-2388, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 13020, id_Start},
    {-2390, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 13082, id_Start},
    {-2392, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 13144, id_Start},
    {-2394, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 13206, id_Start},
    {-2396, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 13268, id_Start},
    {-2398, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 13330, id_Start},
    {-2400, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 13392, id_Start},
    {-2402, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 13454, id_Start},
    {-2404, 0, 0, -1, -1, id_Start},
    {-2406, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 13516, id_Start},
    {-2408, 0, 0, -1, -1, id_Start},
    {-2410, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 13578, id_Start},
    {-2412, 0, 0, -1, -1, id_Start},
    {-2414, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 13640, id_Start},
    {-2416, 0, 0, -1, -1, id_Start},
    {-2418, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 13702, id_Start},
    {-2420, 0, 0, -1, -1, id_Start},
    {-2422, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 13826, id_Start},
    {0, 0, 0, -1, 13888, id_Start},
    {0, 0, 0, -1, 13950, id_Start},
    {0, 0, 0, -1, 14012, id_Start},
    {-2424, 0, 0, -1, -1, id_Start},
    {-2426, 0, 0, -1, -1, id_Start},
    {-2428, 0, 0, -1, -1, id_Start},
    {-2430, 0, 0, -1, -1, id_Start},
    {-2432, 0, 0, -1, -1, id_Start},
    {0, 0, 0, -1, 14074, id_Start},
    {-2434, 0, 0, -1, -1, id_Start},
    {-2436, -2436, 0, -1, -1, pr_compat | id_Start},
    {4352, 4352, 0, -1, -1, pr_compat | id_Start},
    {4353, 4353, 0, -1, -1, pr_compat | id_Start},
    {4522, 4522, 0, -1, -1, pr_compat | id_Start},
    {4354, 4354, 0, -1, -1, pr_compat | id_Start},
    {4524, 4524, 0, -1, -1, pr_compat | id_Start},
    {4525, 4525, 0, -1, -1, pr_compat | id_Start},
    {4355, 4355, 0, -1, -1, pr_compat | id_Start},
    {4356, 4356, 0, -1, -1, pr_compat | id_Start},
    {4357, 4357, 0, -1, -1, pr_compat | id_Start},
    {4528, 4528, 0, -1, -1, pr_compat | id_Start},
    {4529, 4529, 0, -1, -1, pr_compat | id_Start},
    {4530, 4530, 0, -1, -1, pr_compat | id_Start},
    {4531, 4531, 0, -1, -1, pr_compat | id_Start},
    {4532, 4532, 0, -1, -1, pr_compat | id_Start},
    {4533, 4533, 0, -1, -1, pr_compat | id_Start},
    {4378, 4378, 0, -1, -1, pr_compat | id_Start},
    {4358, 4358, 0, -1, -1, pr_compat | id_Start},
    {4359, 4359, 0, -1, -1, pr_compat | id_Start},
    {4360, 4360, 0, -1, -1, pr_compat | id_Start},
    {4385, 4385, 0, -1, -1, pr_compat | id_Start},
    {4361, 4361, 0, -1, -1, pr_compat | id_Start},
    {4362, 4362, 0, -1, -1, pr_compat | id_Start},
    {4363, 4363, 0, -1, -1, pr_compat | id_Start},
    {4364, 4364, 0, -1, -1, pr_compat | id_Start},
    {4365, 4365, 0, -1, -1, pr_compat | id_Start},
    {4366, 4366, 0, -1, -1, pr_compat | id_Start},
    {4367, 4367, 0, -1, -1, pr_compat | id_Start},
    {4368, 4368, 0, -1, -1, pr_compat | id_Start},
    {4369, 4369, 0, -1, -1, pr_compat | id_Start},
    {4370, 4370, 0, -1, -1, pr_compat | id_Start},
    {4449, 4449, 0, -1, -1, pr_compat | id_Start},
    {4450, 4450, 0, -1, -1, pr_compat | id_Start},
    {4451, 4451, 0, -1, -1, pr_compat | id_Start},
    {4452, 4452, 0, -1, -1, pr_compat | id_Start},
    {4453, 4453, 0, -1, -1, pr_compat | id_Start},
    {4454, 4454, 0, -1, -1, pr_compat | id_Start},
    {4455, 4455, 0, -1, -1, pr_compat | id_Start},
    {4456, 4456, 0, -1, -1, pr_compat | id_Start},
    {4457, 4457, 0, -1, -1, pr_compat | id_Start},
    {4458, 4458, 0, -1, -1, pr_compat | id_Start},
    {4459, 4459, 0, -1, -1, pr_compat | id_Start},
    {4460, 4460, 0, -1, -1, pr_compat | id_Start},
    {4461, 4461, 0, -1, -1, pr_compat | id_Start},
    {4462, 4462, 0, -1, -1, pr_compat | id_Start},
    {4463, 4463, 0, -1, -1, pr_compat | id_Start},
    {4464, 4464, 0, -1, -1, pr_compat | id_Start},
    {4465, 4465, 0, -1, -1, pr_compat | id_Start},
    {4466, 4466, 0, -1, -1, pr_compat | id_Start},
    {4467, 4467, 0, -1, -1, pr_compat | id_Start},
    {4468, 4468, 0, -1, -1, pr_compat | id_Start},
    {4469, 4469, 0, -1, -1, pr_compat | id_Start},
    {4448, 0, 0, -1, -1, pr_compat},
    {4372, 4372, 0, -1, -1, pr_compat | id_Start},
    {4373, 4373, 0, -1, -1, pr_compat | id_Start},
    {4551, 4551, 0, -1, -1, pr_compat | id_Start},
    {4552, 4552, 0, -1, -1, pr_compat | id_Start},
    {4556, 4556, 0, -1, -1, pr_compat | id_Start},
    {4558, 4558, 0, -1, -1, pr_compat | id_Start},
    {4563, 4563, 0, -1, -1, pr_compat | id_Start},
    {4567, 4567, 0, -1, -1, pr_compat | id_Start},
    {4569, 4569, 0, -1, -1, pr_compat | id_Start},
    {4380, 4380, 0, -1, -1, pr_compat | id_Start},
    {4573, 4573, 0, -1, -1, pr_compat | id_Start},
    {4575, 4575, 0, -1, -1, pr_compat | id_Start},
    {4381, 4381, 0, -1, -1, pr_compat | id_Start},
    {4382, 4382, 0, -1, -1, pr_compat | id_Start},
    {4384, 4384, 0, -1, -1, pr_compat | id_Start},
    {4386, 4386, 0, -1, -1, pr_compat | id_Start},
    {4387, 4387, 0, -1, -1, pr_compat | id_Start},
    {4391, 4391, 0, -1, -1, pr_compat | id_Start},
    {4393, 4393, 0, -1, -1, pr_compat | id_Start},
    {4395, 4395, 0, -1, -1, pr_compat | id_Start},
    {4396, 4396, 0, -1, -1, pr_compat | id_Start},
    {4397, 4397, 0, -1, -1, pr_compat | id_Start},
    {4398, 4398, 0, -1, -1, pr_compat | id_Start},
    {4399, 4399, 0, -1, -1, pr_compat | id_Start},
    {4402, 4402, 0, -1, -1, pr_compat | id_Start},
    {4406, 4406, 0, -1, -1, pr_compat | id_Start},
    {4416, 4416, 0, -1, -1, pr_compat | id_Start},
    {4423, 4423, 0, -1, -1, pr_compat | id_Start},
    {4428, 4428, 0, -1, -1, pr_compat | id_Start},
    {4593, 4593, 0, -1, -1, pr_compat | id_Start},
    {4594, 4594, 0, -1, -1, pr_compat | id_Start},
    {4439, 4439, 0, -1, -1, pr_compat | id_Start},
    {4440, 4440, 0, -1, -1, pr_compat | id_Start},
    {4441, 4441, 0, -1, -1, pr_compat | id_Start},
    {4484, 4484, 0, -1, -1, pr_compat | id_Start},
    {4485, 4485, 0, -1, -1, pr_compat | id_Start},
    {4488, 4488, 0, -1, -1, pr_compat | id_Start},
    {4497, 4497, 0, -1, -1, pr_compat | id_Start},
    {4498, 4498, 0, -1, -1, pr_compat | id_Start},
    {4500, 4500, 0, -1, -1, pr_compat | id_Start},
    {4510, 4510, 0, -1, -1, pr_compat | id_Start},
    {4513, 4513, 0, -1, -1, pr_compat | id_Start},
    {30002, 30002, 0, -1, -1, pr_compat},
    {19993, 19993, 0, -1, -1, pr_compat},
    {19969, 19969, 0, -1, -1, pr_compat},
    {22320, 22320, 0, -1, -1, pr_compat},
    {-2438, -2438, 0, -1, -1, pr_compat},
    {-2441, -2441, 0, -1, -1, pr_compat},
    {-2444, -2444, 0, -1, -1, pr_compat},
    {-2447, -2447, 0, -1, -1, pr_compat},
    {-2450, -2450, 0, -1, -1, pr_compat},
    {-2453, -2453, 0, -1, -1, pr_compat},
    {-2456, -2456, 0, -1, -1, pr_compat},
    {-2459, -2459, 0, -1, -1, pr_compat},
    {-2462, -2462, 0, -1, -1, pr_compat},
    {-2465, -2465, 0, -1, -1, pr_compat},
    {-2468, -2468, 0, -1, -1, pr_compat},
    {-2471, -2471, 0, -1, -1, pr_compat},
    {-2474, -2474, 0, -1, -1, pr_compat},
    {-2477, -2477, 0, -1, -1, pr_compat},
    {-2480, -16873, 0, -1, -1, pr_compat},
    {-2484, -16876, 0, -1, -1, pr_compat},
    {-2488, -16879, 0, -1, -1, pr_compat},
    {-2492, -16882, 0, -1, -1, pr_compat},
    {-2496, -16885, 0, -1, -1, pr_compat},
    {-2500, -16888, 0, -1, -1, pr_compat},
    {-2504, -16891, 0, -1, -1, pr_compat},
    {-2508, -16894, 0, -1, -1, pr_compat},
    {-2512, -16897, 0, -1, -1, pr_compat},
    {-2516, -16900, 0, -1, -1, pr_compat},
    {-2520, -16903, 0, -1, -1, pr_compat},
    {-2524, -16906, 0, -1, -1, pr_compat},
    {-2528, -16909, 0, -1, -1, pr_compat},
    {-2532, -16912, 0, -1, -1, pr_compat},
    {-2536, -16915, 0, -1, -1, pr_compat},
    {-2540, -16918, 0, -1, -1, pr_compat},
    {-2547, -16922, 0, -1, -1, pr_compat},
    {-2553, -2553, 0, -1, -1, pr_compat},
    {-2556, -2556, 0, -1, -1, pr_compat},
    {-2559, -2559, 0, -1, -1, pr_compat},
    {-2562, -2562, 0, -1, -1, pr_compat},
    {-2565, -2565, 0, -1, -1, pr_compat},
    {-2568, -2568, 0, -1, -1, pr_compat},
    {-2571, -2571, 0, -1, -1, pr_compat},
    {-2574, -2574, 0, -1, -1, pr_compat},
    {-2577, -2577, 0, -1, -1, pr_compat},
    {-2580, -2580, 0, -1, -1, pr_compat},
    {-2583, -2583, 0, -1, -1, pr_compat},
    {-2586, -2586, 0, -1, -1, pr_compat},
    {-2589, -2589, 0, -1, -1, pr_compat},
    {-2592, -2592, 0, -1, -1, pr_compat},
    {-16476, -16476, 0, -1, -1, pr_compat},
    {-2595, -2595, 0, -1, -1, pr_compat},
    {-2598, -2598, 0, -1, -1, pr_compat},
    {-2601, -2601, 0, -1, -1, pr_compat},
    {-2604, -2604, 0, -1, -1, pr_compat},
    {-2607, -2607, 0, -1, -1, pr_compat},
    {-2610, -2610, 0, -1, -1, pr_compat},
    {-2613, -2613, 0, -1, -1, pr_compat},
    {-16479, -16479, 0, -1, -1, pr_compat},
    {-2616, -2616, 0, -1, -1, pr_compat},
    {-2619, -2619, 0, -1, -1, pr_compat},
    {-2622, -2622, 0, -1, -1, pr_compat},
    {-2625, -2625, 0, -1, -1, pr_compat},
    {-2628, -2628, 0, -1, -1, pr_compat},
    {-2631, -2631, 0, -1, -1, pr_compat},
    {-2634, -2634, 0, -1, -1, pr_compat},
    {-16482, -16482, 0, -1, -1, pr_compat},
    {-2637, -2637, 0, -1, -1, pr_compat},
    {-2640, -2640, 0, -1, -1, pr_compat},
    {-2643, -2643, 0, -1, -1, pr_compat},
    {-16485, -16485, 0, -1, -1, pr_compat},
    {-16488, -16488, 0, -1, -1, pr_compat},
    {21839, 21839, 0, -1, -1, pr_compat},
    {24188, 24188, 0, -1, -1, pr_compat},
    {31631, 31631, 0, -1, -1, pr_compat},
    {-2646, -4617, 0, -1, -1, pr_compat},
    {-2649, -2649, 0, -1, -1, pr_compat},
    {-2651, -2651, 0, -1, -1, pr_compat},
    {-2653, -2653, 0, -1, -1, pr_compat},
    {-2655, -2655, 0, -1, -1, pr_compat},
    {-2657, -2657, 0, -1, -1, pr_compat},
    {-2659, -2659, 0, -1, -1, pr_compat},
    {-2661, -2661, 0, -1, -1, pr_compat},
    {-2663, -2663, 0, -1, -1, pr_compat},
    {-2665, -2665, 0, -1, -1, pr_compat},
    {-2667, -2667, 0, -1, -1, pr_compat},
    {-2669, -2669, 0, -1, -1, pr_compat},
    {-2671, -2671, 0, -1, -1, pr_compat},
    {-2673, -2673, 0, -1, -1, pr_compat},
    {-2675, -2675, 0, -1, -1, pr_compat},
    {-2677, -2677, 0, -1, -1, pr_compat},
    {4352, 4352, 0, -1, -1, pr_compat},
    {4354, 4354, 0, -1, -1, pr_compat},
    {4355, 4355, 0, -1, -1, pr_compat},
    {4357, 4357, 0, -1, -1, pr_compat},
    {4358, 4358, 0, -1, -1, pr_compat},
    {4359, 4359, 0, -1, -1, pr_compat},
    {4361, 4361, 0, -1, -1, pr_compat},
    {4363, 4363, 0, -1, -1, pr_compat},
    {4364, 4364, 0, -1, -1, pr_compat},
    {4366, 4366, 0, -1, -1, pr_compat},
    {4367, 4367, 0, -1, -1, pr_compat},
    {4368, 4368, 0, -1, -1, pr_compat},
    {4369, 4369, 0, -1, -1, pr_compat},
    {4370, 4370, 0, -1, -1, pr_compat},
    {-2679, -16926, 0, -1, -1, pr_compat},
    {-2681, -16927, 0, -1, -1, pr_compat},
    {-2683, -16928, 0, -1, -1, pr_compat},
    {-2685, -16929, 0, -1, -1, pr_compat},
    {-2687, -16930, 0, -1, -1, pr_compat},
    {-2689, -16931, 0, -1, -1, pr_compat},
    {-2691, -16932, 0, -1, -1, pr_compat},
    {-2693, -16933, 0, -1, -1, pr_compat},
    {-2695, -16934, 0, -1, -1, pr_compat},
    {-2697, -16935, 0, -1, -1, pr_compat},
    {-2699, -16936, 0, -1, -1, pr_compat},
    {-2701, -16937, 0, -1, -1, pr_compat},
    {-2703, -16938, 0, -1, -1, pr_compat},
    {-2705, -16939, 0, -1, -1, pr_compat},
    {-2707, -16940, 0, -1, -1, pr_compat},
    {-2712, -16942, 0, -1, -1, pr_compat},
    {-2716, -16944, 0, -1, -1, pr_compat},
    {20116, 20116, 0, -1, -1, pr_compat},
    {20845, 20845, 0, -1, -1, pr_compat},
    {19971, 19971, 0, -1, -1, pr_compat},
    {20061, 20061, 0, -1, -1, pr_compat},
    {26666, 26666, 0, -1, -1, pr_compat},
    {31038, 31038, 0, -1, -1, pr_compat},
    {21517, 21517, 0, -1, -1, pr_compat},
    {29305, 29305, 0, -1, -1, pr_compat},
    {-16491, -16491, 0, -1, -1, pr_compat},
    {31069, 31069, 0, -1, -1, pr_compat},
    {21172, 21172, 0, -1, -1, pr_compat},
    {31192, 31192, 0, -1, -1, pr_compat},
    {30007, 30007, 0, -1, -1, pr_compat},
    {-16492, -16492, 0, -1, -1, pr_compat},
    {20778, 20778, 0, -1, -1, pr_compat},
    {21360, 21360, 0, -1, -1, pr_compat},
    {27880, 27880, 0, -1, -1, pr_compat},
    {-16493, -16493, 0, -1, -1, pr_compat},
    {20241, 20241, 0, -1, -1, pr_compat},
    {20889, 20889, 0, -1, -1, pr_compat},
    {27491, 27491, 0, -1, -1, pr_compat},
    {21307, 21307, 0, -1, -1, pr_compat},
    {23447, 23447, 0, -1, -1, pr_compat},
    {23398, 23398, 0, -1, -1, pr_compat},
    {30435, 30435, 0, -1, -1, pr_compat},
    {20225, 20225, 0, -1, -1, pr_compat},
    {-16494, -16494, 0, -1, -1, pr_compat},
    {21332, 21332, 0, -1, -1, pr_compat},
    {22812, 22812, 0, -1, -1, pr_compat},
    {-2718, -2718, 0, -1, -1, pr_compat},
    {-2720, -2720, 0, -1, -1, pr_compat},
    {-2722, -2722, 0, -1, -1, pr_compat},
    {-2724, -2724, 0, -1, -1, pr_compat},
    {-2726, -2726, 0, -1, -1, pr_compat},
    {-2728, -2728, 0, -1, -1, pr_compat},
    {-2730, -2730, 0, -1, -1, pr_compat},
    {-2732, -2732, 0, -1, -1, pr_compat},
    {-2734, -2734, 0, -1, -1, pr_compat},
    {-2736, -2736, 0, -1, -1, pr_compat},
    {-2738, -2738, 0, -1, -1, pr_compat},
    {-2740, -2740, 0, -1, -1, pr_compat},
    {-2742, -2742, 0, -1, -1, pr_compat},
    {-2744, -2744, 0, -1, -1, pr_compat},
    {-2746, -2746, 0, -1, -1, pr_compat},
    {-2748, -2748, 0, -1, -1, pr_compat},
    {-2750, -2750, 0, -1, -1, pr_compat},
    {-2752, -2752, 0, -1, -1, pr_compat},
    {-2754, -2754, 0, -1, -1, pr_compat},
    {-2756, -2756, 0, -1, -1, pr_compat},
    {-2758, -2758, 0, -1, -1, pr_compat},
    {-2760, -2760, 0, -1, -1, pr_compat},
    {-2762, -2762, 0, -1, -1, pr_compat},
    {-2764, -2764, 0, -1, -1, pr_compat},
    {-2766, -2766, 0, -1, -1, pr_compat},
    {-2769, -2769, 0, -1, -1, pr_compat},
    {-2772, -2772, 0, -1, -1, pr_compat},
    {-2775, -4620, 0, -1, -1, pr_compat},
    {-2777, -2777, 0, -1, -1, pr_compat},
    {-2780, -4622, 0, -1, -1, pr_compat},
    {-2782, -4624, 0, -1, -1, pr_compat},
    {12450, 12450, 0, -1, -1, pr_compat},
    {12452, 12452, 0, -1, -1, pr_compat},
    {12454, 12454, 0, -1, -1, pr_compat},
    {12456, 12456, 0, -1, -1, pr_compat},
    {12458, 12458, 0, -1, -1, pr_compat},
    {12459, 12459, 0, -1, -1, pr_compat},
    {12461, 12461, 0, -1, -1, pr_compat},
    {12463, 12463, 0, -1, -1, pr_compat},
    {12465, 12465, 0, -1, -1, pr_compat},
    {12467, 12467, 0, -1, -1, pr_compat},
    {12471, 12471, 0, -1, -1, pr_compat},
    {12473, 12473, 0, -1, -1, pr_compat},
    {12475, 12475, 0, -1, -1, pr_compat},
    {12477, 12477, 0, -1, -1, pr_compat},
    {12479, 12479, 0, -1, -1, pr_compat},
    {12481, 12481, 0, -1, -1, pr_compat},
    {12484, 12484, 0, -1, -1, pr_compat},
    {12486, 12486, 0, -1, -1, pr_compat},
    {12488, 12488, 0, -1, -1, pr_compat},
    {12490, 12490, 0, -1, -1, pr_compat},
    {12491, 12491, 0, -1, -1, pr_compat},
    {12492, 12492, 0, -1, -1, pr_compat},
    {12493, 12493, 0, -1, -1, pr_compat},
    {12494, 12494, 0, -1, -1, pr_compat},
    {12495, 12495, 0, -1, -1, pr_compat},
    {12498, 12498, 0, -1, -1, pr_compat},
    {12501, 12501, 0, -1, -1, pr_compat},
    {12504, 12504, 0, -1, -1, pr_compat},
    {12507, 12507, 0, -1, -1, pr_compat},
    {12510, 12510, 0, -1, -1, pr_compat},
    {12511, 12511, 0, -1, -1, pr_compat},
    {12512, 12512, 0, -1, -1, pr_compat},
    {12513, 12513, 0, -1, -1, pr_compat},
    {12514, 12514, 0, -1, -1, pr_compat},
    {12516, 12516, 0, -1, -1, pr_compat},
    {12518, 12518, 0, -1, -1, pr_compat},
    {12520, 12520, 0, -1, -1, pr_compat},
    {12521, 12521, 0, -1, -1, pr_compat},
    {12522, 12522, 0, -1, -1, pr_compat},
    {12523, 12523, 0, -1, -1, pr_compat},
    {12524, 12524, 0, -1, -1, pr_compat},
    {12525, 12525, 0, -1, -1, pr_compat},
    {12527, 12527, 0, -1, -1, pr_compat},
    {12528, 12528, 0, -1, -1, pr_compat},
    {12529, 12529, 0, -1, -1, pr_compat},
    {12530, 12530, 0, -1, -1, pr_compat},
    {-2785, -2785, 0, -1, -1, pr_compat},
    {-2789, -2789, 0, -1, -1, pr_compat},
    {-2793, -2793, 0, -1, -1, pr_compat},
    {-2797, -2797, 0, -1, -1, pr_compat},
    {-2800, -2800, 0, -1, -1, pr_compat},
    {-2804, -2804, 0, -1, -1, pr_compat},
    {-2807, -2807, 0, -1, -1, pr_compat},
    {-2810, -2810, 0, -1, -1, pr_compat},
    {-2815, -2815, 0, -1, -1, pr_compat},
    {-2819, -2819, 0, -1, -1, pr_compat},
    {-2822, -2822, 0, -1, -1, pr_compat},
    {-2825, -2825, 0, -1, -1, pr_compat},
    {-2828, -2828, 0, -1, -1, pr_compat},
    {-2832, -2832, 0, -1, -1, pr_compat},
    {-2836, -2836, 0, -1, -1, pr_compat},
    {-2839, -2839, 0, -1, -1, pr_compat},
    {-2842, -2842, 0, -1, -1, pr_compat},
    {-2844, -2844, 0, -1, -1, pr_compat},
    {-2847, -2847, 0, -1, -1, pr_compat},
    {-2851, -2851, 0, -1, -1, pr_compat},
    {-2855, -2855, 0, -1, -1, pr_compat},
    {-2857, -2857, 0, -1, -1, pr_compat},
    {-2862, -2862, 0, -1, -1, pr_compat},
    {-2868, -2868, 0, -1, -1, pr_compat},
    {-2873, -2873, 0, -1, -1, pr_compat},
    {-2876, -2876, 0, -1, -1, pr_compat},
    {-2881, -2881, 0, -1, -1, pr_compat},
    {-2886, -2886, 0, -1, -1, pr_compat},
    {-2890, -2890, 0, -1, -1, pr_compat},
    {-2893, -2893, 0, -1, -1, pr_compat},
    {-2896, -2896, 0, -1, -1, pr_compat},
    {-2899, -2899, 0, -1, -1, pr_compat},
    {-2903, -2903, 0, -1, -1, pr_compat},
    {-2908, -2908, 0, -1, -1, pr_compat},
    {-2912, -2912, 0, -1, -1, pr_compat},
    {-2915, -2915, 0, -1, -1, pr_compat},
    {-2918, -2918, 0, -1, -1, pr_compat},
    {-2921, -2921, 0, -1, -1, pr_compat},
    {-2923, -2923, 0, -1, -1, pr_compat},
    {-2925, -2925, 0, -1, -1, pr_compat},
    {-2927, -2927, 0, -1, -1, pr_compat},
    {-2929, -2929, 0, -1, -1, pr_compat},
    {-2932, -2932, 0, -1, -1, pr_compat},
    {-2935, -2935, 0, -1, -1, pr_compat},
    {-2940, -2940, 0, -1, -1, pr_compat},
    {-2943, -2943, 0, -1, -1, pr_compat},
    {-2947, -2947, 0, -1, -1, pr_compat},
    {-2952, -2952, 0, -1, -1, pr_compat},
    {-2955, -2955, 0, -1, -1, pr_compat},
    {-2957, -2957, 0, -1, -1, pr_compat},
    {-2959, -2959, 0, -1, -1, pr_compat},
    {-2964, -2964, 0, -1, -1, pr_compat},
    {-2968, -2968, 0, -1, -1, pr_compat},
    {-2973, -2973, 0, -1, -1, pr_compat},
    {-2976, -2976, 0, -1, -1, pr_compat},
    {-2981, -2981, 0, -1, -1, pr_compat},
    {-2983, -2983, 0, -1, -1, pr_compat},
    {-2986, -2986, 0, -1, -1, pr_compat},
    {-2989, -2989, 0, -1, -1, pr_compat},
    {-2992, -2992, 0, -1, -1, pr_compat},
    {-2995, -2995, 0, -1, -1, pr_compat},
    {-2998, -2998, 0, -1, -1, pr_compat},
    {-3002, -3002, 0, -1, -1, pr_compat},
    {-3005, -3005, 0, -1, -1, pr_compat},
    {-3007, -3007, 0, -1, -1, pr_compat},
    {-3010, -3010, 0, -1, -1, pr_compat},
    {-3013, -3013, 0, -1, -1, pr_compat},
    {-3016, -3016, 0, -1, -1, pr_compat},
    {-3020, -3020, 0, -1, -1, pr_compat},
    {-3023, -3023, 0, -1, -1, pr_compat},
    {-3026, -3026, 0, -1, -1, pr_compat},
    {-3029, -3029, 0, -1, -1, pr_compat},
    {-3034, -3034, 0, -1, -1, pr_compat},
    {-3038, -3038, 0, -1, -1, pr_compat},
    {-3040, -3040, 0, -1, -1, pr_compat},
    {-3045, -3045, 0, -1, -1, pr_compat},
    {-3047, -3047, 0, -1, -1, pr_compat},
    {-3051, -3051, 0, -1, -1, pr_compat},
    {-3055, -3055, 0, -1, -1, pr_compat},
    {-3058, -3058, 0, -1, -1, pr_compat},
    {-3061, -3061, 0, -1, -1, pr_compat},
    {-3064, -3064, 0, -1, -1, pr_compat},
    {-3068, -3068, 0, -1, -1, pr_compat},
    {-3070, -3070, 0, -1, -1, pr_compat},
    {-3073, -3073, 0, -1, -1, pr_compat},
    {-3077, -3077, 0, -1, -1, pr_compat},
    {-3079, -3079, 0, -1, -1, pr_compat},
    {-3084, -3084, 0, -1, -1, pr_compat},
    {-3087, -3087, 0, -1, -1, pr_compat},
    {-3089, -3089, 0, -1, -1, pr_compat},
    {-3091, -3091, 0, -1, -1, pr_compat},
    {-3093, -3093, 0, -1, -1, pr_compat},
    {-3095, -3095, 0, -1, -1, pr_compat},
    {-3097, -3097, 0, -1, -1, pr_compat},
    {-3099, -3099, 0, -1, -1, pr_compat},
    {-3101, -3101, 0, -1, -1, pr_compat},
    {-3103, -3103, 0, -1, -1, pr_compat},
    {-3105, -3105, 0, -1, -1, pr_compat},
    {-3107, -3107, 0, -1, -1, pr_compat},
    {-3110, -3110, 0, -1, -1, pr_compat},
    {-3113, -3113, 0, -1, -1, pr_compat},
    {-3116, -3116, 0, -1, -1, pr_compat},
    {-3119, -3119, 0, -1, -1, pr_compat},
    {-3122, -3122, 0, -1, -1, pr_compat},
    {-3125, -3125, 0, -1, -1, pr_compat},
    {-3128, -3128, 0, -1, -1, pr_compat},
    {-3131, -3131, 0, -1, -1, pr_compat},
    {-3134, -3134, 0, -1, -1, pr_compat},
    {-3137, -3137, 0, -1, -1, pr_compat},
    {-3140, -3140, 0, -1, -1, pr_compat},
    {-3143, -3143, 0, -1, -1, pr_compat},
    {-3146, -3146, 0, -1, -1, pr_compat},
    {-3149, -3149, 0, -1, -1, pr_compat},
    {-3152, -4627, 0, -1, -1, pr_compat},
    {-3155, -3155, 0, -1, -1, pr_compat},
    {-3157, -4630, 0, -1, -1, pr_compat},
    {-3159, -3159, 0, -1, -1, pr_compat},
    {-3162, -4632, 0, -1, -1, pr_compat},
    {-3164, -3164, 0, -1, -1, pr_compat},
    {-3166, -3166, 0, -1, -1, pr_compat},
    {-3168, -4634, 0, -1, -1, pr_compat},
    {-3171, -4637, 0, -1, -1, pr_compat},
    {-3174, -4640, 0, -1, -1, pr_compat},
    {-3176, -3176, 0, -1, -1, pr_compat},
    {-3178, -3178, 0, -1, -1, pr_compat},
    {-3180, -3180, 0, -1, -1, pr_compat},
    {-3182, -3182, 0, -1, -1, pr_compat},
    {-3184, -3184, 0, -1, -1, pr_compat},
    {-3188, -4642, 0, -1, -1, pr_compat},
    {-3190, -4644, 0, -1, -1, pr_compat},
    {-3192, -4646, 0, -1, -1, pr_compat},
    {-3194, -4648, 0, -1, -1, pr_compat},
    {-3196, -4650, 0, -1, -1, pr_compat},
    {-3198, -4652, 0, -1, -1, pr_compat},
    {-3200, -3389, 0, -1, -1, pr_compat},
    {-3202, -4654, 0, -1, -1, pr_compat},
    {-3204, -3204, 0, -1, -1, pr_compat},
    {-3207, -3207, 0, -1, -1, pr_compat},
    {-3211, -4656, 0, -1, -1, pr_compat},
    {-3213, -4658, 0, -1, -1, pr_compat},
    {-3215, -4660, 0, -1, -1, pr_compat},
    {-3217, -3217, 0, -1, -1, pr_compat},
    {-3219, -3219, 0, -1, -1, pr_compat},
    {-3221, -3221, 0, -1, -1, pr_compat},
    {-3223, -4662, 0, -1, -1, pr_compat},
    {-3225, -4664, 0, -1, -1, pr_compat},
    {-3228, -4667, 0, -1, -1, pr_compat},
    {-3231, -4670, 0, -1, -1, pr_compat},
    {-3234, -4673, 0, -1, -1, pr_compat},
    {-3237, -4676, 0, -1, -1, pr_compat},
    {-3239, -4678, 0, -1, -1, pr_compat},
    {-3241, -4680, 0, -1, -1, pr_compat},
    {-3243, -4682, 0, -1, -1, pr_compat},
    {-3245, -3245, 0, -1, -1, pr_compat},
    {-3247, -3247, 0, -1, -1, pr_compat},
    {-3249, -3249, 0, -1, -1, pr_compat},
    {-3251, -3251, 0, -1, -1, pr_compat},
    {-3253, -3253, 0, -1, -1, pr_compat},
    {-3255, -3255, 0, -1, -1, pr_compat},
    {-3257, -4684, 0, -1, -1, pr_compat},
    {-3260, -4687, 0, -1, -1, pr_compat},
    {-3263, -4690, 0, -1, -1, pr_compat},
    {-3265, -4692, 0, -1, -1, pr_compat},
    {-3268, -4695, 0, -1, -1, pr_compat},
    {-3271, -4698, 0, -1, -1, pr_compat},
    {-3274, -4701, 0, -1, -1, pr_compat},
    {-3276, -4703, 0, -1, -1, pr_compat},
    {-3279, -3279, 0, -1, -1, pr_compat},
    {-3282, -4706, 0, -1, -1, pr_compat},
    {-3286, -4642, 0, -1, -1, pr_compat},
    {-3288, -4710, 0, -1, -1, pr_compat},
    {-3291, -4713, 0, -1, -1, pr_compat},
    {-3294, -4716, 0, -1, -1, pr_compat},
    {-3297, -3297, 0, -1, -1, pr_compat},
    {-3300, -3300, 0, -1, -1, pr_compat},
    {-3305, -4719, 0, -1, -1, pr_compat},
    {-3311, -3311, 0, -1, -1, pr_compat},
    {-3313, -3313, 0, -1, -1, pr_compat},
    {-3315, -3315, 0, -1, -1, pr_compat},
    {-3317, -3317, 0, -1, -1, pr_compat},
    {-3319, -4725, 0, -1, -1, pr_compat},
    {-3321, -4727, 0, -1, -1, pr_compat},
    {-3323, -4729, 0, -1, -1, pr_compat},
    {-3325, -4731, 0, -1, -1, pr_compat},
    {-3327, -4733, 0, -1, -1, pr_compat},
    {-3331, -4735, 0, -1, -1, pr_compat},
    {-3333, -4737, 0, -1, -1, pr_compat},
    {-3335, -4739, 0, -1, -1, pr_compat},
    {-3337, -4741, 0, -1, -1, pr_compat},
    {-3339, -4743, 0, -1, -1, pr_compat},
    {-3341, -4741, 0, -1, -1, pr_compat},
    {-3343, -4745, 0, -1, -1, pr_compat},
    {-3345, -4747, 0, -1, -1, pr_compat},
    {-3347, -3347, 0, -1, -1, pr_compat},
    {-3351, -4749, 0, -1, -1, pr_compat},
    {-3353, -3353, 0, -1, -1, pr_compat},
    {-3355, -3355, 0, -1, -1, pr_compat},
    {-3357, -4751, 0, -1, -1, pr_compat},
    {-3361, -4755, 0, -1, -1, pr_compat},
    {-3364, -4758, 0, -1, -1, pr_compat},
    {-3366, -4760, 0, -1, -1, pr_compat},
    {-3368, -3368, 0, -1, -1, pr_compat},
    {-3370, -4762, 0, -1, -1, pr_compat},
    {-3372, -3372, 0, -1, -1, pr_compat},
    {-3374, -4764, 0, -1, -1, pr_compat},
    {-3376, -3255, 0, -1, -1, pr_compat},
    {-3378, -3378, 0, -1, -1, pr_compat},
    {-3380, -3380, 0, -1, -1, pr_compat},
    {-3382, -3382, 0, -1, -1, pr_compat},
    {-3384, -3384, 0, -1, -1, pr_compat},
    {-3387, -3387, 0, -1, -1, pr_compat},
    {-3389, -3389, 0, -1, -1, pr_compat},
    {-3391, -3391, 0, -1, -1, pr_compat},
    {-3394, -3394, 0, -1, -1, pr_compat},
    {-3397, -4766, 0, -1, -1, pr_compat},
    {-3399, -3399, 0, -1, -1, pr_compat},
    {-3403, -4768, 0, -1, -1, pr_compat},
    {-3406, -4771, 0, -1, -1, pr_compat},
    {-3408, -3408, 0, -1, -1, pr_compat},
    {-3410, -4773, 0, -1, -1, pr_compat},
    {-3412, -4775, 0, -1, -1, pr_compat},
    {-3414, -4777, 0, -1, -1, pr_compat},
    {-3417, -4780, 0, -1, -1, pr_compat},
    {-3420, -3420, 0, -1, -1, pr_compat},
    {-3422, -3422, 0, -1, -1, pr_compat},
    {-3424, -3424, 0, -1, -1, pr_compat},
    {-3426, -3426, 0, -1, -1, pr_compat},
    {-3428, -3428, 0, -1, -1, pr_compat},
    {-3430, -3430, 0, -1, -1, pr_compat},
    {-3432, -3432, 0, -1, -1, pr_compat},
    {-3434, -3434, 0, -1, -1, pr_compat},
    {-3436, -3436, 0, -1, -1, pr_compat},
    {-3438, -3438, 0, -1, -1, pr_compat},
    {-3441, -3441, 0, -1, -1, pr_compat},
    {-3444, -3444, 0, -1, -1, pr_compat},
    {-3447, -3447, 0, -1, -1, pr_compat},
    {-3450, -3450, 0, -1, -1, pr_compat},
    {-3453, -3453, 0, -1, -1, pr_compat},
    {-3456, -3456, 0, -1, -1, pr_compat},
    {-3459, -3459, 0, -1, -1, pr_compat},
    {-3462, -3462, 0, -1, -1, pr_compat},
    {-3465, -3465, 0, -1, -1, pr_compat},
    {-3468, -3468, 0, -1, -1, pr_compat},
    {-3471, -3471, 0, -1, -1, pr_compat},
    {-3474, -3474, 0, -1, -1, pr_compat},
    {-3477, -3477, 0, -1, -1, pr_compat},
    {-3480, -3480, 0, -1, -1, pr_compat},
    {-3483, -3483, 0, -1, -1, pr_compat},
    {-3486, -3486, 0, -1, -1, pr_compat},
    {-3489, -3489, 0, -1, -1, pr_compat},
    {-3492, -3492, 0, -1, -1, pr_compat},
    {-3495, -3495, 0, -1, -1, pr_compat},
    {-3498, -3498, 0, -1, -1, pr_compat},
    {-3501, -3501, 0, -1, -1, pr_compat},
    {-3504, -3504, 0, -1, -1, pr_compat},
    {0, -16945, 0, -1, -1, id_Start},
    {0, -16946, 0, -1, -1, id_Start},
    {0, -16947, 0, -1, -1, id_Start},
    {0, -16948, 0, -1, -1, id_Start},
    {0, -16949, 0, -1, -1, id_Start},
    {0, -16950, 0, -1, -1, id_Start},
    {0, -16951, 0, -1, -1, id_Start},
    {0, -16952, 0, -1, -1, id_Start},
    {0, -16953, 0, -1, -1, id_Start},
    {0, -16954, 0, -1, -1, id_Start},
    {0, -16955, 0, -1, -1, id_Start},
    {0, -16956, 0, -1, -1, id_Start},
    {0, -16957, 0, -1, -1, id_Start},
    {0, -16958, 0, -1, -1, id_Start},
    {0, -16959, 0, -1, -1, id_Start},
    {0, -16960, 0, -1, -1, id_Start},
    {0, -16961, 0, -1, -1, id_Start},
    {0, -16962, 0, -1, -1, id_Start},
    {0, -16963, 0, -1, -1, id_Start},
    {0, -16964, 0, -1, -1, id_Start},
    {0, -16965, 0, -1, -1, id_Start},
    {0, -16966, 0, -1, -1, id_Start},
    {0, -16967, 0, -1, -1, id_Start},
    {0, -16968, 0, -1, -1, id_Start},
    {0, -16969, 0, -1, -1, id_Start},
    {0, -16970, 0, -1, -1, id_Start},
    {0, -16971, 0, -1, -1, id_Start},
    {0, -16972, 0, -1, -1, id_Start},
    {0, -16973, 0, -1, -1, id_Start},
    {0, -16974, 0, -1, -1, id_Start},
    {0, -16975, 0, -1, -1, id_Start},
    {0, -16976, 0, -1, -1, id_Start},
    {0, -16977, 0, -1, -1, id_Start},
    {0, -16978, 0, -1, -1, id_Start},
    {0, -16979, 0, -1, -1, id_Start},
    {0, -16980, 0, -1, -1, id_Start},
    {1098, 1098, 0, -1, -1, pr_compat | id_Start},
    {1100, 1100, 0, -1, -1, pr_compat | id_Start},
    {0, -16981, 0, -1, -1, id_Start},
    {0, -16982, 0, -1, -1, id_Start},
    {0, -16496, 0, -1, -1, id_Start},
    {0, -16983, 0, -1, -1, id_Start},
    {0, -16984, 0, -1, -1, id_Start},
    {0, -16985, 0, -1, -1, id_Start},
    {0, -16986, 0, -1, -1, id_Start},
    {0, -16987, 0, -1, -1, id_Start},
    {0, -16988, 0, -1, -1, id_Start},
    {0, -16989, 0, -1, -1, id_Start},
    {0, -16990, 0, -1, -1, id_Start},
    {0, -16991, 0, -1, -1, id_Start},
    {0, -16992, 0, -1, -1, id_Start},
    {0, -16993, 0, -1, -1, id_Start},
    {0, -16994, 0, -1, -1, id_Start},
    {0, -16995, 0, -1, -1, id_Start},
    {0, -16996, 0, -1, -1, id_Start},
    {0, -16997, 0, -1, -1, id_Start},
    {0, -16998, 0, -1, -1, id_Start},
    {0, -16999, 0, -1, -1, id_Start},
    {0, -17000, 0, -1, -1, id_Start},
    {0, -17001, 0, -1, -1, id_Start},
    {0, -17002, 0, -1, -1, id_Start},
    {0, -17003, 0, -1, -1, id_Start},
    {0, -17004, 0, -1, -1, id_Start},
    {0, -17005, 0, -1, -1, id_Start},
    {0, -17006, 0, -1, -1, id_Start},
    {0, -17007, 0, -1, -1, id_Start},
    {0, -17008, 0, -1, -1, id_Start},
    {0, -17009, 0, -1, -1, id_Start},
    {0, -17010, 0, -1, -1, id_Start},
    {0, -17011, 0, -1, -1, id_Start},
    {0, -17012, 0, -1, -1, id_Start},
    {0, -17013, 0, -1, -1, id_Start},
    {0, -17014, 0, -1, -1, id_Start},
    {0, -17015, 0, -1, -1, id_Start},
    {0, -17016, 0, -1, -1, id_Start},
    {0, -16495, 0, -1, -1, id_Start},
    {-16495, -16495, 0, -1, -1, pr_compat | id_Start},
    {0, -17017, 0, -1, -1, id_Start},
    {0, -17018, 0, -1, -1, id_Start},
    {0, 7545, 0, -1, -1, id_Start},
    {0, -17019, 0, -1, -1, id_Start},
    {0, -17020, 0, -1, -1, id_Start},
    {0, -17021, 0, -1, -1, id_Start},
    {0, -17022, 0, -1, -1, id_Start},
    {0, -17023, 0, -1, -1, id_Start},
    {0, -17024, 0, -1, -1, id_Start},
    {0, 613, 0, -1, -1, id_Start},
    {0, -17025, 0, -1, -1, id_Start},
    {0, -17026, 0, -1, -1, id_Start},
    {0, -17027, 0, -1, -1, id_Start},
    {0, -17028, 0, -1, -1, id_Start},
    {0, -17029, 0, -1, -1, id_Start},
    {0, -17030, 0, -1, -1, id_Start},
    {0, -17031, 0, -1, -1, id_Start},
    {0, -17032, 0, -1, -1, id_Start},
    {0, -17033, 0, -1, -1, id_Start},
    {0, -17034, 0, -1, -1, id_Start},
    {0, -17035, 0, -1, -1, id_Start},
    {0, -17036, 0, -1, -1, id_Start},
    {0, 614, 0, -1, -1, id_Start},
    {0, 604, 0, -1, -1, id_Start},
    {0, 609, 0, -1, -1, id_Start},
    {0, 620, 0, -1, -1, id_Start},
    {0, 618, 0, -1, -1, id_Start},
    {0, 670, 0, -1, -1, id_Start},
    {0, 647, 0, -1, -1, id_Start},
    {0, 669, 0, -1, -1, id_Start},
    {0, -17037, 0, -1, -1, id_Start},
    {0, -17038, 0, -1, -1, id_Start},
    {0, -17039, 0, -1, -1, id_Start},
    {0, -17040, 0, -1, -1, id_Start},
    {294, 295, 0, -1, -1, pr_compat | id_Start},
    {339, 339, 0, -1, -1, pr_compat | id_Start},
    {-16496, -16496, 0, -1, -1, pr_compat | id_Start},
    {-16497, -16497, 0, -1, -1, pr_compat | id_Start},
    {619, 619, 0, -1, -1, pr_compat | id_Start},
    {-16498, -16498, 0, -1, -1, pr_compat | id_Start},
    {0, 5024, 0, -1, -1, id_Start},
    {0, 5025, 0, -1, -1, id_Start},
    {0, 5026, 0, -1, -1, id_Start},
    {0, 5027, 0, -1, -1, id_Start},
    {0, 5028, 0, -1, -1, id_Start},
    {0, 5029, 0, -1, -1, id_Start},
    {0, 5030, 0, -1, -1, id_Start},
    {0, 5031, 0, -1, -1, id_Start},
    {0, 5032, 0, -1, -1, id_Start},
    {0, 5033, 0, -1, -1, id_Start},
    {0, 5034, 0, -1, -1, id_Start},
    {0, 5035, 0, -1, -1, id_Start},
    {0, 5036, 0, -1, -1, id_Start},
    {0, 5037, 0, -1, -1, id_Start},
    {0, 5038, 0, -1, -1, id_Start},
    {0, 5039, 0, -1, -1, id_Start},
    {0, 5040, 0, -1, -1, id_Start},
    {0, 5041, 0, -1, -1, id_Start},
    {0, 5042, 0, -1, -1, id_Start},
    {0, 5043, 0, -1, -1, id_Start},
    {0, 5044, 0, -1, -1, id_Start},
    {0, 5045, 0, -1, -1, id_Start},
    {0, 5046, 0, -1, -1, id_Start},
    {0, 5047, 0, -1, -1, id_Start},
    {0, 5048, 0, -1, -1, id_Start},
    {0, 5049, 0, -1, -1, id_Start},
    {0, 5050, 0, -1, -1, id_Start},
    {0, 5051, 0, -1, -1, id_Start},
    {0, 5052, 0, -1, -1, id_Start},
    {0, 5053, 0, -1, -1, id_Start},
    {0, 5054, 0, -1, -1, id_Start},
    {0, 5055, 0, -1, -1, id_Start},
    {0, 5056, 0, -1, -1, id_Start},
    {0, 5057, 0, -1, -1, id_Start},
    {0, 5058, 0, -1, -1, id_Start},
    {0, 5059, 0, -1, -1, id_Start},
    {0, 5060, 0, -1, -1, id_Start},
    {0, 5061, 0, -1, -1, id_Start},
    {0, 5062, 0, -1, -1, id_Start},
    {0, 5063, 0, -1, -1, id_Start},
    {0, 5064, 0, -1, -1, id_Start},
    {0, 5065, 0, -1, -1, id_Start},
    {0, 5066, 0, -1, -1, id_Start},
    {0, 5067, 0, -1, -1, id_Start},
    {0, 5068, 0, -1, -1, id_Start},
    {0, 5069, 0, -1, -1, id_Start},
    {0, 5070, 0, -1, -1, id_Start},
    {0, 5071, 0, -1, -1, id_Start},
    {0, 5072, 0, -1, -1, id_Start},
    {0, 5073, 0, -1, -1, id_Start},
    {0, 5074, 0, -1, -1, id_Start},
    {0, 5075, 0, -1, -1, id_Start},
    {0, 5076, 0, -1, -1, id_Start},
    {0, 5077, 0, -1, -1, id_Start},
    {0, 5078, 0, -1, -1, id_Start},
    {0, 5079, 0, -1, -1, id_Start},
    {0, 5080, 0, -1, -1, id_Start},
    {0, 5081, 0, -1, -1, id_Start},
    {0, 5082, 0, -1, -1, id_Start},
    {0, 5083, 0, -1, -1, id_Start},
    {0, 5084, 0, -1, -1, id_Start},
    {0, 5085, 0, -1, -1, id_Start},
    {0, 5086, 0, -1, -1, id_Start},
    {0, 5087, 0, -1, -1, id_Start},
    {0, 5088, 0, -1, -1, id_Start},
    {0, 5089, 0, -1, -1, id_Start},
    {0, 5090, 0, -1, -1, id_Start},
    {0, 5091, 0, -1, -1, id_Start},
    {0, 5092, 0, -1, -1, id_Start},
    {0, 5093, 0, -1, -1, id_Start},
    {0, 5094, 0, -1, -1, id_Start},
    {0, 5095, 0, -1, -1, id_Start},
    {0, 5096, 0, -1, -1, id_Start},
    {0, 5097, 0, -1, -1, id_Start},
    {0, 5098, 0, -1, -1, id_Start},
    {0, 5099, 0, -1, -1, id_Start},
    {0, 5100, 0, -1, -1, id_Start},
    {0, 5101, 0, -1, -1, id_Start},
    {0, 5102, 0, -1, -1, id_Start},
    {0, 5103, 0, -1, -1, id_Start},
    {-16499, -16499, 0, -1, -1, id_Start | qc_N},
    {26356, 26356, 0, -1, -1, id_Start | qc_N},
    {-16420, -16420, 0, -1, -1, id_Start | qc_N},
    {-16500, -16500, 0, -1, -1, id_Start | qc_N},
    {28369, 28369, 0, -1, -1, id_Start | qc_N},
    {20018, 20018, 0, -1, -1, id_Start | qc_N},
    {21477, 21477, 0, -1, -1, id_Start | qc_N},
    {22865, 22865, 0, -1, -1, id_Start | qc_N},
    {-16428, -16428, 0, -1, -1, id_Start | qc_N},
    {21895, 21895, 0, -1, -1, id_Start | qc_N},
    {22856, 22856, 0, -1, -1, id_Start | qc_N},
    {30313, 30313, 0, -1, -1, id_Start | qc_N},
    {32645, 32645, 0, -1, -1, id_Start | qc_N},
    {-16501, -16501, 0, -1, -1, id_Start | qc_N},
    {-16502, -16502, 0, -1, -1, id_Start | qc_N},
    {-16503, -16503, 0, -1, -1, id_Start | qc_N},
    {-16504, -16504, 0, -1, -1, id_Start | qc_N},
    {27931, 27931, 0, -1, -1, id_Start | qc_N},
    {28889, 28889, 0, -1, -1, id_Start | qc_N},
    {29662, 29662, 0, -1, -1, id_Start | qc_N},
    {-16505, -16505, 0, -1, -1, id_Start | qc_N},
    {-16506, -16506, 0, -1, -1, id_Start | qc_N},
    {-16507, -16507, 0, -1, -1, id_Start | qc_N},
    {20098, 20098, 0, -1, -1, id_Start | qc_N},
    {21365, 21365, 0, -1, -1, id_Start | qc_N},
    {27396, 27396, 0, -1, -1, id_Start | qc_N},
    {29211, 29211, 0, -1, -1, id_Start | qc_N},
    {-16508, -16508, 0, -1, -1, id_Start | qc_N},
    {-16509, -16509, 0, -1, -1, id_Start | qc_N},
    {23888, 23888, 0, -1, -1, id_Start | qc_N},
    {28651, 28651, 0, -1, -1, id_Start | qc_N},
    {-16510, -16510, 0, -1, -1, id_Start | qc_N},
    {-16511, -16511, 0, -1, -1, id_Start | qc_N},
    {25289, 25289, 0, -1, -1, id_Start | qc_N},
    {-16512, -16512, 0, -1, -1, id_Start | qc_N},
    {-16513, -16513, 0, -1, -1, id_Start | qc_N},
    {28010, 28010, 0, -1, -1, id_Start | qc_N},
    {29436, 29436, 0, -1, -1, id_Start | qc_N},
    {-16514, -16514, 0, -1, -1, id_Start | qc_N},
    {20358, 20358, 0, -1, -1, id_Start | qc_N},
    {20919, 20919, 0, -1, -1, id_Start | qc_N},
    {21214, 21214, 0, -1, -1, id_Start | qc_N},
    {25796, 25796, 0, -1, -1, id_Start | qc_N},
    {27347, 27347, 0, -1, -1, id_Start | qc_N},
    {29200, 29200, 0, -1, -1, id_Start | qc_N},
    {30439, 30439, 0, -1, -1, id_Start | qc_N},
    {-16386, -16386, 0, -1, -1, id_Start | qc_N},
    {-16515, -16515, 0, -1, -1, id_Start | qc_N},
    {-16517, -16517, 0, -1, -1, id_Start | qc_N},
    {-16518, -16518, 0, -1, -1, id_Start | qc_N},
    {-16519, -16519, 0, -1, -1, id_Start | qc_N},
    {-16520, -16520, 0, -1, -1, id_Start | qc_N},
    {31103, 31103, 0, -1, -1, id_Start | qc_N},
    {32160, 32160, 0, -1, -1, id_Start | qc_N},
    {-16521, -16521, 0, -1, -1, id_Start | qc_N},
    {-16522, -16522, 0, -1, -1, id_Start | qc_N},
    {-16459, -16459, 0, -1, -1, id_Start | qc_N},
    {-16523, -16523, 0, -1, -1, id_Start | qc_N},
    {22751, 22751, 0, -1, -1, id_Start | qc_N},
    {24324, 24324, 0, -1, -1, id_Start | qc_N},
    {31840, 31840, 0, -1, -1, id_Start | qc_N},
    {-16524, -16524, 0, -1, -1, id_Start | qc_N},
    {29282, 29282, 0, -1, -1, id_Start | qc_N},
    {30922, 30922, 0, -1, -1, id_Start | qc_N},
    {-16525, -16525, 0, -1, -1, id_Start | qc_N},
    {-16526, -16526, 0, -1, -1, id_Start | qc_N},
    {22744, 22744, 0, -1, -1, id_Start | qc_N},
    {23650, 23650, 0, -1, -1, id_Start | qc_N},
    {27155, 27155, 0, -1, -1, id_Start | qc_N},
    {28122, 28122, 0, -1, -1, id_Start | qc_N},
    {28431, 28431, 0, -1, -1, id_Start | qc_N},
    {32047, 32047, 0, -1, -1, id_Start | qc_N},
    {32311, 32311, 0, -1, -1, id_Start | qc_N},
    {-16527, -16527, 0, -1, -1, id_Start | qc_N},
    {21202, 21202, 0, -1, -1, id_Start | qc_N},
    {-16528, -16528, 0, -1, -1, id_Start | qc_N},
    {20956, 20956, 0, -1, -1, id_Start | qc_N},
    {20940, 20940, 0, -1, -1, id_Start | qc_N},
    {31260, 31260, 0, -1, -1, id_Start | qc_N},
    {32190, 32190, 0, -1, -1, id_Start | qc_N},
    {-16529, -16529, 0, -1, -1, id_Start | qc_N},
    {-16530, -16530, 0, -1, -1, id_Start | qc_N},
    {-16531, -16531, 0, -1, -1, id_Start | qc_N},
    {25295, 25295, 0, -1, -1, id_Start | qc_N},
    {20025, 20025, 0, -1, -1, id_Start | qc_N},
    {24594, 24594, 0, -1, -1, id_Start | qc_N},
    {30971, 30971, 0, -1, -1, id_Start | qc_N},
    {20415, 20415, 0, -1, -1, id_Start | qc_N},
    {24489, 24489, 0, -1, -1, id_Start | qc_N},
    {19981, 19981, 0, -1, -1, id_Start | qc_N},
    {27852, 27852, 0, -1, -1, id_Start | qc_N},
    {25976, 25976, 0, -1, -1, id_Start | qc_N},
    {32034, 32034, 0, -1, -1, id_Start | qc_N},
    {21443, 21443, 0, -1, -1, id_Start | qc_N},
    {22622, 22622, 0, -1, -1, id_Start | qc_N},
    {30465, 30465, 0, -1, -1, id_Start | qc_N},
    {-16533, -16533, 0, -1, -1, id_Start | qc_N},
    {-16422, -16422, 0, -1, -1, id_Start | qc_N},
    {27784, 27784, 0, -1, -1, id_Start | qc_N},
    {25342, 25342, 0, -1, -1, id_Start | qc_N},
    {25504, 25504, 0, -1, -1, id_Start | qc_N},
    {30053, 30053, 0, -1, -1, id_Start | qc_N},
    {20142, 20142, 0, -1, -1, id_Start | qc_N},
    {20841, 20841, 0, -1, -1, id_Start | qc_N},
    {20937, 20937, 0, -1, -1, id_Start | qc_N},
    {26753, 26753, 0, -1, -1, id_Start | qc_N},
    {31975, 31975, 0, -1, -1, id_Start | qc_N},
    {-16536, -16536, 0, -1, -1, id_Start | qc_N},
    {-16537, -16537, 0, -1, -1, id_Start | qc_N},
    {-16538, -16538, 0, -1, -1, id_Start | qc_N},
    {21237, 21237, 0, -1, -1, id_Start | qc_N},
    {21570, 21570, 0, -1, -1, id_Start | qc_N},
    {22899, 22899, 0, -1, -1, id_Start | qc_N},
    {24300, 24300, 0, -1, -1, id_Start | qc_N},
    {26053, 26053, 0, -1, -1, id_Start | qc_N},
    {28670, 28670, 0, -1, -1, id_Start | qc_N},
    {31018, 31018, 0, -1, -1, id_Start | qc_N},
    {-16539, -16539, 0, -1, -1, id_Start | qc_N},
    {-16540, -16540, 0, -1, -1, id_Start | qc_N},
    {-16541, -16541, 0, -1, -1, id_Start | qc_N},
    {-16542, -16542, 0, -1, -1, id_Start | qc_N},
    {21147, 21147, 0, -1, -1, id_Start | qc_N},
    {26310, 26310, 0, -1, -1, id_Start | qc_N},
    {27511, 27511, 0, -1, -1, id_Start | qc_N},
    {-16543, -16543, 0, -1, -1, id_Start | qc_N},
    {24180, 24180, 0, -1, -1, id_Start | qc_N},
    {24976, 24976, 0, -1, -1, id_Start | qc_N},
    {25088, 25088, 0, -1, -1, id_Start | qc_N},
    {25754, 25754, 0, -1, -1, id_Start | qc_N},
    {28451, 28451, 0, -1, -1, id_Start | qc_N},
    {29001, 29001, 0, -1, -1, id_Start | qc_N},
    {29833, 29833, 0, -1, -1, id_Start | qc_N},
    {31178, 31178, 0, -1, -1, id_Start | qc_N},
    {-16544, -16544, 0, -1, -1, id_Start | qc_N},
    {-16545, -16545, 0, -1, -1, id_Start | qc_N},
    {-16546, -16546, 0, -1, -1, id_Start | qc_N},
    {-16547, -16547, 0, -1, -1, id_Start | qc_N},
    {-16548, -16548, 0, -1, -1, id_Start | qc_N},
    {21015, 21015, 0, -1, -1, id_Start | qc_N},
    {21155, 21155, 0, -1, -1, id_Start | qc_N},
    {21693, 21693, 0, -1, -1, id_Start | qc_N},
    {28872, 28872, 0, -1, -1, id_Start | qc_N},
    {-16549, -16549, 0, -1, -1, id_Start | qc_N},
    {24265, 24265, 0, -1, -1, id_Start | qc_N},
    {24565, 24565, 0, -1, -1, id_Start | qc_N},
    {25467, 25467, 0, -1, -1, id_Start | qc_N},
    {27566, 27566, 0, -1, -1, id_Start | qc_N},
    {31806, 31806, 0, -1, -1, id_Start | qc_N},
    {29557, 29557, 0, -1, -1, id_Start | qc_N},
    {20196, 20196, 0, -1, -1, id_Start | qc_N},
    {22265, 22265, 0, -1, -1, id_Start | qc_N},
    {23994, 23994, 0, -1, -1, id_Start | qc_N},
    {24604, 24604, 0, -1, -1, id_Start | qc_N},
    {29618, 29618, 0, -1, -1, id_Start | qc_N},
    {29801, 29801, 0, -1, -1, id_Start | qc_N},
    {32666, 32666, 0, -1, -1, id_Start | qc_N},
    {-16550, -16550, 0, -1, -1, id_Start | qc_N},
    {-16551, -16551, 0, -1, -1, id_Start | qc_N},
    {-16552, -16552, 0, -1, -1, id_Start | qc_N},
    {-16553, -16553, 0, -1, -1, id_Start | qc_N},
    {-16554, -16554, 0, -1, -1, id_Start | qc_N},
    {20363, 20363, 0, -1, -1, id_Start | qc_N},
    {31150, 31150, 0, -1, -1, id_Start | qc_N},
    {-16555, -16555, 0, -1, -1, id_Start | qc_N},
    {-16556, -16556, 0, -1, -1, id_Start | qc_N},
    {24801, 24801, 0, -1, -1, id_Start | qc_N},
    {20102, 20102, 0, -1, -1, id_Start | qc_N},
    {20698, 20698, 0, -1, -1, id_Start | qc_N},
    {23534, 23534, 0, -1, -1, id_Start | qc_N},
    {23615, 23615, 0, -1, -1, id_Start | qc_N},
    {26009, 26009, 0, -1, -1, id_Start | qc_N},
    {29134, 29134, 0, -1, -1, id_Start | qc_N},
    {30274, 30274, 0, -1, -1, id_Start | qc_N},
    {-16557, -16557, 0, -1, -1, id_Start | qc_N},
    {-16558, -16558, 0, -1, -1, id_Start | qc_N},
    {-16473, -16473, 0, -1, -1, id_Start | qc_N},
    {26248, 26248, 0, -1, -1, id_Start | qc_N},
    {-16559, -16559, 0, -1, -1, id_Start | qc_N},
    {21129, 21129, 0, -1, -1, id_Start | qc_N},
    {26491, 26491, 0, -1, -1, id_Start | qc_N},
    {26611, 26611, 0, -1, -1, id_Start | qc_N},
    {28316, 28316, 0, -1, -1, id_Start | qc_N},
    {29705, 29705, 0, -1, -1, id_Start | qc_N},
    {30041, 30041, 0, -1, -1, id_Start | qc_N},
    {30827, 30827, 0, -1, -1, id_Start | qc_N},
    {32016, 32016, 0, -1, -1, id_Start | qc_N},
    {-16560, -16560, 0, -1, -1, id_Start | qc_N},
    {20845, 20845, 0, -1, -1, id_Start | qc_N},
    {25134, 25134, 0, -1, -1, id_Start | qc_N},
    {-16561, -16561, 0, -1, -1, id_Start | qc_N},
    {20523, 20523, 0, -1, -1, id_Start | qc_N},
    {23833, 23833, 0, -1, -1, id_Start | qc_N},
    {28138, 28138, 0, -1, -1, id_Start | qc_N},
    {-16562, -16562, 0, -1, -1, id_Start | qc_N},
    {24459, 24459, 0, -1, -1, id_Start | qc_N},
    {24900, 24900, 0, -1, -1, id_Start | qc_N},
    {26647, 26647, 0, -1, -1, id_Start | qc_N},
    {-16563, -16563, 0, -1, -1, id_Start | qc_N},
    {21033, 21033, 0, -1, -1, id_Start | qc_N},
    {21519, 21519, 0, -1, -1, id_Start | qc_N},
    {23653, 23653, 0, -1, -1, id_Start | qc_N},
    {26131, 26131, 0, -1, -1, id_Start | qc_N},
    {26446, 26446, 0, -1, -1, id_Start | qc_N},
    {26792, 26792, 0, -1, -1, id_Start | qc_N},
    {27877, 27877, 0, -1, -1, id_Start | qc_N},
    {29702, 29702, 0, -1, -1, id_Start | qc_N},
    {30178, 30178, 0, -1, -1, id_Start | qc_N},
    {32633, 32633, 0, -1, -1, id_Start | qc_N},
    {-16564, -16564, 0, -1, -1, id_Start | qc_N},
    {-16565, -16565, 0, -1, -1, id_Start | qc_N},
    {-16427, -16427, 0, -1, -1, id_Start | qc_N},
    {-16566, -16566, 0, -1, -1, id_Start | qc_N},
    {21311, 21311, 0, -1, -1, id_Start | qc_N},
    {28346, 28346, 0, -1, -1, id_Start | qc_N},
    {21533, 21533, 0, -1, -1, id_Start | qc_N},
    {29136, 29136, 0, -1, -1, id_Start | qc_N},
    {29848, 29848, 0, -1, -1, id_Start | qc_N},
    {-16567, -16567, 0, -1, -1, id_Start | qc_N},
    {-16568, -16568, 0, -1, -1, id_Start | qc_N},
    {-16569, -16569, 0, -1, -1, id_Start | qc_N},
    {-16570, -16570, 0, -1, -1, id_Start | qc_N},
    {26519, 26519, 0, -1, -1, id_Start | qc_N},
    {28107, 28107, 0, -1, -1, id_Start | qc_N},
    {-16571, -16571, 0, -1, -1, id_Start | qc_N},
    {31435, 31435, 0, -1, -1, id_Start | qc_N},
    {31520, 31520, 0, -1, -1, id_Start | qc_N},
    {31890, 31890, 0, -1, -1, id_Start | qc_N},
    {29376, 29376, 0, -1, -1, id_Start | qc_N},
    {28825, 28825, 0, -1, -1, id_Start | qc_N},
    {-16572, -16572, 0, -1, -1, id_Start | qc_N},
    {20160, 20160, 0, -1, -1, id_Start | qc_N},
    {-16573, -16573, 0, -1, -1, id_Start | qc_N},
    {21050, 21050, 0, -1, -1, id_Start | qc_N},
    {24230, 24230, 0, -1, -1, id_Start | qc_N},
    {25299, 25299, 0, -1, -1, id_Start | qc_N},
    {31958, 31958, 0, -1, -1, id_Start | qc_N},
    {23429, 23429, 0, -1, -1, id_Start | qc_N},
    {27934, 27934, 0, -1, -1, id_Start | qc_N},
    {26292, 26292, 0, -1, -1, id_Start | qc_N},
    {-16574, -16574, 0, -1, -1, id_Start | qc_N},
    {-16405, -16405, 0, -1, -1, id_Start | qc_N},
    {-16575, -16575, 0, -1, -1, id_Start | qc_N},
    {-16408, -16408, 0, -1, -1, id_Start | qc_N},
    {24275, 24275, 0, -1, -1, id_Start | qc_N},
    {20800, 20800, 0, -1, -1, id_Start | qc_N},
    {21952, 21952, 0, -1, -1, id_Start | qc_N},
    {20958, 20958, 0, -1, -1, id_Start | qc_N},
    {31036, 31036, 0, -1, -1, id_Start | qc_N},
    {31070, 31070, 0, -1, -1, id_Start | qc_N},
    {31077, 31077, 0, -1, -1, id_Start | qc_N},
    {31934, 31934, 0, -1, -1, id_Start | qc_N},
    {32701, 32701, 0, -1, -1, id_Start | qc_N},
    {-16577, -16577, 0, -1, -1, id_Start | qc_N},
    {-16580, -16580, 0, -1, -1, id_Start | qc_N},
    {-16581, -16581, 0, -1, -1, id_Start | qc_N},
    {-16582, -16582, 0, -1, -1, id_Start | qc_N},
    {-16583, -16583, 0, -1, -1, id_Start | qc_N},
    {-16584, -16584, 0, -1, -1, id_Start | qc_N},
    {-16585, -16585, 0, -1, -1, id_Start | qc_N},
    {-16586, -16586, 0, -1, -1, id_Start | qc_N},
    {22120, 22120, 0, -1, -1, id_Start | qc_N},
    {22592, 22592, 0, -1, -1, id_Start | qc_N},
    {22696, 22696, 0, -1, -1, id_Start | qc_N},
    {23652, 23652, 0, -1, -1, id_Start | qc_N},
    {24936, 24936, 0, -1, -1, id_Start | qc_N},
    {26082, 26082, 0, -1, -1, id_Start | qc_N},
    {28186, 28186, 0, -1, -1, id_Start | qc_N},
    {29227, 29227, 0, -1, -1, id_Start | qc_N},
    {29730, 29730, 0, -1, -1, id_Start | qc_N},
    {30865, 30865, 0, -1, -1, id_Start | qc_N},
    {31038, 31038, 0, -1, -1, id_Start | qc_N},
    {31049, 31049, 0, -1, -1, id_Start | qc_N},
    {31048, 31048, 0, -1, -1, id_Start | qc_N},
    {31056, 31056, 0, -1, -1, id_Start | qc_N},
    {31069, 31069, 0, -1, -1, id_Start | qc_N},
    {31117, 31117, 0, -1, -1, id_Start | qc_N},
    {31118, 31118, 0, -1, -1, id_Start | qc_N},
    {31361, 31361, 0, -1, -1, id_Start | qc_N},
    {32265, 32265, 0, -1, -1, id_Start | qc_N},
    {32321, 32321, 0, -1, -1, id_Start | qc_N},
    {32626, 32626, 0, -1, -1, id_Start | qc_N},
    {-16588, -16588, 0, -1, -1, id_Start | qc_N},
    {-16591, -16591, 0, -1, -1, id_Start | qc_N},
    {-16595, -16595, 0, -1, -1, id_Start | qc_N},
    {-16597, -16597, 0, -1, -1, id_Start | qc_N},
    {24693, 24693, 0, -1, -1, id_Start | qc_N},
    {-16601, -16601, 0, -1, -1, id_Start | qc_N},
    {-16602, -16602, 0, -1, -1, id_Start | qc_N},
    {20006, 20006, 0, -1, -1, id_Start | qc_N},
    {20840, 20840, 0, -1, -1, id_Start | qc_N},
    {20352, 20352, 0, -1, -1, id_Start | qc_N},
    {20805, 20805, 0, -1, -1, id_Start | qc_N},
    {20864, 20864, 0, -1, -1, id_Start | qc_N},
    {21845, 21845, 0, -1, -1, id_Start | qc_N},
    {21986, 21986, 0, -1, -1, id_Start | qc_N},
    {22707, 22707, 0, -1, -1, id_Start | qc_N},
    {22852, 22852, 0, -1, -1, id_Start | qc_N},
    {22868, 22868, 0, -1, -1, id_Start | qc_N},
    {23138, 23138, 0, -1, -1, id_Start | qc_N},
    {23336, 23336, 0, -1, -1, id_Start | qc_N},
    {24274, 24274, 0, -1, -1, id_Start | qc_N},
    {24281, 24281, 0, -1, -1, id_Start | qc_N},
    {24425, 24425, 0, -1, -1, id_Start | qc_N},
    {24493, 24493, 0, -1, -1, id_Start | qc_N},
    {24792, 24792, 0, -1, -1, id_Start | qc_N},
    {24840, 24840, 0, -1, -1, id_Start | qc_N},
    {24928, 24928, 0, -1, -1, id_Start | qc_N},
    {25140, 25140, 0, -1, -1, id_Start | qc_N},
    {25540, 25540, 0, -1, -1, id_Start | qc_N},
    {25628, 25628, 0, -1, -1, id_Start | qc_N},
    {25682, 25682, 0, -1, -1, id_Start | qc_N},
    {25942, 25942, 0, -1, -1, id_Start | qc_N},
    {26454, 26454, 0, -1, -1, id_Start | qc_N},
    {27513, 27513, 0, -1, -1, id_Start | qc_N},
    {28379, 28379, 0, -1, -1, id_Start | qc_N},
    {30631, 30631, 0, -1, -1, id_Start | qc_N},
    {29359, 29359, 0, -1, -1, id_Start | qc_N},
    {29958, 29958, 0, -1, -1, id_Start | qc_N},
    {30011, 30011, 0, -1, -1, id_Start | qc_N},
    {30237, 30237, 0, -1, -1, id_Start | qc_N},
    {30239, 30239, 0, -1, -1, id_Start | qc_N},
    {30427, 30427, 0, -1, -1, id_Start | qc_N},
    {30528, 30528, 0, -1, -1, id_Start | qc_N},
    {31409, 31409, 0, -1, -1, id_Start | qc_N},
    {31867, 31867, 0, -1, -1, id_Start | qc_N},
    {32091, 32091, 0, -1, -1, id_Start | qc_N},
    {32574, 32574, 0, -1, -1, id_Start | qc_N},
    {-16603, -16603, 0, -1, -1, id_Start | qc_N},
    {-16604, -16604, 0, -1, -1, id_Start | qc_N},
    {-16606, -16606, 0, -1, -1, id_Start | qc_N},
    {-16607, -16607, 0, -1, -1, id_Start | qc_N},
    {-16608, -16608, 0, -1, -1, id_Start | qc_N},
    {-16609, -16609, 0, -1, -1, id_Start | qc_N},
    {-16613, -16613, 0, -1, -1, id_Start | qc_N},
    {-16614, -16614, 0, -1, -1, id_Start | qc_N},
    {-16615, -16615, 0, -1, -1, id_Start | qc_N},
    {-16616, -16616, 0, -1, -1, id_Start | qc_N},
    {-16617, -16617, 0, -1, -1, id_Start | qc_N},
    {-16620, -16620, 0, -1, -1, id_Start | qc_N},
    {-16621, -16621, 0, -1, -1, id_Start | qc_N},
    {-16622, -16622, 0, -1, -1, id_Start | qc_N},
    {16408, 16408, 0, -1, -1, id_Start | qc_N},
    {-16623, -16623, 0, -1, -1, id_Start | qc_N},
    {-16624, -16624, 0, -1, -1, id_Start | qc_N},
    {-16625, -16625, 0, -1, -1, id_Start | qc_N},
    {-16626, -16626, 0, -1, -1, id_Start | qc_N},
    {-16627, -16627, 0, -1, -1, id_Start | qc_N},
    {-3507, -3507, 0, -1, -1, pr_compat | id_Start},
    {-3509, -3509, 0, -1, -1, pr_compat | id_Start},
    {-3511, -3511, 0, -1, -1, pr_compat | id_Start},
    {-3513, -3513, 0, -1, -1, pr_compat | id_Start},
    {-3516, -3516, 0, -1, -1, pr_compat | id_Start},
    {-3519, -3521, 0, -1, -1, pr_compat | id_Start},
    {-3521, -3521, 0, -1, -1, pr_compat | id_Start},
    {-3523, -3523, 0, -1, -1, pr_compat | id_Start},
    {-3525, -3525, 0, -1, -1, pr_compat | id_Start},
    {-3527, -3527, 0, -1, -1, pr_compat | id_Start},
    {-3529, -3529, 0, -1, -1, pr_compat | id_Start},
    {-3531, -3531, 0, -1, -1, pr_compat | id_Start},
    {-3533, -3533, 0, -1, -1, id_Start | qc_N},
    {0, 0, 26, -1, -1, id_Continue},
    {-3535, -3535, 0, -1, -1, id_Start | qc_N},
    {1506, 1506, 0, -1, -1, pr_compat | id_Start},
    {1492, 1492, 0, -1, -1, pr_compat | id_Start},
    {1499, 1499, 0, -1, -1, pr_compat | id_Start},
    {1500, 1500, 0, -1, -1, pr_compat | id_Start},
    {1501, 1501, 0, -1, -1, pr_compat | id_Start},
    {1512, 1512, 0, -1, -1, pr_compat | id_Start},
    {1514, 1514, 0, -1, -1, pr_compat | id_Start},
    {-3537, -3537, 0, -1, -1, id_Start | qc_N},
    {-3539, -3539, 0, -1, -1, id_Start | qc_N},
    {-16628, -4783, 0, -1, -1, id_Start | qc_N},
    {-16630, -4786, 0, -1, -1, id_Start | qc_N},
    {-3541, -3541, 0, -1, -1, id_Start | qc_N},
    {-3543, -3543, 0, -1, -1, id_Start | qc_N},
    {-3545, -3545, 0, -1, -1, id_Start | qc_N},
    {-3547, -3547, 0, -1, -1, id_Start | qc_N},
    {-3549, -3549, 0, -1, -1, id_Start | qc_N},
    {-3551, -3551, 0, -1, -1, id_Start | qc_N},
    {-3553, -3553, 0, -1, -1, id_Start | qc_N},
    {-3555, -3555, 0, -1, -1, id_Start | qc_N},
    {-3557, -3557, 0, -1, -1, id_Start | qc_N},
    {-3559, -3559, 0, -1, -1, id_Start | qc_N},
    {-3561, -3561, 0, -1, -1, id_Start | qc_N},
    {-3563, -3563, 0, -1, -1, id_Start | qc_N},
    {-3565, -3565, 0, -1, -1, id_Start | qc_N},
    {-3567, -3567, 0, -1, -1, id_Start | qc_N},
    {-3569, -3569, 0, -1, -1, id_Start | qc_N},
    {-3571, -3571, 0, -1, -1, id_Start | qc_N},
    {-3573, -3573, 0, -1, -1, id_Start | qc_N},
    {-3575, -3575, 0, -1, -1, id_Start | qc_N},
    {-3577, -3577, 0, -1, -1, id_Start | qc_N},
    {-3579, -3579, 0, -1, -1, id_Start | qc_N},
    {-3581, -3581, 0, -1, -1, id_Start | qc_N},
    {-3583, -3583, 0, -1, -1, id_Start | qc_N},
    {-3585, -3585, 0, -1, -1, id_Start | qc_N},
    {-3587, -3587, 0, -1, -1, id_Start | qc_N},
    {-3589, -3589, 0, -1, -1, id_Start | qc_N},
    {-3591, -3591, 0, -1, -1, id_Start | qc_N},
    {-3593, -3593, 0, -1, -1, id_Start | qc_N},
    {-3595, -3595, 0, -1, -1, id_Start | qc_N},
    {-3597, -3597, 0, -1, -1, pr_compat | id_Start},
    {1655, -738, 0, -1, -1, pr_compat | id_Start},
    {-3647, -3647, 0, -1, -1, pr_compat | id_Start},
    {-3665, -3665, 0, -1, -1, pr_compat | id_Start},
    {-3759, -3759, 0, -1, -1, pr_compat | id_Start},
    {-3761, -3761, 0, -1, -1, pr_compat | id_Start},
    {-3779, -3779, 0, -1, -1, pr_compat | id_Start},
    {-3781, -3781, 0, -1, -1, pr_compat | id_Start},
    {-3795, -3795, 0, -1, -1, pr_compat | id_Start},
    {-3797, -3797, 0, -1, -1, pr_compat | id_Start},
    {-3801, -3801, 0, -1, -1, pr_compat},
    {-3804, -3804, 0, -1, -1, pr_compat},
    {-3807, -3807, 0, -1, -1, pr_compat},
    {-3810, -3810, 0, -1, -1, pr_compat},
    {-3813, -3813, 0, -1, -1, pr_compat},
    {-3816, -3816, 0, -1, -1, pr_compat},
    {-3819, -3819, 0, -1, -1, pr_compat | id_Start},
    {-3821, -3821, 0, -1, -1, pr_compat | id_Start},
    {-3823, -3823, 0, -1, -1, pr_compat | id_Start},
    {-3825, -3825, 0, -1, -1, pr_compat | id_Start},
    {-3827, -3827, 0, -1, -1, pr_compat | id_Start},
    {-3829, -3829, 0, -1, -1, pr_compat | id_Start},
    {-3831, -3831, 0, -1, -1, pr_compat | id_Start},
    {-3833, -3833, 0, -1, -1, pr_compat | id_Start},
    {-3835, -3835, 0, -1, -1, pr_compat | id_Start},
    {-3837, -3837, 0, -1, -1, pr_compat | id_Start},
    {-3839, -3839, 0, -1, -1, pr_compat | id_Start},
    {-3841, -3841, 0, -1, -1, pr_compat | id_Start},
    {-3843, -3843, 0, -1, -1, pr_compat | id_Start},
    {-3845, -3845, 0, -1, -1, pr_compat | id_Start},
    {-3847, -3847, 0, -1, -1, pr_compat | id_Start},
    {-3849, -3849, 0, -1, -1, pr_compat | id_Start},
    {-3851, -3851, 0, -1, -1, pr_compat | id_Start},
    {-3853, -3853, 0, -1, -1, pr_compat | id_Start},
    {-3855, -3855, 0, -1, -1, pr_compat | id_Start},
    {-3857, -3857, 0, -1, -1, pr_compat | id_Start},
    {-3865, -3865, 0, -1, -1, pr_compat | id_Start},
    {-3867, -3867, 0, -1, -1, pr_compat | id_Start},
    {-3871, -3871, 0, -1, -1, pr_compat | id_Start},
    {-3875, -3875, 0, -1, -1, pr_compat | id_Start},
    {-3883, -3883, 0, -1, -1, pr_compat | id_Start},
    {-3886, -3886, 0, -1, -1, pr_compat | id_Start},
    {-3889, -3889, 0, -1, -1, pr_compat | id_Start},
    {-3948, -3948, 0, -1, -1, pr_compat | id_Start},
    {-3954, -3954, 0, -1, -1, pr_compat | id_Start},
    {-3957, -3957, 0, -1, -1, pr_compat | id_Start},
    {-3960, -3960, 0, -1, -1, pr_compat | id_Start},
    {-3963, -3963, 0, -1, -1, pr_compat | id_Start},
    {-3966, -3966, 0, -1, -1, pr_compat | id_Start},
    {-3972, -3972, 0, -1, -1, pr_compat | id_Start},
    {-3975, -3975, 0, -1, -1, pr_compat | id_Start},
    {-3978, -3978, 0, -1, -1, pr_compat | id_Start},
    {-3981, -3981, 0, -1, -1, pr_compat | id_Start},
    {-3984, -3984, 0, -1, -1, pr_compat | id_Start},
    {-3990, -3990, 0, -1, -1, pr_compat | id_Start},
    {-4005, -4005, 0, -1, -1, pr_compat | id_Start},
    {-4014, -4014, 0, -1, -1, pr_compat | id_Start},
    {-4023, -4023, 0, -1, -1, pr_compat | id_Start},
    {-4026, -4026, 0, -1, -1, pr_compat | id_Start},
    {-4035, -4035, 0, -1, -1, pr_compat | id_Start},
    {-4038, -4038, 0, -1, -1, pr_compat | id_Start},
    {-4041, -4041, 0, -1, -1, pr_compat | id_Start},
    {-4044, -4044, 0, -1, -1, pr_compat | id_Start},
    {-4053, -4053, 0, -1, -1, pr_compat | id_Start},
    {-4059, -4059, 0, -1, -1, pr_compat | id_Start},
    {-4062, -4062, 0, -1, -1, pr_compat | id_Start},
    {-4074, -4074, 0, -1, -1, pr_compat | id_Start},
    {-4077, -4077, 0, -1, -1, pr_compat | id_Start},
    {-4080, -4080, 0, -1, -1, pr_compat | id_Start},
    {-4083, -4083, 0, -1, -1, pr_compat | id_Start},
    {-4086, -4086, 0, -1, -1, pr_compat | id_Start},
    {-4089, -4089, 0, -1, -1, pr_compat | id_Start},
    {-4092, -4092, 0, -1, -1, pr_compat | id_Start},
    {-4095, -4095, 0, -1, -1, pr_compat | id_Start},
    {-4098, -4098, 0, -1, -1, pr_compat | id_Start},
    {-4101, -4101, 0, -1, -1, pr_compat | id_Start},
    {-4104, -4104, 0, -1, -1, pr_compat | id_Start},
    {-4107, -4107, 0, -1, -1, pr_compat | id_Start},
    {-4113, -4113, 0, -1, -1, pr_compat | id_Start},
    {-4116, -4116, 0, -1, -1, pr_compat | id_Start},
    {-4119, -4119, 0, -1, -1, pr_compat | id_Start},
    {-4125, -4125, 0, -1, -1, pr_compat | id_Start},
    {-4128, -4128, 0, -1, -1, pr_compat | id_Start},
    {-4131, -4131, 0, -1, -1, pr_compat | id_Start},
    {-4134, -4134, 0, -1, -1, pr_compat | id_Start},
    {-4137, -4137, 0, -1, -1, pr_compat | id_Start},
    {-4140, -4140, 0, -1, -1, pr_compat | id_Start},
    {-4143, -4143, 0, -1, -1, pr_compat | id_Start},
    {-4146, -4146, 0, -1, -1, pr_compat | id_Start},
    {-4149, -4149, 0, -1, -1, pr_compat | id_Start},
    {-4152, -4152, 0, -1, -1, pr_compat | id_Start},
    {-4155, -4155, 0, -1, -1, pr_compat | id_Start},
    {-4158, -4158, 0, -1, -1, pr_compat | id_Start},
    {-4161, -4161, 0, -1, -1, pr_compat | id_Start},
    {-4164, -4164, 0, -1, -1, pr_compat | id_Start},
    {-4167, -4167, 0, -1, -1, pr_compat | id_Start},
    {-4170, -4170, 0, -1, -1, pr_compat | id_Start},
    {-4173, -4173, 0, -1, -1, pr_compat | id_Start},
    {-4176, -4176, 0, -1, -1, pr_compat | id_Start},
    {-4179, -4179, 0, -1, -1, pr_compat | id_Start},
    {-4182, -4182, 0, -1, -1, pr_compat | id_Start},
    {-4185, -4185, 0, -1, -1, pr_compat | id_Start},
    {-4188, -4188, 0, -1, -1, pr_compat | id_Start},
    {-4191, -4191, 0, -1, -1, pr_compat | id_Start},
    {-4194, -4194, 0, -1, -1, pr_compat | id_Start},
    {-4200, -4200, 0, -1, -1, pr_compat | id_Start},
    {-4209, -4209, 0, -1, -1, pr_compat | id_Start},
    {-4212, -4212, 0, -1, -1, pr_compat | id_Start},
    {-4215, -4215, 0, -1, -1, pr_compat | id_Start},
    {-4218, -4218, 0, -1, -1, pr_compat | id_Start},
    {-4221, -4221, 0, -1, -1, pr_compat | id_Start},
    {-4224, -4224, 0, -1, -1, pr_compat | id_Start},
    {-4227, -4227, 0, -1, -1, pr_compat | id_Start},
    {-4230, -4230, 0, -1, -1, pr_compat | id_Start},
    {-4233, -4233, 0, -1, -1, pr_compat | id_Start},
    {-4236, -4236, 0, -1, -1, pr_compat | id_Start},
    {-4240, -4240, 0, -1, -1, pr_compat | id_Start},
    {-4244, -4244, 0, -1, -1, pr_compat | id_Start},
    {-4248, -4248, 0, -1, -1, pr_compat | id_Start},
    {-4252, -4252, 0, -1, -1, pr_compat | id_Start},
    {-4256, -4256, 0, -1, -1, pr_compat | id_Start},
    {-4260, -4260, 0, -1, -1, pr_compat | id_Start},
    {-4264, -4264, 0, -1, -1, pr_compat | id_Start},
    {-4267, -4267, 0, -1, -1, pr_compat},
    {-4285, -4285, 0, -1, -1, pr_compat},
    {-4293, -4293, 0, -1, -1, pr_compat},
    {12310, 12310, 0, -1, -1, pr_compat},
    {12311, 12311, 0, -1, -1, pr_compat},
    {8230, -1826, 0, -1, -1, pr_compat},
    {8229, -1824, 0, -1, -1, pr_compat},
    {8211, 8211, 0, -1, -1, pr_compat},
    {12304, 12304, 0, -1, -1, pr_compat},
    {12305, 12305, 0, -1, -1, pr_compat},
    {12298, 12298, 0, -1, -1, pr_compat},
    {12299, 12299, 0, -1, -1, pr_compat},
    {12296, 12296, 0, -1, -1, pr_compat},
    {12297, 12297, 0, -1, -1, pr_compat},
    {12302, 12302, 0, -1, -1, pr_compat},
    {12303, 12303, 0, -1, -1, pr_compat},
    {-4297, -4297, 0, -1, -1, pr_compat},
    {-4299, -4299, 0, -1, -1, pr_compat | id_Start},
    {-4301, -4301, 0, -1, -1, pr_compat},
    {-4303, -4303, 0, -1, -1, pr_compat},
    {-4305, -4305, 0, -1, -1, pr_compat},
    {-4307, -4307, 0, -1, -1, pr_compat | id_Start},
    {-4309, -4309, 0, -1, -1, pr_compat},
    {-4311, -4311, 0, -1, -1, pr_compat | id_Start},
    {-4313, -4313, 0, -1, -1, pr_compat},
    {-4315, -4315, 0, -1, -1, pr_compat | id_Start},
    {-4317, -4317, 0, -1, -1, pr_compat},
    {-4319, -4319, 0, -1, -1, pr_compat | id_Start},
    {-4321, -4321, 0, -1, -1, pr_compat},
    {-4323, -4323, 0, -1, -1, pr_compat | id_Start},
    {1569, 1569, 0, -1, -1, pr_compat | id_Start},
    {34, 34, 0, -1, -1, pr_compat},
    {39, 39, 0, -1, -1, pr_compat},
    {47, 47, 0, -1, -1, pr_compat},
    {94, 94, 0, -1, -1, pr_compat},
    {96, 96, 0, -1, -1, pr_compat},
    {124, 124, 0, -1, -1, pr_compat},
    {126, 126, 0, -1, -1, pr_compat},
    {10629, 10629, 0, -1, -1, pr_compat},
    {10630, 10630, 0, -1, -1, pr_compat},
    {12539, 12539, 0, -1, -1, pr_compat},
    {12530, 12530, 0, -1, -1, pr_compat | id_Start},
    {12449, 12449, 0, -1, -1, pr_compat | id_Start},
    {12451, 12451, 0, -1, -1, pr_compat | id_Start},
    {12453, 12453, 0, -1, -1, pr_compat | id_Start},
    {12455, 12455, 0, -1, -1, pr_compat | id_Start},
    {12457, 12457, 0, -1, -1, pr_compat | id_Start},
    {12515, 12515, 0, -1, -1, pr_compat | id_Start},
    {12517, 12517, 0, -1, -1, pr_compat | id_Start},
    {12519, 12519, 0, -1, -1, pr_compat | id_Start},
    {12483, 12483, 0, -1, -1, pr_compat | id_Start},
    {12540, 12540, 0, -1, -1, pr_compat | id_Start},
    {12450, 12450, 0, -1, -1, pr_compat | id_Start},
    {12452, 12452, 0, -1, -1, pr_compat | id_Start},
    {12454, 12454, 0, -1, -1, pr_compat | id_Start},
    {12456, 12456, 0, -1, -1, pr_compat | id_Start},
    {12458, 12458, 0, -1, -1, pr_compat | id_Start},
    {12459, 12459, 0, -1, -1, pr_compat | id_Start},
    {12461, 12461, 0, -1, -1, pr_compat | id_Start},
    {12463, 12463, 0, -1, -1, pr_compat | id_Start},
    {12465, 12465, 0, -1, -1, pr_compat | id_Start},
    {12467, 12467, 0, -1, -1, pr_compat | id_Start},
    {12469, 12469, 0, -1, -1, pr_compat | id_Start},
    {12471, 12471, 0, -1, -1, pr_compat | id_Start},
    {12473, 12473, 0, -1, -1, pr_compat | id_Start},
    {12475, 12475, 0, -1, -1, pr_compat | id_Start},
    {12477, 12477, 0, -1, -1, pr_compat | id_Start},
    {12479, 12479, 0, -1, -1, pr_compat | id_Start},
    {12481, 12481, 0, -1, -1, pr_compat | id_Start},
    {12484, 12484, 0, -1, -1, pr_compat | id_Start},
    {12486, 12486, 0, -1, -1, pr_compat | id_Start},
    {12488, 12488, 0, -1, -1, pr_compat | id_Start},
    {12490, 12490, 0, -1, -1, pr_compat | id_Start},
    {12491, 12491, 0, -1, -1, pr_compat | id_Start},
    {12492, 12492, 0, -1, -1, pr_compat | id_Start},
    {12493, 12493, 0, -1, -1, pr_compat | id_Start},
    {12494, 12494, 0, -1, -1, pr_compat | id_Start},
    {12495, 12495, 0, -1, -1, pr_compat | id_Start},
    {12498, 12498, 0, -1, -1, pr_compat | id_Start},
    {12501, 12501, 0, -1, -1, pr_compat | id_Start},
    {12504, 12504, 0, -1, -1, pr_compat | id_Start},
    {12507, 12507, 0, -1, -1, pr_compat | id_Start},
    {12510, 12510, 0, -1, -1, pr_compat | id_Start},
    {12511, 12511, 0, -1, -1, pr_compat | id_Start},
    {12512, 12512, 0, -1, -1, pr_compat | id_Start},
    {12513, 12513, 0, -1, -1, pr_compat | id_Start},
    {12514, 12514, 0, -1, -1, pr_compat | id_Start},
    {12516, 12516, 0, -1, -1, pr_compat | id_Start},
    {12518, 12518, 0, -1, -1, pr_compat | id_Start},
    {12520, 12520, 0, -1, -1, pr_compat | id_Start},
    {12521, 12521, 0, -1, -1, pr_compat | id_Start},
    {12522, 12522, 0, -1, -1, pr_compat | id_Start},
    {12523, 12523, 0, -1, -1, pr_compat | id_Start},
    {12524, 12524, 0, -1, -1, pr_compat | id_Start},
    {12525, 12525, 0, -1, -1, pr_compat | id_Start},
    {12527, 12527, 0, -1, -1, pr_compat | id_Start},
    {12531, 12531, 0, -1, -1, pr_compat | id_Start},
    {12441, 12441, 0, -1, -1, pr_compat | id_Continue},
    {12442, 12442, 0, -1, -1, pr_compat | id_Continue},
    {12644, 0, 0, -1, -1, pr_compat},
    {12593, 4352, 0, -1, -1, pr_compat | id_Start},
    {12594, 4353, 0, -1, -1, pr_compat | id_Start},
    {12595, 4522, 0, -1, -1, pr_compat | id_Start},
    {12596, 4354, 0, -1, -1, pr_compat | id_Start},
    {12597, 4524, 0, -1, -1, pr_compat | id_Start},
    {12598, 4525, 0, -1, -1, pr_compat | id_Start},
    {12599, 4355, 0, -1, -1, pr_compat | id_Start},
    {12600, 4356, 0, -1, -1, pr_compat | id_Start},
    {12601, 4357, 0, -1, -1, pr_compat | id_Start},
    {12602, 4528, 0, -1, -1, pr_compat | id_Start},
    {12603, 4529, 0, -1, -1, pr_compat | id_Start},
    {12604, 4530, 0, -1, -1, pr_compat | id_Start},
    {12605, 4531, 0, -1, -1, pr_compat | id_Start},
    {12606, 4532, 0, -1, -1, pr_compat | id_Start},
    {12607, 4533, 0, -1, -1, pr_compat | id_Start},
    {12608, 4378, 0, -1, -1, pr_compat | id_Start},
    {12609, 4358, 0, -1, -1, pr_compat | id_Start},
    {12610, 4359, 0, -1, -1, pr_compat | id_Start},
    {12611, 4360, 0, -1, -1, pr_compat | id_Start},
    {12612, 4385, 0, -1, -1, pr_compat | id_Start},
    {12613, 4361, 0, -1, -1, pr_compat | id_Start},
    {12614, 4362, 0, -1, -1, pr_compat | id_Start},
    {12615, 4363, 0, -1, -1, pr_compat | id_Start},
    {12616, 4364, 0, -1, -1, pr_compat | id_Start},
    {12617, 4365, 0, -1, -1, pr_compat | id_Start},
    {12618, 4366, 0, -1, -1, pr_compat | id_Start},
    {12619, 4367, 0, -1, -1, pr_compat | id_Start},
    {12620, 4368, 0, -1, -1, pr_compat | id_Start},
    {12621, 4369, 0, -1, -1, pr_compat | id_Start},
    {12622, 4370, 0, -1, -1, pr_compat | id_Start},
    {12623, 4449, 0, -1, -1, pr_compat | id_Start},
    {12624, 4450, 0, -1, -1, pr_compat | id_Start},
    {12625, 4451, 0, -1, -1, pr_compat | id_Start},
    {12626, 4452, 0, -1, -1, pr_compat | id_Start},
    {12627, 4453, 0, -1, -1, pr_compat | id_Start},
    {12628, 4454, 0, -1, -1, pr_compat | id_Start},
    {12629, 4455, 0, -1, -1, pr_compat | id_Start},
    {12630, 4456, 0, -1, -1, pr_compat | id_Start},
    {12631, 4457, 0, -1, -1, pr_compat | id_Start},
    {12632, 4458, 0, -1, -1, pr_compat | id_Start},
    {12633, 4459, 0, -1, -1, pr_compat | id_Start},
    {12634, 4460, 0, -1, -1, pr_compat | id_Start},
    {12635, 4461, 0, -1, -1, pr_compat | id_Start},
    {12636, 4462, 0, -1, -1, pr_compat | id_Start},
    {12637, 4463, 0, -1, -1, pr_compat | id_Start},
    {12638, 4464, 0, -1, -1, pr_compat | id_Start},
    {12639, 4465, 0, -1, -1, pr_compat | id_Start},
    {12640, 4466, 0, -1, -1, pr_compat | id_Start},
    {12641, 4467, 0, -1, -1, pr_compat | id_Start},
    {12642, 4468, 0, -1, -1, pr_compat | id_Start},
    {12643, 4469, 0, -1, -1, pr_compat | id_Start},
    {162, 162, 0, -1, -1, pr_compat},
    {163, 163, 0, -1, -1, pr_compat},
    {172, 172, 0, -1, -1, pr_compat},
    {175, -3, 0, -1, -1, pr_compat},
    {166, 166, 0, -1, -1, pr_compat},
    {165, 165, 0, -1, -1, pr_compat},
    {8361, 8361, 0, -1, -1, pr_compat},
    {9474, 9474, 0, -1, -1, pr_compat},
    {8592, 8592, 0, -1, -1, pr_compat},
    {8593, 8593, 0, -1, -1, pr_compat},
    {8594, 8594, 0, -1, -1, pr_compat},
    {8595, 8595, 0, -1, -1, pr_compat},
    {9632, 9632, 0, -1, -1, pr_compat},
    {9675, 9675, 0, -1, -1, pr_compat},
    {0, -17041, 0, -1, -1, 0},
    {0, -17042, 0, -1, -1, 0},
    {0, -17043, 0, -1, -1, 0},
    {0, -17044, 0, -1, -1, 0},
    {0, -17045, 0, -1, -1, 0},
    {0, -17046, 0, -1, -1, 0},
    {0, -17047, 0, -1, -1, 0},
    {0, -17048, 0, -1, -1, 0},
    {0, -17049, 0, -1, -1, 0},
    {0, -17050, 0, -1, -1, 0},
    {0, -17051, 0, -1, -1, 0},
    {0, -17052, 0, -1, -1, 0},
    {0, -17053, 0, -1, -1, 0},
    {0, -17054, 0, -1, -1, 0},
    {0, -17055, 0, -1, -1, 0},
    {0, -17056, 0, -1, -1, 0},
    {0, -17057, 0, -1, -1, 0},
    {0, -17058, 0, -1, -1, 0},
    {0, -17059, 0, -1, -1, 0},
    {0, -17060, 0, -1, -1, 0},
    {0, -17061, 0, -1, -1, 0},
    {0, -17062, 0, -1, -1, 0},
    {0, -17063, 0, -1, -1, 0},
    {0, -17064, 0, -1, -1, 0},
    {0, -17065, 0, -1, -1, 0},
    {0, -17066, 0, -1, -1, 0},
    {0, -17067, 0, -1, -1, 0},
    {0, -17068, 0, -1, -1, 0},
    {0, -17069, 0, -1, -1, 0},
    {0, -17070, 0, -1, -1, 0},
    {0, -17071, 0, -1, -1, 0},
    {0, -17072, 0, -1, -1, 0},
    {0, -17073, 0, -1, -1, 0},
    {0, -17074, 0, -1, -1, 0},
    {0, -17075, 0, -1, -1, 0},
    {0, -17076, 0, -1, -1, 0},
    {0, -17077, 0, -1, -1, 0},
    {0, -17078, 0, -1, -1, 0},
    {0, -17079, 0, -1, -1, 0},
    {0, -17080, 0, -1, -1, 0},
    {0, -17081, 0, -1, -1, id_Start},
    {0, -17082, 0, -1, -1, id_Start},
    {0, -17083, 0, -1, -1, id_Start},
    {0, -17084, 0, -1, -1, id_Start},
    {0, -17085, 0, -1, -1, id_Start},
    {0, -17086, 0, -1, -1, id_Start},
    {0, -17087, 0, -1, -1, id_Start},
    {0, -17088, 0, -1, -1, id_Start},
    {0, -17089, 0, -1, -1, id_Start},
    {0, -17090, 0, -1, -1, id_Start},
    {0, -17091, 0, -1, -1, id_Start},
    {0, -17092, 0, -1, -1, id_Start},
    {0, -17093, 0, -1, -1, id_Start},
    {0, -17094, 0, -1, -1, id_Start},
    {0, -17095, 0, -1, -1, id_Start},
    {0, -17096, 0, -1, -1, id_Start},
    {0, -17097, 0, -1, -1, id_Start},
    {0, -17098, 0, -1, -1, id_Start},
    {0, -17099, 0, -1, -1, id_Start},
    {0, -17100, 0, -1, -1, id_Start},
    {0, -17101, 0, -1, -1, id_Start},
    {0, -17102, 0, -1, -1, id_Start},
    {0, -17103, 0, -1, -1, id_Start},
    {0, -17104, 0, -1, -1, id_Start},
    {0, -17105, 0, -1, -1, id_Start},
    {0, -17106, 0, -1, -1, id_Start},
    {0, -17107, 0, -1, -1, id_Start},
    {0, -17108, 0, -1, -1, id_Start},
    {0, -17109, 0, -1, -1, id_Start},
    {0, -17110, 0, -1, -1, id_Start},
    {0, -17111, 0, -1, -1, id_Start},
    {0, -17112, 0, -1, -1, id_Start},
    {0, -17113, 0, -1, -1, id_Start},
    {0, -17114, 0, -1, -1, id_Start},
    {0, -17115, 0, -1, -1, id_Start},
    {0, -17116, 0, -1, -1, id_Start},
    {0, -17117, 0, -1, -1, 0},
    {0, -17118, 0, -1, -1, 0},
    {0, -17119, 0, -1, -1, 0},
    {0, -17120, 0, -1, -1, 0},
    {0, -17121, 0, -1, -1, 0},
    {0, -17122, 0, -1, -1, 0},
    {0, -17123, 0, -1, -1, 0},
    {0, -17124, 0, -1, -1, 0},
    {0, -17125, 0, -1, -1, 0},
    {0, -17126, 0, -1, -1, 0},
    {0, -17127, 0, -1, -1, 0},
    {0, -17128, 0, -1, -1, 0},
    {0, -17129, 0, -1, -1, 0},
    {0, -17130, 0, -1, -1, 0},
    {0, -17131, 0, -1, -1, 0},
    {0, -17132, 0, -1, -1, 0},
    {0, -17133, 0, -1, -1, 0},
    {0, -17134, 0, -1, -1, 0},
    {0, -17135, 0, -1, -1, 0},
    {0, -17136, 0, -1, -1, 0},
    {0, -17137, 0, -1, -1, 0},
    {0, -17138, 0, -1, -1, 0},
    {0, -17139, 0, -1, -1, 0},
    {0, -17140, 0, -1, -1, 0},
    {0, -17141, 0, -1, -1, 0},
    {0, -17142, 0, -1, -1, 0},
    {0, -17143, 0, -1, -1, 0},
    {0, -17144, 0, -1, -1, 0},
    {0, -17145, 0, -1, -1, 0},
    {0, -17146, 0, -1, -1, 0},
    {0, -17147, 0, -1, -1, 0},
    {0, -17148, 0, -1, -1, 0},
    {0, -17149, 0, -1, -1, 0},
    {0, -17150, 0, -1, -1, 0},
    {0, -17151, 0, -1, -1, 0},
    {0, -17152, 0, -1, -1, 0},
    {0, -17153, 0, -1, -1, 0},
    {0, -17154, 0, -1, -1, 0},
    {0, -17155, 0, -1, -1, 0},
    {0, -17156, 0, -1, -1, 0},
    {0, -17157, 0, -1, -1, 0},
    {0, -17158, 0, -1, -1, 0},
    {0, -17159, 0, -1, -1, 0},
    {0, -17160, 0, -1, -1, 0},
    {0, -17161, 0, -1, -1, 0},
    {0, -17162, 0, -1, -1, 0},
    {0, -17163, 0, -1, -1, 0},
    {0, -17164, 0, -1, -1, 0},
    {0, -17165, 0, -1, -1, 0},
    {0, -17166, 0, -1, -1, 0},
    {0, -17167, 0, -1, -1, 0},
    {0, 0, 0, -1, 12276, 0},
    {-16632, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 12338, 0},
    {-16634, 0, 0, -1, -1, 0},
    {0, 0, 0, -1, 12462, 0},
    {-16636, 0, 0, -1, -1, 0},
    {0, 0, 7, 41, -1, qc_M},
    {0, 0, 0, 42, -1, id_Continue | qc_M},
    {-16638, 0, 0, -1, -1, id_Continue},
    {-16640, 0, 0, -1, -1, id_Continue},
    {0, 0, 0, -1, 14136, id_Continue},
    {0, 0, 0, -1, 14198, id_Continue},
    {0, 0, 0, 43, -1, qc_M},
    {0, 0, 0, -1, 14260, 0},
    {-16642, 0, 0, -1, -1, 0},
    {-16644, 0, 0, -1, -1, 0},
    {0, 0, 0, 44, -1, qc_M},
    {0, 0, 0, 46, -1, qc_M},
    {0, 0, 0, -1, 14322, 0},
    {0, 0, 0, 45, -1, qc_M},
    {-16646, 0, 0, -1, -1, 0},
    {-16648, 0, 0, -1, -1, 0},
    {0, 0, 0, 47, -1, qc_M},
    {-16650, 0, 0, -1, -1, 0},
    {0, 0, 0, 48, -1, qc_M},
    {0, 0, 0, -1, 14384, 0},
    {0, 0, 0, -1, 14446, 0},
    {-16652, 0, 0, -1, -1, 0},
    {-16654, 0, 0, -1, -1, 0},
    {0, -17168, 0, -1, -1, 0},
    {0, -17169, 0, -1, -1, 0},
    {0, -17170, 0, -1, -1, 0},
    {0, -17171, 0, -1, -1, 0},
    {0, -17172, 0, -1, -1, 0},
    {0, -17173, 0, -1, -1, 0},
    {0, -17174, 0, -1, -1, 0},
    {0, -17175, 0, -1, -1, 0},
    {0, -17176, 0, -1, -1, 0},
    {0, -17177, 0, -1, -1, 0},
    {0, -17178, 0, -1, -1, 0},
    {0, -17179, 0, -1, -1, 0},
    {0, -17180, 0, -1, -1, 0},
    {0, -17181, 0, -1, -1, 0},
    {0, -17182, 0, -1, -1, 0},
    {0, -17183, 0, -1, -1, 0},
    {0, -17184, 0, -1, -1, 0},
    {0, -17185, 0, -1, -1, 0},
    {0, -17186, 0, -1, -1, 0},
    {0, -17187, 0, -1, -1, 0},
    {0, -17188, 0, -1, -1, 0},
    {0, -17189, 0, -1, -1, 0},
    {0, -17190, 0, -1, -1, 0},
    {0, -17191, 0, -1, -1, 0},
    {0, -17192, 0, -1, -1, 0},
    {0, -17193, 0, -1, -1, 0},
    {0, -17194, 0, -1, -1, 0},
    {0, -17195, 0, -1, -1, 0},
    {0, -17196, 0, -1, -1, 0},
    {0, -17197, 0, -1, -1, 0},
    {0, -17198, 0, -1, -1, 0},
    {0, -17199, 0, -1, -1, 0},
    {0, -17200, 0, -1, -1, 0},
    {0, -17201, 0, -1, -1, 0},
    {0, -17202, 0, -1, -1, 0},
    {0, -17203, 0, -1, -1, 0},
    {0, -17204, 0, -1, -1, 0},
    {0, -17205, 0, -1, -1, 0},
    {0, -17206, 0, -1, -1, 0},
    {0, -17207, 0, -1, -1, 0},
    {0, -17208, 0, -1, -1, 0},
    {0, -17209, 0, -1, -1, 0},
    {0, -17210, 0, -1, -1, 0},
    {0, -17211, 0, -1, -1, 0},
    {0, -17212, 0, -1, -1, 0},
    {0, -17213, 0, -1, -1, 0},
    {0, -17214, 0, -1, -1, 0},
    {0, -17215, 0, -1, -1, 0},
    {0, -17216, 0, -1, -1, 0},
    {0, -17217, 0, -1, -1, 0},
    {0, -17218, 0, -1, -1, 0},
    {0, -17219, 0, -1, -1, 0},
    {0, -17220, 0, -1, -1, 0},
    {0, -17221, 0, -1, -1, 0},
    {0, -17222, 0, -1, -1, 0},
    {0, -17223, 0, -1, -1, 0},
    {0, -17224, 0, -1, -1, 0},
    {0, -17225, 0, -1, -1, 0},
    {0, -17226, 0, -1, -1, 0},
    {0, -17227, 0, -1, -1, 0},
    {0, -17228, 0, -1, -1, 0},
    {0, -17229, 0, -1, -1, 0},
    {0, -17230, 0, -1, -1, 0},
    {0, -17231, 0, -1, -1, 0},
    {-16656, -16656, 0, -1, -1, qc_N},
    {-16658, -16658, 0, -1, -1, qc_N},
    {-16660, -17232, 0, -1, -1, qc_N},
    {-16662, -17235, 0, -1, -1, qc_N},
    {-16664, -17238, 0, -1, -1, qc_N},
    {-16666, -17241, 0, -1, -1, qc_N},
    {-16668, -17244, 0, -1, -1, qc_N},
    {0, 0, 226, -1, -1, 0},
    {-16670, -16670, 0, -1, -1, qc_N},
    {-16672, -16672, 0, -1, -1, qc_N},
    {-16674, -17247, 0, -1, -1, qc_N},
    {-16676, -17250, 0, -1, -1, qc_N},
    {-16678, -17253, 0, -1, -1, qc_N},
    {-16680, -17256, 0, -1, -1, qc_N},
    {305, 305, 0, -1, -1, pr_compat | id_Start},
    {567, 567, 0, -1, -1, pr_compat | id_Start},
    {988, 989, 0, -1, -1, pr_compat | id_Start},
    {989, 989, 0, -1, -1, pr_compat | id_Start},
    {0, -17259, 0, -1, -1, id_Start},
    {0, -17260, 0, -1, -1, id_Start},
    {0, -17261, 0, -1, -1, id_Start},
    {0, -17262, 0, -1, -1, id_Start},
    {0, -17263, 0, -1, -1, id_Start},
    {0, -17264, 0, -1, -1, id_Start},
    {0, -17265, 0, -1, -1, id_Start},
    {0, -17266, 0, -1, -1, id_Start},
    {0, -17267, 0, -1, -1, id_Start},
    {0, -17268, 0, -1, -1, id_Start},
    {0, -17269, 0, -1, -1, id_Start},
    {0, -17270, 0, -1, -1, id_Start},
    {0, -17271, 0, -1, -1, id_Start},
    {0, -17272, 0, -1, -1, id_Start},
    {0, -17273, 0, -1, -1, id_Start},
    {0, -17274, 0, -1, -1, id_Start},
    {0, -17275, 0, -1, -1, id_Start},
    {0, -17276, 0, -1, -1, id_Start},
    {0, -17277, 0, -1, -1, id_Start},
    {0, -17278, 0, -1, -1, id_Start},
    {0, -17279, 0, -1, -1, id_Start},
    {0, -17280, 0, -1, -1, id_Start},
    {0, -17281, 0, -1, -1, id_Start},
    {0, -17282, 0, -1, -1, id_Start},
    {0, -17283, 0, -1, -1, id_Start},
    {0, -17284, 0, -1, -1, id_Start},
    {0, -17285, 0, -1, -1, id_Start},
    {0, -17286, 0, -1, -1, id_Start},
    {0, -17287, 0, -1, -1, id_Start},
    {0, -17288, 0, -1, -1, id_Start},
    {0, -17289, 0, -1, -1, id_Start},
    {0, -17290, 0, -1, -1, id_Start},
    {0, -17291, 0, -1, -1, id_Start},
    {0, -17292, 0, -1, -1, id_Start},
    {-4333, -4333, 0, -1, -1, pr_compat},
    {-4335, -4335, 0, -1, -1, pr_compat},
    {-4337, -4337, 0, -1, -1, pr_compat},
    {-4339, -4339, 0, -1, -1, pr_compat},
    {-4341, -4341, 0, -1, -1, pr_compat},
    {-4343, -4343, 0, -1, -1, pr_compat},
    {-4345, -4345, 0, -1, -1, pr_compat},
    {-4347, -4347, 0, -1, -1, pr_compat},
    {-4349, -4349, 0, -1, -1, pr_compat},
    {-4351, -4351, 0, -1, -1, pr_compat},
    {-4353, -4353, 0, -1, -1, pr_compat},
    {-4355, -2222, 0, -1, -1, pr_compat},
    {-4358, -2225, 0, -1, -1, pr_compat},
    {-4361, -2228, 0, -1, -1, pr_compat},
    {-4364, -2231, 0, -1, -1, pr_compat},
    {-4367, -2234, 0, -1, -1, pr_compat},
    {-4370, -2237, 0, -1, -1, pr_compat},
    {-4373, -2240, 0, -1, -1, pr_compat},
    {-4376, -2243, 0, -1, -1, pr_compat},
    {-4379, -2246, 0, -1, -1, pr_compat},
    {-4382, -2249, 0, -1, -1, pr_compat},
    {-4385, -2252, 0, -1, -1, pr_compat},
    {-4388, -2255, 0, -1, -1, pr_compat},
    {-4391, -2258, 0, -1, -1, pr_compat},
    {-4394, -2261, 0, -1, -1, pr_compat},
    {-4397, -2264, 0, -1, -1, pr_compat},
    {-4400, -2267, 0, -1, -1, pr_compat},
    {-4403, -2270, 0, -1, -1, pr_compat},
    {-4406, -2273, 0, -1, -1, pr_compat},
    {-4409, -2276, 0, -1, -1, pr_compat},
    {-4412, -2279, 0, -1, -1, pr_compat},
    {-4415, -2282, 0, -1, -1, pr_compat},
    {-4418, -2285, 0, -1, -1, pr_compat},
    {-4421, -2288, 0, -1, -1, pr_compat},
    {-4424, -2291, 0, -1, -1, pr_compat},
    {-4427, -2294, 0, -1, -1, pr_compat},
    {-4430, -2297, 0, -1, -1, pr_compat},
    {-4433, -4789, 0, -1, -1, pr_compat},
    {-4436, -3355, 0, -1, -1, pr_compat},
    {-4438, -4792, 0, -1, -1, pr_compat},
    {-4440, -4794, 0, -1, -1, pr_compat},
    {-4442, -4796, 0, -1, -1, pr_compat},
    {-4444, -4488, 0, -1, -1, pr_compat},
    {-4446, -4798, 0, -1, -1, pr_compat},
    {-4449, -4801, 0, -1, -1, pr_compat},
    {-4451, -4803, 0, -1, -1, pr_compat},
    {-4453, -4805, 0, -1, -1, pr_compat},
    {-4455, -4807, 0, -1, -1, pr_compat},
    {-4457, -4457, 0, -1, -1, pr_compat},
    {-4459, -4459, 0, -1, -1, pr_compat},
    {23383, 23383, 0, -1, -1, pr_compat},
    {21452, 21452, 0, -1, -1, pr_compat},
    {12487, 12487, 0, -1, -1, pr_compat},
    {22810, 22810, 0, -1, -1, pr_compat},
    {-16682, -16682, 0, -1, -1, pr_compat},
    {20132, 20132, 0, -1, -1, pr_compat},
    {26144, 26144, 0, -1, -1, pr_compat},
    {28961, 28961, 0, -1, -1, pr_compat},
    {26009, 26009, 0, -1, -1, pr_compat},
    {21069, 21069, 0, -1, -1, pr_compat},
    {24460, 24460, 0, -1, -1, pr_compat},
    {20877, 20877, 0, -1, -1, pr_compat},
    {26032, 26032, 0, -1, -1, pr_compat},
    {21021, 21021, 0, -1, -1, pr_compat},
    {32066, 32066, 0, -1, -1, pr_compat},
    {-16683, -16683, 0, -1, -1, pr_compat},
    {22768, 22768, 0, -1, -1, pr_compat},
    {21561, 21561, 0, -1, -1, pr_compat},
    {28436, 28436, 0, -1, -1, pr_compat},
    {25237, 25237, 0, -1, -1, pr_compat},
    {25429, 25429, 0, -1, -1, pr_compat},
    {-16684, -16684, 0, -1, -1, pr_compat},
    {25351, 25351, 0, -1, -1, pr_compat},
    {25171, 25171, 0, -1, -1, pr_compat},
    {31105, 31105, 0, -1, -1, pr_compat},
    {31354, 31354, 0, -1, -1, pr_compat},
    {21512, 21512, 0, -1, -1, pr_compat},
    {28288, 28288, 0, -1, -1, pr_compat},
    {30003, 30003, 0, -1, -1, pr_compat},
    {21106, 21106, 0, -1, -1, pr_compat},
    {21942, 21942, 0, -1, -1, pr_compat},
    {-16685, -16685, 0, -1, -1, pr_compat},
    {-4461, -4461, 0, -1, -1, pr_compat},
    {-4464, -4464, 0, -1, -1, pr_compat},
    {-4467, -4467, 0, -1, -1, pr_compat},
    {-4470, -4470, 0, -1, -1, pr_compat},
    {-4473, -4473, 0, -1, -1, pr_compat},
    {-4476, -4476, 0, -1, -1, pr_compat},
    {-4479, -4479, 0, -1, -1, pr_compat},
    {-4482, -4482, 0, -1, -1, pr_compat},
    {-4485, -4485, 0, -1, -1, pr_compat},
    {24471, 24471, 0, -1, -1, pr_compat},
    {21487, 21487, 0, -1, -1, pr_compat},
    {20029, 20029, 0, -1, -1, id_Start | qc_N},
    {20024, 20024, 0, -1, -1, id_Start | qc_N},
    {20033, 20033, 0, -1, -1, id_Start | qc_N},
    {-16686, -16686, 0, -1, -1, id_Start | qc_N},
    {20320, 20320, 0, -1, -1, id_Start | qc_N},
    {20411, 20411, 0, -1, -1, id_Start | qc_N},
    {20482, 20482, 0, -1, -1, id_Start | qc_N},
    {20602, 20602, 0, -1, -1, id_Start | qc_N},
    {20633, 20633, 0, -1, -1, id_Start | qc_N},
    {20687, 20687, 0, -1, -1, id_Start | qc_N},
    {13470, 13470, 0, -1, -1, id_Start | qc_N},
    {-16687, -16687, 0, -1, -1, id_Start | qc_N},
    {20820, 20820, 0, -1, -1, id_Start | qc_N},
    {20836, 20836, 0, -1, -1, id_Start | qc_N},
    {20855, 20855, 0, -1, -1, id_Start | qc_N},
    {-16688, -16688, 0, -1, -1, id_Start | qc_N},
    {13497, 13497, 0, -1, -1, id_Start | qc_N},
    {20839, 20839, 0, -1, -1, id_Start | qc_N},
    {20877, 20877, 0, -1, -1, id_Start | qc_N},
    {-16689, -16689, 0, -1, -1, id_Start | qc_N},
    {20887, 20887, 0, -1, -1, id_Start | qc_N},
    {20900, 20900, 0, -1, -1, id_Start | qc_N},
    {20172, 20172, 0, -1, -1, id_Start | qc_N},
    {20908, 20908, 0, -1, -1, id_Start | qc_N},
    {-16690, -16690, 0, -1, -1, id_Start | qc_N},
    {20981, 20981, 0, -1, -1, id_Start | qc_N},
    {20995, 20995, 0, -1, -1, id_Start | qc_N},
    {13535, 13535, 0, -1, -1, id_Start | qc_N},
    {21051, 21051, 0, -1, -1, id_Start | qc_N},
    {21062, 21062, 0, -1, -1, id_Start | qc_N},
    {21106, 21106, 0, -1, -1, id_Start | qc_N},
    {21111, 21111, 0, -1, -1, id_Start | qc_N},
    {13589, 13589, 0, -1, -1, id_Start | qc_N},
    {21253, 21253, 0, -1, -1, id_Start | qc_N},
    {21254, 21254, 0, -1, -1, id_Start | qc_N},
    {21321, 21321, 0, -1, -1, id_Start | qc_N},
    {21338, 21338, 0, -1, -1, id_Start | qc_N},
    {21363, 21363, 0, -1, -1, id_Start | qc_N},
    {21373, 21373, 0, -1, -1, id_Start | qc_N},
    {-16691, -16691, 0, -1, -1, id_Start | qc_N},
    {28784, 28784, 0, -1, -1, id_Start | qc_N},
    {21450, 21450, 0, -1, -1, id_Start | qc_N},
    {21471, 21471, 0, -1, -1, id_Start | qc_N},
    {-16692, -16692, 0, -1, -1, id_Start | qc_N},
    {21483, 21483, 0, -1, -1, id_Start | qc_N},
    {21489, 21489, 0, -1, -1, id_Start | qc_N},
    {21510, 21510, 0, -1, -1, id_Start | qc_N},
    {21662, 21662, 0, -1, -1, id_Start | qc_N},
    {21560, 21560, 0, -1, -1, id_Start | qc_N},
    {21576, 21576, 0, -1, -1, id_Start | qc_N},
    {21608, 21608, 0, -1, -1, id_Start | qc_N},
    {21666, 21666, 0, -1, -1, id_Start | qc_N},
    {21750, 21750, 0, -1, -1, id_Start | qc_N},
    {21776, 21776, 0, -1, -1, id_Start | qc_N},
    {21843, 21843, 0, -1, -1, id_Start | qc_N},
    {21859, 21859, 0, -1, -1, id_Start | qc_N},
    {21931, 21931, 0, -1, -1, id_Start | qc_N},
    {21939, 21939, 0, -1, -1, id_Start | qc_N},
    {21954, 21954, 0, -1, -1, id_Start | qc_N},
    {22294, 22294, 0, -1, -1, id_Start | qc_N},
    {22295, 22295, 0, -1, -1, id_Start | qc_N},
    {22097, 22097, 0, -1, -1, id_Start | qc_N},
    {22132, 22132, 0, -1, -1, id_Start | qc_N},
    {22766, 22766, 0, -1, -1, id_Start | qc_N},
    {22478, 22478, 0, -1, -1, id_Start | qc_N},
    {22516, 22516, 0, -1, -1, id_Start | qc_N},
    {22541, 22541, 0, -1, -1, id_Start | qc_N},
    {22411, 22411, 0, -1, -1, id_Start | qc_N},
    {22578, 22578, 0, -1, -1, id_Start | qc_N},
    {22577, 22577, 0, -1, -1, id_Start | qc_N},
    {22700, 22700, 0, -1, -1, id_Start | qc_N},
    {-16693, -16693, 0, -1, -1, id_Start | qc_N},
    {22770, 22770, 0, -1, -1, id_Start | qc_N},
    {22775, 22775, 0, -1, -1, id_Start | qc_N},
    {22790, 22790, 0, -1, -1, id_Start | qc_N},
    {22810, 22810, 0, -1, -1, id_Start | qc_N},
    {22818, 22818, 0, -1, -1, id_Start | qc_N},
    {22882, 22882, 0, -1, -1, id_Start | qc_N},
    {-16694, -16694, 0, -1, -1, id_Start | qc_N},
    {-16695, -16695, 0, -1, -1, id_Start | qc_N},
    {23020, 23020, 0, -1, -1, id_Start | qc_N},
    {23067, 23067, 0, -1, -1, id_Start | qc_N},
    {23079, 23079, 0, -1, -1, id_Start | qc_N},
    {23000, 23000, 0, -1, -1, id_Start | qc_N},
    {23142, 23142, 0, -1, -1, id_Start | qc_N},
    {14062, 14062, 0, -1, -1, id_Start | qc_N},
    {14076, 14076, 0, -1, -1, id_Start | qc_N},
    {23304, 23304, 0, -1, -1, id_Start | qc_N},
    {-16696, -16696, 0, -1, -1, id_Start | qc_N},
    {23491, 23491, 0, -1, -1, id_Start | qc_N},
    {23512, 23512, 0, -1, -1, id_Start | qc_N},
    {23539, 23539, 0, -1, -1, id_Start | qc_N},
    {-16697, -16697, 0, -1, -1, id_Start | qc_N},
    {23551, 23551, 0, -1, -1, id_Start | qc_N},
    {23558, 23558, 0, -1, -1, id_Start | qc_N},
    {24403, 24403, 0, -1, -1, id_Start | qc_N},
    {23586, 23586, 0, -1, -1, id_Start | qc_N},
    {14209, 14209, 0, -1, -1, id_Start | qc_N},
    {23648, 23648, 0, -1, -1, id_Start | qc_N},
    {23744, 23744, 0, -1, -1, id_Start | qc_N},
    {23693, 23693, 0, -1, -1, id_Start | qc_N},
    {-16698, -16698, 0, -1, -1, id_Start | qc_N},
    {23875, 23875, 0, -1, -1, id_Start | qc_N},
    {-16699, -16699, 0, -1, -1, id_Start | qc_N},
    {23918, 23918, 0, -1, -1, id_Start | qc_N},
    {23915, 23915, 0, -1, -1, id_Start | qc_N},
    {23932, 23932, 0, -1, -1, id_Start | qc_N},
    {24033, 24033, 0, -1, -1, id_Start | qc_N},
    {24034, 24034, 0, -1, -1, id_Start | qc_N},
    {14383, 14383, 0, -1, -1, id_Start | qc_N},
    {24061, 24061, 0, -1, -1, id_Start | qc_N},
    {24104, 24104, 0, -1, -1, id_Start | qc_N},
    {24125, 24125, 0, -1, -1, id_Start | qc_N},
    {24169, 24169, 0, -1, -1, id_Start | qc_N},
    {14434, 14434, 0, -1, -1, id_Start | qc_N},
    {-16700, -16700, 0, -1, -1, id_Start | qc_N},
    {14460, 14460, 0, -1, -1, id_Start | qc_N},
    {24240, 24240, 0, -1, -1, id_Start | qc_N},
    {24243, 24243, 0, -1, -1, id_Start | qc_N},
    {24246, 24246, 0, -1, -1, id_Start | qc_N},
    {-16701, -16701, 0, -1, -1, id_Start | qc_N},
    {24318, 24318, 0, -1, -1, id_Start | qc_N},
    {14535, 14535, 0, -1, -1, id_Start | qc_N},
    {-16704, -16704, 0, -1, -1, id_Start | qc_N},
    {-16705, -16705, 0, -1, -1, id_Start | qc_N},
    {24418, 24418, 0, -1, -1, id_Start | qc_N},
    {24427, 24427, 0, -1, -1, id_Start | qc_N},
    {14563, 14563, 0, -1, -1, id_Start | qc_N},
    {24474, 24474, 0, -1, -1, id_Start | qc_N},
    {24525, 24525, 0, -1, -1, id_Start | qc_N},
    {24535, 24535, 0, -1, -1, id_Start | qc_N},
    {24569, 24569, 0, -1, -1, id_Start | qc_N},
    {24705, 24705, 0, -1, -1, id_Start | qc_N},
    {14650, 14650, 0, -1, -1, id_Start | qc_N},
    {14620, 14620, 0, -1, -1, id_Start | qc_N},
    {-16706, -16706, 0, -1, -1, id_Start | qc_N},
    {24775, 24775, 0, -1, -1, id_Start | qc_N},
    {24904, 24904, 0, -1, -1, id_Start | qc_N},
    {24954, 24954, 0, -1, -1, id_Start | qc_N},
    {25010, 25010, 0, -1, -1, id_Start | qc_N},
    {24996, 24996, 0, -1, -1, id_Start | qc_N},
    {25007, 25007, 0, -1, -1, id_Start | qc_N},
    {25054, 25054, 0, -1, -1, id_Start | qc_N},
    {25104, 25104, 0, -1, -1, id_Start | qc_N},
    {25115, 25115, 0, -1, -1, id_Start | qc_N},
    {25181, 25181, 0, -1, -1, id_Start | qc_N},
    {25265, 25265, 0, -1, -1, id_Start | qc_N},
    {25300, 25300, 0, -1, -1, id_Start | qc_N},
    {25424, 25424, 0, -1, -1, id_Start | qc_N},
    {-16707, -16707, 0, -1, -1, id_Start | qc_N},
    {25405, 25405, 0, -1, -1, id_Start | qc_N},
    {25340, 25340, 0, -1, -1, id_Start | qc_N},
    {25448, 25448, 0, -1, -1, id_Start | qc_N},
    {25475, 25475, 0, -1, -1, id_Start | qc_N},
    {25572, 25572, 0, -1, -1, id_Start | qc_N},
    {-16708, -16708, 0, -1, -1, id_Start | qc_N},
    {25634, 25634, 0, -1, -1, id_Start | qc_N},
    {25541, 25541, 0, -1, -1, id_Start | qc_N},
    {25513, 25513, 0, -1, -1, id_Start | qc_N},
    {14894, 14894, 0, -1, -1, id_Start | qc_N},
    {25705, 25705, 0, -1, -1, id_Start | qc_N},
    {25726, 25726, 0, -1, -1, id_Start | qc_N},
    {25757, 25757, 0, -1, -1, id_Start | qc_N},
    {25719, 25719, 0, -1, -1, id_Start | qc_N},
    {14956, 14956, 0, -1, -1, id_Start | qc_N},
    {25964, 25964, 0, -1, -1, id_Start | qc_N},
    {-16709, -16709, 0, -1, -1, id_Start | qc_N},
    {26083, 26083, 0, -1, -1, id_Start | qc_N},
    {26360, 26360, 0, -1, -1, id_Start | qc_N},
    {26185, 26185, 0, -1, -1, id_Start | qc_N},
    {15129, 15129, 0, -1, -1, id_Start | qc_N},
    {15112, 15112, 0, -1, -1, id_Start | qc_N},
    {15076, 15076, 0, -1, -1, id_Start | qc_N},
    {20882, 20882, 0, -1, -1, id_Start | qc_N},
    {20885, 20885, 0, -1, -1, id_Start | qc_N},
    {26368, 26368, 0, -1, -1, id_Start | qc_N},
    {26268, 26268, 0, -1, -1, id_Start | qc_N},
    {-16710, -16710, 0, -1, -1, id_Start | qc_N},
    {17369, 17369, 0, -1, -1, id_Start | qc_N},
    {26401, 26401, 0, -1, -1, id_Start | qc_N},
    {26462, 26462, 0, -1, -1, id_Start | qc_N},
    {26451, 26451, 0, -1, -1, id_Start | qc_N},
    {-16711, -16711, 0, -1, -1, id_Start | qc_N},
    {15177, 15177, 0, -1, -1, id_Start | qc_N},
    {26618, 26618, 0, -1, -1, id_Start | qc_N},
    {26501, 26501, 0, -1, -1, id_Start | qc_N},
    {26706, 26706, 0, -1, -1, id_Start | qc_N},
    {-16712, -16712, 0, -1, -1, id_Start | qc_N},
    {26766, 26766, 0, -1, -1, id_Start | qc_N},
    {26655, 26655, 0, -1, -1, id_Start | qc_N},
    {26900, 26900, 0, -1, -1, id_Start | qc_N},
    {26946, 26946, 0, -1, -1, id_Start | qc_N},
    {27043, 27043, 0, -1, -1, id_Start | qc_N},
    {27114, 27114, 0, -1, -1, id_Start | qc_N},
    {27304, 27304, 0, -1, -1, id_Start | qc_N},
    {-16713, -16713, 0, -1, -1, id_Start | qc_N},
    {27355, 27355, 0, -1, -1, id_Start | qc_N},
    {15384, 15384, 0, -1, -1, id_Start | qc_N},
    {27425, 27425, 0, -1, -1, id_Start | qc_N},
    {-16714, -16714, 0, -1, -1, id_Start | qc_N},
    {27476, 27476, 0, -1, -1, id_Start | qc_N},
    {15438, 15438, 0, -1, -1, id_Start | qc_N},
    {27506, 27506, 0, -1, -1, id_Start | qc_N},
    {27551, 27551, 0, -1, -1, id_Start | qc_N},
    {27579, 27579, 0, -1, -1, id_Start | qc_N},
    {-16715, -16715, 0, -1, -1, id_Start | qc_N},
    {-16716, -16716, 0, -1, -1, id_Start | qc_N},
    {-16717, -16717, 0, -1, -1, id_Start | qc_N},
    {27726, 27726, 0, -1, -1, id_Start | qc_N},
    {-16718, -16718, 0, -1, -1, id_Start | qc_N},
    {27839, 27839, 0, -1, -1, id_Start | qc_N},
    {27853, 27853, 0, -1, -1, id_Start | qc_N},
    {27751, 27751, 0, -1, -1, id_Start | qc_N},
    {27926, 27926, 0, -1, -1, id_Start | qc_N},
    {27966, 27966, 0, -1, -1, id_Start | qc_N},
    {28009, 28009, 0, -1, -1, id_Start | qc_N},
    {28024, 28024, 0, -1, -1, id_Start | qc_N},
    {28037, 28037, 0, -1, -1, id_Start | qc_N},
    {-16719, -16719, 0, -1, -1, id_Start | qc_N},
    {27956, 27956, 0, -1, -1, id_Start | qc_N},
    {28207, 28207, 0, -1, -1, id_Start | qc_N},
    {28270, 28270, 0, -1, -1, id_Start | qc_N},
    {15667, 15667, 0, -1, -1, id_Start | qc_N},
    {28359, 28359, 0, -1, -1, id_Start | qc_N},
    {-16720, -16720, 0, -1, -1, id_Start | qc_N},
    {28153, 28153, 0, -1, -1, id_Start | qc_N},
    {28526, 28526, 0, -1, -1, id_Start | qc_N},
    {-16721, -16721, 0, -1, -1, id_Start | qc_N},
    {-16722, -16722, 0, -1, -1, id_Start | qc_N},
    {28614, 28614, 0, -1, -1, id_Start | qc_N},
    {28729, 28729, 0, -1, -1, id_Start | qc_N},
    {28699, 28699, 0, -1, -1, id_Start | qc_N},
    {15766, 15766, 0, -1, -1, id_Start | qc_N},
    {28746, 28746, 0, -1, -1, id_Start | qc_N},
    {28797, 28797, 0, -1, -1, id_Start | qc_N},
    {28791, 28791, 0, -1, -1, id_Start | qc_N},
    {28845, 28845, 0, -1, -1, id_Start | qc_N},
    {-16723, -16723, 0, -1, -1, id_Start | qc_N},
    {28997, 28997, 0, -1, -1, id_Start | qc_N},
    {-16724, -16724, 0, -1, -1, id_Start | qc_N},
    {29084, 29084, 0, -1, -1, id_Start | qc_N},
    {-16725, -16725, 0, -1, -1, id_Start | qc_N},
    {29224, 29224, 0, -1, -1, id_Start | qc_N},
    {29264, 29264, 0, -1, -1, id_Start | qc_N},
    {-16726, -16726, 0, -1, -1, id_Start | qc_N},
    {29312, 29312, 0, -1, -1, id_Start | qc_N},
    {29333, 29333, 0, -1, -1, id_Start | qc_N},
    {-16727, -16727, 0, -1, -1, id_Start | qc_N},
    {-16728, -16728, 0, -1, -1, id_Start | qc_N},
    {29562, 29562, 0, -1, -1, id_Start | qc_N},
    {29579, 29579, 0, -1, -1, id_Start | qc_N},
    {16044, 16044, 0, -1, -1, id_Start | qc_N},
    {29605, 29605, 0, -1, -1, id_Start | qc_N},
    {29767, 29767, 0, -1, -1, id_Start | qc_N},
    {29788, 29788, 0, -1, -1, id_Start | qc_N},
    {29829, 29829, 0, -1, -1, id_Start | qc_N},
    {29898, 29898, 0, -1, -1, id_Start | qc_N},
    {16155, 16155, 0, -1, -1, id_Start | qc_N},
    {29988, 29988, 0, -1, -1, id_Start | qc_N},
    {-16729, -16729, 0, -1, -1, id_Start | qc_N},
    {30014, 30014, 0, -1, -1, id_Start | qc_N},
    {-16730, -16730, 0, -1, -1, id_Start | qc_N},
    {-16731, -16731, 0, -1, -1, id_Start | qc_N},
    {30224, 30224, 0, -1, -1, id_Start | qc_N},
    {-16732, -16732, 0, -1, -1, id_Start | qc_N},
    {-16733, -16733, 0, -1, -1, id_Start | qc_N},
    {-16734, -16734, 0, -1, -1, id_Start | qc_N},
    {16380, 16380, 0, -1, -1, id_Start | qc_N},
    {16392, 16392, 0, -1, -1, id_Start | qc_N},
    {-16735, -16735, 0, -1, -1, id_Start | qc_N},
    {-16736, -16736, 0, -1, -1, id_Start | qc_N},
    {-16737, -16737, 0, -1, -1, id_Start | qc_N},
    {-16738, -16738, 0, -1, -1, id_Start | qc_N},
    {30494, 30494, 0, -1, -1, id_Start | qc_N},
    {30603, 30603, 0, -1, -1, id_Start | qc_N},
    {16454, 16454, 0, -1, -1, id_Start | qc_N},
    {16534, 16534, 0, -1, -1, id_Start | qc_N},
    {-16739, -16739, 0, -1, -1, id_Start | qc_N},
    {30798, 30798, 0, -1, -1, id_Start | qc_N},
    {16611, 16611, 0, -1, -1, id_Start | qc_N},
    {-16740, -16740, 0, -1, -1, id_Start | qc_N},
    {-16741, -16741, 0, -1, -1, id_Start | qc_N},
    {-16742, -16742, 0, -1, -1, id_Start | qc_N},
    {31211, 31211, 0, -1, -1, id_Start | qc_N},
    {16687, 16687, 0, -1, -1, id_Start | qc_N},
    {31306, 31306, 0, -1, -1, id_Start | qc_N},
    {31311, 31311, 0, -1, -1, id_Start | qc_N},
    {-16743, -16743, 0, -1, -1, id_Start | qc_N},
    {31470, 31470, 0, -1, -1, id_Start | qc_N},
    {16898, 16898, 0, -1, -1, id_Start | qc_N},
    {-16745, -16745, 0, -1, -1, id_Start | qc_N},
    {31686, 31686, 0, -1, -1, id_Start | qc_N},
    {31689, 31689, 0, -1, -1, id_Start | qc_N},
    {16935, 16935, 0, -1, -1, id_Start | qc_N},
    {-16746, -16746, 0, -1, -1, id_Start | qc_N},
    {31954, 31954, 0, -1, -1, id_Start | qc_N},
    {17056, 17056, 0, -1, -1, id_Start | qc_N},
    {31976, 31976, 0, -1, -1, id_Start | qc_N},
    {31971, 31971, 0, -1, -1, id_Start | qc_N},
    {32000, 32000, 0, -1, -1, id_Start | qc_N},
    {-16747, -16747, 0, -1, -1, id_Start | qc_N},
    {32099, 32099, 0, -1, -1, id_Start | qc_N},
    {17153, 17153, 0, -1, -1, id_Start | qc_N},
    {32199, 32199, 0, -1, -1, id_Start | qc_N},
    {32258, 32258, 0, -1, -1, id_Start | qc_N},
    {32325, 32325, 0, -1, -1, id_Start | qc_N},
    {17204, 17204, 0, -1, -1, id_Start | qc_N},
    {-16748, -16748, 0, -1, -1, id_Start | qc_N},
    {-16749, -16749, 0, -1, -1, id_Start | qc_N},
    {17241, 17241, 0, -1, -1, id_Start | qc_N},
    {-16750, -16750, 0, -1, -1, id_Start | qc_N},
    {32634, 32634, 0, -1, -1, id_Start | qc_N},
    {-16751, -16751, 0, -1, -1, id_Start | qc_N},
    {32661, 32661, 0, -1, -1, id_Start | qc_N},
    {32762, 32762, 0, -1, -1, id_Start | qc_N},
    {-16752, -16752, 0, -1, -1, id_Start | qc_N},
    {-16753, -16753, 0, -1, -1, id_Start | qc_N},
    {-16754, -16754, 0, -1, -1, id_Start | qc_N},
    {-16755, -16755, 0, -1, -1, id_Start | qc_N},
    {-16756, -16756, 0, -1, -1, id_Start | qc_N},
    {-16757, -16757, 0, -1, -1, id_Start | qc_N},
    {17365, 17365, 0, -1, -1, id_Start | qc_N},
    {-16758, -16758, 0, -1, -1, id_Start | qc_N},
    {-16759, -16759, 0, -1, -1, id_Start | qc_N},
    {17419, 17419, 0, -1, -1, id_Start | qc_N},
    {-16760, -16760, 0, -1, -1, id_Start | qc_N},
    {23221, 23221, 0, -1, -1, id_Start | qc_N},
    {-16761, -16761, 0, -1, -1, id_Start | qc_N},
    {-16762, -16762, 0, -1, -1, id_Start | qc_N},
    {-16763, -16763, 0, -1, -1, id_Start | qc_N},
    {-16764, -16764, 0, -1, -1, id_Start | qc_N},
    {-16765, -16765, 0, -1, -1, id_Start | qc_N},
    {-16766, -16766, 0, -1, -1, id_Start | qc_N},
    {17515, 17515, 0, -1, -1, id_Start | qc_N},
    {-16767, -16767, 0, -1, -1, id_Start | qc_N},
    {-16768, -16768, 0, -1, -1, id_Start | qc_N},
    {-16769, -16769, 0, -1, -1, id_Start | qc_N},
    {21171, 21171, 0, -1, -1, id_Start | qc_N},
    {-16770, -16770, 0, -1, -1, id_Start | qc_N},
    {-16771, -16771, 0, -1, -1, id_Start | qc_N},
    {-16772, -16772, 0, -1, -1, id_Start | qc_N},
    {-16773, -16773, 0, -1, -1, id_Start | qc_N},
    {-16774, -16774, 0, -1, -1, id_Start | qc_N},
    {-16775, -16775, 0, -1, -1, id_Start | qc_N},
    {-16776, -16776, 0, -1, -1, id_Start | qc_N},
    {-16777, -16777, 0, -1, -1, id_Start | qc_N},
    {-16778, -16778, 0, -1, -1, id_Start | qc_N},
    {-16779, -16779, 0, -1, -1, id_Start | qc_N},
    {-16780, -16780, 0, -1, -1, id_Start | qc_N},
    {-16781, -16781, 0, -1, -1, id_Start | qc_N},
    {-16782, -16782, 0, -1, -1, id_Start | qc_N},
    {-16783, -16783, 0, -1, -1, id_Start | qc_N},
    {-16784, -16784, 0, -1, -1, id_Start | qc_N},
    {-16785, -16785, 0, -1, -1, id_Start | qc_N},
    {-16786, -16786, 0, -1, -1, id_Start | qc_N},
    {-16787, -16787, 0, -1, -1, id_Start | qc_N},
    {17707, 17707, 0, -1, -1, id_Start | qc_N},
    {-16788, -16788, 0, -1, -1, id_Start | qc_N},
    {-16789, -16789, 0, -1, -1, id_Start | qc_N},
    {-16790, -16790, 0, -1, -1, id_Start | qc_N},
    {-16791, -16791, 0, -1, -1, id_Start | qc_N},
    {-16792, -16792, 0, -1, -1, id_Start | qc_N},
    {-16793, -16793, 0, -1, -1, id_Start | qc_N},
    {17757, 17757, 0, -1, -1, id_Start | qc_N},
    {17761, 17761, 0, -1, -1, id_Start | qc_N},
    {-16794, -16794, 0, -1, -1, id_Start | qc_N},
    {-16795, -16795, 0, -1, -1, id_Start | qc_N},
    {17771, 17771, 0, -1, -1, id_Start | qc_N},
    {-16796, -16796, 0, -1, -1, id_Start | qc_N},
    {-16797, -16797, 0, -1, -1, id_Start | qc_N},
    {-16798, -16798, 0, -1, -1, id_Start | qc_N},
    {-16799, -16799, 0, -1, -1, id_Start | qc_N},
    {-16800, -16800, 0, -1, -1, id_Start | qc_N},
    {-16801, -16801, 0, -1, -1, id_Start | qc_N},
    {-16802, -16802, 0, -1, -1, id_Start | qc_N},
    {-16803, -16803, 0, -1, -1, id_Start | qc_N},
    {-16804, -16804, 0, -1, -1, id_Start | qc_N},
    {-16805, -16805, 0, -1, -1, id_Start | qc_N},
    {17879, 17879, 0, -1, -1, id_Start | qc_N},
    {-16806, -16806, 0, -1, -1, id_Start | qc_N},
    {-16807, -16807, 0, -1, -1, id_Start | qc_N},
    {17913, 17913, 0, -1, -1, id_Start | qc_N},
    {-16808, -16808, 0, -1, -1, id_Start | qc_N},
    {-16406, -16406, 0, -1, -1, id_Start | qc_N},
    {-16809, -16809, 0, -1, -1, id_Start | qc_N},
    {-16810, -16810, 0, -1, -1, id_Start | qc_N},
    {-16811, -16811, 0, -1, -1, id_Start | qc_N},
    {17973, 17973, 0, -1, -1, id_Start | qc_N},
    {-16812, -16812, 0, -1, -1, id_Start | qc_N},
    {13499, 13499, 0, -1, -1, id_Start | qc_N},
    {-16813, -16813, 0, -1, -1, id_Start | qc_N},
    {-16814, -16814, 0, -1, -1, id_Start | qc_N},
    {18110, 18110, 0, -1, -1, id_Start | qc_N},
    {18119, 18119, 0, -1, -1, id_Start | qc_N},
    {-16815, -16815, 0, -1, -1, id_Start | qc_N},
    {-16413, -16413, 0, -1, -1, id_Start | qc_N},
    {-16816, -16816, 0, -1, -1, id_Start | qc_N},
    {-16817, -16817, 0, -1, -1, id_Start | qc_N},
    {-16818, -16818, 0, -1, -1, id_Start | qc_N},
    {-16819, -16819, 0, -1, -1, id_Start | qc_N},
    {-16820, -16820, 0, -1, -1, id_Start | qc_N},
    {-16821, -16821, 0, -1, -1, id_Start | qc_N},
    {-16822, -16822, 0, -1, -1, id_Start | qc_N},
    {-16823, -16823, 0, -1, -1, id_Start | qc_N},
    {-16824, -16824, 0, -1, -1, id_Start | qc_N},
    {-16825, -16825, 0, -1, -1, id_Start | qc_N},
    {-16826, -16826, 0, -1, -1, id_Start | qc_N},
    {-16827, -16827, 0, -1, -1, id_Start | qc_N},
    {-16828, -16828, 0, -1, -1, id_Start | qc_N},
    {-16829, -16829, 0, -1, -1, id_Start | qc_N},
    {-16830, -16830, 0, -1, -1, id_Start | qc_N},
    {-16831, -16831, 0, -1, -1, id_Start | qc_N},
    {-16832, -16832, 0, -1, -1, id_Start | qc_N},
    {-16833, -16833, 0, -1, -1, id_Start | qc_N},
    {-16834, -16834, 0, -1, -1, id_Start | qc_N},
    {-16835, -16835, 0, -1, -1, id_Start | qc_N},
    {-16836, -16836, 0, -1, -1, id_Start | qc_N},
    {-16837, -16837, 0, -1, -1, id_Start | qc_N},
    {-16838, -16838, 0, -1, -1, id_Start | qc_N},
    {-16839, -16839, 0, -1, -1, id_Start | qc_N},
    {-16840, -16840, 0, -1, -1, id_Start | qc_N},
    {-16841, -16841, 0, -1, -1, id_Start | qc_N},
    {-16842, -16842, 0, -1, -1, id_Start | qc_N},
    {18837, 18837, 0, -1, -1, id_Start | qc_N},
    {-16843, -16843, 0, -1, -1, id_Start | qc_N},
    {-16844, -16844, 0, -1, -1, id_Start | qc_N},
    {18918, 18918, 0, -1, -1, id_Start | qc_N},
    {-16845, -16845, 0, -1, -1, id_Start | qc_N},
    {23986, 23986, 0, -1, -1, id_Start | qc_N},
    {-16846, -16846, 0, -1, -1, id_Start | qc_N},
    {-16847, -16847, 0, -1, -1, id_Start | qc_N},
    {-16848, -16848, 0, -1, -1, id_Start | qc_N},
    {19054, 19054, 0, -1, -1, id_Start | qc_N},
    {19062, 19062, 0, -1, -1, id_Start | qc_N},
    {-16849, -16849, 0, -1, -1, id_Start | qc_N},
    {-16850, -16850, 0, -1, -1, id_Start | qc_N},
    {19122, 19122, 0, -1, -1, id_Start | qc_N},
    {-16851, -16851, 0, -1, -1, id_Start | qc_N},
    {-16852, -16852, 0, -1, -1, id_Start | qc_N},
    {-16853, -16853, 0, -1, -1, id_Start | qc_N},
    {-16854, -16854, 0, -1, -1, id_Start | qc_N},
    {19251, 19251, 0, -1, -1, id_Start | qc_N},
    {-16855, -16855, 0, -1, -1, id_Start | qc_N},
    {-16856, -16856, 0, -1, -1, id_Start | qc_N},
    {-16857, -16857, 0, -1, -1, id_Start | qc_N},
    {-16858, -16858, 0, -1, -1, id_Start | qc_N},
    {19406, 19406, 0, -1, -1, id_Start | qc_N},
    {-16859, -16859, 0, -1, -1, id_Start | qc_N},
    {-16860, -16860, 0, -1, -1, id_Start | qc_N},
    {-16861, -16861, 0, -1, -1, id_Start | qc_N},
    {19662, 19662, 0, -1, -1, id_Start | qc_N},
    {19693, 19693, 0, -1, -1, id_Start | qc_N},
    {-16862, -16862, 0, -1, -1, id_Start | qc_N},
    {-16863, -16863, 0, -1, -1, id_Start | qc_N},
    {19704, 19704, 0, -1, -1, id_Start | qc_N},
    {-16864, -16864, 0, -1, -1, id_Start | qc_N},
    {-16865, -16865, 0, -1, -1, id_Start | qc_N},
    {-16866, -16866, 0, -1, -1, id_Start | qc_N},
    {-16461, -16461, 0, -1, -1, id_Start | qc_N},
    {19798, 19798, 0, -1, -1, id_Start | qc_N},
    {-16465, -16465, 0, -1, -1, id_Start | qc_N},
    {-16867, -16867, 0, -1, -1, id_Start | qc_N},
    {-16868, -16868, 0, -1, -1, id_Start | qc_N},
    {-16869, -16869, 0, -1, -1, id_Start | qc_N},
    {-16870, -16870, 0, -1, -1, id_Start | qc_N},
    {-16470, -16470, 0, -1, -1, id_Start | qc_N},
    {-16871, -16871, 0, -1, -1, id_Start | qc_N},
};

const uint32_t ucomposed[13] = {
    0, 69786, 69788, 69803, 69934, 69935, 70475, 70476,
    70843, 70844, 70846, 71098, 71099,
};

const int16_t ucomposing[23312] = {
    192, 193, 194, 195, 196, 197, 0, 256,
    258, 260, 550, 461, 0, 0, 0, 512,
    514, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7680, 7840, 0, 0, 0, 0,
    0, 7842, 0, 0, 0, 0,
    0, 262, 264, 0, 0, 0, 199, 0,
    0, 0, 266, 268, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    200, 201, 202, 7868, 203, 0, 552, 274,
    276, 280, 278, 282, 0, 0, 0, 516,
    518, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7864, 0, 7704, 7706, 0,
    0, 7866, 0, 0, 0, 0,
    204, 205, 206, 296, 207, 0, 0, 298,
    300, 302, 304, 463, 0, 0, 0, 520,
    522, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7882, 0, 0, 7724, 0,
    0, 7880, 0, 0, 0, 0,
    504, 323, 0, 209, 0, 0, 325, 0,
    0, 0, 7748, 327, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7750, 7752, 7754, 0, 0,
    0, 0, 0, 0, 0, 0,
    210, 211, 212, 213, 214, 0, 0, 332,
    334, 490, 558, 465, 336, 0, 416, 524,
    526, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7884, 0, 0, 0, 0,
    0, 7886, 0, 0, 0, 0,
    217, 218, 219, 360, 220, 366, 0, 362,
    364, 370, 0, 467, 368, 0, 431, 532,
    534, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7908, 0, 7798, 7796, 0,
    7794, 7910, 0, 0, 0, 0,
    7922, 221, 374, 7928, 376, 0, 0, 562,
    0, 0, 7822, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7924, 0, 0, 0, 0,
    0, 7926, 0, 0, 0, 0,
    224, 225, 226, 227, 228, 229, 0, 257,
    259, 261, 551, 462, 0, 0, 0, 513,
    515, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7681, 7841, 0, 0, 0, 0,
    0, 7843, 0, 0, 0, 0,
    0, 263, 265, 0, 0, 0, 231, 0,
    0, 0, 267, 269, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    232, 233, 234, 7869, 235, 0, 553, 275,
    277, 281, 279, 283, 0, 0, 0, 517,
    519, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7865, 0, 7705, 7707, 0,
    0, 7867, 0, 0, 0, 0,
    236, 237, 238, 297, 239, 0, 0, 299,
    301, 303, 0, 464, 0, 0, 0, 521,
    523, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7883, 0, 0, 7725, 0,
    0, 7881, 0, 0, 0, 0,
    505, 324, 0, 241, 0, 0, 326, 0,
    0, 0, 7749, 328, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7751, 7753, 7755, 0, 0,
    0, 0, 0, 0, 0, 0,
    242, 243, 244, 245, 246, 0, 0, 333,
    335, 491, 559, 466, 337, 0, 417, 525,
    527, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7885, 0, 0, 0, 0,
    0, 7887, 0, 0, 0, 0,
    249, 250, 251, 361, 252, 367, 0, 363,
    365, 371, 0, 468, 369, 0, 432, 533,
    535, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7909, 0, 7799, 7797, 0,
    7795, 7911, 0, 0, 0, 0,
    7923, 253, 375, 7929, 255, 7833, 0, 563,
    0, 0, 7823, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7925, 0, 0, 0, 0,
    0, 7927, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 7696, 0,
    0, 0, 7690, 270, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7692, 7694, 7698, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 7697, 0,
    0, 0, 7691, 271, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7693, 7695, 7699, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 500, 284, 0, 0, 0, 290, 7712,
    286, 0, 288, 486, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 501, 285, 0, 0, 0, 291, 7713,
    287, 0, 289, 487, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 292, 0, 7718, 0, 7720, 0,
    0, 0, 7714, 542, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7716, 0, 0, 0, 7722,
    0, 0, 0, 0, 0, 0,
    0, 0, 293, 0, 7719, 0, 7721, 0,
    0, 0, 7715, 543, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7717, 7830, 0, 0, 7723,
    0, 0, 0, 0, 0, 0,
    0, 0, 308, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 309, 0, 0, 0, 0, 0,
    0, 0, 0, 496, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 7728, 0, 0, 0, 0, 310, 0,
    0, 0, 0, 488, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7730, 7732, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 7729, 0, 0, 0, 0, 311, 0,
    0, 0, 0, 489, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7731, 7733, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 313, 0, 0, 0, 0, 315, 0,
    0, 0, 0, 317, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7734, 7738, 7740, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 314, 0, 0, 0, 0, 316, 0,
    0, 0, 0, 318, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7735, 7739, 7741, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 340, 0, 0, 0, 0, 342, 0,
    0, 0, 7768, 344, 0, 0, 0, 528,
    530, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7770, 7774, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 341, 0, 0, 0, 0, 343, 0,
    0, 0, 7769, 345, 0, 0, 0, 529,
    531, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7771, 7775, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 346, 348, 0, 0, 0, 350, 0,
    0, 0, 7776, 352, 0, 0, 0, 0,
    0, 536, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7778, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 347, 349, 0, 0, 0, 351, 0,
    0, 0, 7777, 353, 0, 0, 0, 0,
    0, 537, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7779, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 354, 0,
    0, 0, 7786, 356, 0, 0, 0, 0,
    0, 538, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7788, 7790, 7792, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7831, 0, 355, 0,
    0, 0, 7787, 357, 0, 0, 0, 0,
    0, 539, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7789, 7791, 7793, 0, 0,
    0, 0, 0, 0, 0, 0,
    7808, 7810, 372, 0, 7812, 0, 0, 0,
    0, 0, 7814, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7816, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    7809, 7811, 373, 0, 7813, 7832, 0, 0,
    0, 0, 7815, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7817, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 377, 7824, 0, 0, 0, 0, 0,
    0, 0, 379, 381, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7826, 7828, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 378, 7825, 0, 0, 0, 0, 0,
    0, 0, 380, 382, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7827, 7829, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8602, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8603, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8622, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    475, 471, 0, 0, 0, 0, 0, 469,
    0, 0, 0, 473, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    476, 472, 0, 0, 0, 0, 0, 470,
    0, 0, 0, 474, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 478,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 479,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 480,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 481,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 508, 0, 0, 0, 0, 0, 482,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 509, 0, 0, 0, 0, 0, 483,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 492,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 493,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 494, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 495, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 506, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 507, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 510, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 511, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8740, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8742, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 554,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 555,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 7756, 0, 0, 7758, 0, 0, 556,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 7757, 0, 0, 7759, 0, 0, 557,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 560,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 561,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8769, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8772, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8775, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8777, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8800, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8802, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8813, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8814, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8815, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8816, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8817, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8820, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8821, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8824, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8825, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8832, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8833, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8836, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8837, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8840, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8841, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8876, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8877, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8878, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8879, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8928, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8929, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8930, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8931, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8938, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8939, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8940, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8941, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    8173, 901, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 8129, 0,
    8122, 902, 0, 0, 0, 0, 0, 8121,
    8120, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7944, 7945, 0, 8124,
    8136, 904, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7960, 7961, 0, 0,
    8138, 905, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7976, 7977, 0, 8140,
    8154, 906, 0, 0, 938, 0, 0, 8153,
    8152, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7992, 7993, 0, 0,
    8184, 908, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 8008, 8009, 0, 0,
    8170, 910, 0, 0, 939, 0, 0, 8169,
    8168, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 8025, 0, 0,
    8186, 911, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 8040, 8041, 0, 8188,
    8146, 912, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 8151, 0,
    8048, 940, 0, 0, 0, 0, 0, 8113,
    8112, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7936, 7937, 8118, 8115,
    8050, 941, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7952, 7953, 0, 0,
    8052, 942, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7968, 7969, 8134, 8131,
    8054, 943, 0, 0, 970, 0, 0, 8145,
    8144, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7984, 7985, 8150, 0,
    8162, 944, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 8167, 0,
    8058, 973, 0, 0, 971, 0, 0, 8161,
    8160, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 8016, 8017, 8166, 0,
    8056, 972, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 8000, 8001, 0, 0,
    8060, 974, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 8032, 8033, 8182, 8179,
    0, 979, 0, 0, 980, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    1024, 0, 0, 0, 1025, 0, 0, 0,
    1238, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 1027, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1031, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 1036, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    1037, 0, 0, 0, 1252, 0, 0, 1250,
    1049, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1264, 0, 0, 1262,
    1038, 0, 0, 0, 1266, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    1117, 0, 0, 0, 1253, 0, 0, 1251,
    1081, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    1104, 0, 0, 0, 1105, 0, 0, 0,
    1239, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 1107, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1111, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 1116, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1265, 0, 0, 1263,
    1118, 0, 0, 0, 1267, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1142,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1143,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1244, 0, 0, 0,
    1217, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1245, 0, 0, 0,
    1218, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1234, 0, 0, 0,
    1232, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1235, 0, 0, 0,
    1233, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1242, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1243, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1246, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1247, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1254, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1255, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1258, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1259, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1260, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1261, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1268, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1269, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1272, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1273, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1570, 1571, 1573, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1572, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1574, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1728, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1730, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1747, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2345, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2353, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2356, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2507, 2508,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8653, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8654, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8655, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2888, 2891, 2892, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2964, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3020, 3018, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3019, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8708, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8713, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3144, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8716, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3264, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3271, 3272,
    3274, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3275, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 3402, 3404, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 3403, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3546, 3548, 3550, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3549, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 4134, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12364,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12366,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12368,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12370,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12372,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12374,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12376,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12378,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12380,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12382,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12384,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12386,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12389,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12391,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12393,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12400,
    12401, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12403,
    12404, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12406,
    12407, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12409,
    12410, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12412,
    12413, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12436,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12446,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12460,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12462,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12464,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12466,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12468,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12470,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12472,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12474,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12476,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12478,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12480,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12482,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12485,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12487,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12489,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12496,
    12497, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12499,
    12500, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12502,
    12503, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12505,
    12506, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12508,
    12509, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12532,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12535,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12536,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12537,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12538,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12542,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -6, -7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -8, -9, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -11, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -12, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6918, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6920, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6922, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6924, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6926, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6930, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6971, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6973, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6976, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6977, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6979, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7682, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7684, 7686, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7683, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7685, 7687, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 7688, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 7689, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    7700, 7702, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    7701, 7703, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    7708, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    7709, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7710, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7711, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 7726, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 7727, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7736,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7737,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 7742, 0, 0, 0, 0, 0, 0,
    0, 0, 7744, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7746, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 7743, 0, 0, 0, 0, 0, 0,
    0, 0, 7745, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7747, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    7760, 7762, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    7761, 7763, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 7764, 0, 0, 0, 0, 0, 0,
    0, 0, 7766, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 7765, 0, 0, 0, 0, 0, 0,
    0, 0, 7767, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7772,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7773,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7780, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7781, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7782, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7783, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7784, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7785, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 7800, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 7801, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7802, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7803, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 7804, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7806, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 7805, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7807, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7820, 0, 0, 0,
    0, 0, 7818, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7821, 0, 0, 0,
    0, 0, 7819, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7835, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    7846, 7844, 0, 7850, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7848, 0, 0, 0, 0,
    7847, 7845, 0, 7851, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7849, 0, 0, 0, 0,
    0, 0, 7852, 0, 0, 0, 0, 0,
    7862, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 7853, 0, 0, 0, 0, 0,
    7863, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    7856, 7854, 0, 7860, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7858, 0, 0, 0, 0,
    7857, 7855, 0, 7861, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7859, 0, 0, 0, 0,
    7872, 7870, 0, 7876, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7874, 0, 0, 0, 0,
    7873, 7871, 0, 7877, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7875, 0, 0, 0, 0,
    0, 0, 7878, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 7879, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    7890, 7888, 0, 7894, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7892, 0, 0, 0, 0,
    7891, 7889, 0, 7895, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7893, 0, 0, 0, 0,
    0, 0, 7896, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 7897, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    7900, 7898, 0, 7904, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7906, 0, 0, 0, 0,
    0, 7902, 0, 0, 0, 0,
    7901, 7899, 0, 7905, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7907, 0, 0, 0, 0,
    0, 7903, 0, 0, 0, 0,
    7914, 7912, 0, 7918, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7920, 0, 0, 0, 0,
    0, 7916, 0, 0, 0, 0,
    7915, 7913, 0, 7919, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7921, 0, 0, 0, 0,
    0, 7917, 0, 0, 0, 0,
    7938, 7940, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7942, 8064,
    7939, 7941, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7943, 8065,
    7946, 7948, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7950, 8072,
    7947, 7949, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7951, 8073,
    7954, 7956, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    7955, 7957, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    7962, 7964, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    7963, 7965, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    7970, 7972, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7974, 8080,
    7971, 7973, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7975, 8081,
    7978, 7980, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7982, 8088,
    7979, 7981, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7983, 8089,
    7986, 7988, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7990, 0,
    7987, 7989, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7991, 0,
    7994, 7996, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7998, 0,
    7995, 7997, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7999, 0,
    8002, 8004, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    8003, 8005, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    8010, 8012, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    8011, 8013, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    8018, 8020, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 8022, 0,
    8019, 8021, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 8023, 0,
    8027, 8029, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 8031, 0,
    8034, 8036, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 8038, 8096,
    8035, 8037, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 8039, 8097,
    8042, 8044, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 8046, 8104,
    8043, 8045, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 8047, 8105,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8066,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8067,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8068,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8069,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8070,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8071,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8074,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8075,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8076,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8077,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8078,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8079,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8082,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8083,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8084,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8085,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8086,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8087,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8090,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8091,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8092,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8093,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8094,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8095,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8098,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8099,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8100,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8101,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8102,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8103,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8106,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8107,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8108,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8109,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8110,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8111,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8114,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8116,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8119,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8130,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8132,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8135,
    8141, 8142, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 8143, 0,
    8157, 8158, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 8159, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 8164, 8165, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 8172, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8178,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8180,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8183,
};

