/* SPDX-License-Identifier: GPL-2.0-or-later */

#include <baseboard/gpio.h>
#include <baseboard/variants.h>
#include <boardid.h>
#include <soc/gpio.h>

/* Pad configuration in ramstage*/
static const struct pad_config gpio_table[] = {
	/* GPP_A */
	/* GPP_A00:     ESPI_IO0_AIC */
	/*  GPP_A00 : GPP_A00 ==> ESPI_IO0_EC_R configured on reset, do not touch */

	/* GPP_A01:     ESPI_IO1_AIC */
	/*  GPP_A01 : GPP_A01 ==> ESPI_IO1_EC_R configured on reset, do not touch */

	/* GPP_A02:     ESPI_IO2_AIC */
	/*  GPP_A02 : GPP_A02 ==> ESPI_IO2_EC_R configured on reset, do not touch */

	/* GPP_A03:     ESPI_IO3_AIC */
	/*  GPP_A03 : GPP_A03 ==> ESPI_IO3_EC_R configured on reset, do not touch */

	/* GPP_A04:     ESPI_CS0_AIC_N */
	/*  GPP_A04 : GPP_A04 ==> ESPI_CS0_HDR_L configured on reset, do not touch */

	/* GPP_A05:     ESPI_CLK_AIC */
	/*  GPP_A05 : GPP_A05 ==> ESPI_CLK_HDR configured on reset, do not touch */

	/* GPP_A06:     ESPI_RST_AIC_N */
	/*  GPP_A06 : GPP_A06 ==> ESPI_RST_HDR configured on reset, do not touch */

	/* GPP_A08:     M2_GEN4_SSD_RESET_N */
	PAD_CFG_GPO(GPP_A08, 1, PLTRST),
	/* GPP_A09:     M.2_WWAN_FCP_OFF_N */
	PAD_CFG_GPO(GPP_A09, 1, PLTRST),
	/* GPP_A10:     WWAN_DISABLE_N */
	PAD_CFG_GPO(GPP_A10, 1, PLTRST),
	/* GPP_A11:     WLAN_RST_N */
	PAD_CFG_GPO(GPP_A11, 1, PLTRST),
	/* GPP_A12:     WIFI_WAKE_N */
	PAD_CFG_GPI_SCI_LOW(GPP_A12, NONE, DEEP, LEVEL),
	/* GPP_A13:     PCIE_LNK_DOWN */
	PAD_CFG_NF_OWNERSHIP(GPP_A13, NONE, DEEP, NF2, ACPI),
	/* GPP_A15:     CODEC_GPIO_EN */
	PAD_CFG_GPO(GPP_A15, 1, DEEP),

	/* GPP_B */
	/* GPP_B00:     USBC_SML_CLK_PD */
	PAD_CFG_NF(GPP_B00, NONE, DEEP, NF1),
	/* GPP_B01:     USBC_SML_DATA_PD */
	PAD_CFG_NF(GPP_B01, NONE, DEEP, NF1),
	/* GPP_B02:     ISH_I2C0_SDA_SNSR_HDR */
	PAD_NC(GPP_B02, NONE),
	/* GPP_B03:     ISH_I2C0_SCL_SNSR_HDR */
	PAD_NC(GPP_B03, NONE),
	/* GPP_B04:     ISH_GP_0_SNSR_HDR */
	PAD_NC(GPP_B04, NONE),
	/* GPP_B06:     SOC_PDB_CTRL */
	PAD_CFG_GPO(GPP_B06, 0, DEEP),
	/* GPP_B08:     ISH_GP_4_SNSR_HDR */
	PAD_NC(GPP_B08, NONE),
	/* GPP_B09:     BT_RF_KILL_N */
	PAD_CFG_GPO(GPP_B09, 1, DEEP),
	/* GPP_B10:     NC */
	PAD_NC(GPP_B10, NONE),
	/* GPP_B12:     PM_SLP_S0_N */
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),
	/* GPP_B13:     PLT_RST_N */
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),
	/* GPP_B14:     GPP_B14_DDSP_HPDB */
	PAD_CFG_NF(GPP_B14, NONE, DEEP, NF2),
	/* GPP_B16:     COINLESS_MODE_SELECT */
	PAD_CFG_GPI(GPP_B16, NONE, DEEP),
	/* GPP_B17:     SPI_TPM_INT_N */
	PAD_CFG_GPI_APIC_LOCK(GPP_B17, NONE, LEVEL, INVERT, LOCK_CONFIG),
	/* GPP_B20:     WWAN_RST_N */
	PAD_CFG_GPO(GPP_B20, 1, PLTRST),
	/* GPP_B21:     TCP_RETIMER_FORCE_PWR */
	PAD_CFG_GPO(GPP_B21, 0, DEEP),
	/* GPP_B24:     ESPI_ALERT0_EC_R_N */
	PAD_NC(GPP_B24, NONE),
	/* GPP_B25:     None */
	PAD_NC(GPP_B25, NONE),

	/* GPP_C */
	/* GPP_C00:     SPD_SMB_CLK */
	PAD_CFG_NF(GPP_C00, NONE, DEEP, NF1),
	/* GPP_C01:     SPD_SMB_DATA */
	PAD_CFG_NF(GPP_C01, NONE, DEEP, NF1),
	/* GPP_C02:     NC */
	PAD_NC(GPP_C02, NONE),
	/* GPP_C03:     TCP_LAN_SML0_SCL_R */
	PAD_CFG_NF(GPP_C03, NONE, DEEP, NF1),
	/* GPP_C04:     TCP_LAN_SML0_SDA_R */
	PAD_CFG_NF(GPP_C04, NONE, DEEP, NF1),
	/* GPP_C05:     NC */
	PAD_NC(GPP_C05, NONE),
	/* GPP_C06:     NC */
	PAD_NC(GPP_C06, NONE),
	/* GPP_C07:     NC */
	PAD_NC(GPP_C07, NONE),
	/* GPP_C08:     PM_SLP_S0_N_GPP_CNTRL */
	PAD_CFG_GPO(GPP_C08, 1, PLTRST),
	/* GPP_C09:     CLKREQ0_X1_GEN4_M2_WLAN_N */
	PAD_CFG_NF(GPP_C09, NONE, DEEP, NF1),
	/* GPP_C10:     WIFI_RF_KILL_N */
	PAD_CFG_GPO(GPP_C10, 1, DEEP),
	/* GPP_C11:     CLKREQ2_X4_GEN4_DT_CEM_SLOT1_N */
	PAD_CFG_NF(GPP_C11, NONE, DEEP, NF1),
	/* GPP_C12:     CLKREQ3_X4_GEN4_M2_SSD_N */
	PAD_CFG_NF(GPP_C12, NONE, DEEP, NF1),
	/* GPP_C13:     CLKREQ4_X4_GEN4_DT_CEM_SLOT2_N */
	PAD_CFG_NF(GPP_C13, NONE, DEEP, NF1),
	/* GPP_C14:     CLKREQ5_X1_GEN1_GBE_LAN_N */
	PAD_CFG_NF(GPP_C14, NONE, DEEP, NF1),
	/* GPP_C15:     FPS_RST_N */
	PAD_CFG_GPO_LOCK(GPP_C15, 1, LOCK_CONFIG),
	/* GPP_C16:     MOD_TCSS1_LS_TX_DDC_SCL */
	PAD_CFG_NF(GPP_C16, NONE, DEEP, NF1),
	/* GPP_C17:     MOD_TCSS1_LS_RX_DDC_SDA */
	PAD_CFG_NF(GPP_C17, NONE, DEEP, NF1),
	/* GPP_C18:     MOD_TCSS2_LS_TX_DDC_SCL */
	PAD_CFG_NF(GPP_C18, NONE, DEEP, NF1),
	/* GPP_C19:     MOD_TCSS2_LS_RX_DDC_SDA */
	PAD_CFG_NF(GPP_C19, NONE, DEEP, NF1),
	/* GPP_C22:     DDPB_HDMI_CTRLCLK */
	PAD_CFG_NF(GPP_C22, NONE, DEEP, NF2),
	/* GPP_C23:     DDPB_HDMI_CTRLDATA */
	PAD_CFG_NF(GPP_C23, NONE, DEEP, NF2),

	/* GPP_D */
	/* GPP_D01:     MOD_TCSS1_TYP_A_VBUS_EN */
	PAD_CFG_GPO(GPP_D01, 1, DEEP),
	/* GPP_D02:     SOC_WP_OD */
	PAD_CFG_GPO(GPP_D02, 0, DEEP),
	/* GPP_D03:     X4_SLOT_WAKE_N */
	PAD_CFG_GPI_SCI_LOW(GPP_D03, NONE, DEEP, LEVEL),
	/* GPP_D07:     ISH_UART0_RTS_N_SNSR_HDR */
	PAD_NC(GPP_D07, NONE),
	/* GPP_D08:     ISH_UART0_CTS_N_SNSR_HDR */
	PAD_NC(GPP_D08, NONE),
	/* GPP_D09:     I2S_MCLK_HDR */
	PAD_CFG_NF(GPP_D09, NONE, DEEP, NF1),
	/* GPP_D10:     HDA_BCLK (HDR) */
	PAD_CFG_NF(GPP_D10, NONE, DEEP, NF1),
	/* GPP_D11:     HDA_SYNC (HDR) */
	PAD_CFG_NF(GPP_D11, NONE, DEEP, NF1),
	/* GPP_D12:     HDA_SDO (HDR) */
	PAD_CFG_NF(GPP_D12, NONE, DEEP, NF1),
	/* GPP_D13:     HDA_SDI0 (HDR) */
	PAD_CFG_NF(GPP_D13, NONE, DEEP, NF1),
	/* GPP_D16:     HDA_RST_N (HDR) */
	PAD_CFG_NF(GPP_D16, NONE, DEEP, NF1),
	/* GPP_D17:     HDA_SDI1 (HDR) */
	PAD_CFG_NF(GPP_D17, NONE, DEEP, NF1),
	/* GPP_D19:     NC */
	PAD_NC(GPP_D19, NONE),
	/* GPP_D21:     GPP_D21_UFS_REFCLK_R */
	PAD_CFG_NF(GPP_D21, NONE, DEEP, NF1),

	/* GPP_E */
	/* GPP_E01:     PM_SLP_DRAM_N */
	PAD_CFG_NF(GPP_E01, NONE, DEEP, NF2),
	/* GPP_E02:     NC */
	PAD_NC(GPP_E02, NONE),
	/* GPP_E03:     X4_DT_PCIE_RST_N */
	PAD_CFG_GPO(GPP_E03, 1, PLTRST),
	/* GPP_E05:     GPP_E5_FPS_PWREN */
	PAD_CFG_GPO(GPP_E05, 1, DEEP),
	/* GPP_E06:     GPP_E6_PEN_DETECT */
	PAD_CFG_GPI_TRIG_OWN(GPP_E06, NONE, DEEP, LEVEL, ACPI),
	/* GPP_E07:     LAN_GPIO_RST_N */
	PAD_CFG_GPO(GPP_E07, 1, PLTRST),
	/* GPP_E08:     EC_SOC_INT_ODL */
	PAD_CFG_GPI(GPP_E08, NONE, DEEP),
	/* GPP_E09:     USB_FP_CONN_1_CONN_2_OC0_N */
	PAD_CFG_NF(GPP_E09, NONE, DEEP, NF1),
	/* GPP_E10:     M2_UFS_DET_SEL_N */
	PAD_CFG_GPI(GPP_E10, NONE, DEEP),
	/* GPP_E11:     THC0_SPI1_CLK_TCH_PNL1 */
	PAD_CFG_NF(GPP_E11, NONE, DEEP, NF3),
	/* GPP_E12:     THC_I2C0_SCL_TCH_PNL1 */
	PAD_CFG_NF(GPP_E12, NONE, DEEP, NF3),
	/* GPP_E13:     THC_I2C0_SDA_TCH_PNL1 */
	PAD_CFG_NF(GPP_E13, NONE, DEEP, NF3),
	/* GPP_E14:     THC0_SPI1_IO_2_TCH_PNL1 */
	PAD_CFG_NF(GPP_E14, NONE, DEEP, NF3),
	/* GPP_E15:     THC0_SPI1_IO_3_TCH_PNL1 */
	PAD_CFG_NF(GPP_E15, NONE, DEEP, NF3),
	/* GPP_E16:     THC0_SPI1_RST_N_TCH_PNL1 */
	PAD_CFG_NF(GPP_E16, NONE, PLTRST, NF1),
	/* GPP_E17:     GPP_E17_GSPI0A_CS0 */
	PAD_CFG_NF(GPP_E17, NONE, DEEP, NF5),
	/* GPP_E18:     THC0_SPI1_INT_N_TCH_PNL1 */
	PAD_CFG_NF(GPP_E18, NONE, DEEP, NF3),
	/* GPP_E19:     FPS_INT_N */
	PAD_CFG_GPI_IRQ_WAKE(GPP_E19, NONE, PWROK, LEVEL, INVERT),
	/* GPP_E20:     FPS_FW_UPDATE */
	PAD_CFG_GPO_LOCK(GPP_E20, 0, LOCK_CONFIG),
	/* GPP_E21:     I2C_PMC_PD_INT_N */
	PAD_CFG_NF(GPP_E21, NONE, DEEP, NF1),
	/* GPP_E22:     NC */
	PAD_NC(GPP_E22, NONE),

	/* GPP_F */
	/* GPP_F00:     M.2_CNV_BRI_DT_BT_UART2_RTS_N */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_F00, NONE, DEEP, NF1),
	/* GPP_F01:     M.2_CNV_BRI_RSP_BT_UART2_RXD */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_F01, NONE, DEEP, NF1),
	/* GPP_F02:     M.2_CNV_RGI_DT_BT_UART2_TXD */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_F02, NONE, DEEP, NF1),
	/* GPP_F03:     M.2_CNV_RGI_RSP_BT_UART2_CTS_N */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_F03, NONE, DEEP, NF1),
	/* GPP_F04:     CNV_RF_RESET_R_N */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_F04, NONE, DEEP, NF1),
	/* GPP_F05:     CRF_CLKREQ_R */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_F05, NONE, DEEP, NF3),
	/* GPP_F06:     DISC_WLAN_WWAN_COEX3 */
	PAD_CFG_NF(GPP_F06, NONE, DEEP, NF1),
	/* GPP_F07:     FUSA_DIAGTEST_EN_HDR */
	PAD_CFG_NF(GPP_F07, NONE, DEEP, NF2),
	/* GPP_F08:     TCH_PNL1_PWR_EN */
	PAD_CFG_GPO(GPP_F08, 1, PLTRST),
	/* GPP_F09:     M2_UFS_RST_N */
	PAD_CFG_GPO(GPP_F09, 1, DEEP),
	/* GPP_F10:     X4_PCIE_SLOT1_PWR_EN */
	PAD_CFG_GPO(GPP_F10, 1, PLTRST),
	/* GPP_F11:     THC1_SPI2_CLK_TCH_PNL2 */
	PAD_CFG_NF(GPP_F11, NONE, DEEP, NF11),
	/* GPP_F12:     THC_I2C1_SCL_TCH_PAD */
	PAD_CFG_NF(GPP_F12, NONE, DEEP, NF8),
	/* GPP_F13:     THC_I2C1_SDA_TCH_PAD */
	PAD_CFG_NF(GPP_F13, NONE, DEEP, NF8),
	/* GPP_F14:     GPP_F14_GPSI0A_MOSI */
	PAD_CFG_NF(GPP_F14, NONE, DEEP, NF8),
	/* GPP_F15:     GPP_F15_GSPI0A_MISO */
	PAD_CFG_NF(GPP_F15, NONE, DEEP, NF8),
	/* GPP_F16:     GPP_F16_GSPI0A_CLK */
	PAD_CFG_NF(GPP_F16, NONE, DEEP, NF8),
	/* GPP_F17:     CODEC_INT_N */
	PAD_CFG_GPI_INT(GPP_F17, NONE, PLTRST, EDGE_BOTH),
	/* GPP_F18:     TCH_PAD_INT_N */
	PAD_CFG_GPI_APIC_DRIVER(GPP_F18, NONE, PLTRST, EDGE_SINGLE, INVERT),
	/* GPP_F19:     NC */
	PAD_NC(GPP_F19, NONE),
	/* GPP_F20:     CSE_EARLY_SW */
	PAD_CFG_GPI(GPP_F20, NONE, DEEP),
	/* GPP_F22:     THC1_SPI2_DSYNC */
	PAD_CFG_NF(GPP_F22, NONE, DEEP, NF3),

	/* GPP_H */
	/* GPP_H00:     NC */
	PAD_NC(GPP_H00, NONE),
	/* GPP_H01:     M2_UFS_SLP_N */
	PAD_CFG_GPO(GPP_H01, 1, DEEP),
	/* GPP_H02:     DEBUG_TRACE_PNP */
	PAD_CFG_GPO(GPP_H02, 1, PLTRST),
	/* GPP_H03:     MIC MUTE */
	PAD_CFG_NF(GPP_H03, NONE, DEEP, NF1),
	/* GPP_H04:     CNV_MFUART2_RXD */
	PAD_CFG_NF(GPP_H04, NONE, DEEP, NF1),
	/* GPP_H05:     CNV_MFUART2_TXD */
	PAD_CFG_NF(GPP_H05, NONE, DEEP, NF1),
	/* GPP_H06:     I2C3_SCL_AUDIO_HDR */
	PAD_CFG_NF(GPP_H06, NONE, DEEP, NF1),
	/* GPP_H07:     I2C3_SDA_AUDIO_HDR */
	PAD_CFG_NF(GPP_H07, NONE, DEEP, NF1),
	/* GPP_H08:     SOC_BIOS_LOG_TTK_UART_RX */
	PAD_CFG_NF(GPP_H08, NONE, DEEP, NF1),
	/* GPP_H09:     SOC_BIOS_LOG_TTK_UART_TX */
	PAD_CFG_NF(GPP_H09, NONE, DEEP, NF1),
	/* GPP_H10:     UART0_BUF_RTS */
	PAD_CFG_NF(GPP_H10, NONE, DEEP, NF1),
	/* GPP_H11:     UART0_BUF_CTS */
	PAD_CFG_NF(GPP_H11, NONE, DEEP, NF1),
	/* GPP_H13:     CPU_C10_GATE_N_R */
	PAD_CFG_NF(GPP_H13, NONE, DEEP, NF1),
	/* GPP_H14:     ISH_I3C1_SDA_SNSR_HDR */
	PAD_NC(GPP_H14, NONE),
	/* GPP_H15:     ISH_I3C1_SCL_SNSR_HDR */
	PAD_NC(GPP_H15, NONE),
	/* GPP_H17:     MIC MUTE LED */
	PAD_CFG_NF(GPP_H17, NONE, DEEP, NF1),
	/* GPP_H18:     GEN4_SSD_PWREN */
	PAD_CFG_GPO(GPP_H18, 1, DEEP),
	/* GPP_H19:     I3C0_SDA_HDR */
	PAD_CFG_NF(GPP_H19, NONE, DEEP, NF2),
	/* GPP_H20:     I3C0_SCL_HDR */
	PAD_CFG_NF(GPP_H20, NONE, DEEP, NF2),
	/* GPP_H21:     I2C1_SDA_TTK_CHROME */
	PAD_CFG_NF(GPP_H21, NONE, DEEP, NF1),
	/* GPP_H22:     I2C1_SCL_TTK_CHROME */
	PAD_CFG_NF(GPP_H22, NONE, DEEP, NF1),
	/* GPP_H23:     TP */
	PAD_CFG_NF(GPP_H23, NONE, DEEP, NF1),
	/* GPP_H24:     TP */
	PAD_CFG_NF(GPP_H24, NONE, DEEP, NF1),

	/* GPP_V */
	/* GPP_V00:     PM_BATLOW_N */
	PAD_CFG_NF(GPP_V00, NONE, DEEP, NF1),
	/* GPP_V01:     BC_ACOK_MCP */
	PAD_CFG_NF(GPP_V01, NONE, DEEP, NF1),
	/* GPP_V02:     LANWAKE_N_R */
	PAD_CFG_NF(GPP_V02, NONE, DEEP, NF1),
	/* GPP_V03:     PWRBTN_MCP_N */
	PAD_CFG_NF(GPP_V03, NONE, DEEP, NF1),
	/* GPP_V04:     PM_SLP_S3_N */
	PAD_CFG_NF(GPP_V04, NONE, DEEP, NF1),
	/* GPP_V05:     PM_SLP_S4_N */
	PAD_CFG_NF(GPP_V05, NONE, DEEP, NF1),
	/* GPP_V06:     PM_SLP_A_N */
	PAD_CFG_NF(GPP_V06, NONE, DEEP, NF1),
	/* GPP_V07:     M.2_BTWIFI_SUS_CLK_LS */
	PAD_CFG_NF(GPP_V07, NONE, DEEP, NF1),
	/* GPP_V08:     SLP_WLAN_N */
	PAD_CFG_NF(GPP_V08, NONE, DEEP, NF1),
	/* GPP_V09:     PM_SLP_S5_N */
	PAD_CFG_NF(GPP_V09, NONE, DEEP, NF1),
	/* GPP_V10:     LANPHYPC_R_N */
	PAD_CFG_NF(GPP_V10, NONE, DEEP, NF1),
	/* GPP_V11:     PM_SLP_LAN_N */
	PAD_CFG_NF(GPP_V11, NONE, DEEP, NF1),
	/* GPP_V12:     WAKE_N */
	PAD_CFG_NF(GPP_V12, NONE, DEEP, NF1),
	/* GPP_V13:     GPP_V13_CATERR_N */
	PAD_CFG_NF(GPP_V13, NONE, DEEP, NF1),
	/* GPP_V14:     GPP_V14_FORCEPR_N */
	PAD_CFG_NF(GPP_V14, NONE, DEEP, NF1),
	/* GPP_V15:     GPP_V15_THERMTRIP_N */
	PAD_CFG_NF(GPP_V15, NONE, DEEP, NF1),
	/* GPP_V16:     GPP_V16_VCCST_EN */
	PAD_CFG_NF(GPP_V16, NONE, DEEP, NF1),
};

/* Early pad configuration in bootblock */
static const struct pad_config early_gpio_table[] = {
	/* GPP_B17:     SPI_TPM_INT_N */
	PAD_CFG_GPI_APIC(GPP_B17, NONE, DEEP, LEVEL, INVERT),
	/* GPP_H06: I2C3_SDA_PSS */
	PAD_CFG_NF(GPP_H06, NONE, DEEP, NF1),
	/* GPP_H07: I2C3_SCL_PSS */
	PAD_CFG_NF(GPP_H07, NONE, DEEP, NF1),
	/* GPP_H08:     SOC_BIOS_LOG_TTK_UART_RX */
	PAD_CFG_NF(GPP_H08, NONE, DEEP, NF1),
	/* GPP_H09:     SOC_BIOS_LOG_TTK_UART_TX */
	PAD_CFG_NF(GPP_H09, NONE, DEEP, NF1),
	/* GPP_H21:     I2C1_SDA_TTK_CHROME */
	PAD_CFG_NF(GPP_H21, NONE, DEEP, NF1),
	/* GPP_H22:     I2C1_SCL_TTK_CHROME */
	PAD_CFG_NF(GPP_H22, NONE, DEEP, NF1),
};

/* Pad configuration in romstage */
static const struct pad_config romstage_gpio_table[] = {
	/* GPP_C00:     SPD_SMB_CLK */
	PAD_CFG_NF(GPP_C00, NONE, DEEP, NF1),
	/* GPP_C01:     SPD_SMB_DATA */
	PAD_CFG_NF(GPP_C01, NONE, DEEP, NF1),
	/* GPP_C15:     FPS_RST_N */
	PAD_CFG_GPO(GPP_C15, 0, PLTRST),
};

const struct pad_config *variant_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(gpio_table);
	return gpio_table;
}

const struct pad_config *variant_early_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(early_gpio_table);
	return early_gpio_table;
}

/* Create the stub for romstage gpio, typically use for power sequence */
const struct pad_config *variant_romstage_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(romstage_gpio_table);
	return romstage_gpio_table;
}

static const struct cros_gpio cros_gpios[] = {
	CROS_GPIO_REC_AL(CROS_GPIO_VIRTUAL, CROS_GPIO_DEVICE0_NAME),
	CROS_GPIO_REC_AL(CROS_GPIO_VIRTUAL, CROS_GPIO_DEVICE1_NAME),
	CROS_GPIO_REC_AL(CROS_GPIO_VIRTUAL, CROS_GPIO_DEVICE2_NAME),
	CROS_GPIO_REC_AL(CROS_GPIO_VIRTUAL, CROS_GPIO_DEVICE3_NAME),
	CROS_GPIO_WP_AH(GPIO_PCH_WP, CROS_GPIO_DEVICE4_NAME),
};

DECLARE_CROS_GPIOS(cros_gpios);
