# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_discriminator, rest_field
from ._enums import ResourceKind

if TYPE_CHECKING:
    from .. import models as _models


class AppComponent(_model_base.Model):
    """An Azure resource object (Refer azure generic resource model
    :`https://learn.microsoft.com/en-us/rest/api/resources/resources/get-by-id#genericresource
    <https://learn.microsoft.com/en-us/rest/api/resources/resources/get-by-id#genericresource>`_).

    :ivar resource_id: fully qualified resource Id e.g
     subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.
     Required.
    :vartype resource_id: str
    :ivar resource_name: Azure resource name, required while creating the app component. Required.
    :vartype resource_name: str
    :ivar resource_type: Azure resource type, required while creating the app component. Required.
    :vartype resource_type: str
    :ivar display_name: Azure resource display name.
    :vartype display_name: str
    :ivar resource_group: Resource group name of the Azure resource.
    :vartype resource_group: str
    :ivar subscription_id: Subscription Id of the Azure resource.
    :vartype subscription_id: str
    :ivar kind: Kind of Azure resource type.
    :vartype kind: str
    """

    resource_id: str = rest_field(name="resourceId", visibility=["read"])
    """fully qualified resource Id e.g
     subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.
     Required."""
    resource_name: str = rest_field(name="resourceName", visibility=["read", "create", "update", "delete", "query"])
    """Azure resource name, required while creating the app component. Required."""
    resource_type: str = rest_field(name="resourceType", visibility=["read", "create", "update", "delete", "query"])
    """Azure resource type, required while creating the app component. Required."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource display name."""
    resource_group: Optional[str] = rest_field(name="resourceGroup", visibility=["read"])
    """Resource group name of the Azure resource."""
    subscription_id: Optional[str] = rest_field(name="subscriptionId", visibility=["read"])
    """Subscription Id of the Azure resource."""
    kind: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Kind of Azure resource type."""

    @overload
    def __init__(
        self,
        *,
        resource_name: str,
        resource_type: str,
        display_name: Optional[str] = None,
        kind: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ArtifactsContainerInfo(_model_base.Model):
    """Artifacts container info.

    :ivar url: This is a SAS URI to an Azure Storage Container that contains the test run
     artifacts.
    :vartype url: str
    :ivar expire_date_time: Expiry time of the container (RFC 3339 literal format).
    :vartype expire_date_time: ~datetime.datetime
    """

    url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """This is a SAS URI to an Azure Storage Container that contains the test run artifacts."""
    expire_date_time: Optional[datetime.datetime] = rest_field(
        name="expireDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Expiry time of the container (RFC 3339 literal format)."""

    @overload
    def __init__(
        self,
        *,
        url: Optional[str] = None,
        expire_date_time: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutoStopCriteria(_model_base.Model):
    """Auto stop criteria for a test. This will automatically stop a load test if the error percentage
    is high for a certain time window.

    :ivar auto_stop_disabled: Whether auto-stop should be disabled. The default value is false.
    :vartype auto_stop_disabled: bool
    :ivar error_rate: Threshold percentage of errors on which test run should be automatically
     stopped. Allowed values are in range of 0.0-100.0.
    :vartype error_rate: float
    :ivar error_rate_time_window_in_seconds: Time window during which the error percentage should
     be evaluated in seconds.
    :vartype error_rate_time_window_in_seconds: int
    """

    auto_stop_disabled: Optional[bool] = rest_field(
        name="autoStopDisabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether auto-stop should be disabled. The default value is false."""
    error_rate: Optional[float] = rest_field(
        name="errorRate", visibility=["read", "create", "update", "delete", "query"]
    )
    """Threshold percentage of errors on which test run should be automatically stopped. Allowed
     values are in range of 0.0-100.0."""
    error_rate_time_window_in_seconds: Optional[int] = rest_field(
        name="errorRateTimeWindowInSeconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Time window during which the error percentage should be evaluated in seconds."""

    @overload
    def __init__(
        self,
        *,
        auto_stop_disabled: Optional[bool] = None,
        error_rate: Optional[float] = None,
        error_rate_time_window_in_seconds: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificateMetadata(_model_base.Model):
    """Certificates metadata.

    :ivar value: The value of the certificate for respective type.
    :vartype value: str
    :ivar type: Type of certificate. "AKV_CERT_URI"
    :vartype type: str or ~azure.developer.loadtesting.models.CertificateType
    :ivar name: Name of the certificate.
    :vartype name: str
    """

    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the certificate for respective type."""
    type: Optional[Union[str, "_models.CertificateType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of certificate. \"AKV_CERT_URI\""""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the certificate."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[str] = None,
        type: Optional[Union[str, "_models.CertificateType"]] = None,
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DimensionFilter(_model_base.Model):
    """Dimension name and values to filter.

    :ivar name: The dimension name.
    :vartype name: str
    :ivar values_property: The dimension values. Maximum values can be 20.
    :vartype values_property: list[str]
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The dimension name."""
    values_property: Optional[List[str]] = rest_field(
        name="values", visibility=["read", "create", "update", "delete", "query"]
    )
    """The dimension values. Maximum values can be 20."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        values_property: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DimensionValue(_model_base.Model):
    """Represents a metric dimension value.

    :ivar name: The name of the dimension.
    :vartype name: str
    :ivar value: The value of the dimension.
    :vartype value: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the dimension."""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the dimension."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorDetails(_model_base.Model):
    """Error details if there is any failure in load test run.

    :ivar message: Error details in case test run was not successfully run.
    :vartype message: str
    """

    message: Optional[str] = rest_field(visibility=["read"])
    """Error details in case test run was not successfully run."""


class FunctionFlexConsumptionResourceConfiguration(_model_base.Model):  # pylint: disable=name-too-long
    """Resource configuration instance for a Flex Consumption based Azure Function App.

    :ivar instance_memory_mb: Memory size of the instance. Supported values are 2048, 4096.
     Required.
    :vartype instance_memory_mb: int
    :ivar http_concurrency: HTTP Concurrency for the function app.
    :vartype http_concurrency: int
    """

    instance_memory_mb: int = rest_field(
        name="instanceMemoryMB", visibility=["read", "create", "update", "delete", "query"]
    )
    """Memory size of the instance. Supported values are 2048, 4096. Required."""
    http_concurrency: Optional[int] = rest_field(
        name="httpConcurrency", visibility=["read", "create", "update", "delete", "query"]
    )
    """HTTP Concurrency for the function app."""

    @overload
    def __init__(
        self,
        *,
        instance_memory_mb: int,
        http_concurrency: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TargetResourceConfigurations(_model_base.Model):
    """Configurations of a target resource. This varies with the kind of resource.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FunctionFlexConsumptionTargetResourceConfigurations

    :ivar kind: Kind of the resource for which the configurations apply. Required.
     "FunctionsFlexConsumption"
    :vartype kind: str or ~azure.developer.loadtesting.models.ResourceKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create"])
    """Kind of the resource for which the configurations apply. Required. \"FunctionsFlexConsumption\""""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FunctionFlexConsumptionTargetResourceConfigurations(
    TargetResourceConfigurations, discriminator="FunctionsFlexConsumption"
):  # pylint: disable=name-too-long
    """Configurations for a Function App using Flex Consumption Plan.

    :ivar kind: The kind value to use when providing configuration.
     This should typically be not changed from its value. Required. Resource is a Azure FunctionApp
     on Flex Consumption Plan.
    :vartype kind: str or ~azure.developer.loadtesting.models.FUNCTIONS_FLEX_CONSUMPTION
    :ivar configurations: A map of configurations for a Function app using Flex Consumption Plan.
    :vartype configurations: dict[str,
     ~azure.developer.loadtesting.models.FunctionFlexConsumptionResourceConfiguration]
    """

    kind: Literal[ResourceKind.FUNCTIONS_FLEX_CONSUMPTION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind value to use when providing configuration.
     This should typically be not changed from its value. Required. Resource is a Azure FunctionApp
     on Flex Consumption Plan."""
    configurations: Optional[Dict[str, "_models.FunctionFlexConsumptionResourceConfiguration"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A map of configurations for a Function app using Flex Consumption Plan."""

    @overload
    def __init__(
        self,
        *,
        configurations: Optional[Dict[str, "_models.FunctionFlexConsumptionResourceConfiguration"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=ResourceKind.FUNCTIONS_FLEX_CONSUMPTION, **kwargs)


class LoadTestConfiguration(_model_base.Model):
    """Configurations for the load test.

    :ivar engine_instances: The number of engine instances to execute load test. Supported values
     are in range of 1-400. Required for creating a new test.
    :vartype engine_instances: int
    :ivar split_all_csvs: If false, Azure Load Testing copies and processes your input files
     unmodified
     across all test engine instances. If true, Azure Load Testing splits the CSV
     input data evenly across all engine instances. If you provide multiple CSV
     files, each file will be split evenly.
    :vartype split_all_csvs: bool
    :ivar quick_start_test: If true, optionalLoadTestConfig is required and JMX script for the load
     test is
     not required to upload.
    :vartype quick_start_test: bool
    :ivar optional_load_test_config: Configuration for quick load test.
    :vartype optional_load_test_config:
     ~azure.developer.loadtesting.models.OptionalLoadTestConfiguration
    :ivar regional_load_test_config: Region distribution configuration for the load test.
    :vartype regional_load_test_config:
     list[~azure.developer.loadtesting.models.RegionalConfiguration]
    """

    engine_instances: Optional[int] = rest_field(
        name="engineInstances", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of engine instances to execute load test. Supported values are in range of 1-400.
     Required for creating a new test."""
    split_all_csvs: Optional[bool] = rest_field(
        name="splitAllCSVs", visibility=["read", "create", "update", "delete", "query"]
    )
    """If false, Azure Load Testing copies and processes your input files unmodified
     across all test engine instances. If true, Azure Load Testing splits the CSV
     input data evenly across all engine instances. If you provide multiple CSV
     files, each file will be split evenly."""
    quick_start_test: Optional[bool] = rest_field(
        name="quickStartTest", visibility=["read", "create", "update", "delete", "query"]
    )
    """If true, optionalLoadTestConfig is required and JMX script for the load test is
     not required to upload."""
    optional_load_test_config: Optional["_models.OptionalLoadTestConfiguration"] = rest_field(
        name="optionalLoadTestConfig", visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration for quick load test."""
    regional_load_test_config: Optional[List["_models.RegionalConfiguration"]] = rest_field(
        name="regionalLoadTestConfig", visibility=["read", "create", "update", "delete", "query"]
    )
    """Region distribution configuration for the load test."""

    @overload
    def __init__(
        self,
        *,
        engine_instances: Optional[int] = None,
        split_all_csvs: Optional[bool] = None,
        quick_start_test: Optional[bool] = None,
        optional_load_test_config: Optional["_models.OptionalLoadTestConfiguration"] = None,
        regional_load_test_config: Optional[List["_models.RegionalConfiguration"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetricAvailability(_model_base.Model):
    """Metric availability specifies the time grain (aggregation interval or frequency).

    :ivar time_grain: The time grain specifies the aggregation interval for the metric. Expressed
     as
     a duration 'PT1M', 'PT1H', etc. Known values are: "PT5S", "PT10S", "PT1M", "PT5M", and "PT1H".
    :vartype time_grain: str or ~azure.developer.loadtesting.models.TimeGrain
    """

    time_grain: Optional[Union[str, "_models.TimeGrain"]] = rest_field(
        name="timeGrain", visibility=["read", "create", "update", "delete", "query"]
    )
    """The time grain specifies the aggregation interval for the metric. Expressed as
     a duration 'PT1M', 'PT1H', etc. Known values are: \"PT5S\", \"PT10S\", \"PT1M\", \"PT5M\", and
     \"PT1H\"."""

    @overload
    def __init__(
        self,
        *,
        time_grain: Optional[Union[str, "_models.TimeGrain"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetricDefinition(_model_base.Model):
    """Metric definition.

    :ivar dimensions: List of dimensions.
    :vartype dimensions: list[~azure.developer.loadtesting.models.NameAndDescription]
    :ivar description: The metric description.
    :vartype description: str
    :ivar name: The metric name.
    :vartype name: str
    :ivar namespace: The namespace the metric belongs to.
    :vartype namespace: str
    :ivar primary_aggregation_type: The primary aggregation type value defining how to use the
     values for display. Known values are: "Average", "Count", "None", "Total", "Percentile75",
     "Percentile90", "Percentile95", "Percentile96", "Percentile97", "Percentile98", "Percentile99",
     "Percentile999", and "Percentile9999".
    :vartype primary_aggregation_type: str or ~azure.developer.loadtesting.models.Aggregation
    :ivar supported_aggregation_types: The collection of what all aggregation types are supported.
    :vartype supported_aggregation_types: list[str]
    :ivar unit: The unit of the metric. Known values are: "NotSpecified", "Percent", "Count",
     "Seconds", "Milliseconds", "Bytes", "BytesPerSecond", and "CountPerSecond".
    :vartype unit: str or ~azure.developer.loadtesting.models.MetricUnit
    :ivar metric_availabilities: Metric availability specifies the time grain (aggregation interval
     or
     frequency).
    :vartype metric_availabilities: list[~azure.developer.loadtesting.models.MetricAvailability]
    """

    dimensions: Optional[List["_models.NameAndDescription"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of dimensions."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The metric description."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The metric name."""
    namespace: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The namespace the metric belongs to."""
    primary_aggregation_type: Optional[Union[str, "_models.Aggregation"]] = rest_field(
        name="primaryAggregationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The primary aggregation type value defining how to use the values for display. Known values
     are: \"Average\", \"Count\", \"None\", \"Total\", \"Percentile75\", \"Percentile90\",
     \"Percentile95\", \"Percentile96\", \"Percentile97\", \"Percentile98\", \"Percentile99\",
     \"Percentile999\", and \"Percentile9999\"."""
    supported_aggregation_types: Optional[List[str]] = rest_field(
        name="supportedAggregationTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of what all aggregation types are supported."""
    unit: Optional[Union[str, "_models.MetricUnit"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The unit of the metric. Known values are: \"NotSpecified\", \"Percent\", \"Count\",
     \"Seconds\", \"Milliseconds\", \"Bytes\", \"BytesPerSecond\", and \"CountPerSecond\"."""
    metric_availabilities: Optional[List["_models.MetricAvailability"]] = rest_field(
        name="metricAvailabilities", visibility=["read", "create", "update", "delete", "query"]
    )
    """Metric availability specifies the time grain (aggregation interval or
     frequency)."""

    @overload
    def __init__(
        self,
        *,
        dimensions: Optional[List["_models.NameAndDescription"]] = None,
        description: Optional[str] = None,
        name: Optional[str] = None,
        namespace: Optional[str] = None,
        primary_aggregation_type: Optional[Union[str, "_models.Aggregation"]] = None,
        supported_aggregation_types: Optional[List[str]] = None,
        unit: Optional[Union[str, "_models.MetricUnit"]] = None,
        metric_availabilities: Optional[List["_models.MetricAvailability"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetricDefinitionCollection(_model_base.Model):
    """Represents collection of metric definitions.

    :ivar value: the values for the metric definitions. Required.
    :vartype value: list[~azure.developer.loadtesting.models.MetricDefinition]
    """

    value: List["_models.MetricDefinition"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """the values for the metric definitions. Required."""

    @overload
    def __init__(
        self,
        *,
        value: List["_models.MetricDefinition"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetricNamespace(_model_base.Model):
    """Metric namespace class specifies the metadata for a metric namespace.

    :ivar description: The namespace description.
    :vartype description: str
    :ivar name: The metric namespace name.
    :vartype name: str
    """

    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The namespace description."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The metric namespace name."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetricNamespaceCollection(_model_base.Model):
    """Represents collection of metric namespaces.

    :ivar value: The values for the metric namespaces. Required.
    :vartype value: list[~azure.developer.loadtesting.models.MetricNamespace]
    """

    value: List["_models.MetricNamespace"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The values for the metric namespaces. Required."""

    @overload
    def __init__(
        self,
        *,
        value: List["_models.MetricNamespace"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetricRequestPayload(_model_base.Model):
    """Filters to fetch the set of metric.

    :ivar filters: Get metrics for specific dimension values. Example: Metric contains dimension
     like SamplerName, Error. To retrieve all the time series data where SamplerName
     is equals to HTTPRequest1 or HTTPRequest2, the DimensionFilter value will be
     {"SamplerName", ["HTTPRequest1", "HTTPRequest2"}.
    :vartype filters: list[~azure.developer.loadtesting.models.DimensionFilter]
    """

    filters: Optional[List["_models.DimensionFilter"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Get metrics for specific dimension values. Example: Metric contains dimension
     like SamplerName, Error. To retrieve all the time series data where SamplerName
     is equals to HTTPRequest1 or HTTPRequest2, the DimensionFilter value will be
     {\"SamplerName\", [\"HTTPRequest1\", \"HTTPRequest2\"}."""

    @overload
    def __init__(
        self,
        *,
        filters: Optional[List["_models.DimensionFilter"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetricValue(_model_base.Model):
    """Represents a metric value.

    :ivar timestamp: The timestamp for the metric value in RFC 3339 format.
    :vartype timestamp: ~datetime.datetime
    :ivar value: The metric value.
    :vartype value: float
    """

    timestamp: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp for the metric value in RFC 3339 format."""
    value: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The metric value."""

    @overload
    def __init__(
        self,
        *,
        timestamp: Optional[datetime.datetime] = None,
        value: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NameAndDescription(_model_base.Model):
    """The name and description.

    :ivar description: The description.
    :vartype description: str
    :ivar name: The name.
    :vartype name: str
    """

    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OptionalLoadTestConfiguration(_model_base.Model):
    """Configuration for quick load test.

    :ivar endpoint_url: Test URL. Provide the complete HTTP URL. For example,
     `https://contoso-app.azurewebsites.net/login <https://contoso-app.azurewebsites.net/login>`_.
    :vartype endpoint_url: str
    :ivar requests_per_second: Target throughput (requests per second). This may not be necessarily
     achieved. The actual throughput will be lower if the application is not capable of handling it.
    :vartype requests_per_second: int
    :ivar max_response_time_in_ms: Maximum response time in milliseconds of the API/endpoint.
    :vartype max_response_time_in_ms: int
    :ivar virtual_users: No of concurrent virtual users.
    :vartype virtual_users: int
    :ivar ramp_up_time: Ramp up time in seconds.
    :vartype ramp_up_time: int
    :ivar duration: Test run duration in seconds.
    :vartype duration: int
    """

    endpoint_url: Optional[str] = rest_field(
        name="endpointUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """Test URL. Provide the complete HTTP URL. For example,
     `https://contoso-app.azurewebsites.net/login <https://contoso-app.azurewebsites.net/login>`_."""
    requests_per_second: Optional[int] = rest_field(
        name="requestsPerSecond", visibility=["read", "create", "update", "delete", "query"]
    )
    """Target throughput (requests per second). This may not be necessarily achieved. The actual
     throughput will be lower if the application is not capable of handling it."""
    max_response_time_in_ms: Optional[int] = rest_field(
        name="maxResponseTimeInMs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum response time in milliseconds of the API/endpoint."""
    virtual_users: Optional[int] = rest_field(
        name="virtualUsers", visibility=["read", "create", "update", "delete", "query"]
    )
    """No of concurrent virtual users."""
    ramp_up_time: Optional[int] = rest_field(
        name="rampUpTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """Ramp up time in seconds."""
    duration: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Test run duration in seconds."""

    @overload
    def __init__(
        self,
        *,
        endpoint_url: Optional[str] = None,
        requests_per_second: Optional[int] = None,
        max_response_time_in_ms: Optional[int] = None,
        virtual_users: Optional[int] = None,
        ramp_up_time: Optional[int] = None,
        duration: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PassFailCriteria(_model_base.Model):
    """Pass fail criteria for a test.

    :ivar pass_fail_metrics: Map of id and pass fail metrics { id  : pass fail metrics }.
    :vartype pass_fail_metrics: dict[str, ~azure.developer.loadtesting.models.PassFailMetric]
    :ivar pass_fail_server_metrics: Map of id and pass fail server metrics { id  : pass fail
     metrics }.
    :vartype pass_fail_server_metrics: dict[str,
     ~azure.developer.loadtesting.models.PassFailServerMetric]
    """

    pass_fail_metrics: Optional[Dict[str, "_models.PassFailMetric"]] = rest_field(
        name="passFailMetrics", visibility=["read", "create", "update", "delete", "query"]
    )
    """Map of id and pass fail metrics { id  : pass fail metrics }."""
    pass_fail_server_metrics: Optional[Dict[str, "_models.PassFailServerMetric"]] = rest_field(
        name="passFailServerMetrics", visibility=["read", "create", "update", "delete", "query"]
    )
    """Map of id and pass fail server metrics { id  : pass fail metrics }."""

    @overload
    def __init__(
        self,
        *,
        pass_fail_metrics: Optional[Dict[str, "_models.PassFailMetric"]] = None,
        pass_fail_server_metrics: Optional[Dict[str, "_models.PassFailServerMetric"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PassFailMetric(_model_base.Model):
    """Pass fail metric.

    :ivar client_metric: The client metric on which the criteria should be applied. Known values
     are: "response_time_ms", "latency", "error", "requests", and "requests_per_sec".
    :vartype client_metric: str or ~azure.developer.loadtesting.models.PFMetrics
    :ivar aggregate: The aggregation function to be applied on the client metric. Allowed functions
     * ‘percentage’ - for error metric , ‘avg’, percentiles like ‘p50’, ‘p90’, & so on, ‘min’,
     ‘max’ - for response_time_ms and latency metric, ‘avg’ - for requests_per_sec,
     ‘count’ - for requests. Known values are: "count", "percentage", "avg", "p50", "p75", "p90",
     "p95", "p96", "p97", "p98", "p99", "p99.9", "p99.99", "min", and "max".
    :vartype aggregate: str or ~azure.developer.loadtesting.models.PassFailAggregationFunction
    :ivar condition: The comparison operator. Supported types ‘>’, ‘<’.
    :vartype condition: str
    :ivar request_name: Request name for which the Pass fail criteria has to be applied.
    :vartype request_name: str
    :ivar value: The value to compare with the client metric. Allowed values - ‘error : [0.0 ,
     100.0] unit- % ’, response_time_ms and latency : any integer value unit- ms.
    :vartype value: float
    :ivar action: Action taken after the threshold is met. Default is ‘continue’. Known values are:
     "continue" and "stop".
    :vartype action: str or ~azure.developer.loadtesting.models.PassFailAction
    :ivar actual_value: The actual value of the client metric for the test run.
    :vartype actual_value: float
    :ivar result: Outcome of the test run. Known values are: "passed", "undetermined", and
     "failed".
    :vartype result: str or ~azure.developer.loadtesting.models.PassFailResult
    """

    client_metric: Optional[Union[str, "_models.PFMetrics"]] = rest_field(
        name="clientMetric", visibility=["read", "create", "update", "delete", "query"]
    )
    """The client metric on which the criteria should be applied. Known values are:
     \"response_time_ms\", \"latency\", \"error\", \"requests\", and \"requests_per_sec\"."""
    aggregate: Optional[Union[str, "_models.PassFailAggregationFunction"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The aggregation function to be applied on the client metric. Allowed functions
     * ‘percentage’ - for error metric , ‘avg’, percentiles like ‘p50’, ‘p90’, & so on, ‘min’,
     ‘max’ - for response_time_ms and latency metric, ‘avg’ - for requests_per_sec,
     ‘count’ - for requests. Known values are: \"count\", \"percentage\", \"avg\", \"p50\", \"p75\",
     \"p90\", \"p95\", \"p96\", \"p97\", \"p98\", \"p99\", \"p99.9\", \"p99.99\", \"min\", and
     \"max\"."""
    condition: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The comparison operator. Supported types ‘>’, ‘<’."""
    request_name: Optional[str] = rest_field(
        name="requestName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Request name for which the Pass fail criteria has to be applied."""
    value: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value to compare with the client metric. Allowed values - ‘error : [0.0 ,
     100.0] unit- % ’, response_time_ms and latency : any integer value unit- ms."""
    action: Optional[Union[str, "_models.PassFailAction"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Action taken after the threshold is met. Default is ‘continue’. Known values are: \"continue\"
     and \"stop\"."""
    actual_value: Optional[float] = rest_field(name="actualValue", visibility=["read"])
    """The actual value of the client metric for the test run."""
    result: Optional[Union[str, "_models.PassFailResult"]] = rest_field(visibility=["read"])
    """Outcome of the test run. Known values are: \"passed\", \"undetermined\", and \"failed\"."""

    @overload
    def __init__(
        self,
        *,
        client_metric: Optional[Union[str, "_models.PFMetrics"]] = None,
        aggregate: Optional[Union[str, "_models.PassFailAggregationFunction"]] = None,
        condition: Optional[str] = None,
        request_name: Optional[str] = None,
        value: Optional[float] = None,
        action: Optional[Union[str, "_models.PassFailAction"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PassFailServerMetric(_model_base.Model):
    """Pass fail server metric.

    :ivar resource_id: The resource id of the resource emitting the metric. Required.
    :vartype resource_id: str
    :ivar metric_namespace: The server metric namespace. Required.
    :vartype metric_namespace: str
    :ivar metric_name: The server metric name. Required.
    :vartype metric_name: str
    :ivar aggregation: Aggregation Type. Required.
    :vartype aggregation: str
    :ivar condition: The comparison operator. Supported types ‘>’, ‘<’. Required.
    :vartype condition: str
    :ivar value: The value to compare with the server metric. Required.
    :vartype value: float
    :ivar action: Action taken after the threshold is met. Default is ‘continue’. Known values are:
     "continue" and "stop".
    :vartype action: str or ~azure.developer.loadtesting.models.PassFailAction
    :ivar actual_value: The actual value of the server metric.
    :vartype actual_value: float
    :ivar result: Outcome of the test run. Known values are: "passed", "undetermined", and
     "failed".
    :vartype result: str or ~azure.developer.loadtesting.models.PassFailResult
    """

    resource_id: str = rest_field(name="resourceId", visibility=["read", "create", "update", "delete", "query"])
    """The resource id of the resource emitting the metric. Required."""
    metric_namespace: str = rest_field(
        name="metricNamespace", visibility=["read", "create", "update", "delete", "query"]
    )
    """The server metric namespace. Required."""
    metric_name: str = rest_field(name="metricName", visibility=["read", "create", "update", "delete", "query"])
    """The server metric name. Required."""
    aggregation: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Aggregation Type. Required."""
    condition: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The comparison operator. Supported types ‘>’, ‘<’. Required."""
    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value to compare with the server metric. Required."""
    action: Optional[Union[str, "_models.PassFailAction"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Action taken after the threshold is met. Default is ‘continue’. Known values are: \"continue\"
     and \"stop\"."""
    actual_value: Optional[float] = rest_field(name="actualValue", visibility=["read"])
    """The actual value of the server metric."""
    result: Optional[Union[str, "_models.PassFailResult"]] = rest_field(visibility=["read"])
    """Outcome of the test run. Known values are: \"passed\", \"undetermined\", and \"failed\"."""

    @overload
    def __init__(
        self,
        *,
        resource_id: str,
        metric_namespace: str,
        metric_name: str,
        aggregation: str,
        condition: str,
        value: float,
        action: Optional[Union[str, "_models.PassFailAction"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RegionalConfiguration(_model_base.Model):
    """Region distribution configuration for the load test.

    :ivar engine_instances:   The number of engine instances to execute load test in specified
     region. Supported values are in range of 1-400. Required.
    :vartype engine_instances: int
    :ivar region: Azure region name.
     The region name should of format accepted by ARM, and should be a region supported by Azure
     Load Testing. For example, East US should be passed as "eastus".
     The region name must match one of the strings in the "Name" column returned from running the
     "az account list-locations -o table" Azure CLI command. Required.
    :vartype region: str
    """

    engine_instances: int = rest_field(
        name="engineInstances", visibility=["read", "create", "update", "delete", "query"]
    )
    """  The number of engine instances to execute load test in specified region. Supported values are
     in range of 1-400. Required."""
    region: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Azure region name.
     The region name should of format accepted by ARM, and should be a region supported by Azure
     Load Testing. For example, East US should be passed as \"eastus\".
     The region name must match one of the strings in the \"Name\" column returned from running the
     \"az account list-locations -o table\" Azure CLI command. Required."""

    @overload
    def __init__(
        self,
        *,
        engine_instances: int,
        region: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceMetric(_model_base.Model):
    """Associated metric definition for particular metrics of the azure resource (
    Refer :
    `https://learn.microsoft.com/en-us/rest/api/monitor/metric-definitions/list#metricdefinition
    <https://learn.microsoft.com/en-us/rest/api/monitor/metric-definitions/list#metricdefinition>`_).

    :ivar id: Unique name for metric.
    :vartype id: str
    :ivar resource_id: Azure resource id. Required.
    :vartype resource_id: str
    :ivar metric_namespace: Metric name space. Required.
    :vartype metric_namespace: str
    :ivar display_description: Metric description.
    :vartype display_description: str
    :ivar name: The invariant value of metric name. Required.
    :vartype name: str
    :ivar aggregation: Metric aggregation. Required.
    :vartype aggregation: str
    :ivar unit: Metric unit.
    :vartype unit: str
    :ivar resource_type: Azure resource type. Required.
    :vartype resource_type: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Unique name for metric."""
    resource_id: str = rest_field(name="resourceId", visibility=["read", "create", "update", "delete", "query"])
    """Azure resource id. Required."""
    metric_namespace: str = rest_field(
        name="metricNamespace", visibility=["read", "create", "update", "delete", "query"]
    )
    """Metric name space. Required."""
    display_description: Optional[str] = rest_field(
        name="displayDescription", visibility=["read", "create", "update", "delete", "query"]
    )
    """Metric description."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The invariant value of metric name. Required."""
    aggregation: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metric aggregation. Required."""
    unit: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metric unit."""
    resource_type: str = rest_field(name="resourceType", visibility=["read", "create", "update", "delete", "query"])
    """Azure resource type. Required."""

    @overload
    def __init__(
        self,
        *,
        resource_id: str,
        metric_namespace: str,
        name: str,
        aggregation: str,
        resource_type: str,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Secret(_model_base.Model):
    """Secret.

    :ivar value: The value of the secret for the respective type.
    :vartype value: str
    :ivar type: Type of secret. Known values are: "AKV_SECRET_URI" and "SECRET_VALUE".
    :vartype type: str or ~azure.developer.loadtesting.models.SecretType
    """

    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the secret for the respective type."""
    type: Optional[Union[str, "_models.SecretType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of secret. Known values are: \"AKV_SECRET_URI\" and \"SECRET_VALUE\"."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[str] = None,
        type: Optional[Union[str, "_models.SecretType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Test(_model_base.Model):
    """Load test model.

    :ivar pass_fail_criteria: Pass fail criteria for a test.
    :vartype pass_fail_criteria: ~azure.developer.loadtesting.models.PassFailCriteria
    :ivar auto_stop_criteria: Auto stop criteria for a test. This will automatically stop a load
     test if the error percentage is high for a certain time window.
    :vartype auto_stop_criteria: ~azure.developer.loadtesting.models.AutoStopCriteria
    :ivar secrets: Secrets can be stored in an Azure Key Vault or any other secret store. If the
     secret is stored in an Azure Key Vault, the value should be the secret
     identifier and the type should be AKV_SECRET_URI. If the secret is stored
     elsewhere, the secret value should be provided directly and the type should be
     SECRET_VALUE.
    :vartype secrets: dict[str, ~azure.developer.loadtesting.models.Secret]
    :ivar certificate: Certificates metadata.
    :vartype certificate: ~azure.developer.loadtesting.models.CertificateMetadata
    :ivar environment_variables: Environment variables which are defined as a set of <name,value>
     pairs.
    :vartype environment_variables: dict[str, str]
    :ivar load_test_configuration: The load test configuration.
    :vartype load_test_configuration: ~azure.developer.loadtesting.models.LoadTestConfiguration
    :ivar baseline_test_run_id: Id of the test run to be marked as baseline to view trends of
     client-side metrics from recent test runs.
    :vartype baseline_test_run_id: str
    :ivar input_artifacts: The input artifacts for the test.
    :vartype input_artifacts: ~azure.developer.loadtesting.models.TestInputArtifacts
    :ivar test_id: Unique test identifier for the load test, must contain only lower-case
     alphabetic, numeric, underscore or hyphen characters. Required.
    :vartype test_id: str
    :ivar description: The test description.
    :vartype description: str
    :ivar display_name: Display name of a test.
    :vartype display_name: str
    :ivar subnet_id: Subnet ID on which the load test instances should run.
    :vartype subnet_id: str
    :ivar kind: Kind of test. Known values are: "URL", "JMX", and "Locust".
    :vartype kind: str or ~azure.developer.loadtesting.models.TestKind
    :ivar public_ip_disabled: Inject load test engines without deploying public IP for outbound
     access.
    :vartype public_ip_disabled: bool
    :ivar keyvault_reference_identity_type: Type of the managed identity referencing the Key vault.
    :vartype keyvault_reference_identity_type: str
    :ivar keyvault_reference_identity_id: Resource Id of the managed identity referencing the Key
     vault.
    :vartype keyvault_reference_identity_id: str
    :ivar metrics_reference_identity_type: Type of the managed identity referencing the metrics.
     Known values are: "SystemAssigned" and "UserAssigned".
    :vartype metrics_reference_identity_type: str or
     ~azure.developer.loadtesting.models.ManagedIdentityType
    :ivar metrics_reference_identity_id: Resource Id of the managed identity referencing the
     metrics.
    :vartype metrics_reference_identity_id: str
    :ivar engine_built_in_identity_type: Type of the managed identity built in load test engines.
     Known values are: "SystemAssigned" and "UserAssigned".
    :vartype engine_built_in_identity_type: str or
     ~azure.developer.loadtesting.models.ManagedIdentityType
    :ivar engine_built_in_identity_ids: Resource Ids of the managed identity built in to load test
     engines. Required if engineBuiltInIdentityType is UserAssigned.
    :vartype engine_built_in_identity_ids: list[str]
    :ivar created_date_time: The creation datetime(RFC 3339 literal format).
    :vartype created_date_time: ~datetime.datetime
    :ivar created_by: The user that created.
    :vartype created_by: str
    :ivar last_modified_date_time: The last Modified datetime(RFC 3339 literal format).
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar last_modified_by: The user that last modified.
    :vartype last_modified_by: str
    """

    pass_fail_criteria: Optional["_models.PassFailCriteria"] = rest_field(
        name="passFailCriteria", visibility=["read", "create", "update", "delete", "query"]
    )
    """Pass fail criteria for a test."""
    auto_stop_criteria: Optional["_models.AutoStopCriteria"] = rest_field(
        name="autoStopCriteria", visibility=["read", "create", "update", "delete", "query"]
    )
    """Auto stop criteria for a test. This will automatically stop a load test if the error percentage
     is high for a certain time window."""
    secrets: Optional[Dict[str, "_models.Secret"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Secrets can be stored in an Azure Key Vault or any other secret store. If the
     secret is stored in an Azure Key Vault, the value should be the secret
     identifier and the type should be AKV_SECRET_URI. If the secret is stored
     elsewhere, the secret value should be provided directly and the type should be
     SECRET_VALUE."""
    certificate: Optional["_models.CertificateMetadata"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Certificates metadata."""
    environment_variables: Optional[Dict[str, str]] = rest_field(
        name="environmentVariables", visibility=["read", "create", "update", "delete", "query"]
    )
    """Environment variables which are defined as a set of <name,value> pairs."""
    load_test_configuration: Optional["_models.LoadTestConfiguration"] = rest_field(
        name="loadTestConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The load test configuration."""
    baseline_test_run_id: Optional[str] = rest_field(
        name="baselineTestRunId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Id of the test run to be marked as baseline to view trends of client-side metrics from recent
     test runs."""
    input_artifacts: Optional["_models.TestInputArtifacts"] = rest_field(name="inputArtifacts", visibility=["read"])
    """The input artifacts for the test."""
    test_id: str = rest_field(name="testId", visibility=["read"])
    """Unique test identifier for the load test, must contain only lower-case alphabetic, numeric,
     underscore or hyphen characters. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The test description."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of a test."""
    subnet_id: Optional[str] = rest_field(name="subnetId", visibility=["read", "create", "update", "delete", "query"])
    """Subnet ID on which the load test instances should run."""
    kind: Optional[Union[str, "_models.TestKind"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Kind of test. Known values are: \"URL\", \"JMX\", and \"Locust\"."""
    public_ip_disabled: Optional[bool] = rest_field(
        name="publicIPDisabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Inject load test engines without deploying public IP for outbound access."""
    keyvault_reference_identity_type: Optional[str] = rest_field(
        name="keyvaultReferenceIdentityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of the managed identity referencing the Key vault."""
    keyvault_reference_identity_id: Optional[str] = rest_field(
        name="keyvaultReferenceIdentityId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource Id of the managed identity referencing the Key vault."""
    metrics_reference_identity_type: Optional[Union[str, "_models.ManagedIdentityType"]] = rest_field(
        name="metricsReferenceIdentityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of the managed identity referencing the metrics. Known values are: \"SystemAssigned\" and
     \"UserAssigned\"."""
    metrics_reference_identity_id: Optional[str] = rest_field(
        name="metricsReferenceIdentityId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource Id of the managed identity referencing the metrics."""
    engine_built_in_identity_type: Optional[Union[str, "_models.ManagedIdentityType"]] = rest_field(
        name="engineBuiltInIdentityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of the managed identity built in load test engines. Known values are: \"SystemAssigned\"
     and \"UserAssigned\"."""
    engine_built_in_identity_ids: Optional[List[str]] = rest_field(
        name="engineBuiltInIdentityIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource Ids of the managed identity built in to load test engines. Required if
     engineBuiltInIdentityType is UserAssigned."""
    created_date_time: Optional[datetime.datetime] = rest_field(
        name="createdDateTime", visibility=["read"], format="rfc3339"
    )
    """The creation datetime(RFC 3339 literal format)."""
    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read"])
    """The user that created."""
    last_modified_date_time: Optional[datetime.datetime] = rest_field(
        name="lastModifiedDateTime", visibility=["read"], format="rfc3339"
    )
    """The last Modified datetime(RFC 3339 literal format)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy", visibility=["read"])
    """The user that last modified."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        pass_fail_criteria: Optional["_models.PassFailCriteria"] = None,
        auto_stop_criteria: Optional["_models.AutoStopCriteria"] = None,
        secrets: Optional[Dict[str, "_models.Secret"]] = None,
        certificate: Optional["_models.CertificateMetadata"] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        load_test_configuration: Optional["_models.LoadTestConfiguration"] = None,
        baseline_test_run_id: Optional[str] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        subnet_id: Optional[str] = None,
        kind: Optional[Union[str, "_models.TestKind"]] = None,
        public_ip_disabled: Optional[bool] = None,
        keyvault_reference_identity_type: Optional[str] = None,
        keyvault_reference_identity_id: Optional[str] = None,
        metrics_reference_identity_type: Optional[Union[str, "_models.ManagedIdentityType"]] = None,
        metrics_reference_identity_id: Optional[str] = None,
        engine_built_in_identity_type: Optional[Union[str, "_models.ManagedIdentityType"]] = None,
        engine_built_in_identity_ids: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestAppComponents(_model_base.Model):
    """Test app components.

    :ivar components: Azure resource collection { resource id (fully qualified resource Id e.g
     subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName})
     : resource object }. Required.
    :vartype components: dict[str, ~azure.developer.loadtesting.models.AppComponent]
    :ivar test_id: Test identifier.
    :vartype test_id: str
    :ivar created_date_time: The creation datetime(RFC 3339 literal format).
    :vartype created_date_time: ~datetime.datetime
    :ivar created_by: The user that created.
    :vartype created_by: str
    :ivar last_modified_date_time: The last Modified datetime(RFC 3339 literal format).
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar last_modified_by: The user that last modified.
    :vartype last_modified_by: str
    """

    components: Dict[str, "_models.AppComponent"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource collection { resource id (fully qualified resource Id e.g
     subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName})
     : resource object }. Required."""
    test_id: Optional[str] = rest_field(name="testId", visibility=["read"])
    """Test identifier."""
    created_date_time: Optional[datetime.datetime] = rest_field(
        name="createdDateTime", visibility=["read"], format="rfc3339"
    )
    """The creation datetime(RFC 3339 literal format)."""
    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read"])
    """The user that created."""
    last_modified_date_time: Optional[datetime.datetime] = rest_field(
        name="lastModifiedDateTime", visibility=["read"], format="rfc3339"
    )
    """The last Modified datetime(RFC 3339 literal format)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy", visibility=["read"])
    """The user that last modified."""

    @overload
    def __init__(
        self,
        *,
        components: Dict[str, "_models.AppComponent"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestFileInfo(_model_base.Model):
    """Test file info.

    :ivar file_name: Name of the file. Required.
    :vartype file_name: str
    :ivar url: File URL.
    :vartype url: str
    :ivar file_type: File type. Known values are: "JMX_FILE", "USER_PROPERTIES",
     "ADDITIONAL_ARTIFACTS", "ZIPPED_ARTIFACTS", "URL_TEST_CONFIG", and "TEST_SCRIPT".
    :vartype file_type: str or ~azure.developer.loadtesting.models.FileType
    :ivar expire_date_time: Expiry time of the file (RFC 3339 literal format).
    :vartype expire_date_time: ~datetime.datetime
    :ivar validation_status: Validation status of the file. Known values are: "NOT_VALIDATED",
     "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
     "VALIDATION_NOT_REQUIRED".
    :vartype validation_status: str or ~azure.developer.loadtesting.models.FileValidationStatus
    :ivar validation_failure_details: Validation failure error details.
    :vartype validation_failure_details: str
    """

    file_name: str = rest_field(name="fileName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the file. Required."""
    url: Optional[str] = rest_field(visibility=["read"])
    """File URL."""
    file_type: Optional[Union[str, "_models.FileType"]] = rest_field(name="fileType", visibility=["read"])
    """File type. Known values are: \"JMX_FILE\", \"USER_PROPERTIES\", \"ADDITIONAL_ARTIFACTS\",
     \"ZIPPED_ARTIFACTS\", \"URL_TEST_CONFIG\", and \"TEST_SCRIPT\"."""
    expire_date_time: Optional[datetime.datetime] = rest_field(
        name="expireDateTime", visibility=["read"], format="rfc3339"
    )
    """Expiry time of the file (RFC 3339 literal format)."""
    validation_status: Optional[Union[str, "_models.FileValidationStatus"]] = rest_field(
        name="validationStatus", visibility=["read"]
    )
    """Validation status of the file. Known values are: \"NOT_VALIDATED\", \"VALIDATION_SUCCESS\",
     \"VALIDATION_FAILURE\", \"VALIDATION_INITIATED\", and \"VALIDATION_NOT_REQUIRED\"."""
    validation_failure_details: Optional[str] = rest_field(name="validationFailureDetails", visibility=["read"])
    """Validation failure error details."""

    @overload
    def __init__(
        self,
        *,
        file_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestInputArtifacts(_model_base.Model):
    """The input artifacts for the test.

    :ivar config_file_info: The load test YAML file that contains the the test configuration.
    :vartype config_file_info: ~azure.developer.loadtesting.models.TestFileInfo
    :ivar test_script_file_info: The test script file for the test run.
    :vartype test_script_file_info: ~azure.developer.loadtesting.models.TestFileInfo
    :ivar user_prop_file_info: The user properties file.
    :vartype user_prop_file_info: ~azure.developer.loadtesting.models.TestFileInfo
    :ivar input_artifacts_zip_file_info: The zip file with all input artifacts.
    :vartype input_artifacts_zip_file_info: ~azure.developer.loadtesting.models.TestFileInfo
    :ivar url_test_config_file_info: The config json file for url based test.
    :vartype url_test_config_file_info: ~azure.developer.loadtesting.models.TestFileInfo
    :ivar additional_file_info: Additional supported files for the test run.
    :vartype additional_file_info: list[~azure.developer.loadtesting.models.TestFileInfo]
    """

    config_file_info: Optional["_models.TestFileInfo"] = rest_field(
        name="configFileInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The load test YAML file that contains the the test configuration."""
    test_script_file_info: Optional["_models.TestFileInfo"] = rest_field(
        name="testScriptFileInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The test script file for the test run."""
    user_prop_file_info: Optional["_models.TestFileInfo"] = rest_field(
        name="userPropFileInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user properties file."""
    input_artifacts_zip_file_info: Optional["_models.TestFileInfo"] = rest_field(
        name="inputArtifactsZipFileInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The zip file with all input artifacts."""
    url_test_config_file_info: Optional["_models.TestFileInfo"] = rest_field(
        name="urlTestConfigFileInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The config json file for url based test."""
    additional_file_info: Optional[List["_models.TestFileInfo"]] = rest_field(
        name="additionalFileInfo", visibility=["read"]
    )
    """Additional supported files for the test run."""

    @overload
    def __init__(
        self,
        *,
        config_file_info: Optional["_models.TestFileInfo"] = None,
        test_script_file_info: Optional["_models.TestFileInfo"] = None,
        user_prop_file_info: Optional["_models.TestFileInfo"] = None,
        input_artifacts_zip_file_info: Optional["_models.TestFileInfo"] = None,
        url_test_config_file_info: Optional["_models.TestFileInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestProfile(_model_base.Model):
    """Test Profile Model.

    :ivar test_profile_id: Unique identifier for the test profile, must contain only lower-case
     alphabetic, numeric, underscore or hyphen characters. Required.
    :vartype test_profile_id: str
    :ivar display_name: Display name of the test profile.
    :vartype display_name: str
    :ivar description: Description for the test profile.
    :vartype description: str
    :ivar test_id: Associated test ID for the test profile. This property is required for creating
     a Test Profile and it's not allowed to be updated.
    :vartype test_id: str
    :ivar target_resource_id: Target resource ID on which the test profile is created. This
     property is required for creating a Test Profile and it's not allowed to be updated.
    :vartype target_resource_id: str
    :ivar target_resource_configurations: Configurations of the target resource on which testing
     would be done.
    :vartype target_resource_configurations:
     ~azure.developer.loadtesting.models.TargetResourceConfigurations
    :ivar created_date_time: The creation datetime(RFC 3339 literal format).
    :vartype created_date_time: ~datetime.datetime
    :ivar created_by: The user that created.
    :vartype created_by: str
    :ivar last_modified_date_time: The last Modified datetime(RFC 3339 literal format).
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar last_modified_by: The user that last modified.
    :vartype last_modified_by: str
    """

    test_profile_id: str = rest_field(name="testProfileId", visibility=["read"])
    """Unique identifier for the test profile, must contain only lower-case alphabetic, numeric,
     underscore or hyphen characters. Required."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the test profile."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description for the test profile."""
    test_id: Optional[str] = rest_field(name="testId", visibility=["read", "create"])
    """Associated test ID for the test profile. This property is required for creating a Test Profile
     and it's not allowed to be updated."""
    target_resource_id: Optional[str] = rest_field(name="targetResourceId", visibility=["read", "create"])
    """Target resource ID on which the test profile is created. This property is required for creating
     a Test Profile and it's not allowed to be updated."""
    target_resource_configurations: Optional["_models.TargetResourceConfigurations"] = rest_field(
        name="targetResourceConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Configurations of the target resource on which testing would be done."""
    created_date_time: Optional[datetime.datetime] = rest_field(
        name="createdDateTime", visibility=["read"], format="rfc3339"
    )
    """The creation datetime(RFC 3339 literal format)."""
    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read"])
    """The user that created."""
    last_modified_date_time: Optional[datetime.datetime] = rest_field(
        name="lastModifiedDateTime", visibility=["read"], format="rfc3339"
    )
    """The last Modified datetime(RFC 3339 literal format)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy", visibility=["read"])
    """The user that last modified."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        test_id: Optional[str] = None,
        target_resource_id: Optional[str] = None,
        target_resource_configurations: Optional["_models.TargetResourceConfigurations"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestProfileRun(_model_base.Model):
    """Test Profile Run model.

    :ivar test_profile_run_id: Unique identifier for the test profile run, must contain only
     lower-case alphabetic, numeric, underscore or hyphen characters. Required.
    :vartype test_profile_run_id: str
    :ivar display_name: Display name for the test profile run.
    :vartype display_name: str
    :ivar description: The test profile run description.
    :vartype description: str
    :ivar test_profile_id: Associated test profile ID for the test profile run. This is required to
     create a test profile run and can't be updated.
    :vartype test_profile_id: str
    :ivar target_resource_id: Target resource ID on which the test profile run is created.
    :vartype target_resource_id: str
    :ivar target_resource_configurations: Configurations of the target resource on which the test
     profile ran.
    :vartype target_resource_configurations:
     ~azure.developer.loadtesting.models.TargetResourceConfigurations
    :ivar status: The test profile run status. Known values are: "ACCEPTED", "NOTSTARTED",
     "EXECUTING", "DONE", "CANCELLING", "CANCELLED", and "FAILED".
    :vartype status: str or ~azure.developer.loadtesting.models.TestProfileRunStatus
    :ivar error_details: Error details if there is any failure in test profile run. These errors
     are specific to the Test Profile Run.
    :vartype error_details: list[~azure.developer.loadtesting.models.ErrorDetails]
    :ivar start_date_time: The test profile run start DateTime(RFC 3339 literal format).
    :vartype start_date_time: ~datetime.datetime
    :ivar end_date_time: The test profile run end DateTime(RFC 3339 literal format).
    :vartype end_date_time: ~datetime.datetime
    :ivar duration_in_seconds: Test profile run duration in seconds.
    :vartype duration_in_seconds: int
    :ivar test_run_details: Details of the test runs ran as part of the test profile run.
     Key is the testRunId of the corresponding testRun.
    :vartype test_run_details: dict[str, ~azure.developer.loadtesting.models.TestRunDetail]
    :ivar recommendations: Recommendations provided based on a successful test profile run.
    :vartype recommendations:
     list[~azure.developer.loadtesting.models.TestProfileRunRecommendation]
    :ivar created_date_time: The creation datetime(RFC 3339 literal format).
    :vartype created_date_time: ~datetime.datetime
    :ivar created_by: The user that created.
    :vartype created_by: str
    :ivar last_modified_date_time: The last Modified datetime(RFC 3339 literal format).
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar last_modified_by: The user that last modified.
    :vartype last_modified_by: str
    """

    test_profile_run_id: str = rest_field(name="testProfileRunId", visibility=["read"])
    """Unique identifier for the test profile run, must contain only lower-case alphabetic, numeric,
     underscore or hyphen characters. Required."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name for the test profile run."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The test profile run description."""
    test_profile_id: Optional[str] = rest_field(name="testProfileId", visibility=["read", "create"])
    """Associated test profile ID for the test profile run. This is required to create a test profile
     run and can't be updated."""
    target_resource_id: Optional[str] = rest_field(name="targetResourceId", visibility=["read"])
    """Target resource ID on which the test profile run is created."""
    target_resource_configurations: Optional["_models.TargetResourceConfigurations"] = rest_field(
        name="targetResourceConfigurations", visibility=["read"]
    )
    """Configurations of the target resource on which the test profile ran."""
    status: Optional[Union[str, "_models.TestProfileRunStatus"]] = rest_field(visibility=["read"])
    """The test profile run status. Known values are: \"ACCEPTED\", \"NOTSTARTED\", \"EXECUTING\",
     \"DONE\", \"CANCELLING\", \"CANCELLED\", and \"FAILED\"."""
    error_details: Optional[List["_models.ErrorDetails"]] = rest_field(name="errorDetails", visibility=["read"])
    """Error details if there is any failure in test profile run. These errors are specific to the
     Test Profile Run."""
    start_date_time: Optional[datetime.datetime] = rest_field(
        name="startDateTime", visibility=["read"], format="rfc3339"
    )
    """The test profile run start DateTime(RFC 3339 literal format)."""
    end_date_time: Optional[datetime.datetime] = rest_field(name="endDateTime", visibility=["read"], format="rfc3339")
    """The test profile run end DateTime(RFC 3339 literal format)."""
    duration_in_seconds: Optional[int] = rest_field(name="durationInSeconds", visibility=["read"])
    """Test profile run duration in seconds."""
    test_run_details: Optional[Dict[str, "_models.TestRunDetail"]] = rest_field(
        name="testRunDetails", visibility=["read"]
    )
    """Details of the test runs ran as part of the test profile run.
     Key is the testRunId of the corresponding testRun."""
    recommendations: Optional[List["_models.TestProfileRunRecommendation"]] = rest_field(visibility=["read"])
    """Recommendations provided based on a successful test profile run."""
    created_date_time: Optional[datetime.datetime] = rest_field(
        name="createdDateTime", visibility=["read"], format="rfc3339"
    )
    """The creation datetime(RFC 3339 literal format)."""
    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read"])
    """The user that created."""
    last_modified_date_time: Optional[datetime.datetime] = rest_field(
        name="lastModifiedDateTime", visibility=["read"], format="rfc3339"
    )
    """The last Modified datetime(RFC 3339 literal format)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy", visibility=["read"])
    """The user that last modified."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        test_profile_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestProfileRunRecommendation(_model_base.Model):
    """A recommendation object that provides a list of configuration that optimizes its category.

    :ivar category: Category of the recommendation. Required. Known values are:
     "ThroughputOptimized" and "CostOptimized".
    :vartype category: str or ~azure.developer.loadtesting.models.RecommendationCategory
    :ivar configurations: List of configurations IDs for which the recommendation is applicable.
     These are a subset of the provided target resource configurations.
    :vartype configurations: list[str]
    """

    category: Union[str, "_models.RecommendationCategory"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Category of the recommendation. Required. Known values are: \"ThroughputOptimized\" and
     \"CostOptimized\"."""
    configurations: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of configurations IDs for which the recommendation is applicable. These are a subset of
     the provided target resource configurations."""

    @overload
    def __init__(
        self,
        *,
        category: Union[str, "_models.RecommendationCategory"],
        configurations: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestRun(_model_base.Model):
    """Load test run model.

    :ivar test_run_id: Unique test run identifier for the load test run, must contain only
     lower-case alphabetic, numeric, underscore or hyphen characters. Required.
    :vartype test_run_id: str
    :ivar pass_fail_criteria: Pass fail criteria for a test.
    :vartype pass_fail_criteria: ~azure.developer.loadtesting.models.PassFailCriteria
    :ivar auto_stop_criteria: Auto stop criteria for a test. This will automatically stop a load
     test if the error percentage is high for a certain time window.
    :vartype auto_stop_criteria: ~azure.developer.loadtesting.models.AutoStopCriteria
    :ivar secrets: Secrets can be stored in an Azure Key Vault or any other secret store. If the
     secret is stored in an Azure Key Vault, the value should be the secret
     identifier and the type should be AKV_SECRET_URI. If the secret is stored
     elsewhere, the secret value should be provided directly and the type should be
     SECRET_VALUE.
    :vartype secrets: dict[str, ~azure.developer.loadtesting.models.Secret]
    :ivar certificate: Certificates metadata.
    :vartype certificate: ~azure.developer.loadtesting.models.CertificateMetadata
    :ivar environment_variables: Environment variables which are defined as a set of <name,value>
     pairs.
    :vartype environment_variables: dict[str, str]
    :ivar error_details: Error details if there is any failure in load test run.
    :vartype error_details: list[~azure.developer.loadtesting.models.ErrorDetails]
    :ivar test_run_statistics: Test run statistics. Key is the sampler name and value is the set of
     statistics for performance metrics like response time, throughput, etc. from the load test run.
     The sampler name is the same as the name mentioned in the test script.
     Sampler name "Total" represents the aggregated statistics of all the samplers.
    :vartype test_run_statistics: dict[str, ~azure.developer.loadtesting.models.TestRunStatistics]
    :ivar regional_statistics: Regional statistics. Key is the Azure region name and value is the
     test run statistics.
     The region name should of format accepted by ARM, and should be a region supported by Azure
     Load Testing. For example, East US should be passed as "eastus".
     The region name must match one of the strings in the "Name" column returned from running the
     "az account list-locations -o table" Azure CLI command.
    :vartype regional_statistics: dict[str, ~azure.developer.loadtesting.models.TestRunStatistics]
    :ivar load_test_configuration: The load test configuration.
    :vartype load_test_configuration: ~azure.developer.loadtesting.models.LoadTestConfiguration
    :ivar test_artifacts: Collection of test run artifacts.
    :vartype test_artifacts: ~azure.developer.loadtesting.models.TestRunArtifacts
    :ivar test_result: Test result for pass/Fail criteria used during the test run. Known values
     are: "PASSED", "NOT_APPLICABLE", and "FAILED".
    :vartype test_result: str or ~azure.developer.loadtesting.models.PassFailTestResult
    :ivar virtual_users: Number of virtual users, for which test has been run.
    :vartype virtual_users: int
    :ivar display_name: Display name of a testRun.
    :vartype display_name: str
    :ivar test_id: Associated test Id.
    :vartype test_id: str
    :ivar description: The test run description.
    :vartype description: str
    :ivar status: The test run status. Known values are: "ACCEPTED", "NOTSTARTED", "PROVISIONING",
     "PROVISIONED", "CONFIGURING", "CONFIGURED", "EXECUTING", "EXECUTED", "DEPROVISIONING",
     "DEPROVISIONED", "DONE", "CANCELLING", "CANCELLED", "FAILED", "VALIDATION_SUCCESS", and
     "VALIDATION_FAILURE".
    :vartype status: str or ~azure.developer.loadtesting.models.TestRunStatus
    :ivar start_date_time: The test run start DateTime(RFC 3339 literal format).
    :vartype start_date_time: ~datetime.datetime
    :ivar end_date_time: The test run end DateTime(RFC 3339 literal format).
    :vartype end_date_time: ~datetime.datetime
    :ivar executed_date_time: Test run initiated time.
    :vartype executed_date_time: ~datetime.datetime
    :ivar portal_url: Portal url.
    :vartype portal_url: str
    :ivar duration: Test run duration in milliseconds.
    :vartype duration: int
    :ivar virtual_user_hours: Virtual user hours consumed by the test run.
    :vartype virtual_user_hours: float
    :ivar subnet_id: Subnet ID on which the load test instances should run.
    :vartype subnet_id: str
    :ivar kind: Type of test. Known values are: "URL", "JMX", and "Locust".
    :vartype kind: str or ~azure.developer.loadtesting.models.TestKind
    :ivar request_data_level: Request data collection level for test run. Known values are: "NONE"
     and "ERRORS".
    :vartype request_data_level: str or ~azure.developer.loadtesting.models.RequestDataLevel
    :ivar debug_logs_enabled: Enable or disable debug level logging. True if debug logs are enabled
     for the test run. False otherwise.
    :vartype debug_logs_enabled: bool
    :ivar public_ip_disabled: Inject load test engines without deploying public IP for outbound
     access.
    :vartype public_ip_disabled: bool
    :ivar created_by_type: The type of the entity that created the test run. (E.x. User,
     ScheduleTrigger, etc). Known values are: "User" and "ScheduledTrigger".
    :vartype created_by_type: str or ~azure.developer.loadtesting.models.CreatedByType
    :ivar created_date_time: The creation datetime(RFC 3339 literal format).
    :vartype created_date_time: ~datetime.datetime
    :ivar created_by: The user that created.
    :vartype created_by: str
    :ivar last_modified_date_time: The last Modified datetime(RFC 3339 literal format).
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar last_modified_by: The user that last modified.
    :vartype last_modified_by: str
    """

    test_run_id: str = rest_field(name="testRunId", visibility=["read"])
    """Unique test run identifier for the load test run, must contain only lower-case alphabetic,
     numeric, underscore or hyphen characters. Required."""
    pass_fail_criteria: Optional["_models.PassFailCriteria"] = rest_field(
        name="passFailCriteria", visibility=["read", "create", "update", "delete", "query"]
    )
    """Pass fail criteria for a test."""
    auto_stop_criteria: Optional["_models.AutoStopCriteria"] = rest_field(
        name="autoStopCriteria", visibility=["read", "create", "update", "delete", "query"]
    )
    """Auto stop criteria for a test. This will automatically stop a load test if the error percentage
     is high for a certain time window."""
    secrets: Optional[Dict[str, "_models.Secret"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Secrets can be stored in an Azure Key Vault or any other secret store. If the
     secret is stored in an Azure Key Vault, the value should be the secret
     identifier and the type should be AKV_SECRET_URI. If the secret is stored
     elsewhere, the secret value should be provided directly and the type should be
     SECRET_VALUE."""
    certificate: Optional["_models.CertificateMetadata"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Certificates metadata."""
    environment_variables: Optional[Dict[str, str]] = rest_field(
        name="environmentVariables", visibility=["read", "create", "update", "delete", "query"]
    )
    """Environment variables which are defined as a set of <name,value> pairs."""
    error_details: Optional[List["_models.ErrorDetails"]] = rest_field(name="errorDetails", visibility=["read"])
    """Error details if there is any failure in load test run."""
    test_run_statistics: Optional[Dict[str, "_models.TestRunStatistics"]] = rest_field(
        name="testRunStatistics", visibility=["read"]
    )
    """Test run statistics. Key is the sampler name and value is the set of statistics for performance
     metrics like response time, throughput, etc. from the load test run.
     The sampler name is the same as the name mentioned in the test script.
     Sampler name \"Total\" represents the aggregated statistics of all the samplers."""
    regional_statistics: Optional[Dict[str, "_models.TestRunStatistics"]] = rest_field(
        name="regionalStatistics", visibility=["read"]
    )
    """Regional statistics. Key is the Azure region name and value is the test run statistics.
     The region name should of format accepted by ARM, and should be a region supported by Azure
     Load Testing. For example, East US should be passed as \"eastus\".
     The region name must match one of the strings in the \"Name\" column returned from running the
     \"az account list-locations -o table\" Azure CLI command."""
    load_test_configuration: Optional["_models.LoadTestConfiguration"] = rest_field(
        name="loadTestConfiguration", visibility=["read"]
    )
    """The load test configuration."""
    test_artifacts: Optional["_models.TestRunArtifacts"] = rest_field(name="testArtifacts", visibility=["read"])
    """Collection of test run artifacts."""
    test_result: Optional[Union[str, "_models.PassFailTestResult"]] = rest_field(name="testResult", visibility=["read"])
    """Test result for pass/Fail criteria used during the test run. Known values are: \"PASSED\",
     \"NOT_APPLICABLE\", and \"FAILED\"."""
    virtual_users: Optional[int] = rest_field(name="virtualUsers", visibility=["read"])
    """Number of virtual users, for which test has been run."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of a testRun."""
    test_id: Optional[str] = rest_field(name="testId", visibility=["read", "create", "update", "delete", "query"])
    """Associated test Id."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The test run description."""
    status: Optional[Union[str, "_models.TestRunStatus"]] = rest_field(visibility=["read"])
    """The test run status. Known values are: \"ACCEPTED\", \"NOTSTARTED\", \"PROVISIONING\",
     \"PROVISIONED\", \"CONFIGURING\", \"CONFIGURED\", \"EXECUTING\", \"EXECUTED\",
     \"DEPROVISIONING\", \"DEPROVISIONED\", \"DONE\", \"CANCELLING\", \"CANCELLED\", \"FAILED\",
     \"VALIDATION_SUCCESS\", and \"VALIDATION_FAILURE\"."""
    start_date_time: Optional[datetime.datetime] = rest_field(
        name="startDateTime", visibility=["read"], format="rfc3339"
    )
    """The test run start DateTime(RFC 3339 literal format)."""
    end_date_time: Optional[datetime.datetime] = rest_field(name="endDateTime", visibility=["read"], format="rfc3339")
    """The test run end DateTime(RFC 3339 literal format)."""
    executed_date_time: Optional[datetime.datetime] = rest_field(
        name="executedDateTime", visibility=["read"], format="rfc3339"
    )
    """Test run initiated time."""
    portal_url: Optional[str] = rest_field(name="portalUrl", visibility=["read"])
    """Portal url."""
    duration: Optional[int] = rest_field(visibility=["read"])
    """Test run duration in milliseconds."""
    virtual_user_hours: Optional[float] = rest_field(name="virtualUserHours", visibility=["read"])
    """Virtual user hours consumed by the test run."""
    subnet_id: Optional[str] = rest_field(name="subnetId", visibility=["read"])
    """Subnet ID on which the load test instances should run."""
    kind: Optional[Union[str, "_models.TestKind"]] = rest_field(visibility=["read"])
    """Type of test. Known values are: \"URL\", \"JMX\", and \"Locust\"."""
    request_data_level: Optional[Union[str, "_models.RequestDataLevel"]] = rest_field(
        name="requestDataLevel", visibility=["read", "create", "update", "delete", "query"]
    )
    """Request data collection level for test run. Known values are: \"NONE\" and \"ERRORS\"."""
    debug_logs_enabled: Optional[bool] = rest_field(
        name="debugLogsEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enable or disable debug level logging. True if debug logs are enabled for the test run. False
     otherwise."""
    public_ip_disabled: Optional[bool] = rest_field(name="publicIPDisabled", visibility=["read"])
    """Inject load test engines without deploying public IP for outbound access."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the entity that created the test run. (E.x. User, ScheduleTrigger, etc). Known
     values are: \"User\" and \"ScheduledTrigger\"."""
    created_date_time: Optional[datetime.datetime] = rest_field(
        name="createdDateTime", visibility=["read"], format="rfc3339"
    )
    """The creation datetime(RFC 3339 literal format)."""
    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read"])
    """The user that created."""
    last_modified_date_time: Optional[datetime.datetime] = rest_field(
        name="lastModifiedDateTime", visibility=["read"], format="rfc3339"
    )
    """The last Modified datetime(RFC 3339 literal format)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy", visibility=["read"])
    """The user that last modified."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        pass_fail_criteria: Optional["_models.PassFailCriteria"] = None,
        auto_stop_criteria: Optional["_models.AutoStopCriteria"] = None,
        secrets: Optional[Dict[str, "_models.Secret"]] = None,
        certificate: Optional["_models.CertificateMetadata"] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        display_name: Optional[str] = None,
        test_id: Optional[str] = None,
        description: Optional[str] = None,
        request_data_level: Optional[Union[str, "_models.RequestDataLevel"]] = None,
        debug_logs_enabled: Optional[bool] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestRunAppComponents(_model_base.Model):
    """Test run app component.

    :ivar components: Azure resource collection { resource id (fully qualified resource Id e.g
     subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName})
     : resource object }. Required.
    :vartype components: dict[str, ~azure.developer.loadtesting.models.AppComponent]
    :ivar test_run_id: Test run identifier.
    :vartype test_run_id: str
    :ivar created_date_time: The creation datetime(RFC 3339 literal format).
    :vartype created_date_time: ~datetime.datetime
    :ivar created_by: The user that created.
    :vartype created_by: str
    :ivar last_modified_date_time: The last Modified datetime(RFC 3339 literal format).
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar last_modified_by: The user that last modified.
    :vartype last_modified_by: str
    """

    components: Dict[str, "_models.AppComponent"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource collection { resource id (fully qualified resource Id e.g
     subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName})
     : resource object }. Required."""
    test_run_id: Optional[str] = rest_field(name="testRunId", visibility=["read"])
    """Test run identifier."""
    created_date_time: Optional[datetime.datetime] = rest_field(
        name="createdDateTime", visibility=["read"], format="rfc3339"
    )
    """The creation datetime(RFC 3339 literal format)."""
    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read"])
    """The user that created."""
    last_modified_date_time: Optional[datetime.datetime] = rest_field(
        name="lastModifiedDateTime", visibility=["read"], format="rfc3339"
    )
    """The last Modified datetime(RFC 3339 literal format)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy", visibility=["read"])
    """The user that last modified."""

    @overload
    def __init__(
        self,
        *,
        components: Dict[str, "_models.AppComponent"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestRunArtifacts(_model_base.Model):
    """Collection of test run artifacts.

    :ivar input_artifacts: The input artifacts for the test run.
    :vartype input_artifacts: ~azure.developer.loadtesting.models.TestRunInputArtifacts
    :ivar output_artifacts: The output artifacts for the test run.
    :vartype output_artifacts: ~azure.developer.loadtesting.models.TestRunOutputArtifacts
    """

    input_artifacts: Optional["_models.TestRunInputArtifacts"] = rest_field(name="inputArtifacts", visibility=["read"])
    """The input artifacts for the test run."""
    output_artifacts: Optional["_models.TestRunOutputArtifacts"] = rest_field(
        name="outputArtifacts", visibility=["read", "create", "update", "delete", "query"]
    )
    """The output artifacts for the test run."""

    @overload
    def __init__(
        self,
        *,
        output_artifacts: Optional["_models.TestRunOutputArtifacts"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestRunDetail(_model_base.Model):
    """Details of a particular test run for a test profile run.

    :ivar status: Status of the test run. Required. Known values are: "ACCEPTED", "NOTSTARTED",
     "PROVISIONING", "PROVISIONED", "CONFIGURING", "CONFIGURED", "EXECUTING", "EXECUTED",
     "DEPROVISIONING", "DEPROVISIONED", "DONE", "CANCELLING", "CANCELLED", "FAILED",
     "VALIDATION_SUCCESS", and "VALIDATION_FAILURE".
    :vartype status: str or ~azure.developer.loadtesting.models.TestRunStatus
    :ivar configuration_id: ID of the configuration on which the test ran. Required.
    :vartype configuration_id: str
    :ivar properties: Key value pair of extra properties associated with the test run. Required.
    :vartype properties: dict[str, str]
    """

    status: Union[str, "_models.TestRunStatus"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Status of the test run. Required. Known values are: \"ACCEPTED\", \"NOTSTARTED\",
     \"PROVISIONING\", \"PROVISIONED\", \"CONFIGURING\", \"CONFIGURED\", \"EXECUTING\",
     \"EXECUTED\", \"DEPROVISIONING\", \"DEPROVISIONED\", \"DONE\", \"CANCELLING\", \"CANCELLED\",
     \"FAILED\", \"VALIDATION_SUCCESS\", and \"VALIDATION_FAILURE\"."""
    configuration_id: str = rest_field(
        name="configurationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ID of the configuration on which the test ran. Required."""
    properties: Dict[str, str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Key value pair of extra properties associated with the test run. Required."""

    @overload
    def __init__(
        self,
        *,
        status: Union[str, "_models.TestRunStatus"],
        configuration_id: str,
        properties: Dict[str, str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestRunFileInfo(_model_base.Model):
    """Test run file info.

    :ivar file_name: Name of the file. Required.
    :vartype file_name: str
    :ivar url: File URL.
    :vartype url: str
    :ivar file_type: File type. Known values are: "JMX_FILE", "USER_PROPERTIES",
     "ADDITIONAL_ARTIFACTS", "ZIPPED_ARTIFACTS", "URL_TEST_CONFIG", and "TEST_SCRIPT".
    :vartype file_type: str or ~azure.developer.loadtesting.models.FileType
    :ivar expire_date_time: Expiry time of the file (RFC 3339 literal format).
    :vartype expire_date_time: ~datetime.datetime
    :ivar validation_status: Validation status of the file. Known values are: "NOT_VALIDATED",
     "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
     "VALIDATION_NOT_REQUIRED".
    :vartype validation_status: str or ~azure.developer.loadtesting.models.FileValidationStatus
    :ivar validation_failure_details: Validation failure error details.
    :vartype validation_failure_details: str
    """

    file_name: str = rest_field(name="fileName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the file. Required."""
    url: Optional[str] = rest_field(visibility=["read"])
    """File URL."""
    file_type: Optional[Union[str, "_models.FileType"]] = rest_field(name="fileType", visibility=["read"])
    """File type. Known values are: \"JMX_FILE\", \"USER_PROPERTIES\", \"ADDITIONAL_ARTIFACTS\",
     \"ZIPPED_ARTIFACTS\", \"URL_TEST_CONFIG\", and \"TEST_SCRIPT\"."""
    expire_date_time: Optional[datetime.datetime] = rest_field(
        name="expireDateTime", visibility=["read"], format="rfc3339"
    )
    """Expiry time of the file (RFC 3339 literal format)."""
    validation_status: Optional[Union[str, "_models.FileValidationStatus"]] = rest_field(
        name="validationStatus", visibility=["read"]
    )
    """Validation status of the file. Known values are: \"NOT_VALIDATED\", \"VALIDATION_SUCCESS\",
     \"VALIDATION_FAILURE\", \"VALIDATION_INITIATED\", and \"VALIDATION_NOT_REQUIRED\"."""
    validation_failure_details: Optional[str] = rest_field(name="validationFailureDetails", visibility=["read"])
    """Validation failure error details."""

    @overload
    def __init__(
        self,
        *,
        file_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestRunInputArtifacts(_model_base.Model):
    """The input artifacts for the test run.

    :ivar config_file_info: The load test YAML file that contains the the test configuration.
    :vartype config_file_info: ~azure.developer.loadtesting.models.TestRunFileInfo
    :ivar test_script_file_info: The test script file for the test run.
    :vartype test_script_file_info: ~azure.developer.loadtesting.models.TestRunFileInfo
    :ivar user_prop_file_info: The user properties file.
    :vartype user_prop_file_info: ~azure.developer.loadtesting.models.TestRunFileInfo
    :ivar input_artifacts_zip_file_info: The zip file for all input artifacts.
    :vartype input_artifacts_zip_file_info: ~azure.developer.loadtesting.models.TestRunFileInfo
    :ivar url_test_config_file_info: The config json file for url based test.
    :vartype url_test_config_file_info: ~azure.developer.loadtesting.models.TestRunFileInfo
    :ivar additional_file_info: Additional supported files for the test run.
    :vartype additional_file_info: list[~azure.developer.loadtesting.models.TestRunFileInfo]
    """

    config_file_info: Optional["_models.TestRunFileInfo"] = rest_field(
        name="configFileInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The load test YAML file that contains the the test configuration."""
    test_script_file_info: Optional["_models.TestRunFileInfo"] = rest_field(
        name="testScriptFileInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The test script file for the test run."""
    user_prop_file_info: Optional["_models.TestRunFileInfo"] = rest_field(
        name="userPropFileInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user properties file."""
    input_artifacts_zip_file_info: Optional["_models.TestRunFileInfo"] = rest_field(
        name="inputArtifactsZipFileInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The zip file for all input artifacts."""
    url_test_config_file_info: Optional["_models.TestRunFileInfo"] = rest_field(
        name="urlTestConfigFileInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The config json file for url based test."""
    additional_file_info: Optional[List["_models.TestRunFileInfo"]] = rest_field(
        name="additionalFileInfo", visibility=["read"]
    )
    """Additional supported files for the test run."""

    @overload
    def __init__(
        self,
        *,
        config_file_info: Optional["_models.TestRunFileInfo"] = None,
        test_script_file_info: Optional["_models.TestRunFileInfo"] = None,
        user_prop_file_info: Optional["_models.TestRunFileInfo"] = None,
        input_artifacts_zip_file_info: Optional["_models.TestRunFileInfo"] = None,
        url_test_config_file_info: Optional["_models.TestRunFileInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestRunOutputArtifacts(_model_base.Model):
    """The output artifacts for the test run.

    :ivar result_file_info: The test run results file.
    :vartype result_file_info: ~azure.developer.loadtesting.models.TestRunFileInfo
    :ivar logs_file_info: The test run report with metrics.
    :vartype logs_file_info: ~azure.developer.loadtesting.models.TestRunFileInfo
    :ivar artifacts_container_info: The container for test run artifacts.
    :vartype artifacts_container_info: ~azure.developer.loadtesting.models.ArtifactsContainerInfo
    :ivar report_file_info: The report file for the test run.
    :vartype report_file_info: ~azure.developer.loadtesting.models.TestRunFileInfo
    """

    result_file_info: Optional["_models.TestRunFileInfo"] = rest_field(
        name="resultFileInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The test run results file."""
    logs_file_info: Optional["_models.TestRunFileInfo"] = rest_field(
        name="logsFileInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The test run report with metrics."""
    artifacts_container_info: Optional["_models.ArtifactsContainerInfo"] = rest_field(
        name="artifactsContainerInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The container for test run artifacts."""
    report_file_info: Optional["_models.TestRunFileInfo"] = rest_field(
        name="reportFileInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The report file for the test run."""

    @overload
    def __init__(
        self,
        *,
        result_file_info: Optional["_models.TestRunFileInfo"] = None,
        logs_file_info: Optional["_models.TestRunFileInfo"] = None,
        artifacts_container_info: Optional["_models.ArtifactsContainerInfo"] = None,
        report_file_info: Optional["_models.TestRunFileInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestRunServerMetricsConfiguration(_model_base.Model):
    """Test run server metrics configuration.

    :ivar test_run_id: Test run identifier.
    :vartype test_run_id: str
    :ivar metrics: Azure resource metrics collection {metric id : metrics object} (Refer :
     `https://learn.microsoft.com/en-us/rest/api/monitor/metric-definitions/list#metricdefinition
     <https://learn.microsoft.com/en-us/rest/api/monitor/metric-definitions/list#metricdefinition>`_
     for metric id).
    :vartype metrics: dict[str, ~azure.developer.loadtesting.models.ResourceMetric]
    :ivar created_date_time: The creation datetime(RFC 3339 literal format).
    :vartype created_date_time: ~datetime.datetime
    :ivar created_by: The user that created.
    :vartype created_by: str
    :ivar last_modified_date_time: The last Modified datetime(RFC 3339 literal format).
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar last_modified_by: The user that last modified.
    :vartype last_modified_by: str
    """

    test_run_id: Optional[str] = rest_field(name="testRunId", visibility=["read"])
    """Test run identifier."""
    metrics: Optional[Dict[str, "_models.ResourceMetric"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource metrics collection {metric id : metrics object} (Refer :
     `https://learn.microsoft.com/en-us/rest/api/monitor/metric-definitions/list#metricdefinition
     <https://learn.microsoft.com/en-us/rest/api/monitor/metric-definitions/list#metricdefinition>`_
     for metric id)."""
    created_date_time: Optional[datetime.datetime] = rest_field(
        name="createdDateTime", visibility=["read"], format="rfc3339"
    )
    """The creation datetime(RFC 3339 literal format)."""
    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read"])
    """The user that created."""
    last_modified_date_time: Optional[datetime.datetime] = rest_field(
        name="lastModifiedDateTime", visibility=["read"], format="rfc3339"
    )
    """The last Modified datetime(RFC 3339 literal format)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy", visibility=["read"])
    """The user that last modified."""

    @overload
    def __init__(
        self,
        *,
        metrics: Optional[Dict[str, "_models.ResourceMetric"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TestRunStatistics(_model_base.Model):
    """Test run statistics.

    :ivar transaction: Transaction name.
    :vartype transaction: str
    :ivar sample_count: Sampler count.
    :vartype sample_count: float
    :ivar error_count: Error count.
    :vartype error_count: float
    :ivar error_pct: Error percentage.
    :vartype error_pct: float
    :ivar mean_res_time: Mean response time.
    :vartype mean_res_time: float
    :ivar median_res_time: Median response time.
    :vartype median_res_time: float
    :ivar max_res_time: Max response time.
    :vartype max_res_time: float
    :ivar min_res_time: Minimum response time.
    :vartype min_res_time: float
    :ivar pct1_res_time: 90 percentile response time.
    :vartype pct1_res_time: float
    :ivar pct2_res_time: 95 percentile response time.
    :vartype pct2_res_time: float
    :ivar pct3_res_time: 99 percentile response time.
    :vartype pct3_res_time: float
    :ivar pct75_res_time: 75 percentile response time.
    :vartype pct75_res_time: float
    :ivar pct96_res_time: 96 percentile response time.
    :vartype pct96_res_time: float
    :ivar pct97_res_time: 97 percentile response time.
    :vartype pct97_res_time: float
    :ivar pct98_res_time: 98 percentile response time.
    :vartype pct98_res_time: float
    :ivar pct999_res_time: 99.9 percentile response time.
    :vartype pct999_res_time: float
    :ivar pct9999_res_time: 99.99 percentile response time.
    :vartype pct9999_res_time: float
    :ivar throughput: Throughput.
    :vartype throughput: float
    :ivar received_k_bytes_per_sec: Received network bytes.
    :vartype received_k_bytes_per_sec: float
    :ivar sent_k_bytes_per_sec: Send network bytes.
    :vartype sent_k_bytes_per_sec: float
    """

    transaction: Optional[str] = rest_field(visibility=["read"])
    """Transaction name."""
    sample_count: Optional[float] = rest_field(name="sampleCount", visibility=["read"])
    """Sampler count."""
    error_count: Optional[float] = rest_field(name="errorCount", visibility=["read"])
    """Error count."""
    error_pct: Optional[float] = rest_field(name="errorPct", visibility=["read"])
    """Error percentage."""
    mean_res_time: Optional[float] = rest_field(name="meanResTime", visibility=["read"])
    """Mean response time."""
    median_res_time: Optional[float] = rest_field(name="medianResTime", visibility=["read"])
    """Median response time."""
    max_res_time: Optional[float] = rest_field(name="maxResTime", visibility=["read"])
    """Max response time."""
    min_res_time: Optional[float] = rest_field(name="minResTime", visibility=["read"])
    """Minimum response time."""
    pct1_res_time: Optional[float] = rest_field(name="pct1ResTime", visibility=["read"])
    """90 percentile response time."""
    pct2_res_time: Optional[float] = rest_field(name="pct2ResTime", visibility=["read"])
    """95 percentile response time."""
    pct3_res_time: Optional[float] = rest_field(name="pct3ResTime", visibility=["read"])
    """99 percentile response time."""
    pct75_res_time: Optional[float] = rest_field(name="pct75ResTime", visibility=["read"])
    """75 percentile response time."""
    pct96_res_time: Optional[float] = rest_field(name="pct96ResTime", visibility=["read"])
    """96 percentile response time."""
    pct97_res_time: Optional[float] = rest_field(name="pct97ResTime", visibility=["read"])
    """97 percentile response time."""
    pct98_res_time: Optional[float] = rest_field(name="pct98ResTime", visibility=["read"])
    """98 percentile response time."""
    pct999_res_time: Optional[float] = rest_field(name="pct999ResTime", visibility=["read"])
    """99.9 percentile response time."""
    pct9999_res_time: Optional[float] = rest_field(name="pct9999ResTime", visibility=["read"])
    """99.99 percentile response time."""
    throughput: Optional[float] = rest_field(visibility=["read"])
    """Throughput."""
    received_k_bytes_per_sec: Optional[float] = rest_field(name="receivedKBytesPerSec", visibility=["read"])
    """Received network bytes."""
    sent_k_bytes_per_sec: Optional[float] = rest_field(name="sentKBytesPerSec", visibility=["read"])
    """Send network bytes."""


class TestServerMetricsConfiguration(_model_base.Model):
    """Test server metrics configuration.

    :ivar test_id: Test identifier.
    :vartype test_id: str
    :ivar metrics: Azure resource metrics collection {metric id : metrics object} (Refer :
     `https://learn.microsoft.com/en-us/rest/api/monitor/metric-definitions/list#metricdefinition
     <https://learn.microsoft.com/en-us/rest/api/monitor/metric-definitions/list#metricdefinition>`_
     for metric id). Required.
    :vartype metrics: dict[str, ~azure.developer.loadtesting.models.ResourceMetric]
    :ivar created_date_time: The creation datetime(RFC 3339 literal format).
    :vartype created_date_time: ~datetime.datetime
    :ivar created_by: The user that created.
    :vartype created_by: str
    :ivar last_modified_date_time: The last Modified datetime(RFC 3339 literal format).
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar last_modified_by: The user that last modified.
    :vartype last_modified_by: str
    """

    test_id: Optional[str] = rest_field(name="testId", visibility=["read"])
    """Test identifier."""
    metrics: Dict[str, "_models.ResourceMetric"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource metrics collection {metric id : metrics object} (Refer :
     `https://learn.microsoft.com/en-us/rest/api/monitor/metric-definitions/list#metricdefinition
     <https://learn.microsoft.com/en-us/rest/api/monitor/metric-definitions/list#metricdefinition>`_
     for metric id). Required."""
    created_date_time: Optional[datetime.datetime] = rest_field(
        name="createdDateTime", visibility=["read"], format="rfc3339"
    )
    """The creation datetime(RFC 3339 literal format)."""
    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read"])
    """The user that created."""
    last_modified_date_time: Optional[datetime.datetime] = rest_field(
        name="lastModifiedDateTime", visibility=["read"], format="rfc3339"
    )
    """The last Modified datetime(RFC 3339 literal format)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy", visibility=["read"])
    """The user that last modified."""

    @overload
    def __init__(
        self,
        *,
        metrics: Dict[str, "_models.ResourceMetric"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TimeSeriesElement(_model_base.Model):
    """The time series returned when a data query is performed.

    :ivar data: An array of data points representing the metric values.
    :vartype data: list[~azure.developer.loadtesting.models.MetricValue]
    :ivar dimension_values: The dimension values.
    :vartype dimension_values: list[~azure.developer.loadtesting.models.DimensionValue]
    """

    data: Optional[List["_models.MetricValue"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An array of data points representing the metric values."""
    dimension_values: Optional[List["_models.DimensionValue"]] = rest_field(
        name="dimensionValues", visibility=["read", "create", "update", "delete", "query"]
    )
    """The dimension values."""

    @overload
    def __init__(
        self,
        *,
        data: Optional[List["_models.MetricValue"]] = None,
        dimension_values: Optional[List["_models.DimensionValue"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
