# 2025-07-28 Triage Log

A week with lots of mixed results, including a few benchmarks that appear to be
newly bimodal, which made some of the results look closer to noise than signal.
Overall, however, the week ended as a slight improvement.

Triage done by **@simulacrum**.
Revision range: [3f9f20f7..e3514bde](https://perf.rust-lang.org/?start=3f9f20f71dd945fe7d044e274094a53c90788269&end=e3514bde96d2d13586337a48db77fa64b850d249&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 0.9%]    | 7     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.0%, 0.7%]    | 26    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.1%, -0.2%]  | 69    |
| Improvements ✅ <br /> (secondary) | -1.8% | [-10.3%, -0.0%] | 96    |
| All ❌✅ (primary)                 | -0.3% | [-1.1%, 0.9%]   | 76    |

1 Regressions, 2 Improvements, 9 Mixed; 2 of them in rollups
38 artifact comparisons made in total

#### Regressions

resolve: Make disambiguators for underscore bindings module-local (take 2) [#144272](https://github.com/rust-lang/rust/pull/144272) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3c30dbbe31bfbf6029f4534170165ba573ff0fd1&end=fc5af1813307d25a84d633f21e2e53c9376eb547&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.1%, 0.7%] | 17    |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.0%, 0.6%] | 21    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.1%, 0.7%] | 17    |

Unclear root cause; cachegrind diffs point at the regression ocurring in an
unrelated function. It may also be bimodality as the regression temporarily
self-resolves in a subsequent commmit.

#### Improvements

Various refactors to the LTO handling code (part 2) [#144062](https://github.com/rust-lang/rust/pull/144062) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fc5af1813307d25a84d633f21e2e53c9376eb547&end=5d22242a3a84a55be2f648a94eecff58887547f4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -3.4% | [-6.7%, -1.1%] | 6     |
| All ❌✅ (primary)                 | -     | -              | 0     |

Avoids doing some work unless LTO is actually requested, which seems to lead to a nice improvement in the large workspace benchmark.

Do not run per-module late lints if they can be all skipped [#139597](https://github.com/rust-lang/rust/pull/139597) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0dd07bd2165db70ffbe0b903635de26ca630bf20&end=f32b23204a0efe2fe8383ed4be1a30b56c1bbf94&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.1%]   | 4     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.5%, -0.2%] | 17    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.5%, -0.1%] | 24    |
| All ❌✅ (primary)                 | -0.4% | [-0.5%, -0.2%] | 17    |


#### Mixed

Ports `#[macro_use]` and `#[macro_escape]` to the new attribute parsing infrastructure [#143843](https://github.com/rust-lang/rust/pull/143843) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5a30e4307f0506bed87eeecd171f8366fdbda1dc&end=4ff3fa01cbdd468851b1b859541ee1c648cde7de&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 7     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.9%, -0.0%] | 4     |
| All ❌✅ (primary)                 | -     | -              | 0     |

Not particularly worried about the regressions here, they affect
unused-warnings and deep-vector only (and not too high in magnitude) and this
is part of larger changes throughout the compiler.

Create an `AllocId` for `ConstValue::Slice`. [#116707](https://github.com/rust-lang/rust/pull/116707) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=efd420c770bb179537c01063e98cb6990c439654&end=3c30dbbe31bfbf6029f4534170165ba573ff0fd1&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.2%, 1.0%]    | 6     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.0%, 0.9%]    | 38    |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.6%, -0.1%]  | 17    |
| Improvements ✅ <br /> (secondary) | -1.9% | [-10.2%, -0.0%] | 56    |
| All ❌✅ (primary)                 | -0.1% | [-0.6%, 1.0%]   | 23    |

Overall an improvement and potentially will allow for further simplifications
(https://github.com/rust-lang/rust/pull/116707#issuecomment-3069572150).

Rollup of 15 pull requests [#144398](https://github.com/rust-lang/rust/pull/144398) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5d22242a3a84a55be2f648a94eecff58887547f4&end=246733a3d978de41c5b77b8120ba8f41592df9f1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.0%, 0.2%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.8%, -0.1%] | 14    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.6%, -0.1%] | 21    |
| All ❌✅ (primary)                 | -0.3% | [-0.8%, 0.4%]  | 17    |

Regressions appear limited to incr-println-like scenarios most likely from
https://github.com/rust-lang/rust/pull/143374#issuecomment-3037244091. Not
worth further investigation given limited impact and the change looks fairly
benign.

MIR-build: No longer emit assumes in enum-as casting [#144389](https://github.com/rust-lang/rust/pull/144389) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=246733a3d978de41c5b77b8120ba8f41592df9f1&end=b56aaec52bc0fa35591a872fb4aac81f606e265c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 0.7%]   | 13    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.1%, 0.6%]   | 17    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.9%, -0.1%] | 8     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | 0.1%  | [-0.9%, 0.7%]  | 21    |

> looks like html5ever has gone bimodal

(https://github.com/rust-lang/rust/pull/144389#issuecomment-3116885962)

Resolve: refactor `define` into `define_local` and `define_extern` [#143884](https://github.com/rust-lang/rust/pull/143884) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=eed187cfce988dd669b7d9161f324433e64358ee&end=edc3841c5d28e0f54c6d3c7e906ad083129f3903&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.1%  | [0.1%, 0.1%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.3%, 0.7%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.8%, -0.2%] | 15    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.5%, -0.2%] | 27    |
| All ❌✅ (primary)                 | -0.4% | [-0.8%, 0.1%]  | 18    |

Overall positive, few regressions look like they might be within bimodality
thresholds.

Avoid unnecessary `new_adt`/`new_fn_def` calls. [#144425](https://github.com/rust-lang/rust/pull/144425) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=edc3841c5d28e0f54c6d3c7e906ad083129f3903&end=4b596bbd847672da87763b76171687d3544863c2&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.5%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.3%, 0.7%]   | 9     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.1%] | 46    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.6%, -0.1%] | 44    |
| All ❌✅ (primary)                 | -0.2% | [-0.5%, 0.5%]  | 52    |

Overall positive, few regressions look like they might be within bimodality
thresholds.

Preintern some `TyKind::Bound` values [#144434](https://github.com/rust-lang/rust/pull/144434) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4b596bbd847672da87763b76171687d3544863c2&end=f8e355c230c6eb7b78ffce6a92fd81f78c890524&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.1%  | [0.1%, 0.1%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.3%, 1.0%]   | 8     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.1%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.7%, -0.2%] | 23    |
| All ❌✅ (primary)                 | -0.2% | [-0.4%, 0.1%]  | 5     |

match-stress regression looks plausibly like bimodality to me. ucd and
unicode-normalization look more real but are small in magnitude and limited in
which scenarios are affected; overall the change remains positive, so marking
as triaged.

Rollup of 6 pull requests [#144556](https://github.com/rust-lang/rust/pull/144556) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2b5e239c6b86cde974b0ef0f8e23754fb08ff3c5&end=733dab558992d902d6d17576de1da768094e2cf3&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.2%, 1.2%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.0%, -0.0%] | 8     |
| All ❌✅ (primary)                 | -     | -              | 0     |

> So that's probably #143607. One secondary proc-macro benchmark with
> regressions, another one with gains. I guess the magnitude evens out...
>
> I haven't dived into the regression yet but it's probably caused by #143940 (attributes are parsed twice).

Marked as triaged.

Allow more MIR SROA [#144543](https://github.com/rust-lang/rust/pull/144543) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=65b6cdb6a6d33987b9d642a4882283c71fbe3957&end=9ba00e0f9e00990fb88c1beac7172afe93b15609&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 0.8%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.3%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.0%, -0.9%] | 6     |
| All ❌✅ (primary)                 | 0.0%  | [-0.6%, 0.8%]  | 6     |

Changes look possibly like longer-term bimodality? But this is also a MIR
optimization, so mixed results are somewhat expected.
