# Copyright 2016 Cloudbase Solutions Srl
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from oslo_policy import policy

from nova.policies import base


POLICY_ROOT = 'os_compute_api:os-networks:%s'
BASE_POLICY_NAME = 'os_compute_api:os-networks:view'

DEPRECATED_REASON = """
Nova API policies are introducing new default roles with scope_type
capabilities. Old policies are deprecated and silently going to be ignored
in nova 23.0.0 release.
"""

DEPRECATED_POLICY = policy.DeprecatedRule(
    BASE_POLICY_NAME,
    base.RULE_ADMIN_OR_OWNER,
    deprecated_reason=DEPRECATED_REASON,
    deprecated_since='22.0.0'
)


networks_policies = [
    policy.DocumentedRuleDefault(
        name=POLICY_ROOT % 'list',
        check_str=base.PROJECT_READER,
        description="""List networks for the project.

This API is proxy calls to the Network service. This is deprecated.""",
        operations=[
            {
                'method': 'GET',
                'path': '/os-networks'
            }
        ],
        scope_types=['project'],
        deprecated_rule=DEPRECATED_POLICY),
    policy.DocumentedRuleDefault(
        name=POLICY_ROOT % 'show',
        check_str=base.PROJECT_READER,
        description="""Show network details.

This API is proxy calls to the Network service. This is deprecated.""",
        operations=[
            {
                'method': 'GET',
                'path': '/os-networks/{network_id}'
            }
        ],
        scope_types=['project'],
        deprecated_rule=DEPRECATED_POLICY),
]


def list_rules():
    return networks_policies
